
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
        8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u,
        5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u,
        16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u,
        4u, 8u, 4u, 13u, 8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u,
        7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u,
        6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u,
        4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u,
        5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u,
        7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u,
        6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u,
        4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 8u, 8u, 4u, 8u, 5u, 7u,
        7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u,
        5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u,
        4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 13u,
        5u, 8u, 8u, 8u, 1u, 19u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u,
        3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u,
        3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 5u, 10u, 5u, 10u,
        5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u, 3u, 10u,
        4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u,
        3u, 10u, 4u, 10u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u,
        3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u,
        1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u,
        3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u,
        3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u,
        3u, 13u, 3u, 10u, 4u, 10u, 5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u,
        10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u,
        4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 3u, 10u,
        3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u,
        1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u,
        1u, 16u, 1u, 16u, 1u, 16u, 4u, 8u, 3u, 10u, 3u, 10u, 4u, 10u, 1u, 16u,
        3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u,
        3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 5u, 10u,
        5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u,
        3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u,
        5u, 10u, 3u, 10u, 4u, 10u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u,
        1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 13u,
        3u, 10u, 4u, 8u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u,
        4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u,
        4u, 10u, 1u, 16u, 3u, 13u, 3u, 10u, 4u, 10u, 5u, 10u, 5u, 10u, 5u, 10u,
        10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u, 3u, 10u, 4u, 10u,
        5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u,
        4u, 10u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u,
        1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 10u, 3u, 13u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 10u, 1u, 16u, 3u, 13u,
        1u, 16u, 4u, 13u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u,
        3u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u,
        0
};

static const char _indic_syllable_machine_key_spans[] = {
        1, 5, 3, 1, 4, 3, 1, 4,
        3, 1, 4, 3, 1, 5, 1, 1,
        5, 1, 1, 5, 1, 1, 5, 1,
        1, 10, 5, 10, 5, 10, 5, 10,
        5, 10, 1, 5, 3, 1, 4, 3,
        1, 4, 3, 1, 4, 3, 1, 5,
        1, 1, 5, 1, 1, 5, 1, 1,
        5, 1, 1, 10, 5, 10, 5, 10,
        5, 10, 5, 10, 1, 5, 3, 1,
        4, 3, 1, 4, 3, 1, 4, 3,
        1, 5, 1, 1, 5, 1, 1, 5,
        1, 1, 5, 1, 1, 10, 5, 10,
        5, 10, 5, 10, 5, 1, 5, 3,
        1, 4, 3, 1, 4, 3, 1, 4,
        3, 1, 5, 1, 1, 5, 1, 1,
        5, 1, 1, 5, 1, 1, 10, 5,
        10, 5, 10, 5, 10, 5, 10, 10,
        4, 1, 19, 11, 8, 7, 16, 11,
        8, 7, 16, 11, 8, 7, 16, 11,
        8, 7, 16, 11, 8, 7, 6, 6,
        6, 1, 1, 1, 6, 8, 6, 8,
        7, 6, 8, 7, 6, 8, 7, 6,
        8, 7, 8, 11, 16, 16, 16, 8,
        11, 16, 16, 16, 8, 11, 16, 16,
        16, 8, 11, 16, 16, 16, 8, 11,
        11, 8, 7, 16, 11, 8, 7, 16,
        11, 8, 7, 16, 11, 8, 7, 16,
        11, 8, 7, 6, 6, 6, 1, 1,
        1, 6, 8, 6, 8, 7, 6, 8,
        7, 6, 8, 7, 6, 8, 7, 8,
        11, 16, 16, 16, 8, 11, 16, 16,
        16, 8, 11, 16, 16, 16, 8, 11,
        16, 16, 16, 5, 8, 8, 7, 16,
        11, 8, 7, 16, 11, 8, 7, 16,
        11, 8, 7, 16, 11, 8, 7, 6,
        6, 6, 1, 1, 1, 6, 8, 6,
        8, 7, 6, 8, 7, 6, 8, 7,
        6, 8, 7, 8, 11, 16, 16, 16,
        8, 11, 16, 16, 16, 8, 11, 16,
        16, 16, 8, 11, 16, 16, 16, 10,
        8, 5, 11, 8, 7, 16, 11, 8,
        7, 16, 11, 8, 7, 16, 11, 8,
        7, 16, 11, 8, 7, 6, 6, 6,
        1, 1, 1, 6, 8, 6, 8, 7,
        6, 8, 7, 6, 8, 7, 6, 8,
        7, 8, 11, 16, 16, 16, 8, 11,
        16, 16, 16, 8, 11, 16, 16, 16,
        8, 11, 16, 16, 16, 8, 16, 11,
        16, 10, 6, 1, 1, 1, 6, 16,
        8, 6, 6, 1, 1, 1, 6, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
        0, 2, 8, 12, 14, 19, 23, 25,
        30, 34, 36, 41, 45, 47, 53, 55,
        57, 63, 65, 67, 73, 75, 77, 83,
        85, 87, 98, 104, 115, 121, 132, 138,
        149, 155, 166, 168, 174, 178, 180, 185,
        189, 191, 196, 200, 202, 207, 211, 213,
        219, 221, 223, 229, 231, 233, 239, 241,
        243, 249, 251, 253, 264, 270, 281, 287,
        298, 304, 315, 321, 332, 334, 340, 344,
        346, 351, 355, 357, 362, 366, 368, 373,
        377, 379, 385, 387, 389, 395, 397, 399,
        405, 407, 409, 415, 417, 419, 430, 436,
        447, 453, 464, 470, 481, 487, 489, 495,
        499, 501, 506, 510, 512, 517, 521, 523,
        528, 532, 534, 540, 542, 544, 550, 552,
        554, 560, 562, 564, 570, 572, 574, 585,
        591, 602, 608, 619, 625, 636, 642, 653,
        664, 669, 671, 691, 703, 712, 720, 737,
        749, 758, 766, 783, 795, 804, 812, 829,
        841, 850, 858, 875, 887, 896, 904, 911,
        918, 925, 927, 929, 931, 938, 947, 954,
        963, 971, 978, 987, 995, 1002, 1011, 1019,
        1026, 1035, 1043, 1052, 1064, 1081, 1098, 1115,
        1124, 1136, 1153, 1170, 1187, 1196, 1208, 1225,
        1242, 1259, 1268, 1280, 1297, 1314, 1331, 1340,
        1352, 1364, 1373, 1381, 1398, 1410, 1419, 1427,
        1444, 1456, 1465, 1473, 1490, 1502, 1511, 1519,
        1536, 1548, 1557, 1565, 1572, 1579, 1586, 1588,
        1590, 1592, 1599, 1608, 1615, 1624, 1632, 1639,
        1648, 1656, 1663, 1672, 1680, 1687, 1696, 1704,
        1713, 1725, 1742, 1759, 1776, 1785, 1797, 1814,
        1831, 1848, 1857, 1869, 1886, 1903, 1920, 1929,
        1941, 1958, 1975, 1992, 1998, 2007, 2016, 2024,
        2041, 2053, 2062, 2070, 2087, 2099, 2108, 2116,
        2133, 2145, 2154, 2162, 2179, 2191, 2200, 2208,
        2215, 2222, 2229, 2231, 2233, 2235, 2242, 2251,
        2258, 2267, 2275, 2282, 2291, 2299, 2306, 2315,
        2323, 2330, 2339, 2347, 2356, 2368, 2385, 2402,
        2419, 2428, 2440, 2457, 2474, 2491, 2500, 2512,
        2529, 2546, 2563, 2572, 2584, 2601, 2618, 2635,
        2646, 2655, 2661, 2673, 2682, 2690, 2707, 2719,
        2728, 2736, 2753, 2765, 2774, 2782, 2799, 2811,
        2820, 2828, 2845, 2857, 2866, 2874, 2881, 2888,
        2895, 2897, 2899, 2901, 2908, 2917, 2924, 2933,
        2941, 2948, 2957, 2965, 2972, 2981, 2989, 2996,
        3005, 3013, 3022, 3034, 3051, 3068, 3085, 3094,
        3106, 3123, 3140, 3157, 3166, 3178, 3195, 3212,
        3229, 3238, 3250, 3267, 3284, 3301, 3310, 3327,
        3339, 3356, 3367, 3374, 3376, 3378, 3380, 3387,
        3404, 3413, 3420, 3427, 3429, 3431, 3433, 3440
};

static const short _indic_syllable_machine_indicies[] = {
        1, 0, 2, 3, 3, 4, 1, 0,
        5, 5, 4, 0, 4, 0, 6, 6,
        7, 1, 0, 8, 8, 7, 0, 7,
        0, 9, 9, 10, 1, 0, 11, 11,
        10, 0, 10, 0, 12, 12, 13, 1,
        0, 14, 14, 13, 0, 13, 0, 15,
        0, 0, 0, 1, 0, 16, 0, 17,
        0, 18, 12, 12, 13, 1, 0, 19,
        0, 20, 0, 21, 9, 9, 10, 1,
        0, 22, 0, 23, 0, 24, 6, 6,
        7, 1, 0, 25, 0, 26, 0, 2,
        3, 3, 4, 1, 0, 0, 0, 0,
        27, 0, 28, 3, 3, 4, 1, 0,
        28, 3, 3, 4, 1, 0, 0, 0,
        0, 29, 0, 30, 3, 3, 4, 1,
        0, 30, 3, 3, 4, 1, 0, 0,
        0, 0, 31, 0, 32, 3, 3, 4,
        1, 0, 32, 3, 3, 4, 1, 0,
        0, 0, 0, 33, 0, 34, 3, 3,
        4, 1, 0, 34, 3, 3, 4, 1,
        0, 0, 0, 0, 35, 0, 37, 36,
        38, 39, 39, 40, 37, 36, 41, 41,
        40, 36, 40, 36, 42, 42, 43, 37,
        36, 44, 44, 43, 36, 43, 36, 45,
        45, 46, 37, 36, 47, 47, 46, 36,
        46, 36, 48, 48, 49, 37, 36, 50,
        50, 49, 36, 49, 36, 51, 36, 36,
        36, 37, 36, 52, 36, 53, 36, 54,
        48, 48, 49, 37, 36, 55, 36, 56,
        36, 57, 45, 45, 46, 37, 36, 58,
        36, 59, 36, 60, 42, 42, 43, 37,
        36, 61, 36, 62, 36, 38, 39, 39,
        40, 37, 36, 36, 36, 36, 63, 36,
        64, 39, 39, 40, 37, 36, 64, 39,
        39, 40, 37, 36, 36, 36, 36, 65,
        36, 66, 39, 39, 40, 37, 36, 66,
        39, 39, 40, 37, 36, 36, 36, 36,
        67, 36, 68, 39, 39, 40, 37, 36,
        68, 39, 39, 40, 37, 36, 36, 36,
        36, 69, 36, 70, 39, 39, 40, 37,
        36, 70, 39, 39, 40, 37, 36, 36,
        36, 36, 71, 36, 73, 72, 74, 75,
        75, 76, 73, 72, 78, 78, 76, 77,
        76, 77, 79, 79, 80, 73, 72, 81,
        81, 80, 72, 80, 72, 82, 82, 83,
        73, 72, 84, 84, 83, 72, 83, 72,
        85, 85, 86, 73, 72, 87, 87, 86,
        72, 86, 72, 88, 72, 72, 72, 73,
        72, 89, 72, 90, 72, 91, 85, 85,
        86, 73, 72, 92, 72, 93, 72, 94,
        82, 82, 83, 73, 72, 95, 72, 96,
        72, 97, 79, 79, 80, 73, 72, 98,
        72, 99, 72, 74, 75, 75, 76, 73,
        72, 72, 72, 72, 100, 72, 101, 75,
        75, 76, 73, 72, 101, 75, 75, 76,
        73, 72, 72, 72, 72, 102, 72, 103,
        75, 75, 76, 73, 72, 103, 75, 75,
        76, 73, 72, 72, 72, 72, 104, 72,
        105, 75, 75, 76, 73, 72, 105, 75,
        75, 76, 73, 72, 72, 72, 72, 106,
        72, 107, 75, 75, 76, 73, 72, 109,
        108, 110, 111, 111, 112, 109, 108, 113,
        113, 112, 108, 112, 108, 114, 114, 115,
        109, 108, 116, 116, 115, 108, 115, 108,
        117, 117, 118, 109, 108, 119, 119, 118,
        108, 118, 108, 120, 120, 121, 109, 108,
        122, 122, 121, 108, 121, 108, 123, 108,
        108, 108, 109, 108, 124, 108, 125, 108,
        126, 120, 120, 121, 109, 108, 127, 108,
        128, 108, 129, 117, 117, 118, 109, 108,
        130, 108, 131, 108, 132, 114, 114, 115,
        109, 108, 133, 108, 134, 108, 110, 111,
        111, 112, 109, 108, 108, 108, 108, 135,
        108, 136, 111, 111, 112, 109, 108, 136,
        111, 111, 112, 109, 108, 108, 108, 108,
        137, 108, 138, 111, 111, 112, 109, 108,
        138, 111, 111, 112, 109, 108, 108, 108,
        108, 139, 108, 140, 111, 111, 112, 109,
        108, 140, 111, 111, 112, 109, 108, 108,
        108, 108, 141, 108, 142, 111, 111, 112,
        109, 108, 142, 111, 111, 112, 109, 108,
        108, 108, 108, 143, 108, 107, 75, 75,
        76, 73, 72, 72, 72, 72, 144, 72,
        78, 78, 76, 1, 0, 146, 145, 148,
        149, 150, 151, 152, 153, 76, 73, 147,
        154, 155, 155, 144, 147, 156, 157, 147,
        158, 159, 147, 161, 162, 163, 164, 4,
        1, 160, 165, 160, 160, 35, 160, 166,
        162, 167, 167, 4, 1, 160, 165, 160,
        162, 167, 167, 4, 1, 160, 165, 160,
        168, 160, 160, 160, 17, 169, 160, 1,
        160, 165, 160, 160, 160, 160, 160, 168,
        160, 170, 171, 172, 173, 4, 1, 160,
        165, 160, 160, 33, 160, 174, 171, 175,
        175, 4, 1, 160, 165, 160, 171, 175,
        175, 4, 1, 160, 165, 160, 176, 160,
        160, 160, 17, 177, 160, 1, 160, 165,
        160, 160, 160, 160, 160, 176, 160, 178,
        179, 180, 181, 4, 1, 160, 165, 160,
        160, 31, 160, 182, 179, 183, 183, 4,
        1, 160, 165, 160, 179, 183, 183, 4,
        1, 160, 165, 160, 184, 160, 160, 160,
        17, 185, 160, 1, 160, 165, 160, 160,
        160, 160, 160, 184, 160, 186, 187, 188,
        189, 4, 1, 160, 165, 160, 160, 29,
        160, 190, 187, 191, 191, 4, 1, 160,
        165, 160, 187, 191, 191, 4, 1, 160,
        165, 160, 192, 160, 160, 160, 17, 193,
        160, 1, 160, 165, 160, 160, 160, 160,
        160, 192, 160, 194, 195, 196, 197, 4,
        1, 160, 165, 160, 160, 27, 160, 198,
        195, 199, 199, 4, 1, 160, 165, 160,
        195, 199, 199, 4, 1, 160, 165, 160,
        17, 200, 160, 1, 160, 165, 160, 201,
        201, 160, 1, 160, 165, 160, 202, 160,
        160, 203, 160, 165, 160, 165, 160, 204,
        160, 205, 160, 202, 160, 160, 160, 160,
        165, 160, 17, 160, 201, 201, 160, 1,
        160, 165, 160, 201, 200, 160, 1, 160,
        165, 160, 206, 26, 207, 208, 7, 1,
        160, 165, 160, 26, 207, 208, 7, 1,
        160, 165, 160, 207, 207, 7, 1, 160,
        165, 160, 209, 23, 210, 211, 10, 1,
        160, 165, 160, 23, 210, 211, 10, 1,
        160, 165, 160, 210, 210, 10, 1, 160,
        165, 160, 212, 20, 213, 214, 13, 1,
        160, 165, 160, 20, 213, 214, 13, 1,
        160, 165, 160, 213, 213, 13, 1, 160,
        165, 160, 215, 17, 201, 216, 160, 1,
        160, 165, 160, 17, 201, 216, 160, 1,
        160, 165, 160, 194, 195, 199, 199, 4,
        1, 160, 165, 160, 194, 195, 196, 199,
        4, 1, 160, 165, 160, 160, 27, 160,
        192, 160, 217, 160, 201, 201, 160, 1,
        160, 165, 160, 160, 160, 160, 160, 192,
        160, 192, 160, 160, 160, 201, 201, 160,
        1, 160, 165, 160, 160, 160, 160, 160,
        192, 160, 192, 160, 160, 160, 201, 193,
        160, 1, 160, 165, 160, 160, 160, 160,
        160, 192, 160, 186, 187, 191, 191, 4,
        1, 160, 165, 160, 186, 187, 188, 191,
        4, 1, 160, 165, 160, 160, 29, 160,
        184, 160, 218, 160, 201, 201, 160, 1,
        160, 165, 160, 160, 160, 160, 160, 184,
        160, 184, 160, 160, 160, 201, 201, 160,
        1, 160, 165, 160, 160, 160, 160, 160,
        184, 160, 184, 160, 160, 160, 201, 185,
        160, 1, 160, 165, 160, 160, 160, 160,
        160, 184, 160, 178, 179, 183, 183, 4,
        1, 160, 165, 160, 178, 179, 180, 183,
        4, 1, 160, 165, 160, 160, 31, 160,
        176, 160, 219, 160, 201, 201, 160, 1,
        160, 165, 160, 160, 160, 160, 160, 176,
        160, 176, 160, 160, 160, 201, 201, 160,
        1, 160, 165, 160, 160, 160, 160, 160,
        176, 160, 176, 160, 160, 160, 201, 177,
        160, 1, 160, 165, 160, 160, 160, 160,
        160, 176, 160, 170, 171, 175, 175, 4,
        1, 160, 165, 160, 170, 171, 172, 175,
        4, 1, 160, 165, 160, 160, 33, 160,
        168, 160, 220, 160, 201, 201, 160, 1,
        160, 165, 160, 160, 160, 160, 160, 168,
        160, 168, 160, 160, 160, 201, 201, 160,
        1, 160, 165, 160, 160, 160, 160, 160,
        168, 160, 168, 160, 160, 160, 201, 169,
        160, 1, 160, 165, 160, 160, 160, 160,
        160, 168, 160, 161, 162, 167, 167, 4,
        1, 160, 165, 160, 161, 162, 163, 167,
        4, 1, 160, 165, 160, 160, 35, 160,
        222, 223, 224, 225, 40, 37, 221, 226,
        221, 221, 71, 221, 227, 223, 228, 225,
        40, 37, 221, 226, 221, 223, 228, 225,
        40, 37, 221, 226, 221, 229, 221, 221,
        221, 53, 230, 221, 37, 221, 226, 221,
        221, 221, 221, 221, 229, 221, 231, 232,
        233, 234, 40, 37, 221, 226, 221, 221,
        69, 221, 235, 232, 236, 236, 40, 37,
        221, 226, 221, 232, 236, 236, 40, 37,
        221, 226, 221, 237, 221, 221, 221, 53,
        238, 221, 37, 221, 226, 221, 221, 221,
        221, 221, 237, 221, 239, 240, 241, 242,
        40, 37, 221, 226, 221, 221, 67, 221,
        243, 240, 244, 244, 40, 37, 221, 226,
        221, 240, 244, 244, 40, 37, 221, 226,
        221, 245, 221, 221, 221, 53, 246, 221,
        37, 221, 226, 221, 221, 221, 221, 221,
        245, 221, 247, 248, 249, 250, 40, 37,
        221, 226, 221, 221, 65, 221, 251, 248,
        252, 252, 40, 37, 221, 226, 221, 248,
        252, 252, 40, 37, 221, 226, 221, 253,
        221, 221, 221, 53, 254, 221, 37, 221,
        226, 221, 221, 221, 221, 221, 253, 221,
        255, 256, 257, 258, 40, 37, 221, 226,
        221, 221, 63, 221, 259, 256, 260, 260,
        40, 37, 221, 226, 221, 256, 260, 260,
        40, 37, 221, 226, 221, 53, 261, 221,
        37, 221, 226, 221, 262, 262, 221, 37,
        221, 226, 221, 263, 221, 221, 264, 221,
        226, 221, 226, 221, 265, 221, 266, 221,
        263, 221, 221, 221, 221, 226, 221, 53,
        221, 262, 262, 221, 37, 221, 226, 221,
        262, 261, 221, 37, 221, 226, 221, 267,
        62, 268, 269, 43, 37, 221, 226, 221,
        62, 268, 269, 43, 37, 221, 226, 221,
        268, 268, 43, 37, 221, 226, 221, 270,
        59, 271, 272, 46, 37, 221, 226, 221,
        59, 271, 272, 46, 37, 221, 226, 221,
        271, 271, 46, 37, 221, 226, 221, 273,
        56, 274, 275, 49, 37, 221, 226, 221,
        56, 274, 275, 49, 37, 221, 226, 221,
        274, 274, 49, 37, 221, 226, 221, 276,
        53, 262, 277, 221, 37, 221, 226, 221,
        53, 262, 277, 221, 37, 221, 226, 221,
        255, 256, 260, 260, 40, 37, 221, 226,
        221, 255, 256, 257, 260, 40, 37, 221,
        226, 221, 221, 63, 221, 253, 221, 278,
        221, 262, 262, 221, 37, 221, 226, 221,
        221, 221, 221, 221, 253, 221, 253, 221,
        221, 221, 262, 262, 221, 37, 221, 226,
        221, 221, 221, 221, 221, 253, 221, 253,
        221, 221, 221, 262, 254, 221, 37, 221,
        226, 221, 221, 221, 221, 221, 253, 221,
        247, 248, 252, 252, 40, 37, 221, 226,
        221, 247, 248, 249, 252, 40, 37, 221,
        226, 221, 221, 65, 221, 245, 221, 279,
        221, 262, 262, 221, 37, 221, 226, 221,
        221, 221, 221, 221, 245, 221, 245, 221,
        221, 221, 262, 262, 221, 37, 221, 226,
        221, 221, 221, 221, 221, 245, 221, 245,
        221, 221, 221, 262, 246, 221, 37, 221,
        226, 221, 221, 221, 221, 221, 245, 221,
        239, 240, 244, 244, 40, 37, 221, 226,
        221, 239, 240, 241, 244, 40, 37, 221,
        226, 221, 221, 67, 221, 237, 221, 280,
        221, 262, 262, 221, 37, 221, 226, 221,
        221, 221, 221, 221, 237, 221, 237, 221,
        221, 221, 262, 262, 221, 37, 221, 226,
        221, 221, 221, 221, 221, 237, 221, 237,
        221, 221, 221, 262, 238, 221, 37, 221,
        226, 221, 221, 221, 221, 221, 237, 221,
        231, 232, 236, 236, 40, 37, 221, 226,
        221, 231, 232, 233, 236, 40, 37, 221,
        226, 221, 221, 69, 221, 229, 221, 281,
        221, 262, 262, 221, 37, 221, 226, 221,
        221, 221, 221, 221, 229, 221, 229, 221,
        221, 221, 262, 262, 221, 37, 221, 226,
        221, 221, 221, 221, 221, 229, 221, 229,
        221, 221, 221, 262, 230, 221, 37, 221,
        226, 221, 221, 221, 221, 221, 229, 221,
        70, 39, 39, 40, 37, 221, 222, 223,
        228, 225, 40, 37, 221, 226, 221, 283,
        151, 284, 284, 76, 73, 282, 154, 282,
        151, 284, 284, 76, 73, 282, 154, 282,
        285, 282, 282, 282, 90, 286, 282, 73,
        282, 154, 282, 282, 282, 282, 282, 285,
        282, 287, 288, 289, 290, 76, 73, 282,
        154, 282, 282, 106, 282, 291, 288, 292,
        292, 76, 73, 282, 154, 282, 288, 292,
        292, 76, 73, 282, 154, 282, 293, 282,
        282, 282, 90, 294, 282, 73, 282, 154,
        282, 282, 282, 282, 282, 293, 282, 295,
        296, 297, 298, 76, 73, 282, 154, 282,
        282, 104, 282, 299, 296, 300, 300, 76,
        73, 282, 154, 282, 296, 300, 300, 76,
        73, 282, 154, 282, 301, 282, 282, 282,
        90, 302, 282, 73, 282, 154, 282, 282,
        282, 282, 282, 301, 282, 303, 304, 305,
        306, 76, 73, 282, 154, 282, 282, 102,
        282, 307, 304, 308, 308, 76, 73, 282,
        154, 282, 304, 308, 308, 76, 73, 282,
        154, 282, 309, 282, 282, 282, 90, 310,
        282, 73, 282, 154, 282, 282, 282, 282,
        282, 309, 282, 311, 312, 313, 314, 76,
        73, 282, 154, 282, 282, 100, 282, 315,
        312, 316, 316, 76, 73, 282, 154, 282,
        312, 316, 316, 76, 73, 282, 154, 282,
        90, 317, 282, 73, 282, 154, 282, 318,
        318, 282, 73, 282, 154, 282, 319, 282,
        282, 320, 282, 154, 282, 154, 282, 321,
        282, 322, 282, 319, 282, 282, 282, 282,
        154, 282, 90, 282, 318, 318, 282, 73,
        282, 154, 282, 318, 317, 282, 73, 282,
        154, 282, 323, 99, 324, 325, 80, 73,
        282, 154, 282, 99, 324, 325, 80, 73,
        282, 154, 282, 324, 324, 80, 73, 282,
        154, 282, 326, 96, 327, 328, 83, 73,
        282, 154, 282, 96, 327, 328, 83, 73,
        282, 154, 282, 327, 327, 83, 73, 282,
        154, 282, 329, 93, 330, 331, 86, 73,
        282, 154, 282, 93, 330, 331, 86, 73,
        282, 154, 282, 330, 330, 86, 73, 282,
        154, 282, 332, 90, 318, 333, 282, 73,
        282, 154, 282, 90, 318, 333, 282, 73,
        282, 154, 282, 311, 312, 316, 316, 76,
        73, 282, 154, 282, 311, 312, 313, 316,
        76, 73, 282, 154, 282, 282, 100, 282,
        309, 282, 334, 282, 318, 318, 282, 73,
        282, 154, 282, 282, 282, 282, 282, 309,
        282, 309, 282, 282, 282, 318, 318, 282,
        73, 282, 154, 282, 282, 282, 282, 282,
        309, 282, 309, 282, 282, 282, 318, 310,
        282, 73, 282, 154, 282, 282, 282, 282,
        282, 309, 282, 303, 304, 308, 308, 76,
        73, 282, 154, 282, 303, 304, 305, 308,
        76, 73, 282, 154, 282, 282, 102, 282,
        301, 282, 335, 282, 318, 318, 282, 73,
        282, 154, 282, 282, 282, 282, 282, 301,
        282, 301, 282, 282, 282, 318, 318, 282,
        73, 282, 154, 282, 282, 282, 282, 282,
        301, 282, 301, 282, 282, 282, 318, 302,
        282, 73, 282, 154, 282, 282, 282, 282,
        282, 301, 282, 295, 296, 300, 300, 76,
        73, 282, 154, 282, 295, 296, 297, 300,
        76, 73, 282, 154, 282, 282, 104, 282,
        293, 282, 336, 282, 318, 318, 282, 73,
        282, 154, 282, 282, 282, 282, 282, 293,
        282, 293, 282, 282, 282, 318, 318, 282,
        73, 282, 154, 282, 282, 282, 282, 282,
        293, 282, 293, 282, 282, 282, 318, 294,
        282, 73, 282, 154, 282, 282, 282, 282,
        282, 293, 282, 287, 288, 292, 292, 76,
        73, 282, 154, 282, 287, 288, 289, 292,
        76, 73, 282, 154, 282, 282, 106, 282,
        285, 282, 337, 282, 318, 318, 282, 73,
        282, 154, 282, 282, 282, 282, 282, 285,
        282, 285, 282, 282, 282, 318, 318, 282,
        73, 282, 154, 282, 282, 282, 282, 282,
        285, 282, 285, 282, 282, 282, 318, 286,
        282, 73, 282, 154, 282, 282, 282, 282,
        282, 285, 282, 107, 75, 75, 76, 73,
        338, 338, 338, 338, 144, 338, 150, 151,
        284, 284, 76, 73, 282, 154, 282, 107,
        75, 75, 76, 73, 338, 340, 341, 342,
        343, 112, 109, 339, 344, 339, 339, 143,
        339, 345, 341, 343, 343, 112, 109, 339,
        344, 339, 341, 343, 343, 112, 109, 339,
        344, 339, 346, 339, 339, 339, 125, 347,
        339, 109, 339, 344, 339, 339, 339, 339,
        339, 346, 339, 348, 349, 350, 351, 112,
        109, 339, 344, 339, 339, 141, 339, 352,
        349, 353, 353, 112, 109, 339, 344, 339,
        349, 353, 353, 112, 109, 339, 344, 339,
        354, 339, 339, 339, 125, 355, 339, 109,
        339, 344, 339, 339, 339, 339, 339, 354,
        339, 356, 357, 358, 359, 112, 109, 339,
        344, 339, 339, 139, 339, 360, 357, 361,
        361, 112, 109, 339, 344, 339, 357, 361,
        361, 112, 109, 339, 344, 339, 362, 339,
        339, 339, 125, 363, 339, 109, 339, 344,
        339, 339, 339, 339, 339, 362, 339, 364,
        365, 366, 367, 112, 109, 339, 344, 339,
        339, 137, 339, 368, 365, 369, 369, 112,
        109, 339, 344, 339, 365, 369, 369, 112,
        109, 339, 344, 339, 370, 339, 339, 339,
        125, 371, 339, 109, 339, 344, 339, 339,
        339, 339, 339, 370, 339, 372, 373, 374,
        375, 112, 109, 339, 344, 339, 339, 135,
        339, 376, 373, 377, 377, 112, 109, 339,
        344, 339, 373, 377, 377, 112, 109, 339,
        344, 339, 125, 378, 339, 109, 339, 344,
        339, 379, 379, 339, 109, 339, 344, 339,
        380, 339, 339, 381, 339, 344, 339, 344,
        339, 382, 339, 383, 339, 380, 339, 339,
        339, 339, 344, 339, 125, 339, 379, 379,
        339, 109, 339, 344, 339, 379, 378, 339,
        109, 339, 344, 339, 384, 134, 385, 386,
        115, 109, 339, 344, 339, 134, 385, 386,
        115, 109, 339, 344, 339, 385, 385, 115,
        109, 339, 344, 339, 387, 131, 388, 389,
        118, 109, 339, 344, 339, 131, 388, 389,
        118, 109, 339, 344, 339, 388, 388, 118,
        109, 339, 344, 339, 390, 128, 391, 392,
        121, 109, 339, 344, 339, 128, 391, 392,
        121, 109, 339, 344, 339, 391, 391, 121,
        109, 339, 344, 339, 393, 125, 379, 394,
        339, 109, 339, 344, 339, 125, 379, 394,
        339, 109, 339, 344, 339, 372, 373, 377,
        377, 112, 109, 339, 344, 339, 372, 373,
        374, 377, 112, 109, 339, 344, 339, 339,
        135, 339, 370, 339, 395, 339, 379, 379,
        339, 109, 339, 344, 339, 339, 339, 339,
        339, 370, 339, 370, 339, 339, 339, 379,
        379, 339, 109, 339, 344, 339, 339, 339,
        339, 339, 370, 339, 370, 339, 339, 339,
        379, 371, 339, 109, 339, 344, 339, 339,
        339, 339, 339, 370, 339, 364, 365, 369,
        369, 112, 109, 339, 344, 339, 364, 365,
        366, 369, 112, 109, 339, 344, 339, 339,
        137, 339, 362, 339, 396, 339, 379, 379,
        339, 109, 339, 344, 339, 339, 339, 339,
        339, 362, 339, 362, 339, 339, 339, 379,
        379, 339, 109, 339, 344, 339, 339, 339,
        339, 339, 362, 339, 362, 339, 339, 339,
        379, 363, 339, 109, 339, 344, 339, 339,
        339, 339, 339, 362, 339, 356, 357, 361,
        361, 112, 109, 339, 344, 339, 356, 357,
        358, 361, 112, 109, 339, 344, 339, 339,
        139, 339, 354, 339, 397, 339, 379, 379,
        339, 109, 339, 344, 339, 339, 339, 339,
        339, 354, 339, 354, 339, 339, 339, 379,
        379, 339, 109, 339, 344, 339, 339, 339,
        339, 339, 354, 339, 354, 339, 339, 339,
        379, 355, 339, 109, 339, 344, 339, 339,
        339, 339, 339, 354, 339, 348, 349, 353,
        353, 112, 109, 339, 344, 339, 348, 349,
        350, 353, 112, 109, 339, 344, 339, 339,
        141, 339, 346, 339, 398, 339, 379, 379,
        339, 109, 339, 344, 339, 339, 339, 339,
        339, 346, 339, 346, 339, 339, 339, 379,
        379, 339, 109, 339, 344, 339, 339, 339,
        339, 339, 346, 339, 346, 339, 339, 339,
        379, 347, 339, 109, 339, 344, 339, 339,
        339, 339, 339, 346, 339, 340, 341, 343,
        343, 112, 109, 339, 344, 339, 148, 149,
        150, 151, 399, 284, 76, 73, 282, 154,
        155, 155, 144, 282, 282, 148, 282, 161,
        400, 163, 164, 4, 1, 160, 165, 160,
        160, 35, 160, 168, 149, 150, 151, 401,
        402, 76, 403, 160, 404, 160, 155, 144,
        160, 160, 168, 160, 107, 405, 405, 76,
        403, 160, 165, 160, 160, 144, 160, 406,
        160, 160, 407, 160, 404, 160, 404, 160,
        408, 160, 205, 160, 406, 160, 160, 160,
        160, 404, 160, 168, 160, 220, 107, 405,
        405, 76, 403, 160, 165, 160, 160, 160,
        160, 160, 168, 160, 410, 409, 411, 411,
        409, 146, 409, 412, 409, 411, 411, 409,
        146, 409, 412, 409, 413, 409, 409, 414,
        409, 412, 409, 412, 409, 415, 409, 416,
        409, 413, 409, 409, 409, 409, 412, 409,
        148, 338, 338, 338, 338, 338, 338, 338,
        338, 338, 155, 338, 338, 338, 338, 148,
        338, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
        138, 160, 166, 2, 167, 3, 5, 170,
        6, 8, 173, 9, 11, 176, 12, 14,
        15, 159, 17, 18, 175, 20, 21, 172,
        23, 24, 169, 178, 182, 183, 187, 188,
        192, 193, 197, 198, 138, 221, 227, 36,
        228, 37, 39, 231, 40, 42, 234, 43,
        45, 237, 46, 48, 49, 220, 51, 52,
        236, 54, 55, 233, 57, 58, 230, 239,
        243, 244, 248, 249, 253, 254, 258, 260,
        138, 281, 287, 70, 288, 138, 71, 73,
        291, 74, 76, 294, 77, 79, 297, 80,
        82, 83, 280, 85, 86, 296, 88, 89,
        293, 91, 92, 290, 299, 303, 304, 308,
        309, 313, 314, 318, 138, 343, 349, 103,
        350, 104, 106, 353, 107, 109, 356, 110,
        112, 359, 113, 115, 116, 342, 118, 119,
        358, 121, 122, 355, 124, 125, 352, 361,
        365, 366, 370, 371, 375, 376, 380, 381,
        320, 138, 394, 138, 139, 200, 261, 263,
        319, 321, 283, 322, 382, 383, 392, 399,
        138, 140, 142, 33, 199, 162, 141, 32,
        143, 195, 144, 146, 31, 194, 145, 30,
        147, 190, 148, 150, 29, 189, 149, 28,
        151, 185, 152, 154, 27, 184, 153, 26,
        155, 180, 156, 158, 25, 179, 157, 1,
        165, 0, 161, 164, 163, 138, 168, 4,
        22, 171, 7, 19, 174, 10, 16, 177,
        13, 181, 186, 191, 196, 138, 201, 203,
        67, 259, 223, 202, 66, 204, 256, 205,
        207, 65, 255, 206, 64, 208, 251, 209,
        211, 63, 250, 210, 62, 212, 246, 213,
        215, 61, 245, 214, 60, 216, 241, 217,
        219, 59, 240, 218, 35, 226, 34, 222,
        225, 224, 138, 229, 38, 56, 232, 41,
        53, 235, 44, 50, 238, 47, 242, 247,
        252, 257, 138, 262, 100, 264, 316, 265,
        267, 99, 315, 266, 98, 268, 311, 269,
        271, 97, 310, 270, 96, 272, 306, 273,
        275, 95, 305, 274, 94, 276, 301, 277,
        279, 93, 300, 278, 69, 286, 68, 282,
        285, 284, 138, 289, 72, 90, 292, 75,
        87, 295, 78, 84, 298, 81, 302, 307,
        312, 317, 138, 138, 323, 325, 134, 133,
        345, 324, 326, 378, 327, 329, 132, 377,
        328, 131, 330, 373, 331, 333, 130, 372,
        332, 129, 334, 368, 335, 337, 128, 367,
        336, 127, 338, 363, 339, 341, 126, 362,
        340, 102, 348, 101, 344, 347, 346, 138,
        351, 105, 123, 354, 108, 120, 357, 111,
        117, 360, 114, 364, 369, 374, 379, 135,
        384, 385, 391, 386, 388, 136, 387, 390,
        389, 138, 393, 137, 396, 395, 398, 397,
        138
};

static const char _indic_syllable_machine_trans_actions[] = {
        1, 0, 2, 0, 2, 0, 0, 2,
        0, 0, 2, 0, 0, 2, 0, 0,
        0, 2, 0, 0, 2, 0, 0, 2,
        0, 0, 2, 2, 2, 2, 2, 2,
        2, 2, 2, 2, 3, 0, 2, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 2,
        4, 0, 2, 0, 2, 5, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 0, 2, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 6, 2, 6, 2,
        6, 2, 6, 2, 7, 0, 2, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 2,
        6, 8, 0, 11, 2, 2, 6, 0,
        12, 12, 0, 2, 6, 2, 2, 0,
        13, 2, 0, 0, 2, 0, 2, 0,
        2, 2, 2, 0, 0, 2, 2, 0,
        2, 2, 2, 0, 0, 2, 2, 0,
        2, 2, 2, 0, 0, 2, 2, 0,
        2, 2, 2, 0, 0, 2, 2, 0,
        2, 0, 0, 0, 0, 14, 2, 0,
        0, 2, 0, 0, 2, 0, 0, 2,
        0, 2, 2, 2, 2, 15, 2, 0,
        0, 2, 0, 2, 0, 2, 2, 2,
        0, 0, 2, 2, 0, 2, 2, 2,
        0, 0, 2, 2, 0, 2, 2, 2,
        0, 0, 2, 2, 0, 2, 2, 2,
        0, 0, 2, 2, 0, 2, 0, 0,
        0, 0, 16, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 2, 2,
        2, 2, 17, 6, 0, 6, 2, 6,
        0, 0, 6, 6, 0, 6, 2, 6,
        0, 0, 6, 6, 0, 6, 2, 6,
        0, 0, 6, 6, 0, 6, 2, 6,
        0, 0, 6, 6, 0, 2, 0, 0,
        0, 0, 18, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 2, 2,
        2, 2, 19, 20, 2, 0, 0, 0,
        0, 2, 2, 2, 2, 0, 0, 2,
        2, 0, 2, 2, 2, 0, 0, 2,
        2, 0, 2, 2, 2, 0, 0, 2,
        2, 0, 2, 2, 2, 0, 0, 2,
        2, 0, 2, 0, 0, 0, 0, 21,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 2, 2, 2, 2, 0,
        0, 22, 22, 0, 0, 0, 0, 0,
        0, 23, 2, 0, 0, 0, 0, 0,
        24
};

static const char _indic_syllable_machine_to_state_actions[] = {
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 9, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 10, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 73, 73, 78, 78,
        73, 73, 73, 73, 73, 73, 73, 73,
        73, 73, 73, 73, 73, 73, 73, 73,
        73, 73, 73, 73, 73, 73, 73, 73,
        73, 73, 73, 73, 73, 109, 109, 109,
        109, 109, 109, 109, 109, 109, 109, 109,
        109, 109, 109, 109, 109, 109, 109, 109,
        109, 109, 109, 109, 109, 109, 109, 109,
        109, 109, 109, 109, 109, 109, 109, 73,
        1, 146, 0, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 222, 222, 222,
        222, 222, 222, 222, 222, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 283,
        283, 283, 283, 283, 283, 283, 283, 339,
        283, 339, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 340, 340,
        340, 340, 340, 340, 340, 340, 283, 161,
        161, 161, 161, 161, 161, 161, 161, 161,
        410, 410, 410, 410, 410, 410, 410, 339
};

static const int indic_syllable_machine_start = 138;
static const int indic_syllable_machine_first_final = 138;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 138;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 92 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", ts, te, #syllable_type); \
    for (unsigned int i = ts; i < te; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;

#line 934 "hb-ot-shape-complex-indic-machine.hh"
        {
        cs = indic_syllable_machine_start;
        ts = 0;
        te = 0;
        act = 0;
        }

#line 112 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int syllable_serial = 1;

#line 950 "hb-ot-shape-complex-indic-machine.hh"
        {
        int _slen;
        int _trans;
        const unsigned char *_keys;
        const short *_inds;
        if ( p == pe )
                goto _test_eof;
_resume:
        switch ( _indic_syllable_machine_from_state_actions[cs] ) {
        case 10:
#line 1 "NONE"
        {ts = p;}
        break;
#line 964 "hb-ot-shape-complex-indic-machine.hh"
        }

        _keys = _indic_syllable_machine_trans_keys + (cs<<1);
        _inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

        _slen = _indic_syllable_machine_key_spans[cs];
        _trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
                ( info[p].indic_category()) <= _keys[1] ?
                ( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
        cs = _indic_syllable_machine_trans_targs[_trans];

        if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
                goto _again;

        switch ( _indic_syllable_machine_trans_actions[_trans] ) {
        case 2:
#line 1 "NONE"
        {te = p+1;}
        break;
        case 14:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (consonant_syllable); }}
        break;
        case 16:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (vowel_syllable); }}
        break;
        case 21:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (standalone_cluster); }}
        break;
        case 24:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (symbol_cluster); }}
        break;
        case 18:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (broken_cluster); }}
        break;
        case 11:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (non_indic_cluster); }}
        break;
        case 13:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (consonant_syllable); }}
        break;
        case 15:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (vowel_syllable); }}
        break;
        case 20:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (standalone_cluster); }}
        break;
        case 23:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (symbol_cluster); }}
        break;
        case 17:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (broken_cluster); }}
        break;
        case 19:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (non_indic_cluster); }}
        break;
        case 1:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
        break;
        case 3:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
        break;
        case 7:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
        break;
        case 8:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
        break;
        case 4:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (broken_cluster); }}
        break;
        case 5:
#line 1 "NONE"
        {       switch( act ) {
        case 1:
        {{p = ((te))-1;} found_syllable (consonant_syllable); }
        break;
        case 5:
        {{p = ((te))-1;} found_syllable (broken_cluster); }
        break;
        case 6:
        {{p = ((te))-1;} found_syllable (non_indic_cluster); }
        break;
        }
        }
        break;
        case 22:
#line 1 "NONE"
        {te = p+1;}
#line 83 "hb-ot-shape-complex-indic-machine.rl"
        {act = 1;}
        break;
        case 6:
#line 1 "NONE"
        {te = p+1;}
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {act = 5;}
        break;
        case 12:
#line 1 "NONE"
        {te = p+1;}
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {act = 6;}
        break;
#line 1087 "hb-ot-shape-complex-indic-machine.hh"
        }

_again:
        switch ( _indic_syllable_machine_to_state_actions[cs] ) {
        case 9:
#line 1 "NONE"
        {ts = 0;}
        break;
#line 1096 "hb-ot-shape-complex-indic-machine.hh"
        }

        if ( ++p != pe )
                goto _resume;
        _test_eof: {}
        if ( p == eof )
        {
        if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
                _trans = _indic_syllable_machine_eof_trans[cs] - 1;
                goto _eof_trans;
        }
        }

        }

#line 120 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
