/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.UndoManager;
import org.jhotdraw.util.Undoable;

public class RedoCommand
extends AbstractCommand {
    public RedoCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        UndoManager undoManager = this.getDrawingEditor().getUndoManager();
        if (undoManager == null || !undoManager.isRedoable()) {
            return;
        }
        Undoable undoable = undoManager.popRedo();
        boolean bl = undoable.redo();
        if (bl && undoable.isUndoable()) {
            undoManager.pushUndo(undoable);
        }
        undoable.getDrawingView().checkDamage();
        this.getDrawingEditor().figureSelectionChanged(undoable.getDrawingView());
    }

    public boolean isExecutableWithView() {
        UndoManager undoManager = this.getDrawingEditor().getUndoManager();
        return undoManager != null && undoManager.getRedoSize() > 0;
    }
}

