/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FloatingTextField;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextEditingTool
extends AbstractTool
implements ActionListener {
    private FloatingTextField textField;
    private TextHolderFigure typingTarget;

    public TextEditingTool(TextHolderFigure textHolderFigure) {
        this.typingTarget = textHolderFigure;
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        this.endEdit();
        super.deactivate(drawingEditor);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.typingTarget != null) {
            this.beginEdit(this.typingTarget);
            this.updateCursor(this.getView(), mouseEvent.getPoint());
        }
    }

    protected void beginEdit(TextHolderFigure textHolderFigure) {
        if (this.textField == null) {
            this.textField = new FloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolderFigure != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolderFigure);
        this.textField.requestFocus();
        this.typingTarget = textHolderFigure;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure textHolderFigure = this.typingTarget;
            final String string = this.typingTarget.getText();
            final String string2 = this.textField.getText();
            if (string2.length() > 0) {
                this.typingTarget.willChange();
                this.typingTarget.setText(string2);
                this.typingTarget.changed();
            }
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string);
                    textHolderFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string2);
                    textHolderFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(abstractUndoableEdit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.fireToolDone();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.endEdit();
        this.fireToolDone();
    }

    public boolean isEditing() {
        return this.typingTarget != null;
    }

    @Override
    public void updateCursor(DrawingView drawingView, Point point) {
        if (drawingView.isEnabled()) {
            drawingView.setCursor(Cursor.getPredefinedCursor(this.isEditing() ? 0 : 1));
        } else {
            drawingView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

