/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import com.wombatinvasion.pmwikidraw.PmWikiDrawURLEncoder;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.ChopEllipseConnector;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class EllipseFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = -6856203289355118951L;
    private int ellipseFigureSerializedDataVersion = 1;

    public EllipseFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public EllipseFigure(Point point, Point point2) {
        this.basicDisplayBox(point, point2);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, list);
        return new HandleEnumerator(list);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopEllipseConnector(this);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
    }

    public String getMap() {
        String string = (String)this.getAttribute(FigureAttributeConstant.URL);
        if (string != null && string.length() > 0) {
            try {
                string = PmWikiDrawURLEncoder.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle rectangle = this.displayBox();
            double d = (double)rectangle.width / 2.0;
            double d2 = (double)rectangle.height / 2.0;
            double d3 = rectangle.height > rectangle.width ? 1.5707963267948966 : 0.0;
            Point point = this.center();
            String string2 = "";
            for (int i = 0; i < 6; ++i) {
                if (i > 0) {
                    string2 = string2 + ",";
                }
                int n = (int)((double)point.x + Math.cos(d3) * d);
                int n2 = (int)((double)point.y + Math.sin(d3) * d2);
                string2 = string2 + n + "," + n2;
                d3 += 1.0471975511965976;
            }
            return "<area shape=\"poly\" coords=\"" + string2 + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
        }
        return "";
    }
}

