/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xmlopen.zipspy.Utils;
import org.xmlopen.zipspy.ZipHeaderBase;

public class ZipCentralRecord
extends ZipHeaderBase {
    static Logger logger = Logger.getLogger(ZipCentralRecord.class);
    private byte[] madeByVersion = new byte[2];
    private short fileCommentLength;
    private short diskNumberStart;
    private byte[] internalFileAttributes = new byte[2];
    private byte[] externalFileAttributes = new byte[4];
    private int localHeaderOffset;
    private String fileComment;

    public ZipCentralRecord(InputStream is) {
        try {
            is.read(this.madeByVersion);
            is.read(this.extractVersion);
            this.general = Utils.readShortLittle(is);
            is.read(this.method);
            is.read(this.modTime);
            is.read(this.modDate);
            this.crc32 = Utils.readIntLittle(is);
            this.compressedSize = Utils.readIntLittle(is);
            this.uncompressedSize = Utils.readIntLittle(is);
            this.filenameLength = Utils.readShortLittle(is);
            this.extraFieldLength = Utils.readShortLittle(is);
            this.fileCommentLength = Utils.readShortLittle(is);
            this.diskNumberStart = Utils.readShortLittle(is);
            is.read(this.internalFileAttributes);
            is.read(this.externalFileAttributes);
            this.localHeaderOffset = Utils.readIntLittle(is);
            byte[] b = new byte[this.filenameLength];
            is.read(b);
            this.filename = new String(b);
            is.skip(this.extraFieldLength);
            b = new byte[this.fileCommentLength];
            is.read(b);
            this.fileComment = new String(b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getMadeByVersion() {
        return this.madeByVersion;
    }

    public short getFileCommentLength() {
        return this.fileCommentLength;
    }

    public short getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public byte[] getInternalFileAttributes() {
        return this.internalFileAttributes;
    }

    public byte[] getExternalFileAttributes() {
        return this.externalFileAttributes;
    }

    public int getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public String asXmlString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<central-record>");
        sb.append(Utils.makeElement("filename", this.filename));
        sb.append(Utils.makeByteElement("version-made-by", this.madeByVersion));
        sb.append(Utils.makeByteElement("version-needed-to-extract", this.extractVersion));
        sb.append(Utils.makeElement("general-flag", this.general));
        sb.append(Utils.makeByteElement("compression-method", this.method));
        sb.append(Utils.makeByteElement("mod-time", this.extractVersion));
        sb.append(Utils.makeByteElement("mod-date", this.extractVersion));
        sb.append(Utils.makeElement("crc-32", this.crc32));
        sb.append(Utils.makeElement("compressed-size", this.compressedSize));
        sb.append(Utils.makeElement("uncompressed-size", this.uncompressedSize));
        sb.append(Utils.makeElement("filename-length", this.filenameLength));
        sb.append(Utils.makeElement("extra-field-length", this.extraFieldLength));
        sb.append(Utils.makeElement("file-comment-length", this.extraFieldLength));
        sb.append(Utils.makeByteElement("internal-file-attributes", this.internalFileAttributes));
        sb.append(Utils.makeByteElement("external-file-attributes", this.externalFileAttributes));
        sb.append(Utils.makeElement("local-header-offset", this.localHeaderOffset));
        sb.append(Utils.makeElement("file-comment", this.fileComment));
        sb.append("</central-record>");
        return sb.toString();
    }
}

