; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple aarch64 < %s | FileCheck %s

define float @faddp_2xfloat(<2 x float> %a) {
; CHECK-LABEL: faddp_2xfloat:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    faddp s0, v0.2s
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x float> %a, <2 x float> undef, <2 x i32> <i32 1, i32 undef>
  %0 = fadd <2 x float> %a, %shift
  %1 = extractelement <2 x float> %0, i32 0
  ret float %1
}

define float @faddp_4xfloat(<4 x float> %a) {
; CHECK-LABEL: faddp_4xfloat:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    faddp s0, v0.2s
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %0 = fadd <4 x float> %a, %shift
  %1 = extractelement <4 x float> %0, i32 0
  ret float %1
}

define float @faddp_4xfloat_commute(<4 x float> %a) {
; CHECK-LABEL: faddp_4xfloat_commute:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    faddp s0, v0.2s
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %0 = fadd <4 x float> %shift, %a
  %1 = extractelement <4 x float> %0, i32 0
  ret float %1
}

define float @faddp_2xfloat_commute(<2 x float> %a) {
; CHECK-LABEL: faddp_2xfloat_commute:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    faddp s0, v0.2s
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x float> %a, <2 x float> undef, <2 x i32> <i32 1, i32 undef>
  %0 = fadd <2 x float> %shift, %a
  %1 = extractelement <2 x float> %0, i32 0
  ret float %1
}

define double @faddp_2xdouble(<2 x double> %a) {
; CHECK-LABEL: faddp_2xdouble:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    faddp d0, v0.2d
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x double> %a, <2 x double> undef, <2 x i32> <i32 1, i32 undef>
  %0 = fadd <2 x double> %a, %shift
  %1 = extractelement <2 x double> %0, i32 0
  ret double %1
}

define double @faddp_2xdouble_commute(<2 x double> %a) {
; CHECK-LABEL: faddp_2xdouble_commute:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    faddp d0, v0.2d
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x double> %a, <2 x double> undef, <2 x i32> <i32 1, i32 undef>
  %0 = fadd <2 x double> %shift, %a
  %1 = extractelement <2 x double> %0, i32 0
  ret double %1
}

define i64 @addp_2xi64(<2 x i64> %a) {
; CHECK-LABEL: addp_2xi64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp d0, v0.2d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x i64> %a, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %0 = add <2 x i64> %a, %shift
  %1 = extractelement <2 x i64> %0, i32 0
  ret i64 %1
}

define i64 @addp_2xi64_commute(<2 x i64> %a) {
; CHECK-LABEL: addp_2xi64_commute:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp d0, v0.2d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
entry:
  %shift = shufflevector <2 x i64> %a, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %0 = add <2 x i64> %shift, %a
  %1 = extractelement <2 x i64> %0, i32 0
  ret i64 %1
}
