/*
 *  GRUB  --  GRand Unified Bootloader
 *  Copyright (C) 2025 Free Software Foundation, Inc.
 *
 *  GRUB is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  GRUB is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GRUB.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <grub/test.h>
#include <grub/crypto.h>
#include <grub/gcrypt/gcrypt.h>

GRUB_MOD_LICENSE ("GPLv3+");

/* Sample RSA key.  */
static char pubkey_dump[] = {
  0x28, 0x31, 0x30, 0x3a, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x63, 0x2d, 0x6b, 0x65, 0x79, 0x28, 0x33,
  0x3a, 0x72, 0x73, 0x61, 0x28, 0x31, 0x3a, 0x6e,
  0x31, 0x32, 0x39, 0x3a, 0x00, 0xe1, 0x35, 0xc1,
  0x97, 0x90, 0xe8, 0x54, 0xa8, 0x3b, 0x97, 0x05,
  0xaf, 0x45, 0xaf, 0x67, 0xbf, 0xec, 0x07, 0xbe,
  0x9b, 0x55, 0x9c, 0x3f, 0x47, 0xae, 0x25, 0xb6,
  0xe3, 0x23, 0x99, 0x10, 0x5e, 0x17, 0x1a, 0xda,
  0x33, 0xe6, 0x73, 0x0d, 0x96, 0x9c, 0x5c, 0x25,
  0x13, 0x5d, 0x49, 0xb9, 0x86, 0xc0, 0xb1, 0x80,
  0x29, 0x20, 0xb2, 0x91, 0x72, 0x43, 0xcc, 0x2a,
  0x67, 0xd3, 0x11, 0xe8, 0x7b, 0x21, 0x75, 0xf6,
  0x1b, 0xc0, 0xb2, 0x01, 0xc8, 0x35, 0xaa, 0xfb,
  0xa7, 0x29, 0xb4, 0xb9, 0x94, 0x4e, 0x53, 0x49,
  0x82, 0x74, 0xe9, 0x23, 0x69, 0xa4, 0xf6, 0xdf,
  0x40, 0x2a, 0x73, 0x01, 0xfa, 0xe7, 0xf8, 0x32,
  0x6b, 0x57, 0xfe, 0xb9, 0x7d, 0x02, 0xc2, 0xfb,
  0x7f, 0x99, 0x1f, 0x6e, 0x8d, 0x53, 0x01, 0x56,
  0xaf, 0x46, 0x62, 0xb3, 0xe0, 0xa8, 0xa6, 0x0a,
  0x55, 0x2c, 0x4b, 0x85, 0x5b, 0x29, 0x28, 0x31,
  0x3a, 0x65, 0x33, 0x3a, 0x01, 0x00, 0x01, 0x29,
  0x29, 0x29,
};

/* Sample RSA signature of message "hello" with sample key.  */
static char sig_dump[] = {
  0x28, 0x37, 0x3a, 0x73, 0x69, 0x67, 0x2d, 0x76,
  0x61, 0x6c, 0x28, 0x33, 0x3a, 0x72, 0x73, 0x61,
  0x28, 0x31, 0x3a, 0x73, 0x31, 0x32, 0x38, 0x3a,
  0x5b, 0x2d, 0xeb, 0xa5, 0x4b, 0x8b, 0xd9, 0x92,
  0x66, 0x57, 0x89, 0xd8, 0x31, 0xc0, 0x0e, 0x53,
  0xf8, 0x1c, 0x4f, 0xc8, 0x79, 0x67, 0xb9, 0x10,
  0xe5, 0x63, 0x5f, 0xef, 0xb1, 0x0b, 0x0e, 0x7f,
  0xed, 0x86, 0x06, 0xa8, 0x05, 0xbf, 0x6b, 0xd1,
  0x36, 0x41, 0x08, 0x3b, 0xd0, 0xbd, 0xef, 0xb7,
  0xc2, 0x69, 0xb8, 0xb4, 0x3e, 0x2c, 0xb5, 0x39,
  0x13, 0x03, 0xca, 0xad, 0x5f, 0xd2, 0x57, 0x23,
  0x19, 0xdd, 0x71, 0xdd, 0x93, 0xe1, 0x3e, 0x43,
  0xaf, 0xdd, 0x94, 0x07, 0xf3, 0x78, 0xb3, 0x2a,
  0x57, 0x24, 0x97, 0x04, 0x58, 0xc1, 0xaf, 0xd3,
  0xe7, 0xa7, 0x65, 0xd1, 0x23, 0xa3, 0x93, 0x18,
  0xc7, 0x52, 0x70, 0x53, 0x60, 0x8b, 0x5a, 0x5d,
  0x6e, 0xf9, 0x83, 0x52, 0x99, 0xbb, 0x0a, 0x53,
  0x0e, 0x2a, 0x7f, 0x81, 0x52, 0x02, 0x32, 0xa4,
  0xfc, 0xe0, 0x17, 0x0c, 0x0e, 0x96, 0xbd, 0x01,
  0x29, 0x29, 0x29,
};

extern gcry_pk_spec_t _gcry_pubkey_spec_rsa;

static void
rsa_sexp_test (void)
{
  gcry_sexp_t sign_parms, sign_parms_invalid, pubkey, sig;
  int rc;
  grub_size_t errof;

  rc = _gcry_sexp_build (&sign_parms_invalid, &errof,
			"(data (flags) (value \"hi\"))\n");
  grub_test_assert (rc == 0, "sexp build failed");

  rc = _gcry_sexp_build (&sign_parms, &errof,
			"(data (flags) (value \"hello\"))\n");
  grub_test_assert (rc == 0, "sexp build failed");
  rc = _gcry_sexp_new (&pubkey, pubkey_dump, sizeof(pubkey_dump), 0);
  grub_test_assert (rc == 0, "sexp new failed");
  rc = _gcry_sexp_new (&sig, sig_dump, sizeof(sig_dump), 0);
  grub_test_assert (rc == 0, "sexp new failed");
  rc = _gcry_pubkey_spec_rsa.verify (sig, sign_parms, pubkey);
  grub_test_assert (rc == 0, "signature verification failed: %d", rc);
  rc = _gcry_pubkey_spec_rsa.verify (sig, sign_parms_invalid, pubkey);
  grub_test_assert (rc != 0, "signature verification succeded wrongly");
}

GRUB_FUNCTIONAL_TEST (rsa_sexp_test, rsa_sexp_test);
