/*
# Copyright 2016 Nikos Mavrogiannopoulos
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
################################################################################
*/

#include <assert.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>

#include <gnutls/gnutls.h>

#include "fuzzer.h"

int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size)
{
	gnutls_datum_t out;
	int ret;

	ret = gnutls_idna_reverse_map((char *)data, size, &out, 0);
	if (ret < 0)
		goto cleanup;

	assert(out.size == strlen((char *)out.data));
	gnutls_free(out.data);

cleanup:
	return 0;
}
