/* sudoku-saver.c generated by valac 0.32.0.59-edc5, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

GType sudoku_saver_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_SAVER_DUMMY_PROPERTY
};
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
static void _vala_array_add1 (gint** array, int* length, int* size, gint value);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
DifficultyCategory difficulty_category_from_string (const gchar* input);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void sudoku_saver_finalize (GObject* obj);
static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SudokuSaver* sudoku_saver_construct (GType object_type) {
	SudokuSaver * self = NULL;
	GError * _inner_error_ = NULL;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	self = (SudokuSaver*) g_object_new (object_type, NULL);
#line 202 "sudoku-saver.c"
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp0_ = g_get_user_data_dir ();
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		config_dir = _tmp1_;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = config_dir;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_data_dir = _tmp3_;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp4_ = sudoku_saver_get_savegame_file ();
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp5_ = _tmp4_;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp6_ = sudoku_data_dir;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp8_ = _tmp7_;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_saver_set_savegame_file (_tmp8_);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (_tmp8_);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp10_ = _tmp9_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp11_ = sudoku_data_dir;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp13_ = _tmp12_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_saver_set_finishgame_dir (_tmp13_);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (_tmp13_);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp14_ = sudoku_data_dir;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp15_ = g_file_new_for_path (_tmp14_);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		file = _tmp15_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp16_ = file;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (!_tmp17_) {
#line 282 "sudoku-saver.c"
			GFile* _tmp18_ = NULL;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp18_ = file;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			g_file_make_directory (_tmp18_, NULL, &_inner_error_);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_object_unref0 (file);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (sudoku_data_dir);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (config_dir);
#line 296 "sudoku-saver.c"
				goto __catch0_g_error;
			}
		}
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp19_ = sudoku_saver_get_finishgame_dir ();
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp20_ = _tmp19_;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp21_ = g_file_new_for_path (_tmp20_);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		file = _tmp21_;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp22_ = file;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp23_ = g_file_query_exists (_tmp22_, NULL);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (!_tmp23_) {
#line 316 "sudoku-saver.c"
			GFile* _tmp24_ = NULL;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp24_ = file;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			g_file_make_directory (_tmp24_, NULL, &_inner_error_);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_object_unref0 (file);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (sudoku_data_dir);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (config_dir);
#line 330 "sudoku-saver.c"
				goto __catch0_g_error;
			}
		}
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (sudoku_data_dir);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (config_dir);
#line 340 "sudoku-saver.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp25_ = e;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp26_ = _tmp25_->message;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_warning ("sudoku-saver.vala:48: %s", _tmp26_);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 360 "sudoku-saver.c"
	}
	__finally0:
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return NULL;
#line 371 "sudoku-saver.c"
	}
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self;
#line 375 "sudoku-saver.c"
}


SudokuSaver* sudoku_saver_new (void) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
#line 382 "sudoku-saver.c"
}


SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self) {
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver_get_savegame_file ();
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file = _tmp2_;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = file;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (!_tmp4_) {
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		result = NULL;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return result;
#line 419 "sudoku-saver.c"
	}
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = sudoku_saver_get_savegame_file ();
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = _tmp5_;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = sudoku_saver_parse_json_to_game (self, _tmp6_);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp7_;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (file);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 433 "sudoku-saver.c"
}


void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game) {
	SudokuGame* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = sudoku_saver_get_savegame_file ();
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_create_file_for_game (self, _tmp0_, _tmp2_);
#line 453 "sudoku-saver.c"
}


void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame) {
	gchar* file_name = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* file_path = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_->board;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = sudoku_board_to_string (_tmp1_, TRUE);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = _tmp2_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = _tmp4_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (_tmp3_);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file_name = _tmp5_;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = _tmp6_;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = file_name;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file_path = _tmp9_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = game;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = file_path;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_create_file_for_game (self, _tmp10_, _tmp11_);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp12_ = delete_savegame;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (_tmp12_) {
#line 514 "sudoku-saver.c"
		GFile* file = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp13_ = sudoku_saver_get_savegame_file ();
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp14_ = _tmp13_;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp15_ = g_file_new_for_path (_tmp14_);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		file = _tmp15_;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp16_ = file;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (_tmp17_) {
#line 535 "sudoku-saver.c"
			{
				GFile* _tmp18_ = NULL;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp18_ = file;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_file_delete (_tmp18_, NULL, &_inner_error_);
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 544 "sudoku-saver.c"
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				e = _inner_error_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_inner_error_ = NULL;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp19_ = file;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp20_ = g_file_get_uri (_tmp19_);
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp21_ = _tmp20_;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp22_ = e;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp23_ = _tmp22_->message;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_warning ("sudoku-saver.vala:84: Failed to delete %s: %s", _tmp21_, _tmp23_);
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (_tmp21_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_error_free0 (e);
#line 577 "sudoku-saver.c"
			}
			__finally1:
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_object_unref0 (file);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (file_path);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (file_name);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_clear_error (&_inner_error_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				return;
#line 594 "sudoku-saver.c"
			}
		}
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 599 "sudoku-saver.c"
	}
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (file_path);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (file_name);
#line 605 "sudoku-saver.c"
}


static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name) {
	gchar* json_str = NULL;
	SudokuGame* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (file_name != NULL);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = sudoku_saver_serialize_game_to_json (self, _tmp0_);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_str = _tmp1_;
#line 626 "sudoku-saver.c"
	{
		const gchar* _tmp2_ = NULL;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = file_name;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_file_set_contents (_tmp2_, json_str, (gssize) -1, &_inner_error_);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 635 "sudoku-saver.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp3_ = e;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp4_ = _tmp3_->message;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_warning ("sudoku-saver.vala:100: %s", _tmp4_);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 657 "sudoku-saver.c"
	}
	__finally2:
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (json_str);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return;
#line 670 "sudoku-saver.c"
	}
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (json_str);
#line 674 "sudoku-saver.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self ? g_object_ref (self) : NULL;
#line 681 "sudoku-saver.c"
}


static void _vala_array_add1 (gint** array, int* length, int* size, gint value) {
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if ((*length) == (*size)) {
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		*array = g_renew (gint, *array, *size);
#line 692 "sudoku-saver.c"
	}
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	(*array)[(*length)++] = value;
#line 696 "sudoku-saver.c"
}


static void _vala_JsonNode_free (JsonNode* self) {
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_boxed_free (json_node_get_type (), self);
#line 703 "sudoku-saver.c"
}


static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game) {
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	SudokuBoard* _tmp2_ = NULL;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint board_cells_length1 = 0;
	gint board_cells_length2 = 0;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_ = NULL;
	JsonBuilder* _tmp8_ = NULL;
	JsonBuilder* _tmp9_ = NULL;
	JsonBuilder* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	DifficultyCategory _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonBuilder* _tmp16_ = NULL;
	SudokuGame* _tmp17_ = NULL;
	GameMode _tmp18_ = 0;
	JsonBuilder* _tmp23_ = NULL;
	JsonBuilder* _tmp24_ = NULL;
	JsonBuilder* _tmp85_ = NULL;
	JsonBuilder* _tmp86_ = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp87_ = NULL;
	JsonNode* root = NULL;
	JsonBuilder* _tmp88_ = NULL;
	JsonNode* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_->board;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board = _tmp2_;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = board;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells = _tmp6_;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells_length1 = _tmp4_;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells_length2 = _tmp5_;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = json_builder_new ();
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	builder = _tmp7_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = builder;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_begin_object (_tmp8_);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = builder;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp9_, "difficulty_category");
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = builder;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = board;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp13_ = _tmp12_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp14_ = difficulty_category_to_untranslated_string (_tmp13_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp15_ = _tmp14_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_add_string_value (_tmp10_, _tmp15_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (_tmp15_);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp16_ = builder;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp16_, "time_elapsed");
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp17_ = game;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp18_ = _tmp17_->mode;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (_tmp18_ == GAME_MODE_CREATE) {
#line 803 "sudoku-saver.c"
		JsonBuilder* _tmp19_ = NULL;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp19_ = builder;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		json_builder_add_double_value (_tmp19_, (gdouble) 0);
#line 809 "sudoku-saver.c"
	} else {
		JsonBuilder* _tmp20_ = NULL;
		SudokuGame* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp20_ = builder;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp21_ = game;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp22_ = sudoku_game_get_total_time_played (_tmp21_);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		json_builder_add_double_value (_tmp20_, _tmp22_);
#line 822 "sudoku-saver.c"
	}
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp23_ = builder;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp23_, "cells");
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp24_ = builder;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_begin_array (_tmp24_);
#line 832 "sudoku-saver.c"
	{
		gint i = 0;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		i = 0;
#line 837 "sudoku-saver.c"
		{
			gboolean _tmp25_ = FALSE;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp25_ = TRUE;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			while (TRUE) {
#line 844 "sudoku-saver.c"
				gint _tmp27_ = 0;
				SudokuBoard* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!_tmp25_) {
#line 851 "sudoku-saver.c"
					gint _tmp26_ = 0;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp26_ = i;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					i = _tmp26_ + 1;
#line 857 "sudoku-saver.c"
				}
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp25_ = FALSE;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp27_ = i;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp28_ = board;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp29_ = sudoku_board_get_rows (_tmp28_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp30_ = _tmp29_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!(_tmp27_ < _tmp30_)) {
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					break;
#line 873 "sudoku-saver.c"
				}
				{
					gint j = 0;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					j = 0;
#line 879 "sudoku-saver.c"
					{
						gboolean _tmp31_ = FALSE;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						_tmp31_ = TRUE;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						while (TRUE) {
#line 886 "sudoku-saver.c"
							gint _tmp33_ = 0;
							SudokuBoard* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint* earmarks = NULL;
							gint* _tmp37_ = NULL;
							gint earmarks_length1 = 0;
							gint _earmarks_size_ = 0;
							gboolean _tmp51_ = FALSE;
							gint* _tmp52_ = NULL;
							gint _tmp52__length1 = 0;
							gint _tmp52__length2 = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							JsonBuilder* _tmp57_ = NULL;
							JsonBuilder* _tmp58_ = NULL;
							JsonBuilder* _tmp59_ = NULL;
							JsonBuilder* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							JsonBuilder* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							JsonBuilder* _tmp64_ = NULL;
							JsonBuilder* _tmp65_ = NULL;
							JsonBuilder* _tmp66_ = NULL;
							gint* _tmp67_ = NULL;
							gint _tmp67__length1 = 0;
							gint _tmp67__length2 = 0;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							gint _tmp70_ = 0;
							JsonBuilder* _tmp71_ = NULL;
							JsonBuilder* _tmp72_ = NULL;
							SudokuBoard* _tmp73_ = NULL;
							gboolean* _tmp74_ = NULL;
							gint _tmp74__length1 = 0;
							gint _tmp74__length2 = 0;
							gint _tmp75_ = 0;
							gint _tmp76_ = 0;
							gboolean _tmp77_ = FALSE;
							JsonBuilder* _tmp78_ = NULL;
							JsonBuilder* _tmp79_ = NULL;
							gint* _tmp80_ = NULL;
							gint _tmp80__length1 = 0;
							JsonBuilder* _tmp83_ = NULL;
							JsonBuilder* _tmp84_ = NULL;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!_tmp31_) {
#line 935 "sudoku-saver.c"
								gint _tmp32_ = 0;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp32_ = j;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								j = _tmp32_ + 1;
#line 941 "sudoku-saver.c"
							}
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp31_ = FALSE;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp33_ = j;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp34_ = board;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp35_ = sudoku_board_get_cols (_tmp34_);
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp36_ = _tmp35_;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!(_tmp33_ < _tmp36_)) {
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								break;
#line 957 "sudoku-saver.c"
							}
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp37_ = g_new0 (gint, 0);
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks = _tmp37_;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks_length1 = 0;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_earmarks_size_ = earmarks_length1;
#line 967 "sudoku-saver.c"
							{
								gint k = 0;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k = 1;
#line 972 "sudoku-saver.c"
								{
									gboolean _tmp38_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									_tmp38_ = TRUE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									while (TRUE) {
#line 979 "sudoku-saver.c"
										gint _tmp40_ = 0;
										SudokuBoard* _tmp41_ = NULL;
										gint _tmp42_ = 0;
										gint _tmp43_ = 0;
										SudokuBoard* _tmp44_ = NULL;
										gint _tmp45_ = 0;
										gint _tmp46_ = 0;
										gint _tmp47_ = 0;
										gboolean _tmp48_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (!_tmp38_) {
#line 991 "sudoku-saver.c"
											gint _tmp39_ = 0;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp39_ = k;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											k = _tmp39_ + 1;
#line 997 "sudoku-saver.c"
										}
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp38_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp40_ = k;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp41_ = board;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp42_ = sudoku_board_get_max_val (_tmp41_);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp43_ = _tmp42_;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (!(_tmp40_ <= _tmp43_)) {
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											break;
#line 1013 "sudoku-saver.c"
										}
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp44_ = board;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp45_ = i;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp46_ = j;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp47_ = k;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp48_ = sudoku_board_is_earmark_enabled (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (_tmp48_) {
#line 1027 "sudoku-saver.c"
											gint* _tmp49_ = NULL;
											gint _tmp49__length1 = 0;
											gint _tmp50_ = 0;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp49_ = earmarks;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp49__length1 = earmarks_length1;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp50_ = k;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp50_);
#line 1039 "sudoku-saver.c"
										}
									}
								}
							}
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp52_ = board_cells;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp52__length1 = board_cells_length1;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp52__length2 = board_cells_length2;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp53_ = i;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp54_ = j;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp55_ = _tmp52_[(_tmp53_ * _tmp52__length2) + _tmp54_];
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (_tmp55_ == 0) {
#line 1058 "sudoku-saver.c"
								gint* _tmp56_ = NULL;
								gint _tmp56__length1 = 0;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp56_ = earmarks;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp56__length1 = earmarks_length1;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp51_ = _tmp56__length1 == 0;
#line 1067 "sudoku-saver.c"
							} else {
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp51_ = FALSE;
#line 1071 "sudoku-saver.c"
							}
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (_tmp51_) {
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								earmarks = (g_free (earmarks), NULL);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								continue;
#line 1079 "sudoku-saver.c"
							}
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp57_ = builder;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_object (_tmp57_);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp58_ = builder;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp58_, "position");
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp59_ = builder;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_array (_tmp59_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp60_ = builder;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp61_ = i;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp60_, (gint64) _tmp61_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp62_ = builder;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp63_ = j;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp62_, (gint64) _tmp63_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64_ = builder;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_array (_tmp64_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp65_ = builder;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp65_, "value");
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp66_ = builder;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67_ = board_cells;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67__length1 = board_cells_length1;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67__length2 = board_cells_length2;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp68_ = i;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp69_ = j;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp70_ = _tmp67_[(_tmp68_ * _tmp67__length2) + _tmp69_];
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp66_, (gint64) _tmp70_);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71_ = builder;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp71_, "fixed");
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp72_ = builder;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp73_ = board;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp74_ = _tmp73_->is_fixed;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp74__length1 = _tmp73_->is_fixed_length1;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp74__length2 = _tmp73_->is_fixed_length2;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp75_ = i;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp76_ = j;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp77_ = _tmp74_[(_tmp75_ * _tmp74__length2) + _tmp76_];
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_boolean_value (_tmp72_, _tmp77_);
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp78_ = builder;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp78_, "earmarks");
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp79_ = builder;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_array (_tmp79_);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp80_ = earmarks;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp80__length1 = earmarks_length1;
#line 1163 "sudoku-saver.c"
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k_collection = _tmp80_;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k_collection_length1 = _tmp80__length1;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								for (k_it = 0; k_it < _tmp80__length1; k_it = k_it + 1) {
#line 1175 "sudoku-saver.c"
									gint k = 0;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									k = k_collection[k_it];
#line 1179 "sudoku-saver.c"
									{
										JsonBuilder* _tmp81_ = NULL;
										gint _tmp82_ = 0;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp81_ = builder;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp82_ = k;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										json_builder_add_int_value (_tmp81_, (gint64) _tmp82_);
#line 1189 "sudoku-saver.c"
									}
								}
							}
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp83_ = builder;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_array (_tmp83_);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp84_ = builder;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_object (_tmp84_);
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks = (g_free (earmarks), NULL);
#line 1203 "sudoku-saver.c"
						}
					}
				}
			}
		}
	}
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp85_ = builder;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_end_array (_tmp85_);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp86_ = builder;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_end_object (_tmp86_);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp87_ = json_generator_new ();
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	generator = _tmp87_;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_generator_set_pretty (generator, TRUE);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp88_ = builder;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp89_ = json_builder_get_root (_tmp88_);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	root = _tmp89_;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_generator_set_root (generator, root);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp90_ = json_generator_to_data (generator, NULL);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp90_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	__vala_JsonNode_free0 (root);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (generator);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (builder);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells = (g_free (board_cells), NULL);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (board);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1248 "sudoku-saver.c"
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1255 "sudoku-saver.c"
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1262 "sudoku-saver.c"
}


static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path) {
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp3_ = NULL;
	JsonNode* node = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonReader* reader = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonReader* _tmp8_ = NULL;
	JsonReader* _tmp9_ = NULL;
	JsonReader* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonReader* _tmp75_ = NULL;
	JsonReader* _tmp76_ = NULL;
	JsonReader* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	SudokuBoard* _tmp79_ = NULL;
	JsonReader* _tmp80_ = NULL;
	gdouble _tmp81_ = 0.0;
	JsonReader* _tmp82_ = NULL;
	JsonReader* _tmp83_ = NULL;
	JsonReader* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	SudokuBoard* _tmp86_ = NULL;
	JsonReader* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	DifficultyCategory _tmp89_ = 0;
	JsonReader* _tmp90_ = NULL;
	SudokuBoard* _tmp91_ = NULL;
	SudokuGame* _tmp92_ = NULL;
	GError * _inner_error_ = NULL;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (file_path != NULL, NULL);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = json_parser_new ();
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	parser = _tmp0_;
#line 1309 "sudoku-saver.c"
	{
		JsonParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp1_ = parser;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = file_path;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1321 "sudoku-saver.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		result = NULL;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (parser);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return result;
#line 1341 "sudoku-saver.c"
	}
	__finally3:
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (parser);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return NULL;
#line 1354 "sudoku-saver.c"
	}
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = sudoku_board_new (3, 3);
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board = _tmp3_;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = parser;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = json_parser_get_root (_tmp4_);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	node = _tmp6_;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = node;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = json_reader_new (_tmp7_);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	reader = _tmp8_;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = reader;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp9_, "cells");
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = reader;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = json_reader_is_array (_tmp10_);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp11_, NULL);
#line 1384 "sudoku-saver.c"
	{
		gint i = 0;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		i = 0;
#line 1389 "sudoku-saver.c"
		{
			gboolean _tmp12_ = FALSE;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp12_ = TRUE;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			while (TRUE) {
#line 1396 "sudoku-saver.c"
				gint _tmp14_ = 0;
				JsonReader* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				JsonReader* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				JsonReader* _tmp19_ = NULL;
				JsonReader* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				JsonReader* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				JsonReader* _tmp24_ = NULL;
				JsonReader* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gint row = 0;
				JsonReader* _tmp27_ = NULL;
				gint64 _tmp28_ = 0LL;
				JsonReader* _tmp29_ = NULL;
				JsonReader* _tmp30_ = NULL;
				JsonReader* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				gint col = 0;
				JsonReader* _tmp33_ = NULL;
				gint64 _tmp34_ = 0LL;
				JsonReader* _tmp35_ = NULL;
				JsonReader* _tmp36_ = NULL;
				JsonReader* _tmp37_ = NULL;
				JsonReader* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gint val = 0;
				JsonReader* _tmp40_ = NULL;
				gint64 _tmp41_ = 0LL;
				JsonReader* _tmp42_ = NULL;
				JsonReader* _tmp43_ = NULL;
				JsonReader* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				JsonReader* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				JsonReader* _tmp55_ = NULL;
				JsonReader* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				JsonReader* _tmp73_ = NULL;
				JsonReader* _tmp74_ = NULL;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!_tmp12_) {
#line 1444 "sudoku-saver.c"
					gint _tmp13_ = 0;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp13_ = i;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					i = _tmp13_ + 1;
#line 1450 "sudoku-saver.c"
				}
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp12_ = FALSE;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp14_ = i;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp15_ = reader;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp16_ = json_reader_count_elements (_tmp15_);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!(_tmp14_ < _tmp16_)) {
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					break;
#line 1464 "sudoku-saver.c"
				}
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp17_ = reader;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp18_ = i;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp17_, (guint) _tmp18_);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp19_ = reader;
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp19_, "position");
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp20_ = reader;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp21_ = json_reader_is_array (_tmp20_);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp21_, NULL);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp22_ = reader;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp23_ = json_reader_count_elements (_tmp22_);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp23_ == 2, NULL);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp24_ = reader;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp24_, (guint) 0);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp25_ = reader;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp26_ = json_reader_is_value (_tmp25_);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp26_, NULL);
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp27_ = reader;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp28_ = json_reader_get_int_value (_tmp27_);
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				row = (gint) _tmp28_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp29_ = reader;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp29_);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp30_ = reader;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp30_, (guint) 1);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp31_ = reader;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp32_ = json_reader_is_value (_tmp31_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp32_, NULL);
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp33_ = reader;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp34_ = json_reader_get_int_value (_tmp33_);
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				col = (gint) _tmp34_;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp35_ = reader;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp35_);
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp36_ = reader;
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp36_);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp37_ = reader;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp37_, "value");
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp38_ = reader;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp39_ = json_reader_is_value (_tmp38_);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp39_, NULL);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp40_ = reader;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp41_ = json_reader_get_int_value (_tmp40_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				val = (gint) _tmp41_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp42_ = reader;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp42_);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp43_ = reader;
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp43_, "fixed");
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp44_ = reader;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp45_ = json_reader_is_value (_tmp44_);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp45_, NULL);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp46_ = reader;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp47_ = json_reader_get_boolean_value (_tmp46_);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				is_fixed = _tmp47_;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp48_ = reader;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp48_);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp49_ = val;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (_tmp49_ != 0) {
#line 1576 "sudoku-saver.c"
					SudokuBoard* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gboolean _tmp54_ = FALSE;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp50_ = board;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp51_ = row;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp52_ = col;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp53_ = val;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp54_ = is_fixed;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					sudoku_board_insert (_tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
#line 1594 "sudoku-saver.c"
				}
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp55_ = reader;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp55_, "earmarks");
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp56_ = reader;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp57_ = json_reader_is_array (_tmp56_);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp57_, NULL);
#line 1606 "sudoku-saver.c"
				{
					gint k = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					k = 0;
#line 1611 "sudoku-saver.c"
					{
						gboolean _tmp58_ = FALSE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						_tmp58_ = TRUE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						while (TRUE) {
#line 1618 "sudoku-saver.c"
							gint _tmp60_ = 0;
							JsonReader* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							JsonReader* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							JsonReader* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							SudokuBoard* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							JsonReader* _tmp70_ = NULL;
							gint64 _tmp71_ = 0LL;
							JsonReader* _tmp72_ = NULL;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!_tmp58_) {
#line 1634 "sudoku-saver.c"
								gint _tmp59_ = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp59_ = k;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k = _tmp59_ + 1;
#line 1640 "sudoku-saver.c"
							}
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp58_ = FALSE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp60_ = k;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp61_ = reader;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp62_ = json_reader_count_elements (_tmp61_);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!(_tmp60_ < _tmp62_)) {
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								break;
#line 1654 "sudoku-saver.c"
							}
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp63_ = reader;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64_ = k;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_reader_read_element (_tmp63_, (guint) _tmp64_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp65_ = reader;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp66_ = json_reader_is_value (_tmp65_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							g_return_val_if_fail (_tmp66_, NULL);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67_ = board;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp68_ = row;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp69_ = col;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp70_ = reader;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71_ = json_reader_get_int_value (_tmp70_);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							sudoku_board_enable_earmark (_tmp67_, _tmp68_, _tmp69_, (gint) _tmp71_);
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp72_ = reader;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_reader_end_element (_tmp72_);
#line 1684 "sudoku-saver.c"
						}
					}
				}
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp73_ = reader;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp73_);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp74_ = reader;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp74_);
#line 1696 "sudoku-saver.c"
			}
		}
	}
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp75_ = reader;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp75_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp76_ = reader;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp76_, "time_elapsed");
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp77_ = reader;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp78_ = json_reader_is_value (_tmp77_);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp78_, NULL);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp79_ = board;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp80_ = reader;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp81_ = json_reader_get_double_value (_tmp80_);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_board_set_previous_played_time (_tmp79_, _tmp81_);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp82_ = reader;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp82_);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp83_ = reader;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp83_, "difficulty_category");
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp84_ = reader;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp85_ = json_reader_is_value (_tmp84_);
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp85_, NULL);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp86_ = board;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp87_ = reader;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp88_ = json_reader_get_string_value (_tmp87_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp89_ = difficulty_category_from_string (_tmp88_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_board_set_difficulty_category (_tmp86_, _tmp89_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp90_ = reader;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp90_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp91_ = board;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp92_ = sudoku_game_new (_tmp91_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp92_;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (reader);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	__vala_JsonNode_free0 (node);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (board);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (parser);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1766 "sudoku-saver.c"
}


const gchar* sudoku_saver_get_savegame_file (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver__savegame_file;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp0_;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1779 "sudoku-saver.c"
}


static void sudoku_saver_set_savegame_file (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = value;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (sudoku_saver__savegame_file);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__savegame_file = _tmp1_;
#line 1794 "sudoku-saver.c"
}


const gchar* sudoku_saver_get_finishgame_dir (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver__finishgame_dir;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1807 "sudoku-saver.c"
}


static void sudoku_saver_set_finishgame_dir (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = value;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (sudoku_saver__finishgame_dir);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__finishgame_dir = _tmp1_;
#line 1822 "sudoku-saver.c"
}


static void sudoku_saver_class_init (SudokuSaverClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = g_strdup ("");
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__savegame_file = _tmp0_;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup ("");
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__finishgame_dir = _tmp1_;
#line 1845 "sudoku-saver.c"
}


static void sudoku_saver_instance_init (SudokuSaver * self) {
}


static void sudoku_saver_finalize (GObject* obj) {
	SudokuSaver * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
#line 1859 "sudoku-saver.c"
}


GType sudoku_saver_get_type (void) {
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	switch (property_id) {
#line 1880 "sudoku-saver.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		break;
#line 1886 "sudoku-saver.c"
	}
}


static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	switch (property_id) {
#line 1896 "sudoku-saver.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		break;
#line 1902 "sudoku-saver.c"
	}
}



