# Yrsa & Rasa

**Yrsa** and **Rasa** are open-source type families published by [Rosetta](https://rosettatype.com) with generous financial support from Google. The fonts support over 331 languages in the Latin script and 3 languages in the Gujarati script (Gujarati, Kachchi, Avestan). The family currently has 5 weights. The design was done by [Anna Giedryś](http://ancymonic.com) ([@ancymonic](http://github.com/ancymonic)) and [David Březina](http://davi.cz) ([@MrBrezina](http://github.com/MrBrezina)). The font engineering was done by [Johannes Neumeier](http://underscoretype.com) ([@kontur](http://github.com/kontur)).

Yrsa is the name of the Latin-only type family. Rasa is the name of the Gujarati type family. Both type families are intended for continuous reading on the web (longer articles in online news, magazines, blogs). In Yrsa, a special consideration was given to Central and East European languages and proper shaping of their accents. Rasa supports a wide array of basic and compound syllables used in Gujarati. In terms of glyphs included Rasa is a superset of Yrsa, it includes the complete Latin.

What makes the Yrsa & Rasa project different is the design approach. It is a deliberate experiment in remixing existing typefaces to produce a new one. The Latin part is based on [Merriweather](http://sorkintype.com/fonts.html#mw) by Eben Sorkin. The Gujarati is based on David Březina’s [Skolar Gujarati](https://www.rosettatype.com/Skolar#gujarati).

The project has been documented in several articles. See the [Yrsa & Rasa project page](http://github.rosettatype.com/yrsa-rasa) for details.

In 2020–2021, Yrsa and Rasa received a major update. Rosetta added a substantial set of glyphs to the uprights of both type families to provide wider language support, including full support for Vietnamese, additional stylistic sets of numerals (there are lining and text numerals, superiors, inferiors, fractions) and quite a few monetary symbols. On top of all this, Anna Giedryś created the highly anticipated and often requested italics for the Latin script. Unlike the uprights, the italics were designed completely from scratch, giving the family a distinctive touch. Optimized for screen and online use, Yrsa is now a well-rounded text typeface. Rasa received only a minor maintenance update and an addition of glyphs to support the Avestan language. Both families come with variable fonts!

## Download

You can download the compiled fonts from [Releases](https://github.com/rosettatype/yrsa-rasa/releases) section of this repo or from the Google Fonts directory (soon). Alternatively, you can find them in Adobe Typekit.


## Building the fonts from source

If you want to compile the fonts from sources, read the [production README](https://github.com/rosettatype/yrsa-rasa/tree/master/documentation).


## Rosetta – world typography specialists

Rosetta addresses the needs of global typography. Together with our collaborators we create original fonts for a polyphonic world. Our work has been featured and awarded. But most importantly it has enabled people to read better in their native language.

So far our retail library supports pan-European Latin, Arabic, Armenian, Greek, Cyrillic (besides Slavic languages we also support many Asian languages), Inuktitut, and Indic scripts like Gujarati and Devanagari. In total, the library covers more than 450 languages.

For more information see the website at [rosettatype.com](http://rosettatype.com).

You can contact us at <ask@rosettatype.com>.


## License

The fonts and related code are licensed under [Open Font License](https://github.com/rosettatype/yrsa-rasa/tree/master/OFL.txt). See `OFL.txt` for licensing information.


## Feedback & progress

This version is now considered final. Let us know if you spot any problem (via issues).

![Yrsa preview](https://rawgithub.com/rosettatype/yrsa-rasa/master/documentation/Yrsa-Rasa-previews_1_big.svg)

![Rasa preview](https://rawgithub.com/rosettatype/yrsa-rasa/master/documentation/Yrsa-Rasa-previews_2_big.svg)
