/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Oct 29 08:18:40 EDT 2017 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hb_32 -include rdft/scalar/hb.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 236 additions, 62 multiplications, 198 fused multiply/add),
 * 102 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hb.h"

static void hb_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 62, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E Tf, T5K, T7k, T8k, T7N, T8x, T1i, T3i, T2L, T3v, T4v, T5f, T6m, T6T, T42;
	       E T52, TZ, T6X, T1X, T3p, T8p, T8B, T26, T3o, T4n, T58, T7z, T7T, T4k, T59;
	       E T6a, T6p, TK, T6W, T2o, T3m, T8s, T8A, T2x, T3l, T4g, T55, T7G, T7S, T4d;
	       E T56, T61, T6o, Tu, T6f, T7r, T8y, T7Q, T8l, T1F, T3w, T2O, T3j, T4y, T53;
	       E T5R, T6U, T49, T5g;
	       {
		    E T3, T12, T6, T2D, T2G, T6g, T15, T6h, Td, T6k, T1g, T2J, Ta, T6j, T1b;
		    E T2I;
		    {
			 E T1, T2, T13, T14;
			 T1 = cr[0];
			 T2 = ci[WS(rs, 15)];
			 T3 = T1 + T2;
			 T12 = T1 - T2;
			 {
			      E T4, T5, T2E, T2F;
			      T4 = cr[WS(rs, 8)];
			      T5 = ci[WS(rs, 7)];
			      T6 = T4 + T5;
			      T2D = T4 - T5;
			      T2E = ci[WS(rs, 31)];
			      T2F = cr[WS(rs, 16)];
			      T2G = T2E + T2F;
			      T6g = T2E - T2F;
			 }
			 T13 = ci[WS(rs, 23)];
			 T14 = cr[WS(rs, 24)];
			 T15 = T13 + T14;
			 T6h = T13 - T14;
			 {
			      E Tb, Tc, T1c, T1d, T1e, T1f;
			      Tb = ci[WS(rs, 3)];
			      Tc = cr[WS(rs, 12)];
			      T1c = Tb - Tc;
			      T1d = ci[WS(rs, 19)];
			      T1e = cr[WS(rs, 28)];
			      T1f = T1d + T1e;
			      Td = Tb + Tc;
			      T6k = T1d - T1e;
			      T1g = T1c - T1f;
			      T2J = T1c + T1f;
			 }
			 {
			      E T8, T9, T17, T18, T19, T1a;
			      T8 = cr[WS(rs, 4)];
			      T9 = ci[WS(rs, 11)];
			      T17 = T8 - T9;
			      T18 = ci[WS(rs, 27)];
			      T19 = cr[WS(rs, 20)];
			      T1a = T18 + T19;
			      Ta = T8 + T9;
			      T6j = T18 - T19;
			      T1b = T17 - T1a;
			      T2I = T17 + T1a;
			 }
		    }
		    {
			 E T7, Te, T7i, T7j;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 T5K = T7 - Te;
			 T7i = T3 - T6;
			 T7j = T6k - T6j;
			 T7k = T7i - T7j;
			 T8k = T7i + T7j;
		    }
		    {
			 E T7L, T7M, T16, T1h;
			 T7L = T6g - T6h;
			 T7M = Ta - Td;
			 T7N = T7L - T7M;
			 T8x = T7M + T7L;
			 T16 = T12 - T15;
			 T1h = T1b + T1g;
			 T1i = FNMS(KP707106781, T1h, T16);
			 T3i = FMA(KP707106781, T1h, T16);
		    }
		    {
			 E T2H, T2K, T4t, T4u;
			 T2H = T2D + T2G;
			 T2K = T2I - T2J;
			 T2L = FNMS(KP707106781, T2K, T2H);
			 T3v = FMA(KP707106781, T2K, T2H);
			 T4t = T2G - T2D;
			 T4u = T1b - T1g;
			 T4v = FMA(KP707106781, T4u, T4t);
			 T5f = FNMS(KP707106781, T4u, T4t);
		    }
		    {
			 E T6i, T6l, T40, T41;
			 T6i = T6g + T6h;
			 T6l = T6j + T6k;
			 T6m = T6i - T6l;
			 T6T = T6i + T6l;
			 T40 = T12 + T15;
			 T41 = T2I + T2J;
			 T42 = FNMS(KP707106781, T41, T40);
			 T52 = FMA(KP707106781, T41, T40);
		    }
	       }
	       {
		    E TR, T7w, T1H, T1Y, T1K, T7t, T21, T65, TY, T7u, T7x, T1Q, T1V, T24, T68;
		    E T23, T7v, T7y;
		    {
			 E TL, TM, TN, TO, TP, TQ;
			 TL = ci[0];
			 TM = cr[WS(rs, 15)];
			 TN = TL + TM;
			 TO = cr[WS(rs, 7)];
			 TP = ci[WS(rs, 8)];
			 TQ = TO + TP;
			 TR = TN + TQ;
			 T7w = TN - TQ;
			 T1H = TO - TP;
			 T1Y = TL - TM;
		    }
		    {
			 E T1I, T1J, T63, T1Z, T20, T64;
			 T1I = ci[WS(rs, 16)];
			 T1J = cr[WS(rs, 31)];
			 T63 = T1I - T1J;
			 T1Z = ci[WS(rs, 24)];
			 T20 = cr[WS(rs, 23)];
			 T64 = T1Z - T20;
			 T1K = T1I + T1J;
			 T7t = T63 - T64;
			 T21 = T1Z + T20;
			 T65 = T63 + T64;
		    }
		    {
			 E TU, T1M, T1U, T67, TX, T1R, T1P, T66;
			 {
			      E TS, TT, T1S, T1T;
			      TS = cr[WS(rs, 3)];
			      TT = ci[WS(rs, 12)];
			      TU = TS + TT;
			      T1M = TS - TT;
			      T1S = ci[WS(rs, 20)];
			      T1T = cr[WS(rs, 27)];
			      T1U = T1S + T1T;
			      T67 = T1S - T1T;
			 }
			 {
			      E TV, TW, T1N, T1O;
			      TV = ci[WS(rs, 4)];
			      TW = cr[WS(rs, 11)];
			      TX = TV + TW;
			      T1R = TV - TW;
			      T1N = ci[WS(rs, 28)];
			      T1O = cr[WS(rs, 19)];
			      T1P = T1N + T1O;
			      T66 = T1N - T1O;
			 }
			 TY = TU + TX;
			 T7u = TU - TX;
			 T7x = T67 - T66;
			 T1Q = T1M + T1P;
			 T1V = T1R + T1U;
			 T24 = T1R - T1U;
			 T68 = T66 + T67;
			 T23 = T1M - T1P;
		    }
		    TZ = TR + TY;
		    T6X = T65 + T68;
		    {
			 E T1L, T1W, T8n, T8o;
			 T1L = T1H - T1K;
			 T1W = T1Q - T1V;
			 T1X = FNMS(KP707106781, T1W, T1L);
			 T3p = FMA(KP707106781, T1W, T1L);
			 T8n = T7u + T7t;
			 T8o = T7w + T7x;
			 T8p = FNMS(KP414213562, T8o, T8n);
			 T8B = FMA(KP414213562, T8n, T8o);
		    }
		    {
			 E T22, T25, T4l, T4m;
			 T22 = T1Y - T21;
			 T25 = T23 + T24;
			 T26 = FNMS(KP707106781, T25, T22);
			 T3o = FMA(KP707106781, T25, T22);
			 T4l = T1H + T1K;
			 T4m = T23 - T24;
			 T4n = FNMS(KP707106781, T4m, T4l);
			 T58 = FMA(KP707106781, T4m, T4l);
		    }
		    T7v = T7t - T7u;
		    T7y = T7w - T7x;
		    T7z = FMA(KP414213562, T7y, T7v);
		    T7T = FNMS(KP414213562, T7v, T7y);
		    {
			 E T4i, T4j, T62, T69;
			 T4i = T1Y + T21;
			 T4j = T1Q + T1V;
			 T4k = FNMS(KP707106781, T4j, T4i);
			 T59 = FMA(KP707106781, T4j, T4i);
			 T62 = TR - TY;
			 T69 = T65 - T68;
			 T6a = T62 + T69;
			 T6p = T69 - T62;
		    }
	       }
	       {
		    E TC, T7D, T28, T2p, T2b, T7A, T2s, T5W, TJ, T7B, T7E, T2h, T2m, T2v, T5Z;
		    E T2u, T7C, T7F;
		    {
			 E Tw, Tx, Ty, Tz, TA, TB;
			 Tw = cr[WS(rs, 1)];
			 Tx = ci[WS(rs, 14)];
			 Ty = Tw + Tx;
			 Tz = cr[WS(rs, 9)];
			 TA = ci[WS(rs, 6)];
			 TB = Tz + TA;
			 TC = Ty + TB;
			 T7D = Ty - TB;
			 T28 = Tz - TA;
			 T2p = Tw - Tx;
		    }
		    {
			 E T29, T2a, T5U, T2q, T2r, T5V;
			 T29 = ci[WS(rs, 30)];
			 T2a = cr[WS(rs, 17)];
			 T5U = T29 - T2a;
			 T2q = ci[WS(rs, 22)];
			 T2r = cr[WS(rs, 25)];
			 T5V = T2q - T2r;
			 T2b = T29 + T2a;
			 T7A = T5U - T5V;
			 T2s = T2q + T2r;
			 T5W = T5U + T5V;
		    }
		    {
			 E TF, T2d, T2l, T5Y, TI, T2i, T2g, T5X;
			 {
			      E TD, TE, T2j, T2k;
			      TD = cr[WS(rs, 5)];
			      TE = ci[WS(rs, 10)];
			      TF = TD + TE;
			      T2d = TD - TE;
			      T2j = ci[WS(rs, 18)];
			      T2k = cr[WS(rs, 29)];
			      T2l = T2j + T2k;
			      T5Y = T2j - T2k;
			 }
			 {
			      E TG, TH, T2e, T2f;
			      TG = ci[WS(rs, 2)];
			      TH = cr[WS(rs, 13)];
			      TI = TG + TH;
			      T2i = TG - TH;
			      T2e = ci[WS(rs, 26)];
			      T2f = cr[WS(rs, 21)];
			      T2g = T2e + T2f;
			      T5X = T2e - T2f;
			 }
			 TJ = TF + TI;
			 T7B = TF - TI;
			 T7E = T5Y - T5X;
			 T2h = T2d + T2g;
			 T2m = T2i + T2l;
			 T2v = T2i - T2l;
			 T5Z = T5X + T5Y;
			 T2u = T2d - T2g;
		    }
		    TK = TC + TJ;
		    T6W = T5W + T5Z;
		    {
			 E T2c, T2n, T8q, T8r;
			 T2c = T28 + T2b;
			 T2n = T2h - T2m;
			 T2o = FNMS(KP707106781, T2n, T2c);
			 T3m = FMA(KP707106781, T2n, T2c);
			 T8q = T7B + T7A;
			 T8r = T7D + T7E;
			 T8s = FMA(KP414213562, T8r, T8q);
			 T8A = FNMS(KP414213562, T8q, T8r);
		    }
		    {
			 E T2t, T2w, T4e, T4f;
			 T2t = T2p - T2s;
			 T2w = T2u + T2v;
			 T2x = FNMS(KP707106781, T2w, T2t);
			 T3l = FMA(KP707106781, T2w, T2t);
			 T4e = T2b - T28;
			 T4f = T2v - T2u;
			 T4g = FNMS(KP707106781, T4f, T4e);
			 T55 = FMA(KP707106781, T4f, T4e);
		    }
		    T7C = T7A - T7B;
		    T7F = T7D - T7E;
		    T7G = FNMS(KP414213562, T7F, T7C);
		    T7S = FMA(KP414213562, T7C, T7F);
		    {
			 E T4b, T4c, T5T, T60;
			 T4b = T2p + T2s;
			 T4c = T2h + T2m;
			 T4d = FNMS(KP707106781, T4c, T4b);
			 T56 = FMA(KP707106781, T4c, T4b);
			 T5T = TC - TJ;
			 T60 = T5W - T5Z;
			 T61 = T5T - T60;
			 T6o = T5T + T60;
		    }
	       }
	       {
		    E Ti, T5P, Tl, T5O, T1y, T1D, T7p, T7o, T44, T43, Tp, T5M, Ts, T5L, T1n;
		    E T1s, T7m, T7l, T47, T46;
		    {
			 E T1z, T1C, T1u, T1x;
			 {
			      E Tg, Th, T1A, T1B;
			      Tg = cr[WS(rs, 2)];
			      Th = ci[WS(rs, 13)];
			      Ti = Tg + Th;
			      T1z = Tg - Th;
			      T1A = ci[WS(rs, 21)];
			      T1B = cr[WS(rs, 26)];
			      T1C = T1A + T1B;
			      T5P = T1A - T1B;
			 }
			 {
			      E Tj, Tk, T1v, T1w;
			      Tj = cr[WS(rs, 10)];
			      Tk = ci[WS(rs, 5)];
			      Tl = Tj + Tk;
			      T1u = Tj - Tk;
			      T1v = ci[WS(rs, 29)];
			      T1w = cr[WS(rs, 18)];
			      T1x = T1v + T1w;
			      T5O = T1v - T1w;
			 }
			 T1y = T1u + T1x;
			 T1D = T1z - T1C;
			 T7p = T5O - T5P;
			 T7o = Ti - Tl;
			 T44 = T1z + T1C;
			 T43 = T1x - T1u;
		    }
		    {
			 E T1o, T1r, T1j, T1m;
			 {
			      E Tn, To, T1p, T1q;
			      Tn = ci[WS(rs, 1)];
			      To = cr[WS(rs, 14)];
			      Tp = Tn + To;
			      T1o = Tn - To;
			      T1p = ci[WS(rs, 25)];
			      T1q = cr[WS(rs, 22)];
			      T1r = T1p + T1q;
			      T5M = T1p - T1q;
			 }
			 {
			      E Tq, Tr, T1k, T1l;
			      Tq = cr[WS(rs, 6)];
			      Tr = ci[WS(rs, 9)];
			      Ts = Tq + Tr;
			      T1j = Tq - Tr;
			      T1k = ci[WS(rs, 17)];
			      T1l = cr[WS(rs, 30)];
			      T1m = T1k + T1l;
			      T5L = T1k - T1l;
			 }
			 T1n = T1j - T1m;
			 T1s = T1o - T1r;
			 T7m = Tp - Ts;
			 T7l = T5L - T5M;
			 T47 = T1o + T1r;
			 T46 = T1j + T1m;
		    }
		    {
			 E Tm, Tt, T7n, T7q;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 T6f = Tm - Tt;
			 T7n = T7l - T7m;
			 T7q = T7o + T7p;
			 T7r = T7n - T7q;
			 T8y = T7q + T7n;
		    }
		    {
			 E T7O, T7P, T1t, T1E;
			 T7O = T7o - T7p;
			 T7P = T7m + T7l;
			 T7Q = T7O - T7P;
			 T8l = T7O + T7P;
			 T1t = FNMS(KP414213562, T1s, T1n);
			 T1E = FMA(KP414213562, T1D, T1y);
			 T1F = T1t - T1E;
			 T3w = T1E + T1t;
		    }
		    {
			 E T2M, T2N, T4w, T4x;
			 T2M = FNMS(KP414213562, T1y, T1D);
			 T2N = FMA(KP414213562, T1n, T1s);
			 T2O = T2M - T2N;
			 T3j = T2M + T2N;
			 T4w = FMA(KP414213562, T43, T44);
			 T4x = FMA(KP414213562, T46, T47);
			 T4y = T4w - T4x;
			 T53 = T4w + T4x;
		    }
		    {
			 E T5N, T5Q, T45, T48;
			 T5N = T5L + T5M;
			 T5Q = T5O + T5P;
			 T5R = T5N - T5Q;
			 T6U = T5Q + T5N;
			 T45 = FNMS(KP414213562, T44, T43);
			 T48 = FNMS(KP414213562, T47, T46);
			 T49 = T45 + T48;
			 T5g = T48 - T45;
		    }
	       }
	       {
		    E Tv, T10, T6Q, T6V, T6Y, T6Z;
		    Tv = Tf + Tu;
		    T10 = TK + TZ;
		    T6Q = Tv - T10;
		    T6V = T6T + T6U;
		    T6Y = T6W + T6X;
		    T6Z = T6V - T6Y;
		    cr[0] = Tv + T10;
		    ci[0] = T6V + T6Y;
		    {
			 E T6P, T6R, T6S, T70;
			 T6P = W[30];
			 T6R = T6P * T6Q;
			 T6S = W[31];
			 T70 = T6S * T6Q;
			 cr[WS(rs, 16)] = FNMS(T6S, T6Z, T6R);
			 ci[WS(rs, 16)] = FMA(T6P, T6Z, T70);
		    }
	       }
	       {
		    E T8O, T8W, T8T, T8Z;
		    {
			 E T8M, T8N, T8R, T8S;
			 T8M = FMA(KP707106781, T8l, T8k);
			 T8N = T8A + T8B;
			 T8O = FNMS(KP923879532, T8N, T8M);
			 T8W = FMA(KP923879532, T8N, T8M);
			 T8R = FMA(KP707106781, T8y, T8x);
			 T8S = T8s + T8p;
			 T8T = FNMS(KP923879532, T8S, T8R);
			 T8Z = FMA(KP923879532, T8S, T8R);
		    }
		    {
			 E T8P, T8U, T8L, T8Q;
			 T8L = W[34];
			 T8P = T8L * T8O;
			 T8U = T8L * T8T;
			 T8Q = W[35];
			 cr[WS(rs, 18)] = FNMS(T8Q, T8T, T8P);
			 ci[WS(rs, 18)] = FMA(T8Q, T8O, T8U);
		    }
		    {
			 E T8X, T90, T8V, T8Y;
			 T8V = W[2];
			 T8X = T8V * T8W;
			 T90 = T8V * T8Z;
			 T8Y = W[3];
			 cr[WS(rs, 2)] = FNMS(T8Y, T8Z, T8X);
			 ci[WS(rs, 2)] = FMA(T8Y, T8W, T90);
		    }
	       }
	       {
		    E T86, T8e, T8b, T8h;
		    {
			 E T84, T85, T89, T8a;
			 T84 = FNMS(KP707106781, T7r, T7k);
			 T85 = T7S + T7T;
			 T86 = FNMS(KP923879532, T85, T84);
			 T8e = FMA(KP923879532, T85, T84);
			 T89 = FNMS(KP707106781, T7Q, T7N);
			 T8a = T7G + T7z;
			 T8b = FNMS(KP923879532, T8a, T89);
			 T8h = FMA(KP923879532, T8a, T89);
		    }
		    {
			 E T87, T8c, T83, T88;
			 T83 = W[26];
			 T87 = T83 * T86;
			 T8c = T83 * T8b;
			 T88 = W[27];
			 cr[WS(rs, 14)] = FNMS(T88, T8b, T87);
			 ci[WS(rs, 14)] = FMA(T88, T86, T8c);
		    }
		    {
			 E T8f, T8i, T8d, T8g;
			 T8d = W[58];
			 T8f = T8d * T8e;
			 T8i = T8d * T8h;
			 T8g = W[59];
			 cr[WS(rs, 30)] = FNMS(T8g, T8h, T8f);
			 ci[WS(rs, 30)] = FMA(T8g, T8e, T8i);
		    }
	       }
	       {
		    E T6C, T6K, T6H, T6N;
		    {
			 E T6A, T6B, T6F, T6G;
			 T6A = T5K - T5R;
			 T6B = T6p - T6o;
			 T6C = FNMS(KP707106781, T6B, T6A);
			 T6K = FMA(KP707106781, T6B, T6A);
			 T6F = T6m - T6f;
			 T6G = T61 - T6a;
			 T6H = FNMS(KP707106781, T6G, T6F);
			 T6N = FMA(KP707106781, T6G, T6F);
		    }
		    {
			 E T6D, T6I, T6z, T6E;
			 T6z = W[54];
			 T6D = T6z * T6C;
			 T6I = T6z * T6H;
			 T6E = W[55];
			 cr[WS(rs, 28)] = FNMS(T6E, T6H, T6D);
			 ci[WS(rs, 28)] = FMA(T6E, T6C, T6I);
		    }
		    {
			 E T6L, T6O, T6J, T6M;
			 T6J = W[22];
			 T6L = T6J * T6K;
			 T6O = T6J * T6N;
			 T6M = W[23];
			 cr[WS(rs, 12)] = FNMS(T6M, T6N, T6L);
			 ci[WS(rs, 12)] = FMA(T6M, T6K, T6O);
		    }
	       }
	       {
		    E T8u, T8G, T8D, T8J;
		    {
			 E T8m, T8t, T8z, T8C;
			 T8m = FNMS(KP707106781, T8l, T8k);
			 T8t = T8p - T8s;
			 T8u = FNMS(KP923879532, T8t, T8m);
			 T8G = FMA(KP923879532, T8t, T8m);
			 T8z = FNMS(KP707106781, T8y, T8x);
			 T8C = T8A - T8B;
			 T8D = FNMS(KP923879532, T8C, T8z);
			 T8J = FMA(KP923879532, T8C, T8z);
		    }
		    {
			 E T8j, T8v, T8w, T8E;
			 T8j = W[50];
			 T8v = T8j * T8u;
			 T8w = W[51];
			 T8E = T8w * T8u;
			 cr[WS(rs, 26)] = FNMS(T8w, T8D, T8v);
			 ci[WS(rs, 26)] = FMA(T8j, T8D, T8E);
		    }
		    {
			 E T8F, T8H, T8I, T8K;
			 T8F = W[18];
			 T8H = T8F * T8G;
			 T8I = W[19];
			 T8K = T8I * T8G;
			 cr[WS(rs, 10)] = FNMS(T8I, T8J, T8H);
			 ci[WS(rs, 10)] = FMA(T8F, T8J, T8K);
		    }
	       }
	       {
		    E T6c, T6u, T6r, T6x;
		    {
			 E T5S, T6b, T6n, T6q;
			 T5S = T5K + T5R;
			 T6b = T61 + T6a;
			 T6c = FNMS(KP707106781, T6b, T5S);
			 T6u = FMA(KP707106781, T6b, T5S);
			 T6n = T6f + T6m;
			 T6q = T6o + T6p;
			 T6r = FNMS(KP707106781, T6q, T6n);
			 T6x = FMA(KP707106781, T6q, T6n);
		    }
		    {
			 E T5J, T6d, T6e, T6s;
			 T5J = W[38];
			 T6d = T5J * T6c;
			 T6e = W[39];
			 T6s = T6e * T6c;
			 cr[WS(rs, 20)] = FNMS(T6e, T6r, T6d);
			 ci[WS(rs, 20)] = FMA(T5J, T6r, T6s);
		    }
		    {
			 E T6t, T6v, T6w, T6y;
			 T6t = W[6];
			 T6v = T6t * T6u;
			 T6w = W[7];
			 T6y = T6w * T6u;
			 cr[WS(rs, 4)] = FNMS(T6w, T6x, T6v);
			 ci[WS(rs, 4)] = FMA(T6t, T6x, T6y);
		    }
	       }
	       {
		    E T74, T7c, T79, T7f;
		    {
			 E T72, T73, T77, T78;
			 T72 = Tf - Tu;
			 T73 = T6X - T6W;
			 T74 = T72 - T73;
			 T7c = T72 + T73;
			 T77 = T6T - T6U;
			 T78 = TK - TZ;
			 T79 = T77 - T78;
			 T7f = T78 + T77;
		    }
		    {
			 E T75, T7a, T71, T76;
			 T71 = W[46];
			 T75 = T71 * T74;
			 T7a = T71 * T79;
			 T76 = W[47];
			 cr[WS(rs, 24)] = FNMS(T76, T79, T75);
			 ci[WS(rs, 24)] = FMA(T76, T74, T7a);
		    }
		    {
			 E T7d, T7g, T7b, T7e;
			 T7b = W[14];
			 T7d = T7b * T7c;
			 T7g = T7b * T7f;
			 T7e = W[15];
			 cr[WS(rs, 8)] = FNMS(T7e, T7f, T7d);
			 ci[WS(rs, 8)] = FMA(T7e, T7c, T7g);
		    }
	       }
	       {
		    E T7I, T7Y, T7V, T81;
		    {
			 E T7s, T7H, T7R, T7U;
			 T7s = FMA(KP707106781, T7r, T7k);
			 T7H = T7z - T7G;
			 T7I = FNMS(KP923879532, T7H, T7s);
			 T7Y = FMA(KP923879532, T7H, T7s);
			 T7R = FMA(KP707106781, T7Q, T7N);
			 T7U = T7S - T7T;
			 T7V = FNMS(KP923879532, T7U, T7R);
			 T81 = FMA(KP923879532, T7U, T7R);
		    }
		    {
			 E T7h, T7J, T7K, T7W;
			 T7h = W[42];
			 T7J = T7h * T7I;
			 T7K = W[43];
			 T7W = T7K * T7I;
			 cr[WS(rs, 22)] = FNMS(T7K, T7V, T7J);
			 ci[WS(rs, 22)] = FMA(T7h, T7V, T7W);
		    }
		    {
			 E T7X, T7Z, T80, T82;
			 T7X = W[10];
			 T7Z = T7X * T7Y;
			 T80 = W[11];
			 T82 = T80 * T7Y;
			 cr[WS(rs, 6)] = FNMS(T80, T81, T7Z);
			 ci[WS(rs, 6)] = FMA(T7X, T81, T82);
		    }
	       }
	       {
		    E T37, T2A, T38, T2W, T2T, T3c, T2Z, T34;
		    T37 = FNMS(KP923879532, T2O, T2L);
		    {
			 E T1G, T27, T2y, T2z;
			 T1G = FMA(KP923879532, T1F, T1i);
			 T27 = FMA(KP668178637, T26, T1X);
			 T2y = FNMS(KP668178637, T2x, T2o);
			 T2z = T27 - T2y;
			 T2A = FNMS(KP831469612, T2z, T1G);
			 T38 = T2y + T27;
			 T2W = FMA(KP831469612, T2z, T1G);
		    }
		    {
			 E T2P, T32, T2S, T33, T2Q, T2R;
			 T2P = FMA(KP923879532, T2O, T2L);
			 T32 = FNMS(KP923879532, T1F, T1i);
			 T2Q = FMA(KP668178637, T2o, T2x);
			 T2R = FNMS(KP668178637, T1X, T26);
			 T2S = T2Q - T2R;
			 T33 = T2Q + T2R;
			 T2T = FNMS(KP831469612, T2S, T2P);
			 T3c = FMA(KP831469612, T33, T32);
			 T2Z = FMA(KP831469612, T2S, T2P);
			 T34 = FNMS(KP831469612, T33, T32);
		    }
		    {
			 E T2B, T2U, T11, T2C;
			 T11 = W[40];
			 T2B = T11 * T2A;
			 T2U = T11 * T2T;
			 T2C = W[41];
			 cr[WS(rs, 21)] = FNMS(T2C, T2T, T2B);
			 ci[WS(rs, 21)] = FMA(T2C, T2A, T2U);
		    }
		    {
			 E T2X, T30, T2V, T2Y;
			 T2V = W[8];
			 T2X = T2V * T2W;
			 T30 = T2V * T2Z;
			 T2Y = W[9];
			 cr[WS(rs, 5)] = FNMS(T2Y, T2Z, T2X);
			 ci[WS(rs, 5)] = FMA(T2Y, T2W, T30);
		    }
		    {
			 E T39, T36, T3a, T31, T35;
			 T39 = FNMS(KP831469612, T38, T37);
			 T36 = W[25];
			 T3a = T36 * T34;
			 T31 = W[24];
			 T35 = T31 * T34;
			 cr[WS(rs, 13)] = FNMS(T36, T39, T35);
			 ci[WS(rs, 13)] = FMA(T31, T39, T3a);
		    }
		    {
			 E T3f, T3e, T3g, T3b, T3d;
			 T3f = FMA(KP831469612, T38, T37);
			 T3e = W[57];
			 T3g = T3e * T3c;
			 T3b = W[56];
			 T3d = T3b * T3c;
			 cr[WS(rs, 29)] = FNMS(T3e, T3f, T3d);
			 ci[WS(rs, 29)] = FMA(T3b, T3f, T3g);
		    }
	       }
	       {
		    E T4z, T4C, T4W, T4O, T4q, T4Z, T4G, T4T;
		    T4z = FMA(KP923879532, T4y, T4v);
		    {
			 E T4M, T4A, T4B, T4N;
			 T4M = FMA(KP923879532, T49, T42);
			 T4A = FMA(KP668178637, T4d, T4g);
			 T4B = FMA(KP668178637, T4k, T4n);
			 T4N = T4A + T4B;
			 T4C = T4A - T4B;
			 T4W = FMA(KP831469612, T4N, T4M);
			 T4O = FNMS(KP831469612, T4N, T4M);
		    }
		    {
			 E T4a, T4R, T4p, T4S, T4h, T4o;
			 T4a = FNMS(KP923879532, T49, T42);
			 T4R = FNMS(KP923879532, T4y, T4v);
			 T4h = FNMS(KP668178637, T4g, T4d);
			 T4o = FNMS(KP668178637, T4n, T4k);
			 T4p = T4h + T4o;
			 T4S = T4h - T4o;
			 T4q = FNMS(KP831469612, T4p, T4a);
			 T4Z = FNMS(KP831469612, T4S, T4R);
			 T4G = FMA(KP831469612, T4p, T4a);
			 T4T = FMA(KP831469612, T4S, T4R);
		    }
		    {
			 E T4P, T4U, T4L, T4Q;
			 T4L = W[20];
			 T4P = T4L * T4O;
			 T4U = T4L * T4T;
			 T4Q = W[21];
			 cr[WS(rs, 11)] = FNMS(T4Q, T4T, T4P);
			 ci[WS(rs, 11)] = FMA(T4Q, T4O, T4U);
		    }
		    {
			 E T4X, T50, T4V, T4Y;
			 T4V = W[52];
			 T4X = T4V * T4W;
			 T50 = T4V * T4Z;
			 T4Y = W[53];
			 cr[WS(rs, 27)] = FNMS(T4Y, T4Z, T4X);
			 ci[WS(rs, 27)] = FMA(T4Y, T4W, T50);
		    }
		    {
			 E T4D, T4s, T4E, T3Z, T4r;
			 T4D = FNMS(KP831469612, T4C, T4z);
			 T4s = W[37];
			 T4E = T4s * T4q;
			 T3Z = W[36];
			 T4r = T3Z * T4q;
			 cr[WS(rs, 19)] = FNMS(T4s, T4D, T4r);
			 ci[WS(rs, 19)] = FMA(T3Z, T4D, T4E);
		    }
		    {
			 E T4J, T4I, T4K, T4F, T4H;
			 T4J = FMA(KP831469612, T4C, T4z);
			 T4I = W[5];
			 T4K = T4I * T4G;
			 T4F = W[4];
			 T4H = T4F * T4G;
			 cr[WS(rs, 3)] = FNMS(T4I, T4J, T4H);
			 ci[WS(rs, 3)] = FMA(T4F, T4J, T4K);
		    }
	       }
	       {
		    E T3x, T3A, T3U, T3M, T3s, T3X, T3E, T3R;
		    T3x = FMA(KP923879532, T3w, T3v);
		    {
			 E T3K, T3y, T3z, T3L;
			 T3K = FNMS(KP923879532, T3j, T3i);
			 T3y = FMA(KP198912367, T3l, T3m);
			 T3z = FNMS(KP198912367, T3o, T3p);
			 T3L = T3z - T3y;
			 T3A = T3y + T3z;
			 T3U = FMA(KP980785280, T3L, T3K);
			 T3M = FNMS(KP980785280, T3L, T3K);
		    }
		    {
			 E T3k, T3P, T3r, T3Q, T3n, T3q;
			 T3k = FMA(KP923879532, T3j, T3i);
			 T3P = FNMS(KP923879532, T3w, T3v);
			 T3n = FNMS(KP198912367, T3m, T3l);
			 T3q = FMA(KP198912367, T3p, T3o);
			 T3r = T3n + T3q;
			 T3Q = T3n - T3q;
			 T3s = FNMS(KP980785280, T3r, T3k);
			 T3X = FMA(KP980785280, T3Q, T3P);
			 T3E = FMA(KP980785280, T3r, T3k);
			 T3R = FNMS(KP980785280, T3Q, T3P);
		    }
		    {
			 E T3N, T3S, T3J, T3O;
			 T3J = W[48];
			 T3N = T3J * T3M;
			 T3S = T3J * T3R;
			 T3O = W[49];
			 cr[WS(rs, 25)] = FNMS(T3O, T3R, T3N);
			 ci[WS(rs, 25)] = FMA(T3O, T3M, T3S);
		    }
		    {
			 E T3V, T3Y, T3T, T3W;
			 T3T = W[16];
			 T3V = T3T * T3U;
			 T3Y = T3T * T3X;
			 T3W = W[17];
			 cr[WS(rs, 9)] = FNMS(T3W, T3X, T3V);
			 ci[WS(rs, 9)] = FMA(T3W, T3U, T3Y);
		    }
		    {
			 E T3B, T3u, T3C, T3h, T3t;
			 T3B = FNMS(KP980785280, T3A, T3x);
			 T3u = W[33];
			 T3C = T3u * T3s;
			 T3h = W[32];
			 T3t = T3h * T3s;
			 cr[WS(rs, 17)] = FNMS(T3u, T3B, T3t);
			 ci[WS(rs, 17)] = FMA(T3h, T3B, T3C);
		    }
		    {
			 E T3H, T3G, T3I, T3D, T3F;
			 T3H = FMA(KP980785280, T3A, T3x);
			 T3G = W[1];
			 T3I = T3G * T3E;
			 T3D = W[0];
			 T3F = T3D * T3E;
			 cr[WS(rs, 1)] = FNMS(T3G, T3H, T3F);
			 ci[WS(rs, 1)] = FMA(T3D, T3H, T3I);
		    }
	       }
	       {
		    E T5h, T5k, T5E, T5w, T5c, T5H, T5o, T5B;
		    T5h = FMA(KP923879532, T5g, T5f);
		    {
			 E T5u, T5i, T5j, T5v;
			 T5u = FMA(KP923879532, T53, T52);
			 T5i = FMA(KP198912367, T55, T56);
			 T5j = FMA(KP198912367, T58, T59);
			 T5v = T5i + T5j;
			 T5k = T5i - T5j;
			 T5E = FMA(KP980785280, T5v, T5u);
			 T5w = FNMS(KP980785280, T5v, T5u);
		    }
		    {
			 E T54, T5z, T5b, T5A, T57, T5a;
			 T54 = FNMS(KP923879532, T53, T52);
			 T5z = FNMS(KP923879532, T5g, T5f);
			 T57 = FNMS(KP198912367, T56, T55);
			 T5a = FNMS(KP198912367, T59, T58);
			 T5b = T57 + T5a;
			 T5A = T5a - T57;
			 T5c = FMA(KP980785280, T5b, T54);
			 T5H = FNMS(KP980785280, T5A, T5z);
			 T5o = FNMS(KP980785280, T5b, T54);
			 T5B = FMA(KP980785280, T5A, T5z);
		    }
		    {
			 E T5x, T5C, T5t, T5y;
			 T5t = W[28];
			 T5x = T5t * T5w;
			 T5C = T5t * T5B;
			 T5y = W[29];
			 cr[WS(rs, 15)] = FNMS(T5y, T5B, T5x);
			 ci[WS(rs, 15)] = FMA(T5y, T5w, T5C);
		    }
		    {
			 E T5F, T5I, T5D, T5G;
			 T5D = W[60];
			 T5F = T5D * T5E;
			 T5I = T5D * T5H;
			 T5G = W[61];
			 cr[WS(rs, 31)] = FNMS(T5G, T5H, T5F);
			 ci[WS(rs, 31)] = FMA(T5G, T5E, T5I);
		    }
		    {
			 E T5l, T5e, T5m, T51, T5d;
			 T5l = FNMS(KP980785280, T5k, T5h);
			 T5e = W[45];
			 T5m = T5e * T5c;
			 T51 = W[44];
			 T5d = T51 * T5c;
			 cr[WS(rs, 23)] = FNMS(T5e, T5l, T5d);
			 ci[WS(rs, 23)] = FMA(T51, T5l, T5m);
		    }
		    {
			 E T5r, T5q, T5s, T5n, T5p;
			 T5r = FMA(KP980785280, T5k, T5h);
			 T5q = W[13];
			 T5s = T5q * T5o;
			 T5n = W[12];
			 T5p = T5n * T5o;
			 cr[WS(rs, 7)] = FNMS(T5q, T5r, T5p);
			 ci[WS(rs, 7)] = FMA(T5n, T5r, T5s);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hb_32", twinstr, &GENUS, {236, 62, 198, 0} };

void X(codelet_hb_32) (planner *p) {
     X(khc2hc_register) (p, hb_32, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hb_32 -include rdft/scalar/hb.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 98 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hb.h"

static void hb_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 62, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T4o, T6y, T70, T5u, Tf, T12, T5x, T6z, T3m, T3Y, T29, T2y, T4v, T71, T2U;
	       E T3M, Tu, T1U, T6D, T73, T6G, T74, T1h, T2z, T2X, T3o, T4D, T5A, T4K, T5z;
	       E T30, T3n, TK, T1j, T6S, T7w, T6V, T7v, T1y, T2B, T3c, T3S, T4X, T61, T54;
	       E T62, T3f, T3T, TZ, T1A, T6L, T7z, T6O, T7y, T1P, T2C, T35, T3P, T5g, T64;
	       E T5n, T65, T38, T3Q;
	       {
		    E T3, T4m, T24, T4q, T27, T4t, T6, T5s, Ta, T4p, T1X, T5t, T20, T4n, Td;
		    E T4s;
		    {
			 E T1, T2, T22, T23;
			 T1 = cr[0];
			 T2 = ci[WS(rs, 15)];
			 T3 = T1 + T2;
			 T4m = T1 - T2;
			 T22 = ci[WS(rs, 27)];
			 T23 = cr[WS(rs, 20)];
			 T24 = T22 - T23;
			 T4q = T22 + T23;
		    }
		    {
			 E T25, T26, T4, T5;
			 T25 = ci[WS(rs, 19)];
			 T26 = cr[WS(rs, 28)];
			 T27 = T25 - T26;
			 T4t = T25 + T26;
			 T4 = cr[WS(rs, 8)];
			 T5 = ci[WS(rs, 7)];
			 T6 = T4 + T5;
			 T5s = T4 - T5;
		    }
		    {
			 E T8, T9, T1V, T1W;
			 T8 = cr[WS(rs, 4)];
			 T9 = ci[WS(rs, 11)];
			 Ta = T8 + T9;
			 T4p = T8 - T9;
			 T1V = ci[WS(rs, 31)];
			 T1W = cr[WS(rs, 16)];
			 T1X = T1V - T1W;
			 T5t = T1V + T1W;
		    }
		    {
			 E T1Y, T1Z, Tb, Tc;
			 T1Y = ci[WS(rs, 23)];
			 T1Z = cr[WS(rs, 24)];
			 T20 = T1Y - T1Z;
			 T4n = T1Y + T1Z;
			 Tb = ci[WS(rs, 3)];
			 Tc = cr[WS(rs, 12)];
			 Td = Tb + Tc;
			 T4s = Tb - Tc;
		    }
		    {
			 E T7, Te, T21, T28;
			 T4o = T4m - T4n;
			 T6y = T4m + T4n;
			 T70 = T5t - T5s;
			 T5u = T5s + T5t;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 T12 = T7 - Te;
			 {
			      E T5v, T5w, T3k, T3l;
			      T5v = T4p + T4q;
			      T5w = T4s + T4t;
			      T5x = KP707106781 * (T5v - T5w);
			      T6z = KP707106781 * (T5v + T5w);
			      T3k = T1X - T20;
			      T3l = Ta - Td;
			      T3m = T3k - T3l;
			      T3Y = T3l + T3k;
			 }
			 T21 = T1X + T20;
			 T28 = T24 + T27;
			 T29 = T21 - T28;
			 T2y = T21 + T28;
			 {
			      E T4r, T4u, T2S, T2T;
			      T4r = T4p - T4q;
			      T4u = T4s - T4t;
			      T4v = KP707106781 * (T4r + T4u);
			      T71 = KP707106781 * (T4r - T4u);
			      T2S = T3 - T6;
			      T2T = T27 - T24;
			      T2U = T2S - T2T;
			      T3M = T2S + T2T;
			 }
		    }
	       }
	       {
		    E Ti, T4H, T1c, T4F, T1f, T4I, Tl, T4E, Tp, T4A, T15, T4y, T18, T4B, Ts;
		    E T4x;
		    {
			 E Tg, Th, T1a, T1b;
			 Tg = cr[WS(rs, 2)];
			 Th = ci[WS(rs, 13)];
			 Ti = Tg + Th;
			 T4H = Tg - Th;
			 T1a = ci[WS(rs, 29)];
			 T1b = cr[WS(rs, 18)];
			 T1c = T1a - T1b;
			 T4F = T1a + T1b;
		    }
		    {
			 E T1d, T1e, Tj, Tk;
			 T1d = ci[WS(rs, 21)];
			 T1e = cr[WS(rs, 26)];
			 T1f = T1d - T1e;
			 T4I = T1d + T1e;
			 Tj = cr[WS(rs, 10)];
			 Tk = ci[WS(rs, 5)];
			 Tl = Tj + Tk;
			 T4E = Tj - Tk;
		    }
		    {
			 E Tn, To, T13, T14;
			 Tn = ci[WS(rs, 1)];
			 To = cr[WS(rs, 14)];
			 Tp = Tn + To;
			 T4A = Tn - To;
			 T13 = ci[WS(rs, 17)];
			 T14 = cr[WS(rs, 30)];
			 T15 = T13 - T14;
			 T4y = T13 + T14;
		    }
		    {
			 E T16, T17, Tq, Tr;
			 T16 = ci[WS(rs, 25)];
			 T17 = cr[WS(rs, 22)];
			 T18 = T16 - T17;
			 T4B = T16 + T17;
			 Tq = cr[WS(rs, 6)];
			 Tr = ci[WS(rs, 9)];
			 Ts = Tq + Tr;
			 T4x = Tq - Tr;
		    }
		    {
			 E Tm, Tt, T6B, T6C;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 T1U = Tm - Tt;
			 T6B = T4H + T4I;
			 T6C = T4F - T4E;
			 T6D = FNMS(KP923879532, T6C, KP382683432 * T6B);
			 T73 = FMA(KP382683432, T6C, KP923879532 * T6B);
		    }
		    {
			 E T6E, T6F, T19, T1g;
			 T6E = T4A + T4B;
			 T6F = T4x + T4y;
			 T6G = FNMS(KP923879532, T6F, KP382683432 * T6E);
			 T74 = FMA(KP382683432, T6F, KP923879532 * T6E);
			 T19 = T15 + T18;
			 T1g = T1c + T1f;
			 T1h = T19 - T1g;
			 T2z = T1g + T19;
		    }
		    {
			 E T2V, T2W, T4z, T4C;
			 T2V = T15 - T18;
			 T2W = Tp - Ts;
			 T2X = T2V - T2W;
			 T3o = T2W + T2V;
			 T4z = T4x - T4y;
			 T4C = T4A - T4B;
			 T4D = FNMS(KP382683432, T4C, KP923879532 * T4z);
			 T5A = FMA(KP382683432, T4z, KP923879532 * T4C);
		    }
		    {
			 E T4G, T4J, T2Y, T2Z;
			 T4G = T4E + T4F;
			 T4J = T4H - T4I;
			 T4K = FMA(KP923879532, T4G, KP382683432 * T4J);
			 T5z = FNMS(KP382683432, T4G, KP923879532 * T4J);
			 T2Y = Ti - Tl;
			 T2Z = T1c - T1f;
			 T30 = T2Y + T2Z;
			 T3n = T2Y - T2Z;
		    }
	       }
	       {
		    E Ty, T4N, TB, T4Y, T1p, T4O, T1m, T4Z, TI, T52, T1w, T4V, TF, T51, T1t;
		    E T4S;
		    {
			 E Tw, Tx, T1k, T1l;
			 Tw = cr[WS(rs, 1)];
			 Tx = ci[WS(rs, 14)];
			 Ty = Tw + Tx;
			 T4N = Tw - Tx;
			 {
			      E Tz, TA, T1n, T1o;
			      Tz = cr[WS(rs, 9)];
			      TA = ci[WS(rs, 6)];
			      TB = Tz + TA;
			      T4Y = Tz - TA;
			      T1n = ci[WS(rs, 22)];
			      T1o = cr[WS(rs, 25)];
			      T1p = T1n - T1o;
			      T4O = T1n + T1o;
			 }
			 T1k = ci[WS(rs, 30)];
			 T1l = cr[WS(rs, 17)];
			 T1m = T1k - T1l;
			 T4Z = T1k + T1l;
			 {
			      E TG, TH, T4T, T1u, T1v, T4U;
			      TG = ci[WS(rs, 2)];
			      TH = cr[WS(rs, 13)];
			      T4T = TG - TH;
			      T1u = ci[WS(rs, 18)];
			      T1v = cr[WS(rs, 29)];
			      T4U = T1u + T1v;
			      TI = TG + TH;
			      T52 = T4T + T4U;
			      T1w = T1u - T1v;
			      T4V = T4T - T4U;
			 }
			 {
			      E TD, TE, T4Q, T1r, T1s, T4R;
			      TD = cr[WS(rs, 5)];
			      TE = ci[WS(rs, 10)];
			      T4Q = TD - TE;
			      T1r = ci[WS(rs, 26)];
			      T1s = cr[WS(rs, 21)];
			      T4R = T1r + T1s;
			      TF = TD + TE;
			      T51 = T4Q + T4R;
			      T1t = T1r - T1s;
			      T4S = T4Q - T4R;
			 }
		    }
		    {
			 E TC, TJ, T6Q, T6R;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 T1j = TC - TJ;
			 T6Q = T4Z - T4Y;
			 T6R = KP707106781 * (T4S - T4V);
			 T6S = T6Q + T6R;
			 T7w = T6Q - T6R;
		    }
		    {
			 E T6T, T6U, T1q, T1x;
			 T6T = T4N + T4O;
			 T6U = KP707106781 * (T51 + T52);
			 T6V = T6T - T6U;
			 T7v = T6T + T6U;
			 T1q = T1m + T1p;
			 T1x = T1t + T1w;
			 T1y = T1q - T1x;
			 T2B = T1q + T1x;
		    }
		    {
			 E T3a, T3b, T4P, T4W;
			 T3a = T1m - T1p;
			 T3b = TF - TI;
			 T3c = T3a - T3b;
			 T3S = T3b + T3a;
			 T4P = T4N - T4O;
			 T4W = KP707106781 * (T4S + T4V);
			 T4X = T4P - T4W;
			 T61 = T4P + T4W;
		    }
		    {
			 E T50, T53, T3d, T3e;
			 T50 = T4Y + T4Z;
			 T53 = KP707106781 * (T51 - T52);
			 T54 = T50 - T53;
			 T62 = T50 + T53;
			 T3d = Ty - TB;
			 T3e = T1w - T1t;
			 T3f = T3d - T3e;
			 T3T = T3d + T3e;
		    }
	       }
	       {
		    E TN, T56, TQ, T5h, T1G, T57, T1D, T5i, TX, T5l, T1N, T5e, TU, T5k, T1K;
		    E T5b;
		    {
			 E TL, TM, T1B, T1C;
			 TL = ci[0];
			 TM = cr[WS(rs, 15)];
			 TN = TL + TM;
			 T56 = TL - TM;
			 {
			      E TO, TP, T1E, T1F;
			      TO = cr[WS(rs, 7)];
			      TP = ci[WS(rs, 8)];
			      TQ = TO + TP;
			      T5h = TO - TP;
			      T1E = ci[WS(rs, 24)];
			      T1F = cr[WS(rs, 23)];
			      T1G = T1E - T1F;
			      T57 = T1E + T1F;
			 }
			 T1B = ci[WS(rs, 16)];
			 T1C = cr[WS(rs, 31)];
			 T1D = T1B - T1C;
			 T5i = T1B + T1C;
			 {
			      E TV, TW, T5c, T1L, T1M, T5d;
			      TV = ci[WS(rs, 4)];
			      TW = cr[WS(rs, 11)];
			      T5c = TV - TW;
			      T1L = ci[WS(rs, 20)];
			      T1M = cr[WS(rs, 27)];
			      T5d = T1L + T1M;
			      TX = TV + TW;
			      T5l = T5c + T5d;
			      T1N = T1L - T1M;
			      T5e = T5c - T5d;
			 }
			 {
			      E TS, TT, T59, T1I, T1J, T5a;
			      TS = cr[WS(rs, 3)];
			      TT = ci[WS(rs, 12)];
			      T59 = TS - TT;
			      T1I = ci[WS(rs, 28)];
			      T1J = cr[WS(rs, 19)];
			      T5a = T1I + T1J;
			      TU = TS + TT;
			      T5k = T59 + T5a;
			      T1K = T1I - T1J;
			      T5b = T59 - T5a;
			 }
		    }
		    {
			 E TR, TY, T6J, T6K;
			 TR = TN + TQ;
			 TY = TU + TX;
			 TZ = TR + TY;
			 T1A = TR - TY;
			 T6J = KP707106781 * (T5b - T5e);
			 T6K = T5h + T5i;
			 T6L = T6J - T6K;
			 T7z = T6K + T6J;
		    }
		    {
			 E T6M, T6N, T1H, T1O;
			 T6M = T56 + T57;
			 T6N = KP707106781 * (T5k + T5l);
			 T6O = T6M - T6N;
			 T7y = T6M + T6N;
			 T1H = T1D + T1G;
			 T1O = T1K + T1N;
			 T1P = T1H - T1O;
			 T2C = T1H + T1O;
		    }
		    {
			 E T33, T34, T58, T5f;
			 T33 = T1D - T1G;
			 T34 = TU - TX;
			 T35 = T33 - T34;
			 T3P = T34 + T33;
			 T58 = T56 - T57;
			 T5f = KP707106781 * (T5b + T5e);
			 T5g = T58 - T5f;
			 T64 = T58 + T5f;
		    }
		    {
			 E T5j, T5m, T36, T37;
			 T5j = T5h - T5i;
			 T5m = KP707106781 * (T5k - T5l);
			 T5n = T5j - T5m;
			 T65 = T5j + T5m;
			 T36 = TN - TQ;
			 T37 = T1N - T1K;
			 T38 = T36 - T37;
			 T3Q = T36 + T37;
		    }
	       }
	       {
		    E Tv, T10, T2w, T2A, T2D, T2E, T2v, T2x;
		    Tv = Tf + Tu;
		    T10 = TK + TZ;
		    T2w = Tv - T10;
		    T2A = T2y + T2z;
		    T2D = T2B + T2C;
		    T2E = T2A - T2D;
		    cr[0] = Tv + T10;
		    ci[0] = T2A + T2D;
		    T2v = W[30];
		    T2x = W[31];
		    cr[WS(rs, 16)] = FNMS(T2x, T2E, T2v * T2w);
		    ci[WS(rs, 16)] = FMA(T2x, T2w, T2v * T2E);
	       }
	       {
		    E T2I, T2O, T2M, T2Q;
		    {
			 E T2G, T2H, T2K, T2L;
			 T2G = Tf - Tu;
			 T2H = T2C - T2B;
			 T2I = T2G - T2H;
			 T2O = T2G + T2H;
			 T2K = T2y - T2z;
			 T2L = TK - TZ;
			 T2M = T2K - T2L;
			 T2Q = T2L + T2K;
		    }
		    {
			 E T2F, T2J, T2N, T2P;
			 T2F = W[46];
			 T2J = W[47];
			 cr[WS(rs, 24)] = FNMS(T2J, T2M, T2F * T2I);
			 ci[WS(rs, 24)] = FMA(T2F, T2M, T2J * T2I);
			 T2N = W[14];
			 T2P = W[15];
			 cr[WS(rs, 8)] = FNMS(T2P, T2Q, T2N * T2O);
			 ci[WS(rs, 8)] = FMA(T2N, T2Q, T2P * T2O);
		    }
	       }
	       {
		    E T1i, T2a, T2o, T2k, T2d, T2l, T1R, T2p;
		    T1i = T12 + T1h;
		    T2a = T1U + T29;
		    T2o = T29 - T1U;
		    T2k = T12 - T1h;
		    {
			 E T2b, T2c, T1z, T1Q;
			 T2b = T1j + T1y;
			 T2c = T1P - T1A;
			 T2d = KP707106781 * (T2b + T2c);
			 T2l = KP707106781 * (T2c - T2b);
			 T1z = T1j - T1y;
			 T1Q = T1A + T1P;
			 T1R = KP707106781 * (T1z + T1Q);
			 T2p = KP707106781 * (T1z - T1Q);
		    }
		    {
			 E T1S, T2e, T11, T1T;
			 T1S = T1i - T1R;
			 T2e = T2a - T2d;
			 T11 = W[38];
			 T1T = W[39];
			 cr[WS(rs, 20)] = FNMS(T1T, T2e, T11 * T1S);
			 ci[WS(rs, 20)] = FMA(T1T, T1S, T11 * T2e);
		    }
		    {
			 E T2s, T2u, T2r, T2t;
			 T2s = T2k + T2l;
			 T2u = T2o + T2p;
			 T2r = W[22];
			 T2t = W[23];
			 cr[WS(rs, 12)] = FNMS(T2t, T2u, T2r * T2s);
			 ci[WS(rs, 12)] = FMA(T2r, T2u, T2t * T2s);
		    }
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = T1i + T1R;
			 T2i = T2a + T2d;
			 T2f = W[6];
			 T2h = W[7];
			 cr[WS(rs, 4)] = FNMS(T2h, T2i, T2f * T2g);
			 ci[WS(rs, 4)] = FMA(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2m, T2q, T2j, T2n;
			 T2m = T2k - T2l;
			 T2q = T2o - T2p;
			 T2j = W[54];
			 T2n = W[55];
			 cr[WS(rs, 28)] = FNMS(T2n, T2q, T2j * T2m);
			 ci[WS(rs, 28)] = FMA(T2j, T2q, T2n * T2m);
		    }
	       }
	       {
		    E T3O, T4a, T40, T4e, T3V, T4f, T43, T4b, T3N, T3Z;
		    T3N = KP707106781 * (T3n + T3o);
		    T3O = T3M - T3N;
		    T4a = T3M + T3N;
		    T3Z = KP707106781 * (T30 + T2X);
		    T40 = T3Y - T3Z;
		    T4e = T3Y + T3Z;
		    {
			 E T3R, T3U, T41, T42;
			 T3R = FNMS(KP382683432, T3Q, KP923879532 * T3P);
			 T3U = FMA(KP923879532, T3S, KP382683432 * T3T);
			 T3V = T3R - T3U;
			 T4f = T3U + T3R;
			 T41 = FNMS(KP382683432, T3S, KP923879532 * T3T);
			 T42 = FMA(KP382683432, T3P, KP923879532 * T3Q);
			 T43 = T41 - T42;
			 T4b = T41 + T42;
		    }
		    {
			 E T3W, T44, T3L, T3X;
			 T3W = T3O - T3V;
			 T44 = T40 - T43;
			 T3L = W[50];
			 T3X = W[51];
			 cr[WS(rs, 26)] = FNMS(T3X, T44, T3L * T3W);
			 ci[WS(rs, 26)] = FMA(T3X, T3W, T3L * T44);
		    }
		    {
			 E T4i, T4k, T4h, T4j;
			 T4i = T4a + T4b;
			 T4k = T4e + T4f;
			 T4h = W[2];
			 T4j = W[3];
			 cr[WS(rs, 2)] = FNMS(T4j, T4k, T4h * T4i);
			 ci[WS(rs, 2)] = FMA(T4h, T4k, T4j * T4i);
		    }
		    {
			 E T46, T48, T45, T47;
			 T46 = T3O + T3V;
			 T48 = T40 + T43;
			 T45 = W[18];
			 T47 = W[19];
			 cr[WS(rs, 10)] = FNMS(T47, T48, T45 * T46);
			 ci[WS(rs, 10)] = FMA(T47, T46, T45 * T48);
		    }
		    {
			 E T4c, T4g, T49, T4d;
			 T4c = T4a - T4b;
			 T4g = T4e - T4f;
			 T49 = W[34];
			 T4d = W[35];
			 cr[WS(rs, 18)] = FNMS(T4d, T4g, T49 * T4c);
			 ci[WS(rs, 18)] = FMA(T49, T4g, T4d * T4c);
		    }
	       }
	       {
		    E T32, T3A, T3q, T3E, T3h, T3F, T3t, T3B, T31, T3p;
		    T31 = KP707106781 * (T2X - T30);
		    T32 = T2U - T31;
		    T3A = T2U + T31;
		    T3p = KP707106781 * (T3n - T3o);
		    T3q = T3m - T3p;
		    T3E = T3m + T3p;
		    {
			 E T39, T3g, T3r, T3s;
			 T39 = FNMS(KP923879532, T38, KP382683432 * T35);
			 T3g = FMA(KP382683432, T3c, KP923879532 * T3f);
			 T3h = T39 - T3g;
			 T3F = T3g + T39;
			 T3r = FNMS(KP923879532, T3c, KP382683432 * T3f);
			 T3s = FMA(KP923879532, T35, KP382683432 * T38);
			 T3t = T3r - T3s;
			 T3B = T3r + T3s;
		    }
		    {
			 E T3i, T3u, T2R, T3j;
			 T3i = T32 - T3h;
			 T3u = T3q - T3t;
			 T2R = W[58];
			 T3j = W[59];
			 cr[WS(rs, 30)] = FNMS(T3j, T3u, T2R * T3i);
			 ci[WS(rs, 30)] = FMA(T3j, T3i, T2R * T3u);
		    }
		    {
			 E T3I, T3K, T3H, T3J;
			 T3I = T3A + T3B;
			 T3K = T3E + T3F;
			 T3H = W[10];
			 T3J = W[11];
			 cr[WS(rs, 6)] = FNMS(T3J, T3K, T3H * T3I);
			 ci[WS(rs, 6)] = FMA(T3H, T3K, T3J * T3I);
		    }
		    {
			 E T3w, T3y, T3v, T3x;
			 T3w = T32 + T3h;
			 T3y = T3q + T3t;
			 T3v = W[26];
			 T3x = W[27];
			 cr[WS(rs, 14)] = FNMS(T3x, T3y, T3v * T3w);
			 ci[WS(rs, 14)] = FMA(T3x, T3w, T3v * T3y);
		    }
		    {
			 E T3C, T3G, T3z, T3D;
			 T3C = T3A - T3B;
			 T3G = T3E - T3F;
			 T3z = W[42];
			 T3D = W[43];
			 cr[WS(rs, 22)] = FNMS(T3D, T3G, T3z * T3C);
			 ci[WS(rs, 22)] = FMA(T3z, T3G, T3D * T3C);
		    }
	       }
	       {
		    E T60, T6m, T6f, T6n, T67, T6r, T6c, T6q;
		    {
			 E T5Y, T5Z, T6d, T6e;
			 T5Y = T4o + T4v;
			 T5Z = T5z + T5A;
			 T60 = T5Y + T5Z;
			 T6m = T5Y - T5Z;
			 T6d = FMA(KP195090322, T61, KP980785280 * T62);
			 T6e = FNMS(KP195090322, T64, KP980785280 * T65);
			 T6f = T6d + T6e;
			 T6n = T6e - T6d;
		    }
		    {
			 E T63, T66, T6a, T6b;
			 T63 = FNMS(KP195090322, T62, KP980785280 * T61);
			 T66 = FMA(KP980785280, T64, KP195090322 * T65);
			 T67 = T63 + T66;
			 T6r = T63 - T66;
			 T6a = T5u + T5x;
			 T6b = T4K + T4D;
			 T6c = T6a + T6b;
			 T6q = T6a - T6b;
		    }
		    {
			 E T68, T6g, T5X, T69;
			 T68 = T60 - T67;
			 T6g = T6c - T6f;
			 T5X = W[32];
			 T69 = W[33];
			 cr[WS(rs, 17)] = FNMS(T69, T6g, T5X * T68);
			 ci[WS(rs, 17)] = FMA(T69, T68, T5X * T6g);
		    }
		    {
			 E T6u, T6w, T6t, T6v;
			 T6u = T6m + T6n;
			 T6w = T6q + T6r;
			 T6t = W[16];
			 T6v = W[17];
			 cr[WS(rs, 9)] = FNMS(T6v, T6w, T6t * T6u);
			 ci[WS(rs, 9)] = FMA(T6t, T6w, T6v * T6u);
		    }
		    {
			 E T6i, T6k, T6h, T6j;
			 T6i = T60 + T67;
			 T6k = T6c + T6f;
			 T6h = W[0];
			 T6j = W[1];
			 cr[WS(rs, 1)] = FNMS(T6j, T6k, T6h * T6i);
			 ci[WS(rs, 1)] = FMA(T6j, T6i, T6h * T6k);
		    }
		    {
			 E T6o, T6s, T6l, T6p;
			 T6o = T6m - T6n;
			 T6s = T6q - T6r;
			 T6l = W[48];
			 T6p = W[49];
			 cr[WS(rs, 25)] = FNMS(T6p, T6s, T6l * T6o);
			 ci[WS(rs, 25)] = FMA(T6l, T6s, T6p * T6o);
		    }
	       }
	       {
		    E T7u, T7Q, T7J, T7R, T7B, T7V, T7G, T7U;
		    {
			 E T7s, T7t, T7H, T7I;
			 T7s = T6y + T6z;
			 T7t = T73 + T74;
			 T7u = T7s - T7t;
			 T7Q = T7s + T7t;
			 T7H = FMA(KP195090322, T7w, KP980785280 * T7v);
			 T7I = FMA(KP195090322, T7z, KP980785280 * T7y);
			 T7J = T7H - T7I;
			 T7R = T7H + T7I;
		    }
		    {
			 E T7x, T7A, T7E, T7F;
			 T7x = FNMS(KP980785280, T7w, KP195090322 * T7v);
			 T7A = FNMS(KP980785280, T7z, KP195090322 * T7y);
			 T7B = T7x + T7A;
			 T7V = T7x - T7A;
			 T7E = T70 - T71;
			 T7F = T6D - T6G;
			 T7G = T7E + T7F;
			 T7U = T7E - T7F;
		    }
		    {
			 E T7C, T7K, T7r, T7D;
			 T7C = T7u - T7B;
			 T7K = T7G - T7J;
			 T7r = W[44];
			 T7D = W[45];
			 cr[WS(rs, 23)] = FNMS(T7D, T7K, T7r * T7C);
			 ci[WS(rs, 23)] = FMA(T7D, T7C, T7r * T7K);
		    }
		    {
			 E T7Y, T80, T7X, T7Z;
			 T7Y = T7Q + T7R;
			 T80 = T7U - T7V;
			 T7X = W[60];
			 T7Z = W[61];
			 cr[WS(rs, 31)] = FNMS(T7Z, T80, T7X * T7Y);
			 ci[WS(rs, 31)] = FMA(T7X, T80, T7Z * T7Y);
		    }
		    {
			 E T7M, T7O, T7L, T7N;
			 T7M = T7u + T7B;
			 T7O = T7G + T7J;
			 T7L = W[12];
			 T7N = W[13];
			 cr[WS(rs, 7)] = FNMS(T7N, T7O, T7L * T7M);
			 ci[WS(rs, 7)] = FMA(T7N, T7M, T7L * T7O);
		    }
		    {
			 E T7S, T7W, T7P, T7T;
			 T7S = T7Q - T7R;
			 T7W = T7U + T7V;
			 T7P = W[28];
			 T7T = W[29];
			 cr[WS(rs, 15)] = FNMS(T7T, T7W, T7P * T7S);
			 ci[WS(rs, 15)] = FMA(T7P, T7W, T7T * T7S);
		    }
	       }
	       {
		    E T4M, T5M, T5F, T5N, T5p, T5R, T5C, T5Q;
		    {
			 E T4w, T4L, T5D, T5E;
			 T4w = T4o - T4v;
			 T4L = T4D - T4K;
			 T4M = T4w + T4L;
			 T5M = T4w - T4L;
			 T5D = FMA(KP831469612, T4X, KP555570233 * T54);
			 T5E = FNMS(KP831469612, T5g, KP555570233 * T5n);
			 T5F = T5D + T5E;
			 T5N = T5E - T5D;
		    }
		    {
			 E T55, T5o, T5y, T5B;
			 T55 = FNMS(KP831469612, T54, KP555570233 * T4X);
			 T5o = FMA(KP555570233, T5g, KP831469612 * T5n);
			 T5p = T55 + T5o;
			 T5R = T55 - T5o;
			 T5y = T5u - T5x;
			 T5B = T5z - T5A;
			 T5C = T5y + T5B;
			 T5Q = T5y - T5B;
		    }
		    {
			 E T5q, T5G, T4l, T5r;
			 T5q = T4M - T5p;
			 T5G = T5C - T5F;
			 T4l = W[40];
			 T5r = W[41];
			 cr[WS(rs, 21)] = FNMS(T5r, T5G, T4l * T5q);
			 ci[WS(rs, 21)] = FMA(T5r, T5q, T4l * T5G);
		    }
		    {
			 E T5U, T5W, T5T, T5V;
			 T5U = T5M + T5N;
			 T5W = T5Q + T5R;
			 T5T = W[24];
			 T5V = W[25];
			 cr[WS(rs, 13)] = FNMS(T5V, T5W, T5T * T5U);
			 ci[WS(rs, 13)] = FMA(T5T, T5W, T5V * T5U);
		    }
		    {
			 E T5I, T5K, T5H, T5J;
			 T5I = T4M + T5p;
			 T5K = T5C + T5F;
			 T5H = W[8];
			 T5J = W[9];
			 cr[WS(rs, 5)] = FNMS(T5J, T5K, T5H * T5I);
			 ci[WS(rs, 5)] = FMA(T5J, T5I, T5H * T5K);
		    }
		    {
			 E T5O, T5S, T5L, T5P;
			 T5O = T5M - T5N;
			 T5S = T5Q - T5R;
			 T5L = W[56];
			 T5P = W[57];
			 cr[WS(rs, 29)] = FNMS(T5P, T5S, T5L * T5O);
			 ci[WS(rs, 29)] = FMA(T5L, T5S, T5P * T5O);
		    }
	       }
	       {
		    E T6I, T7g, T79, T7h, T6X, T7l, T76, T7k;
		    {
			 E T6A, T6H, T77, T78;
			 T6A = T6y - T6z;
			 T6H = T6D + T6G;
			 T6I = T6A - T6H;
			 T7g = T6A + T6H;
			 T77 = FNMS(KP555570233, T6S, KP831469612 * T6V);
			 T78 = FMA(KP555570233, T6L, KP831469612 * T6O);
			 T79 = T77 - T78;
			 T7h = T77 + T78;
		    }
		    {
			 E T6P, T6W, T72, T75;
			 T6P = FNMS(KP555570233, T6O, KP831469612 * T6L);
			 T6W = FMA(KP831469612, T6S, KP555570233 * T6V);
			 T6X = T6P - T6W;
			 T7l = T6W + T6P;
			 T72 = T70 + T71;
			 T75 = T73 - T74;
			 T76 = T72 - T75;
			 T7k = T72 + T75;
		    }
		    {
			 E T6Y, T7a, T6x, T6Z;
			 T6Y = T6I - T6X;
			 T7a = T76 - T79;
			 T6x = W[52];
			 T6Z = W[53];
			 cr[WS(rs, 27)] = FNMS(T6Z, T7a, T6x * T6Y);
			 ci[WS(rs, 27)] = FMA(T6Z, T6Y, T6x * T7a);
		    }
		    {
			 E T7o, T7q, T7n, T7p;
			 T7o = T7g + T7h;
			 T7q = T7k + T7l;
			 T7n = W[4];
			 T7p = W[5];
			 cr[WS(rs, 3)] = FNMS(T7p, T7q, T7n * T7o);
			 ci[WS(rs, 3)] = FMA(T7n, T7q, T7p * T7o);
		    }
		    {
			 E T7c, T7e, T7b, T7d;
			 T7c = T6I + T6X;
			 T7e = T76 + T79;
			 T7b = W[20];
			 T7d = W[21];
			 cr[WS(rs, 11)] = FNMS(T7d, T7e, T7b * T7c);
			 ci[WS(rs, 11)] = FMA(T7d, T7c, T7b * T7e);
		    }
		    {
			 E T7i, T7m, T7f, T7j;
			 T7i = T7g - T7h;
			 T7m = T7k - T7l;
			 T7f = W[36];
			 T7j = W[37];
			 cr[WS(rs, 19)] = FNMS(T7j, T7m, T7f * T7i);
			 ci[WS(rs, 19)] = FMA(T7f, T7m, T7j * T7i);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hb_32", twinstr, &GENUS, {340, 114, 94, 0} };

void X(codelet_hb_32) (planner *p) {
     X(khc2hc_register) (p, hb_32, &desc);
}
#endif
