// Copyright 2011 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This file contains 100.000 decimal representations of random singles. They
// have been generated using Gay's gdtoa to produce the shortest representation.

#include "utils.h"

#include "gay-shortest-single.h"

namespace double_conversion {

static const PrecomputedShortestSingle kShortestSingleTestNumbers[] = {
  {3.36736864456782105775e+26f, "33673686", 27},
  {1.46182568272479329607e-08f, "14618257", -7},
  {1.39158807800948614758e+22f, "13915881", 23},
  {2.11660013157571985670e+23f, "21166001", 24},
  {1.12098729821300864932e+32f, "11209873", 33},
  {1.04102368567680067936e-23f, "10410237", -22},
  {4.13143748812655475788e-13f, "41314375", -12},
  {9.83890996017493966848e+20f, "983891", 21},
  {1.54088676887868339664e-17f, "15408868", -16},
  {2.97584003906250000000e+04f, "297584", 5},
  {3.79264131188392639160e-02f, "37926413", -1},
  {1.71021875200000000000e+10f, "17102188", 11},
  {8.06074235137899108850e-11f, "80607424", -10},
  {2.28901271820068359375e+01f, "22890127", 2},
  {1.47113100255597364294e+35f, "1471131", 36},
  {2.50842668277236002727e+32f, "25084267", 33},
  {5.98616145920000000000e+10f, "59861615", 11},
  {1.17310761037987840000e+17f, "11731076", 18},
  {5.04973631407483395134e-28f, "50497363", -27},
  {3.71523328000000000000e+08f, "37152333", 9},
  {1.10303343143980550920e-37f, "11030334", -36},
  {3.19572182371912443446e-20f, "31957218", -19},
  {2.28460911869883844822e-28f, "2284609", -27},
  {5.64945840689771546935e+23f, "56494584", 24},
  {7.17221703893650915938e-27f, "7172217", -26},
  {4.89284062155093124602e-08f, "48928406", -7},
  {6.19150727045903638692e-29f, "6191507", -28},
  {1.46337902990928999457e-30f, "1463379", -29},
  {3.96785751459780656769e-22f, "39678575", -21},
  {2.09710865020751953125e+01f, "20971087", 2},
  {2.80506687514561407319e+26f, "28050669", 27},
  {9.85586048000000000000e+08f, "98558605", 9},
  {3.96148468524449301822e-16f, "39614847", -15},
  {8.33828700160000000000e+10f, "8338287", 11},
  {1.55842636108398437500e+02f, "15584264", 3},
  {6.78622305393218994141e-01f, "6786223", 0},
  {5.47857799948797004365e+36f, "5478578", 37},
  {2.09198966468115618838e-16f, "20919897", -15},
  {1.73260148621891023667e+21f, "17326015", 22},
  {2.36379470825195312500e+02f, "23637947", 3},
  {1.29622111893768372224e+21f, "12962211", 22},
  {4.34674980454019532772e-08f, "43467498", -7},
  {3.12232384415855784621e+30f, "31223238", 31},
  {4.24264774296490140490e-17f, "42426477", -16},
  {8.94460287087506245030e-12f, "8944603", -11},
  {1.07441893524297868955e+24f, "10744189", 25},
  {4.12390787239506142819e+32f, "4123908", 33},
  {1.43085093757774781695e-33f, "14308509", -32},
  {8.53805660531876490311e+34f, "8538057", 35},
  {2.11815628051757812500e+02f, "21181563", 3},
  {2.53987830113103298445e-32f, "25398783", -31},
  {3.99278278974405847604e-24f, "39927828", -23},
  {7.85532112076800000000e+12f, "7855321", 13},
  {2.40796081263608126082e+30f, "24079608", 31},
  {4.78973154541262324813e-12f, "47897315", -11},
  {5.49990939711204985167e-34f, "54999094", -33},
  {2.11758349685603906125e-37f, "21175835", -36},
  {1.14418426528573036194e-03f, "11441843", -2},
  {4.43940181185170234974e-34f, "4439402", -33},
  {1.35502790665719938274e-20f, "13550279", -19},
  {3.94072925838434383051e+36f, "39407293", 37},
  {1.99301721411454736091e+31f, "19930172", 32},
  {2.27219600044929514018e+27f, "2272196", 28},
  {2.19690898887958620169e-18f, "2196909", -17},
  {2.41386938476562500000e+03f, "24138694", 4},
  {4.90334772784706274251e-10f, "4903348", -9},
  {2.39612346916573020160e+20f, "23961235", 21},
  {1.93448505401611328125e+01f, "1934485", 2},
  {1.70405186764800000000e+13f, "17040519", 14},
  {5.58718505859375000000e+02f, "5587185", 3},
  {6.35417187804722656139e-36f, "6354172", -35},
  {3.15925499307923018932e-05f, "3159255", -4},
  {4.02344408644689567736e+33f, "4023444", 34},
  {3.34204134628793577785e+33f, "33420413", 34},
  {2.25367293482237952000e+17f, "2253673", 18},
  {4.93802539671372965006e-17f, "49380254", -16},
  {4.91045191499644928000e+18f, "4910452", 19},
  {1.26071169024000000000e+11f, "12607117", 12},
  {1.19068279541556520940e-11f, "11906828", -10},
  {6.15031733485568000000e+14f, "6150317", 15},
  {3.84997401817292772476e-26f, "3849974", -25},
  {5.08654484292492270470e-05f, "5086545", -4},
  {4.11752049469324024072e+29f, "41175205", 30},
  {4.93427345541638368788e+25f, "49342735", 26},
  {1.78068280606846762737e-13f, "17806828", -12},
  {2.73735935704621929123e-21f, "27373594", -20},
  {4.31847494463731923443e+30f, "4318475", 31},
  {6.15620835558994272674e-12f, "61562084", -11},
  {5.03135520948224000000e+14f, "50313552", 15},
  {3.08359732229154972338e+35f, "30835973", 36},
  {1.41924680000000000000e+07f, "14192468", 8},
  {2.79239458816000000000e+12f, "27923946", 13},
  {9.01784520278732310901e+27f, "9017845", 28},
  {4.66106976091396063566e-05f, "46610698", -4},
  {9.97093543397242579551e+32f, "99709354", 33},
  {2.97991427089527860517e-08f, "29799143", -7},
  {3.82099227444168162804e+24f, "38209923", 25},
  {3.26494756798464000000e+14f, "32649476", 15},
  {9.80727337765057095793e+31f, "9807273", 32},
  {9.48505029082298278809e-02f, "948505", -1},
  {2.64949676148562304144e-22f, "26494968", -21},
  {1.05059494742968167996e+35f, "10505949", 36},
  {5.03923067917985240973e+32f, "50392307", 33},
  {1.45480693916478861208e-27f, "14548069", -26},
  {4.91821586575108280614e+29f, "4918216", 30},
  {1.53468813312000000000e+11f, "15346881", 12},
  {1.20550157589605078101e-05f, "12055016", -4},
  {3.47183641600000000000e+09f, "34718364", 10},
  {2.70784720359726067528e-17f, "27078472", -16},
  {2.29797341922482674729e+22f, "22979734", 23},
  {3.03617689393883075089e-15f, "30361769", -14},
  {1.75854031112976372242e-04f, "17585403", -3},
  {1.59521377234067913941e-21f, "15952138", -20},
  {1.66838362212681144509e-24f, "16683836", -23},
  {1.19076694090203718103e-17f, "11907669", -16},
  {4.75005351562500000000e+04f, "47500535", 5},
  {7.74539842041122028604e-07f, "77453984", -6},
  {7.33819861192445877652e-26f, "73381986", -25},
  {4.63171929063362893477e+31f, "46317193", 32},
  {5.56866468617301932235e-31f, "55686647", -30},
  {3.21927646240488548046e-29f, "32192765", -28},
  {9.16840493679046630859e-01f, "9168405", 0},
  {2.48168975102344429568e+20f, "24816898", 21},
  {4.66368098057701496390e+37f, "4663681", 38},
  {7.06682218525190935950e+33f, "7066822", 34},
  {3.42815196315648000000e+14f, "3428152", 15},
  {2.04185535146450547472e-09f, "20418554", -8},
  {3.58115093320596193280e+19f, "3581151", 20},
  {1.60404786675449884115e-10f, "16040479", -9},
  {2.89779897423046782327e-16f, "2897799", -15},
  {4.94312794304032425657e-21f, "4943128", -20},
  {6.83275650000000000000e+06f, "68327565", 7},
  {4.25457278451095388569e-20f, "42545728", -19},
  {3.26925914724953306651e-27f, "3269259", -26},
  {1.64870078085883494400e+18f, "16487008", 19},
  {2.83125484261088191556e-29f, "28312548", -28},
  {8.52609501878773497201e+22f, "8526095", 23},
  {2.61103437830509857097e-26f, "26110344", -25},
  {1.60327618968808325120e+19f, "16032762", 20},
  {3.32686354054609871502e-33f, "33268635", -32},
  {1.01904599601089219224e+35f, "1019046", 36},
  {6.96941646641658859332e-35f, "69694165", -34},
  {9.72944107055664062500e+01f, "9729441", 2},
  {2.29527733192107527758e-25f, "22952773", -24},
  {1.97320364676958849123e-20f, "19732036", -19},
  {1.86824552724467195838e+23f, "18682455", 24},
  {1.79801487222767616000e+18f, "17980149", 19},
  {2.37559401676800000000e+12f, "2375594", 13},
  {2.20082319140101396339e+36f, "22008232", 37},
  {1.16914946048000000000e+11f, "11691495", 12},
  {2.20197962241676410880e+20f, "22019796", 21},
  {9.52057560112337920742e-32f, "95205756", -31},
  {1.54997144698521250202e-28f, "15499714", -27},
  {7.51217803955078125000e+01f, "7512178", 2},
  {6.33201558310724599307e-33f, "63320156", -32},
  {1.46065440298139686283e-33f, "14606544", -32},
  {3.68380466917244188984e-23f, "36838047", -22},
  {2.19461158849298954010e-03f, "21946116", -2},
  {8.88504203318112583208e+24f, "8885042", 25},
  {9.27763687500000000000e+05f, "9277637", 6},
  {1.05418993440093372416e+20f, "10541899", 21},
  {6.24163852646373983994e-35f, "62416385", -34},
  {9.03840155496094193670e-27f, "90384016", -26},
  {3.46257620136789925073e-23f, "34625762", -22},
  {2.31808276922964929934e+30f, "23180828", 31},
  {2.82710025060897407522e-29f, "28271003", -28},
  {8.85321044845661491868e-35f, "88532104", -34},
  {7.36110964775502093977e+28f, "73611096", 29},
  {2.33603384210822309508e-33f, "23360338", -32},
  {1.25233861587908539402e-38f, "12523386", -37},
  {8.47445471233239206365e+32f, "8474455", 33},
  {3.47757400000000000000e+07f, "3477574", 8},
  {4.86092687834533708881e-25f, "4860927", -24},
  {2.27689708853357947388e-26f, "22768971", -25},
  {9.48234646358514510212e-09f, "94823465", -8},
  {1.40746074355721874380e+32f, "14074607", 33},
  {8.90716717331528352897e+24f, "8907167", 25},
  {2.80621220705157270459e-11f, "28062122", -10},
  {2.35301386718750000000e+04f, "23530139", 5},
  {2.79776525000000000000e+06f, "27977652", 7},
  {4.53959102742373943329e-04f, "4539591", -3},
  {5.54838739910656000000e+14f, "55483874", 15},
  {2.97372211541924251302e-31f, "2973722", -30},
  {4.83032287597656250000e+02f, "4830323", 3},
  {1.37776591502657454080e+20f, "13777659", 21},
  {1.68714669412071711224e-15f, "16871467", -14},
  {1.71925285056435243617e+38f, "17192529", 39},
  {1.78740762500000000000e+06f, "17874076", 7},
  {2.64483747327884866061e+29f, "26448375", 30},
  {2.65481810426514636800e+19f, "2654818", 20},
  {1.71960586240000000000e+10f, "17196059", 11},
  {3.21314966661837505605e-36f, "32131497", -35},
  {2.65178191285620572160e+19f, "2651782", 20},
  {1.01284126509595396277e+26f, "10128413", 27},
  {1.23083201969356098737e+33f, "1230832", 34},
  {1.23394982850201473948e+29f, "12339498", 30},
  {6.75300297841626820788e+25f, "6753003", 26},
  {1.84511412641523665789e+37f, "18451141", 38},
  {1.30572415395608657920e+19f, "13057242", 20},
  {2.55919997141409256130e+31f, "25592", 32},
  {3.82925884653098455797e+37f, "38292588", 38},
  {1.51412916879360000000e+13f, "15141292", 14},
  {1.29818081855773925781e+00f, "12981808", 1},
  {2.55367309713905134224e-26f, "25536731", -25},
  {5.73719197199188774439e+25f, "5737192", 26},
  {1.99132689403356218640e+30f, "19913269", 31},
  {5.27131119437863191598e-33f, "52713112", -32},
  {7.28420057088000000000e+11f, "72842006", 12},
  {8.12769058330822550206e-20f, "81276906", -19},
  {1.97019422720000000000e+10f, "19701942", 11},
  {2.81056847632821349888e-21f, "28105685", -20},
  {6.11908983560601600000e+15f, "611909", 16},
  {1.58875530461601022214e-14f, "15887553", -13},
  {1.32663790976955686673e-13f, "13266379", -12},
  {4.22010706028683889029e-21f, "4220107", -20},
  {3.05869764695102563386e-33f, "30586976", -32},
  {3.66440243200000000000e+10f, "36644024", 11},
  {1.06390875826287207284e-21f, "10639088", -20},
  {9.28984530944000000000e+11f, "9289845", 12},
  {1.38848686218261718750e+01f, "13884869", 2},
  {4.50667186885623684681e+36f, "4506672", 37},
  {2.34639442220220919341e-17f, "23463944", -16},
  {7.38656542968750000000e+03f, "73865654", 4},
  {1.63247257334841344000e+17f, "16324726", 18},
  {3.15516281879352279361e-30f, "31551628", -29},
  {1.32793579250574111938e-02f, "13279358", -1},
  {2.83571720000000000000e+07f, "28357172", 8},
  {3.62512146645333547092e+34f, "36251215", 35},
  {3.50316113326698541641e-04f, "3503161", -3},
  {5.02899696712411081734e-13f, "5028997", -12},
  {1.24687239548772820882e+27f, "12468724", 28},
  {1.88507638085866346955e-05f, "18850764", -4},
  {9.72432050227131833739e-39f, "972432", -38},
  {2.37450228750268887978e-12f, "23745023", -11},
  {8.12831040000000000000e+07f, "812831", 8},
  {1.01378251021231499264e+26f, "10137825", 27},
  {6.35707162726789964619e-21f, "63570716", -20},
  {6.76191178588160000000e+13f, "67619118", 14},
  {1.02204471826553344727e-01f, "10220447", 0},
  {8.59731659293174743652e-02f, "85973166", -1},
  {1.89831243138768781392e-15f, "18983124", -14},
  {4.66334578198446080000e+16f, "46633458", 17},
  {7.17282033263972857224e-25f, "71728203", -24},
  {5.09658931200000000000e+09f, "50965893", 10},
  {8.79464781351444040424e-36f, "8794648", -35},
  {4.72029995535194757394e-07f, "47203", -6},
  {2.63877260895846400000e+15f, "26387726", 16},
  {5.37526775316480000000e+13f, "53752678", 14},
  {8.49289625600000000000e+10f, "8492896", 11},
  {3.38634610803911773047e-12f, "3386346", -11},
  {1.04502001557960506412e-24f, "104502", -23},
  {5.18375872000000000000e+08f, "51837587", 9},
  {1.33351761920000000000e+10f, "13335176", 11},
  {1.22983564150466150400e+18f, "12298356", 19},
  {1.20946438628144470329e-13f, "12094644", -12},
  {7.15844741844959232000e+18f, "71584474", 19},
  {2.33790383522590657625e-23f, "23379038", -22},
  {5.69229975720465834685e+32f, "56922998", 33},
  {3.65262574452736000000e+14f, "36526257", 15},
  {1.32091478016000000000e+12f, "13209148", 13},
  {4.03315275502533265915e-19f, "40331528", -18},
  {6.68103149414062500000e+02f, "66810315", 3},
  {3.54190847708552799173e-32f, "35419085", -31},
  {7.31713836901904506602e-19f, "73171384", -18},
  {2.55159906944107038551e+29f, "2551599", 30},
  {4.63865527664640000000e+14f, "46386553", 15},
  {9.84843743248862670541e-32f, "98484374", -31},
  {2.34538093531431624404e-30f, "2345381", -29},
  {4.56881338317671747973e-11f, "45688134", -10},
  {1.71208550000000000000e+06f, "17120855", 7},
  {3.12413980000000000000e+07f, "31241398", 8},
  {1.44122860011520000000e+13f, "14412286", 14},
  {1.06976118717710467262e-16f, "10697612", -15},
  {3.76942619381627826995e+21f, "37694262", 22},
  {1.01315033571740454764e-16f, "101315034", -15},
  {1.57839629495899747003e-13f, "15783963", -12},
  {2.60768917665865393818e-24f, "26076892", -23},
  {4.24710640092037435491e+37f, "42471064", 38},
  {1.07688806074437164529e-38f, "1076888", -37},
  {3.50517029613386928289e+25f, "35051703", 26},
  {2.11303278476945854969e-13f, "21130328", -12},
  {1.95126401514318234193e-24f, "1951264", -23},
  {2.65995968220522627234e-05f, "26599597", -4},
  {4.68905818886241140826e+35f, "4689058", 36},
  {4.04408279066810417129e+32f, "40440828", 33},
  {5.33358031722883579904e+20f, "53335803", 21},
  {4.42096553033728000000e+15f, "44209655", 16},
  {1.27814325712931216863e-29f, "12781433", -28},
  {4.39428203937792000000e+14f, "4394282", 15},
  {2.34875163762637839682e-09f, "23487516", -8},
  {2.86651076352383595315e+21f, "28665108", 22},
  {2.95156349042632506195e+34f, "29515635", 35},
  {2.54076187002662529839e+32f, "25407619", 33},
  {1.63485659499884295949e+28f, "16348566", 29},
  {2.93376045365373519133e-23f, "29337605", -22},
  {8.88674417766748976579e+22f, "8886744", 23},
  {1.06394804687500000000e+04f, "1063948", 5},
  {4.91093291554690284523e-16f, "4910933", -15},
  {3.37238174791139756933e+31f, "33723817", 32},
  {7.57993007192012002409e+31f, "757993", 32},
  {1.37747331291200420031e+29f, "13774733", 30},
  {1.52484512329101562500e+00f, "15248451", 1},
  {1.58029237500000000000e+06f, "15802924", 7},
  {2.15290078833327159834e-26f, "21529008", -25},
  {7.78029871427371791642e-18f, "7780299", -17},
  {2.63872120588123038222e+28f, "26387212", 29},
  {5.27049183845520019531e-01f, "5270492", 0},
  {3.31545039080083370209e-03f, "33154504", -2},
  {1.64546196758690953697e+27f, "1645462", 28},
  {9.85106706619262695312e-01f, "9851067", 0},
  {1.67603838641306899723e-16f, "16760384", -15},
  {4.91277870564551419478e-25f, "49127787", -24},
  {3.23606223519744000000e+14f, "32360622", 15},
  {7.22231804890710016000e+17f, "7222318", 18},
  {3.22895107055396094926e-28f, "3228951", -27},
  {1.87349088000000000000e+08f, "18734909", 9},
  {5.29979884624481201172e-01f, "5299799", 0},
  {2.41739083956229708481e+26f, "24173908", 27},
  {4.05975049145679872000e+17f, "40597505", 18},
  {3.35240271391413622573e-25f, "33524027", -24},
  {7.72146242682150369483e-22f, "77214624", -21},
  {1.62252342700958251953e+00f, "16225234", 1},
  {1.31550268693177881811e-29f, "13155027", -28},
  {2.80515235296273713543e-28f, "28051524", -27},
  {3.70581031139405325803e-11f, "37058103", -10},
  {6.54035812596050203371e-14f, "6540358", -13},
  {4.06347875783237505410e+33f, "40634788", 34},
  {6.37707934633421828391e+31f, "63770793", 32},
  {5.39635046400000000000e+09f, "53963505", 10},
  {1.90009506739624519009e+26f, "1900095", 27},
  {6.96664521311959044745e+24f, "6966645", 25},
  {9.97525751590728759766e-01f, "99752575", 0},
  {3.98529841939831985798e-13f, "39852984", -12},
  {1.45118894678830656630e-08f, "145118895", -7},
  {3.65208902041600000000e+12f, "3652089", 13},
  {5.03051264000000000000e+08f, "50305126", 9},
  {5.55097024244149403932e-19f, "555097", -18},
  {2.77053188443068079342e-27f, "27705319", -26},
  {2.42131412055045689396e-33f, "24213141", -32},
  {1.26940356007445133337e-30f, "12694036", -29},
  {4.63193931776000000000e+11f, "46319393", 12},
  {6.29320207057304514819e-11f, "6293202", -10},
  {9.97533827496893427556e-17f, "9975338", -16},
  {2.08589195178562891719e-13f, "2085892", -12},
  {6.57730701785088969686e-32f, "6577307", -31},
  {5.32492231286596506834e-06f, "53249223", -5},
  {6.38979339673675452985e+33f, "63897934", 34},
  {5.84684400000000000000e+06f, "5846844", 7},
  {1.69837984819821785572e-18f, "16983798", -17},
  {3.60450333081600000000e+12f, "36045033", 13},
  {2.99610163169518944256e+20f, "29961016", 21},
  {2.22659677267074584961e-01f, "22265968", 0},
  {8.15329884893098893613e-27f, "8153299", -26},
  {6.70186161990663902436e+29f, "67018616", 30},
  {1.00529868800000000000e+10f, "10052987", 11},
  {4.91189956665039062500e+01f, "49118996", 2},
  {6.39488325768985524991e-23f, "6394883", -22},
  {5.68694140625000000000e+04f, "56869414", 5},
  {4.22302309743827208877e-06f, "4223023", -5},
  {5.66510394082623818763e+25f, "5665104", 26},
  {1.46286520674721032265e-08f, "14628652", -7},
  {4.19507264907424891375e-20f, "41950726", -19},
  {8.29599315133912329490e-14f, "8295993", -13},
  {9.89308882994069504000e+17f, "9893089", 18},
  {1.02767329280000000000e+11f, "10276733", 12},
  {4.76490795160763999452e+37f, "4764908", 38},
  {7.23134388740803712992e-13f, "7231344", -12},
  {9.00248976703696485585e+30f, "900249", 31},
  {1.85297812550627784299e-28f, "18529781", -27},
  {2.76973736390573321842e-07f, "27697374", -6},
  {1.62757579631874912460e-38f, "16275758", -37},
  {1.43577919899309640253e+22f, "14357792", 23},
  {2.93465810718529945600e+21f, "2934658", 22},
  {2.62364696703316089069e-16f, "2623647", -15},
  {4.27550090580517112448e-30f, "4275501", -29},
  {3.12339680360239769256e+28f, "31233968", 29},
  {2.27339112967831552000e+17f, "22733911", 18},
  {3.81716851352612463724e-35f, "38171685", -34},
  {2.40589433815330266953e-04f, "24058943", -3},
  {6.53163817080836431560e+37f, "6531638", 38},
  {2.20627423408947200000e+16f, "22062742", 17},
  {1.05139413002292662266e-22f, "10513941", -21},
  {2.05759089440107345581e-02f, "20575909", -1},
  {2.94409893745409957702e+28f, "2944099", 29},
  {1.02886659443433274886e-31f, "10288666", -30},
  {2.93294515678469801720e-31f, "29329452", -30},
  {1.90242888109537489072e-09f, "19024289", -8},
  {1.11142559965202083333e-15f, "11114256", -14},
  {2.68873839411200000000e+12f, "26887384", 13},
  {1.36415055930887662417e+24f, "13641506", 25},
  {8.66231890729987852348e-29f, "8662319", -28},
  {5.71096596397108564905e-35f, "5710966", -34},
  {8.07016475897218507931e-35f, "8070165", -34},
  {1.14765204489231109619e-03f, "1147652", -2},
  {8.98335100586420495974e+21f, "8983351", 22},
  {1.31906955064115200000e+15f, "13190696", 16},
  {7.90661724749952554703e-05f, "7906617", -4},
  {9.41892289336483461240e-30f, "9418923", -29},
  {1.63325970000000000000e+07f, "16332597", 8},
  {2.37087400000000000000e+06f, "2370874", 7},
  {4.23475219726562500000e+02f, "42347522", 3},
  {4.46806000000000000000e+07f, "446806", 8},
  {4.80420217496835277871e-11f, "48042022", -10},
  {1.68494207911725098203e-15f, "16849421", -14},
  {1.91817237483704174578e+30f, "19181724", 31},
  {3.14272381365299224854e-02f, "31427238", -1},
  {7.62034211024774009572e-26f, "7620342", -25},
  {5.85540032000000000000e+08f, "58554003", 9},
  {2.03681472778320312500e+02f, "20368147", 3},
  {3.10289331200000000000e+09f, "31028933", 10},
  {5.45673600000000000000e+07f, "5456736", 8},
  {6.15281254203307068684e-21f, "61528125", -20},
  {5.53562163248685241745e+25f, "55356216", 26},
  {1.49690380186037531184e-33f, "14969038", -32},
  {2.56849136177270353137e-31f, "25684914", -30},
  {9.56888036286341820328e+32f, "956888", 33},
  {7.39433407719950241738e-26f, "7394334", -25},
  {8.27336609363555908203e-02f, "8273366", -1},
  {1.46170225744096722600e-21f, "14617023", -20},
  {3.19730681968020754174e+25f, "31973068", 26},
  {1.61219658673622632129e-16f, "16121966", -15},
  {2.09754592167543663095e-11f, "2097546", -10},
  {2.91415460048088247151e+29f, "29141546", 30},
  {2.05226612613740311275e-12f, "20522661", -11},
  {3.90874314776994181336e+24f, "39087431", 25},
  {3.82935420108800000000e+12f, "38293542", 13},
  {3.91148650968611792217e-36f, "39114865", -35},
  {4.14607247291465358116e-19f, "41460725", -18},
  {5.82681799648691722650e+21f, "5826818", 22},
  {1.07100303360000000000e+10f, "1071003", 11},
  {1.61328232352659802513e+26f, "16132823", 27},
  {3.35389810542097155377e-15f, "3353898", -14},
  {6.68477247474527947918e-22f, "66847725", -21},
  {1.12051246593049071292e-23f, "11205125", -22},
  {9.58396672000000000000e+08f, "9583967", 9},
  {1.72219157079085179808e-30f, "17221916", -29},
  {5.97762181693440000000e+13f, "5977622", 14},
  {1.18922547156304328131e+22f, "11892255", 23},
  {1.70376129952088064000e+17f, "17037613", 18},
  {1.70757052425193677283e-23f, "17075705", -22},
  {5.07843118668915849412e-08f, "50784312", -7},
  {1.28498523399491609842e-14f, "12849852", -13},
  {1.68791739270091056824e-05f, "16879174", -4},
  {3.84540595580703807516e-21f, "3845406", -20},
  {3.26251270443833618629e-09f, "32625127", -8},
  {7.21189575195312500000e+02f, "7211896", 3},
  {5.19987372363349643206e-27f, "51998737", -26},
  {3.87258906250000000000e+04f, "3872589", 5},
  {8.14529171034017747284e-38f, "81452917", -37},
  {1.24327503847609932564e-09f, "1243275", -8},
  {1.70878078353808859902e-09f, "17087808", -8},
  {2.10400506526597485396e-15f, "2104005", -14},
  {4.09605107400625356800e+18f, "4096051", 19},
  {7.25929517974686037765e-19f, "7259295", -18},
  {7.21661591552000000000e+11f, "7216616", 12},
  {2.28228671875000000000e+04f, "22822867", 5},
  {4.59280822391911906513e+32f, "45928082", 33},
  {4.53881003769856000000e+14f, "453881", 15},
  {1.57769136574283107638e+24f, "15776914", 25},
  {3.71354441980313600000e+15f, "37135444", 16},
  {6.60563472004065468934e-15f, "66056347", -14},
  {3.70424119296000000000e+11f, "37042412", 12},
  {1.80699552935366291769e-38f, "18069955", -37},
  {7.36111755371093750000e+02f, "73611176", 3},
  {6.44264637838418443655e+26f, "64426464", 27},
  {2.83977804800000000000e+09f, "2839778", 10},
  {2.10183585792000000000e+11f, "21018359", 12},
  {5.56738548278808593750e+01f, "55673855", 2},
  {4.71328540641025028890e-08f, "47132854", -7},
  {4.98114605118615827450e-11f, "4981146", -10},
  {1.48440340402012160000e+17f, "14844034", 18},
  {3.88535159542056753299e+23f, "38853516", 24},
  {1.06958006779904000000e+14f, "10695801", 15},
  {3.67127737865493580103e-27f, "36712774", -26},
  {2.13735871046769259654e-36f, "21373587", -35},
  {4.89768940668388747270e-34f, "48976894", -33},
  {4.34816549912576000000e+14f, "43481655", 15},
  {1.70366365117578445081e-24f, "17036637", -23},
  {3.12100966400000000000e+09f, "31210097", 10},
  {5.75150559644876800000e+15f, "57515056", 16},
  {3.57763093750000000000e+05f, "3577631", 6},
  {3.38686692205140229475e-39f, "3386867", -38},
  {1.71803241478784471617e-38f, "17180324", -37},
  {2.02706652156802499126e-15f, "20270665", -14},
  {8.50882852620275268124e-19f, "85088285", -18},
  {1.95079228620800000000e+12f, "19507923", 13},
  {7.59666494775458306700e+27f, "7596665", 28},
  {5.69625760734065564715e-25f, "56962576", -24},
  {1.26123677474110351682e-12f, "12612368", -11},
  {1.61775112683520000000e+13f, "16177511", 14},
  {3.25284083568570027837e+29f, "3252841", 30},
  {1.37006337228800000000e+12f, "13700634", 13},
  {8.43247387606431419993e-15f, "8432474", -14},
  {9.91072929006113168479e+29f, "9910729", 30},
  {1.39279319134320107097e-24f, "13927932", -23},
  {7.93337844932536598386e-27f, "79333784", -26},
  {3.77202415466308593750e+00f, "37720242", 1},
  {4.69283924079946017716e+25f, "46928392", 26},
  {6.92231035944960000000e+13f, "69223104", 14},
  {2.97650109617645694956e+31f, "2976501", 32},
  {3.18394930690943478849e-24f, "31839493", -23},
  {1.48821674983423690719e-08f, "148821675", -7},
  {1.57903710280744960000e+16f, "15790371", 17},
  {5.72242817202337771114e+28f, "5722428", 29},
  {9.28691113281250000000e+03f, "9286911", 4},
  {5.41228331556457676800e+18f, "54122833", 19},
  {4.45513853694649348682e+33f, "44551385", 34},
  {5.68675846696409445839e-21f, "56867585", -20},
  {1.56210686323014504301e+33f, "15621069", 34},
  {1.91592910156250000000e+04f, "19159291", 5},
  {5.07683481004069985298e+33f, "50768348", 34},
  {7.84080624580383300781e-01f, "7840806", 0},
  {2.38798945312500000000e+04f, "23879895", 5},
  {1.47156556902736438283e+34f, "14715656", 35},
  {2.58301848943209188688e+23f, "25830185", 24},
  {3.43217756746355473331e+24f, "34321776", 25},
  {3.99734400000000000000e+07f, "3997344", 8},
  {2.73433729433600000000e+12f, "27343373", 13},
  {3.05707308352966326622e+38f, "3057073", 39},
  {8.19368248378223210502e+33f, "81936825", 34},
  {6.15388409718267692661e-14f, "6153884", -13},
  {1.44448917124904459469e+29f, "14444892", 30},
  {1.53017540000000000000e+07f, "15301754", 8},
  {8.72303001600000000000e+10f, "872303", 11},
  {2.04661335175620198400e+20f, "20466134", 21},
  {3.56041638690982723584e+21f, "35604164", 22},
  {1.13110030340434125914e+23f, "11311003", 24},
  {1.10402245393804066838e-18f, "11040225", -17},
  {2.30984080000000000000e+08f, "23098408", 9},
  {1.14409197121858596802e-02f, "1144092", -1},
  {4.49877575115985990370e-26f, "44987758", -25},
  {1.24333856295770602340e+23f, "12433386", 24},
  {2.89556859381959309405e+28f, "28955686", 29},
  {1.18324322949754260921e+29f, "11832432", 30},
  {9.58852287692800000000e+12f, "9588523", 13},
  {3.80407499278589966707e-07f, "3804075", -6},
  {8.94998592000000000000e+08f, "8949986", 9},
  {6.06041960000000000000e+07f, "60604196", 8},
  {3.50188830720000000000e+11f, "35018883", 12},
  {1.91535937500000000000e+03f, "19153594", 4},
  {1.59582535932626918912e-27f, "15958254", -26},
  {2.57845950000000000000e+06f, "25784595", 7},
  {2.16460910029054215281e-36f, "21646091", -35},
  {6.45387985197465600000e+15f, "645388", 16},
  {5.26902847290039062500e+01f, "52690285", 2},
  {8.88166086028456533195e+25f, "8881661", 26},
  {2.96410350799560546875e+01f, "29641035", 2},
  {2.89965191240500256546e-30f, "2899652", -29},
  {3.47840100526809692383e-01f, "3478401", 0},
  {1.31948060989379882812e+01f, "13194806", 2},
  {3.40870001084128188296e-35f, "34087", -34},
  {3.56382419769746370698e+24f, "35638242", 25},
  {2.74284261969626186328e-09f, "27428426", -8},
  {8.52141998080000000000e+10f, "852142", 11},
  {4.25617938162758946419e-04f, "42561794", -3},
  {7.51002274376959984397e-28f, "75100227", -27},
  {4.16737748309969902039e-07f, "41673775", -6},
  {6.72384229918356169776e-20f, "6723842", -19},
  {1.34973873855415149592e-07f, "13497387", -6},
  {1.38133792058346579262e-37f, "13813379", -36},
  {1.22841459144523776000e+17f, "12284146", 18},
  {9.81793500000000000000e+05f, "9817935", 6},
  {2.69453925350722249320e+24f, "26945393", 25},
  {4.89331100000000000000e+06f, "4893311", 7},
  {1.66758487466722726822e-04f, "16675849", -3},
  {3.76413799822330474854e-02f, "3764138", -1},
  {2.99822955396345300347e+38f, "29982296", 39},
  {1.98977512925997331822e-34f, "19897751", -33},
  {3.11436759003803064238e-33f, "31143676", -32},
  {1.42411579392000000000e+11f, "14241158", 12},
  {6.38748400000000000000e+07f, "6387484", 8},
  {8.41191034665242515259e-22f, "84119103", -21},
  {5.36038835841406281287e-22f, "53603884", -21},
  {2.30596464640000000000e+10f, "23059646", 11},
  {9.21149481064697445155e+32f, "9211495", 33},
  {4.40936515867823308800e+18f, "44093652", 19},
  {2.91049969382584095001e-03f, "29104997", -2},
  {3.88128719350788742304e-05f, "38812872", -4},
  {2.16655607193169081804e+27f, "2166556", 28},
  {1.56311925678397282343e+35f, "15631193", 36},
  {7.98023191044848969650e+34f, "7980232", 35},
  {1.18251381277059856381e+31f, "11825138", 32},
  {8.00145679333149638656e+20f, "8001457", 21},
  {3.16896004879871351356e-13f, "316896", -12},
  {1.43982434082031250000e+03f, "14398243", 4},
  {4.65372903143648747409e-22f, "4653729", -21},
  {3.91598455607891082764e-02f, "39159846", -1},
  {9.58708501390513329145e+34f, "9587085", 35},
  {5.23109640926122665405e-03f, "52310964", -2},
  {8.78074934878188683177e+29f, "8780749", 30},
  {2.15719588679988424884e+36f, "21571959", 37},
  {8.63517320784544225905e-25f, "8635173", -24},
  {1.22849654871970415115e-03f, "12284965", -2},
  {8.20430483152277445018e+21f, "8204305", 22},
  {7.14603111742223417344e+20f, "7146031", 21},
  {3.29399717383406031997e+31f, "32939972", 32},
  {4.21072310013420826448e-19f, "4210723", -18},
  {2.91131785027273097216e+20f, "29113179", 21},
  {1.10140923672288659823e+36f, "11014092", 37},
  {2.21976205320474628824e-13f, "2219762", -12},
  {6.01390794940925843548e-08f, "6013908", -7},
  {1.02290882812500000000e+05f, "10229088", 6},
  {3.17641464843750000000e+04f, "31764146", 5},
  {5.47458969600000000000e+09f, "54745897", 10},
  {3.14838686565639266054e-24f, "31483869", -23},
  {4.24370355904102325439e-02f, "42437036", -1},
  {3.45436144966182467897e-11f, "34543614", -10},
  {1.53190439321600000000e+12f, "15319044", 13},
  {2.64451033644090366744e+32f, "26445103", 33},
  {1.02546023310047723303e-22f, "102546023", -21},
  {3.42200256000000000000e+08f, "34220026", 9},
  {3.07202501205514854407e+28f, "3072025", 29},
  {1.74036640616642954705e-30f, "17403664", -29},
  {3.79582615339657536424e-10f, "37958262", -9},
  {1.28689427489427519685e-23f, "12868943", -22},
  {4.14836621312000000000e+11f, "41483662", 12},
  {2.90099140000000000000e+07f, "29009914", 8},
  {8.42887164067840000000e+13f, "8428872", 14},
  {5.58067320000000000000e+07f, "55806732", 8},
  {2.05744457378146993242e-34f, "20574446", -33},
  {1.03754804687500000000e+05f, "103754805", 6},
  {1.68566984375000000000e+05f, "16856698", 6},
  {3.01466394297605748191e-20f, "3014664", -19},
  {1.73141220870700307503e-37f, "17314122", -36},
  {1.86154130304982956545e-12f, "18615413", -11},
  {3.10988654785265181748e-38f, "31098865", -37},
  {9.50981669616406360364e+32f, "9509817", 33},
  {1.31885456000000000000e+08f, "13188546", 9},
  {1.52955711923137649050e+21f, "15295571", 22},
  {1.42285627484354179066e+30f, "14228563", 31},
  {4.97881533670010308550e+33f, "49788153", 34},
  {1.34887474095160537547e-25f, "13488747", -24},
  {2.05477379495278000832e-04f, "20547738", -3},
  {2.32062444090843200684e-01f, "23206244", 0},
  {1.19321277852913202364e+23f, "11932128", 24},
  {1.09013401600000000000e+11f, "1090134", 12},
  {1.61432705255334546410e+36f, "1614327", 37},
  {5.70662055874077715524e-27f, "57066206", -26},
  {2.19781174071290207397e-16f, "21978117", -15},
  {5.84478837104038685695e+29f, "58447884", 30},
  {9.91365670111044039459e-11f, "9913657", -10},
  {1.27212096612400037726e+31f, "1272121", 32},
  {2.57381202489340067840e+19f, "2573812", 20},
  {2.82225236296653747559e-02f, "28222524", -1},
  {6.53887721789240344784e-18f, "65388772", -17},
  {5.56600075065812537024e+34f, "55660008", 35},
  {1.66027875353078224395e-29f, "16602788", -28},
  {3.19651698174985470512e+28f, "3196517", 29},
  {6.60471808000000000000e+09f, "6604718", 10},
  {1.42571611189411840000e+17f, "14257161", 18},
  {1.09175502701002529770e+33f, "1091755", 34},
  {9.27230953693690228513e-25f, "927231", -24},
  {3.51008832068181456576e-17f, "35100883", -16},
  {4.63823372510249961063e-26f, "46382337", -25},
  {2.59682660143680586667e-23f, "25968266", -22},
  {1.10641428480000000000e+10f, "11064143", 11},
  {2.31016905365938492793e-25f, "2310169", -24},
  {3.60307758728169670429e-29f, "36030776", -28},
  {2.12314281515382581447e-21f, "21231428", -20},
  {5.86818637083182812272e+34f, "58681864", 35},
  {7.28694483315773986363e-38f, "7286945", -37},
  {1.51354951654624981024e-26f, "15135495", -25},
  {1.08374733647507139163e-29f, "10837473", -28},
  {2.40826676599681377411e-03f, "24082668", -2},
  {5.64902559744000000000e+11f, "56490256", 12},
  {2.10364311444551500158e+32f, "21036431", 33},
  {3.58810693321549995977e-31f, "3588107", -30},
  {1.33362649600000000000e+09f, "13336265", 10},
  {1.63716938976575629476e-33f, "16371694", -32},
  {1.34035884613581401936e-08f, "134035885", -7},
  {1.08632647991180419922e+00f, "10863265", 1},
  {2.69430074695264920592e-05f, "26943007", -4},
  {2.33903436763505936588e-16f, "23390344", -15},
  {4.01586526183434258210e-20f, "40158653", -19},
  {1.27534052900976527309e+32f, "12753405", 33},
  {2.54032015625000000000e+05f, "25403202", 6},
  {3.01351610555166149318e-24f, "30135161", -23},
  {2.83982420480606952850e-36f, "28398242", -35},
  {1.18403568194480612874e-05f, "11840357", -4},
  {3.28668117942517985863e+24f, "32866812", 25},
  {6.88419799235202908160e+19f, "6884198", 20},
  {1.79578522191414791109e-11f, "17957852", -10},
  {3.40230029644925324384e-36f, "34023003", -35},
  {1.31633148193359375000e+02f, "13163315", 3},
  {1.90900016105724245765e-23f, "19090002", -22},
  {6.23926260531200000000e+12f, "62392626", 13},
  {5.15893325358694400000e+15f, "5158933", 16},
  {1.06281608134532051801e-13f, "10628161", -12},
  {2.11941847813510276877e+30f, "21194185", 31},
  {4.28322390016000000000e+11f, "4283224", 12},
  {1.29101655581276286711e-12f, "12910166", -11},
  {4.43680958278108775156e-35f, "44368096", -34},
  {7.52918752209473110016e+20f, "75291875", 21},
  {4.99443614211850066985e+23f, "4994436", 24},
  {4.21205993167257600000e+15f, "421206", 16},
  {2.21234285510656000000e+14f, "22123429", 15},
  {2.98538138167701816963e+31f, "29853814", 32},
  {7.90526278200134532859e-15f, "7905263", -14},
  {6.03041753768164065280e+19f, "60304175", 20},
  {5.64395628689195842653e-16f, "56439563", -15},
  {1.44937307577753399407e+24f, "14493731", 25},
  {2.31657702009630178314e-24f, "2316577", -23},
  {2.22182920000000000000e+07f, "22218292", 8},
  {8.09124617108710294936e-35f, "8091246", -34},
  {3.88960383688502453571e-31f, "38896038", -30},
  {8.15822306661279822076e-27f, "8158223", -26},
  {4.07130058004217369148e-20f, "40713006", -19},
  {1.87776713093235052826e-28f, "18777671", -27},
  {1.52199810000000000000e+07f, "15219981", 8},
  {1.79244796907655720697e-34f, "1792448", -33},
  {2.18747828169631225839e+30f, "21874783", 31},
  {4.35495570149024355305e+34f, "43549557", 35},
  {1.29198836646492054477e-34f, "12919884", -33},
  {1.20475844921487985268e+33f, "120475845", 34},
  {8.41251108795404434204e-03f, "8412511", -2},
  {3.86860068179439317251e-19f, "38686007", -18},
  {1.06943710000000000000e+07f, "10694371", 8},
  {6.31921896878190917657e-26f, "6319219", -25},
  {6.93655300000000000000e+06f, "6936553", 7},
  {3.04186679422855377197e-02f, "30418668", -1},
  {4.30508787332503217740e+24f, "4305088", 25},
  {1.39321114459282766664e+33f, "13932111", 34},
  {2.29090988159179687500e+02f, "22909099", 3},
  {4.42933850000000000000e+06f, "44293385", 7},
  {9.94862378787012608000e+17f, "9948624", 18},
  {1.40633194642043612141e-21f, "14063319", -20},
  {1.41206565142613043492e-18f, "14120657", -17},
  {4.11532697600000000000e+10f, "4115327", 11},
  {1.81541943359375000000e+03f, "18154194", 4},
  {1.18729518965781394946e-37f, "11872952", -36},
  {3.81276526086111323527e+33f, "38127653", 34},
  {3.58661754809586064141e-12f, "35866175", -11},
  {4.40148413056046509281e-23f, "4401484", -22},
  {1.14747978210449218750e+02f, "11474798", 3},
  {4.92408851471282105194e-08f, "49240885", -7},
  {2.90451621019999044193e-15f, "29045162", -14},
  {1.48528877797376000000e+14f, "14852888", 15},
  {3.17290151936000000000e+11f, "31729015", 12},
  {9.12321629584766924381e-05f, "9123216", -4},
  {3.24345459115922660383e-18f, "32434546", -17},
  {9.14842529562624000000e+15f, "9148425", 16},
  {2.77478615171716791465e-13f, "27747862", -12},
  {2.03091154576543905191e-22f, "20309115", -21},
  {2.00310488499673366528e+20f, "20031049", 21},
  {4.66895686105809185117e-19f, "4668957", -18},
  {2.80763303985152000000e+14f, "2807633", 15},
  {1.07339921993177286173e-37f, "10733992", -36},
  {8.36511144338373572569e+26f, "83651114", 27},
  {3.01378477457688964010e+27f, "30137848", 28},
  {1.20476312000000000000e+08f, "12047631", 9},
  {3.68985237871911897489e-14f, "36898524", -13},
  {1.75728398172160000000e+13f, "1757284", 14},
  {2.39171554565429687500e+02f, "23917155", 3},
  {1.34690953132131287626e+27f, "13469095", 28},
  {1.14257268939819167753e-19f, "11425727", -18},
  {3.45717138486817411987e-19f, "34571714", -18},
  {2.69372667115886780472e-33f, "26937267", -32},
  {2.69094104766845703125e+01f, "2690941", 2},
  {2.27170187681295169557e+30f, "22717019", 31},
  {8.16687616000000000000e+08f, "8166876", 9},
  {4.97763061523437500000e+02f, "49776306", 3},
  {1.21925541983515422019e+25f, "12192554", 26},
  {4.96122079202734940415e+35f, "49612208", 36},
  {3.70599849941899673600e+18f, "37059985", 19},
  {1.91651967733352801559e-12f, "19165197", -11},
  {3.33300886889986713868e-11f, "3333009", -10},
  {1.49538579554719477636e-35f, "14953858", -34},
  {4.17151530909960479975e-37f, "41715153", -36},
  {1.52756428414080833536e-38f, "15275643", -37},
  {2.17133209109306335449e-01f, "21713321", 0},
  {2.19680191862109733779e-16f, "21968019", -15},
  {2.36923066200883200000e+16f, "23692307", 17},
  {9.46554838704421474612e+24f, "94655484", 25},
  {7.58738040924072265625e+00f, "75873804", 1},
  {6.53337454423308372498e-03f, "65333745", -2},
  {6.37262670887624823468e-33f, "6372627", -32},
  {3.12970131460964885916e-24f, "31297013", -23},
  {1.13373607397079467773e-01f, "11337361", 0},
  {8.99224325028914075106e+32f, "8992243", 33},
  {1.33496597243582551254e-35f, "1334966", -34},
  {1.98351035966791478435e-32f, "19835104", -31},
  {4.56374801744141368402e-20f, "4563748", -19},
  {3.98783676164341760000e+16f, "39878368", 17},
  {7.93356992000000000000e+08f, "793357", 9},
  {8.73540532498598308876e-32f, "87354053", -31},
  {7.71407064252360093852e+35f, "7714071", 36},
  {4.24695262641300599503e+28f, "42469526", 29},
  {3.92931308741794878318e-26f, "3929313", -25},
  {2.87894140928983688354e-02f, "28789414", -1},
  {1.37549133333196177408e+20f, "13754913", 21},
  {4.91729916324084291994e+21f, "4917299", 22},
  {2.10050197686158169261e-38f, "2100502", -37},
  {2.35891625000000000000e+06f, "23589162", 7},
  {3.53772044381113548800e+18f, "35377204", 19},
  {1.28585806791426703360e+19f, "12858581", 20},
  {7.64849183357089170389e+32f, "7648492", 33},
  {1.65607029567574232311e-31f, "16560703", -30},
  {3.09116314819601429955e+22f, "30911631", 23},
  {5.34771577388296569468e+34f, "5347716", 35},
  {3.90281592319052671838e-31f, "3902816", -30},
  {9.53066665717574042324e-18f, "9530667", -17},
  {1.71591137905695668265e-20f, "17159114", -19},
  {1.56453134322849622157e+24f, "15645313", 25},
  {1.31241158347696951443e-31f, "13124116", -30},
  {2.14529034220491243520e+19f, "21452903", 20},
  {1.36466801621120412472e-17f, "1364668", -16},
  {1.41133687068652153101e-25f, "14113369", -24},
  {1.09531771012333518466e+34f, "10953177", 35},
  {2.62780763355859648512e+20f, "26278076", 21},
  {1.72606287335618887042e-31f, "17260629", -30},
  {2.47512658705398489024e+37f, "24751266", 38},
  {8.60298073247469449702e+26f, "8602981", 27},
  {1.30436232561453868684e-12f, "13043623", -11},
  {1.43062018608332800000e+15f, "14306202", 16},
  {9.11928247660398483276e-04f, "91192825", -3},
  {1.84007622010540217161e-05f, "18400762", -4},
  {1.57376433356800000000e+12f, "15737643", 13},
  {5.51298915373032993870e-14f, "5512989", -13},
  {1.15829344000000000000e+08f, "11582934", 9},
  {6.43131323377819781714e-29f, "6431313", -28},
  {1.11170776617964845699e-32f, "11117078", -31},
  {8.22949375312020947604e-10f, "8229494", -9},
  {2.14219237710123551859e-28f, "21421924", -27},
  {4.24118583296000000000e+12f, "42411858", 13},
  {4.10684774719665004921e-30f, "41068477", -29},
  {4.61073842836893528099e+29f, "46107384", 30},
  {4.64353400000000000000e+06f, "4643534", 7},
  {1.04871515838879606657e-22f, "104871516", -21},
  {1.91990679470080000000e+13f, "19199068", 14},
  {3.56997283935546875000e+02f, "35699728", 3},
  {6.96306907125481336363e-15f, "6963069", -14},
  {3.04238372346845770044e+34f, "30423837", 35},
  {9.80268694542204534784e+20f, "9802687", 21},
  {1.58287126563082898269e-29f, "15828713", -28},
  {5.40403286648647780776e-36f, "5404033", -35},
  {2.91776638031005859375e+01f, "29177664", 2},
  {3.63818912774149794132e-08f, "3638189", -7},
  {1.22900161899462335762e-22f, "12290016", -21},
  {4.58583148429170250893e-04f, "45858315", -3},
  {1.29433785916016136076e-26f, "12943379", -25},
  {3.39496416852799135638e-15f, "33949642", -14},
  {1.59020310093183070421e-05f, "15902031", -4},
  {1.63550280160158818229e-38f, "16355028", -37},
  {7.39617603584000000000e+11f, "7396176", 12},
  {3.31397714610939016190e-29f, "3313977", -28},
  {2.45890836231410503387e-03f, "24589084", -2},
  {1.91208658822798333143e-32f, "19120866", -31},
  {8.23643013356471504077e+21f, "823643", 22},
  {2.26422682131703277814e+22f, "22642268", 23},
  {3.59516914843648000000e+14f, "3595169", 15},
  {8.25887441790356406904e+31f, "8258874", 32},
  {3.97139404187789303145e+28f, "3971394", 29},
  {4.02338701425600216137e-34f, "4023387", -33},
  {2.59698930616076255551e-35f, "25969893", -34},
  {2.47192169189453125000e+02f, "24719217", 3},
  {2.78355166389280427092e-25f, "27835517", -24},
  {1.99077810941130304317e+33f, "19907781", 34},
  {1.63813845849236655741e-30f, "16381385", -29},
  {4.94349716717579212855e-09f, "4943497", -8},
  {5.45252920000000000000e+07f, "54525292", 8},
  {9.84622448640000000000e+10f, "98462245", 11},
  {5.79586133432729600000e+15f, "57958613", 16},
  {2.23198193359375000000e+03f, "2231982", 4},
  {1.30349874893909145612e-07f, "13034987", -6},
  {1.49038266663462523204e+25f, "14903827", 26},
  {1.97722937500000000000e+06f, "19772294", 7},
  {6.22120886527681251594e+32f, "6221209", 33},
  {7.46148466959039803206e-22f, "74614847", -21},
  {3.95315797155424281559e+22f, "3953158", 23},
  {4.18027529258679919621e-10f, "41802753", -9},
  {1.64214408737706207830e-09f, "16421441", -8},
  {1.93032993729179875743e-31f, "19303299", -30},
  {1.11074302428231008623e+24f, "1110743", 25},
  {4.30111102289743030269e-09f, "4301111", -8},
  {2.40350690964857159680e+19f, "2403507", 20},
  {5.97307183101231339481e+33f, "5973072", 34},
  {1.74986758756505380558e+27f, "17498676", 28},
  {7.17313772040424378618e+25f, "71731377", 26},
  {6.82566897148887040000e+16f, "6825669", 17},
  {5.53948938240000000000e+10f, "55394894", 11},
  {3.62071456909179687500e+01f, "36207146", 2},
  {8.21407590400000000000e+09f, "8214076", 10},
  {3.22944879531860351562e+00f, "32294488", 1},
  {2.46625975000000000000e+06f, "24662598", 7},
  {3.50301915709440000000e+13f, "35030192", 14},
  {1.16301584404941358494e-36f, "11630158", -35},
  {1.12307275458435612672e+20f, "112307275", 21},
  {1.02332664000000000000e+08f, "102332664", 9},
  {3.19928019383073119371e-28f, "31992802", -27},
  {7.46828302704986747494e-28f, "7468283", -27},
  {7.60910853374216658235e-24f, "76091085", -23},
  {4.80274672901895382630e+21f, "4802747", 22},
  {7.03148120661225229177e+26f, "7031481", 27},
  {2.85853259500250726400e+18f, "28585326", 19},
  {9.18563541712800666554e-25f, "9185635", -24},
  {1.47511941529600000000e+13f, "14751194", 14},
  {7.99590631878586977077e-15f, "7995906", -14},
  {8.10580843479573441937e-31f, "8105808", -30},
  {1.82390834855704790965e+30f, "18239083", 31},
  {4.62160462274376727472e-31f, "46216046", -30},
  {5.69671206176280975342e-02f, "5696712", -1},
  {4.17044447078412770400e-18f, "41704445", -17},
  {1.49462036278678343160e-23f, "14946204", -22},
  {9.21772686065406644026e-17f, "9217727", -16},
  {2.98323777945600000000e+12f, "29832378", 13},
  {5.94932096100659194593e+34f, "5949321", 35},
  {7.66941679217413189068e-22f, "7669417", -21},
  {7.08060550689697265625e+00f, "70806055", 1},
  {6.07513409504115110707e+21f, "6075134", 22},
  {8.85491020563594834085e+33f, "885491", 34},
  {5.58328727918312402951e-28f, "55832873", -27},
  {3.14844369955909978570e-16f, "31484437", -15},
  {1.06029531250000000000e+05f, "10602953", 6},
  {2.74476498944000000000e+11f, "2744765", 12},
  {1.26284731127330930204e+29f, "12628473", 30},
  {5.45190420038117377717e-21f, "5451904", -20},
  {5.42892254822400000000e+13f, "54289225", 14},
  {1.91724728320000000000e+10f, "19172473", 11},
  {8.77385163155738091397e+25f, "8773852", 26},
  {2.72540094457291472477e+24f, "2725401", 25},
  {2.31991225444959938150e+21f, "23199123", 22},
  {9.65861176756515475618e-37f, "9658612", -36},
  {1.91968360000000000000e+07f, "19196836", 8},
  {2.36446387200000000000e+09f, "23644639", 10},
  {4.49669821278527160320e+20f, "44966982", 21},
  {2.96256691407611441971e+21f, "2962567", 22},
  {4.93509651560080188967e-17f, "49350965", -16},
  {5.08095567996830162855e-33f, "50809557", -32},
  {4.06354649031927060293e+29f, "40635465", 30},
  {1.25820984777890652163e-25f, "12582098", -24},
  {3.76487219675575073433e-25f, "37648722", -24},
  {3.21648853385259059223e-11f, "32164885", -10},
  {8.66036789375357329845e-05f, "8660368", -4},
  {9.07985353570950337598e-10f, "90798535", -9},
  {4.85350604800000000000e+11f, "4853506", 12},
  {3.50162393303454295215e-31f, "3501624", -30},
  {7.85650299157947262785e-14f, "7856503", -13},
  {6.24549684536859938055e+28f, "6245497", 29},
  {4.14916832000000000000e+08f, "41491683", 9},
  {6.58142830104487263687e-31f, "65814283", -30},
  {7.74908591262975668519e+23f, "7749086", 24},
  {3.55660719484609495040e+19f, "35566072", 20},
  {3.23809210556191828800e-08f, "3238092", -7},
  {1.10586470536411241028e-10f, "11058647", -9},
  {1.43432616894756392867e-08f, "14343262", -7},
  {5.83026963742640207805e-18f, "58302696", -17},
  {1.01265880000000000000e+08f, "10126588", 9},
  {1.13099279792954428466e-33f, "11309928", -32},
  {1.82181228274785457522e+31f, "18218123", 32},
  {1.25348888104781508446e-05f, "12534889", -4},
  {5.05574553372635479849e+29f, "50557455", 30},
  {6.19768394547200000000e+13f, "6197684", 14},
  {1.88166275620460510254e-03f, "18816628", -2},
  {1.35900992900133132935e-02f, "13590099", -1},
  {2.06782037362464277911e-16f, "20678204", -15},
  {1.22850548228322451711e-21f, "12285055", -20},
  {5.40536745532746659119e-20f, "54053675", -19},
  {1.72027600000000000000e+06f, "1720276", 7},
  {9.76310397916922267231e-16f, "9763104", -15},
  {3.22223246394296607699e-29f, "32222325", -28},
  {3.42638851433137438720e+19f, "34263885", 20},
  {5.99940083920955657959e-02f, "5999401", -1},
  {1.72704353928565979004e-01f, "17270435", 0},
  {4.22313332951221480727e-24f, "42231333", -23},
  {9.25826619309250997519e+27f, "9258266", 28},
  {1.15850728760092751514e-28f, "11585073", -27},
  {2.33568276414189250623e-16f, "23356828", -15},
  {1.03548337748877509978e-24f, "10354834", -23},
  {8.50958250769592146239e-39f, "8509583", -38},
  {1.62014229983429117287e+31f, "16201423", 32},
  {1.06604337428314833655e-16f, "10660434", -15},
  {1.21605116274347564073e+24f, "12160512", 25},
  {8.38720815104000000000e+11f, "8387208", 12},
  {5.66854816890880000000e+14f, "5668548", 15},
  {1.97050452983674912512e-25f, "19705045", -24},
  {1.74626989606454624547e-35f, "17462699", -34},
  {5.60733913383717735952e+35f, "5607339", 36},
  {3.34044707031017009971e+21f, "3340447", 22},
  {3.02742231788740513903e-30f, "30274223", -29},
  {1.46952678055190082404e+28f, "14695268", 29},
  {5.59945587429378374223e-23f, "5599456", -22},
  {2.57622481548965074189e+38f, "25762248", 39},
  {1.27521850585937500000e+03f, "12752185", 4},
  {1.74561112883200000000e+13f, "17456111", 14},
  {4.89727174863219261169e-03f, "48972717", -2},
  {4.28581690566767919088e+25f, "4285817", 26},
  {3.63788688266323615892e+30f, "3637887", 31},
  {4.49614227565445120000e+16f, "44961423", 17},
  {1.04215189367096172646e-07f, "10421519", -6},
  {5.07598110933841854325e-24f, "5075981", -23},
  {2.35887610715352375323e+26f, "23588761", 27},
  {5.18890940446009989835e-27f, "51889094", -26},
  {5.11555938549760000000e+13f, "51155594", 14},
  {5.41724292106495614041e-14f, "5417243", -13},
  {3.42379900472589149274e-12f, "3423799", -11},
  {6.77694152832031250000e+02f, "67769415", 3},
  {1.02866499219089746475e-03f, "1028665", -2},
  {1.32913872896000000000e+11f, "13291387", 12},
  {1.13522711552065536000e+17f, "11352271", 18},
  {1.73561344854533672333e-03f, "17356134", -2},
  {3.13699340820312500000e+03f, "31369934", 4},
  {1.75837159368036322519e-38f, "17583716", -37},
  {3.09329339263517841615e-18f, "30932934", -17},
  {3.49850857894244477216e-24f, "34985086", -23},
  {1.69199511850188800000e+15f, "16919951", 16},
  {1.03083330031950026751e-04f, "10308333", -3},
  {1.02193075581454807439e-20f, "102193076", -19},
  {1.30862861516800000000e+12f, "13086286", 13},
  {4.67414651871203495468e-22f, "46741465", -21},
  {5.19125194220482200080e-12f, "5191252", -11},
  {2.67845382690429687500e+01f, "26784538", 2},
  {4.43023327534319832921e-06f, "44302333", -5},
  {1.76544694661939782776e-12f, "1765447", -11},
  {4.62070126727377484731e-35f, "46207013", -34},
  {1.12993395302594187759e-31f, "1129934", -30},
  {1.44446206251347305352e+24f, "1444462", 25},
  {3.25539620263691070079e+29f, "32553962", 30},
  {6.72390527264618032538e+37f, "67239053", 38},
  {9.23367233276367187500e+01f, "9233672", 2},
  {4.92845392440975605623e-17f, "4928454", -16},
  {4.61113407270710370063e-25f, "4611134", -24},
  {2.86257892390118229287e-11f, "2862579", -10},
  {4.21616350649856030941e-05f, "42161635", -4},
  {3.88424294552527683664e+27f, "3884243", 28},
  {2.63625545613312000000e+14f, "26362555", 15},
  {2.38726178543707420099e+22f, "23872618", 23},
  {3.52497164790577244275e-09f, "35249716", -8},
  {3.89058672883745329305e-28f, "38905867", -27},
  {4.56984480479150079191e-06f, "4569845", -5},
  {5.78984006085085699287e-31f, "578984", -30},
  {1.14339640000000000000e+08f, "11433964", 9},
  {2.29915564074234286071e+36f, "22991556", 37},
  {1.54913030836674714466e-30f, "15491303", -29},
  {5.89043816556767251373e+28f, "5890438", 29},
  {1.15485523331423349722e-26f, "11548552", -25},
  {4.43237393825573594202e+23f, "4432374", 24},
  {8.35508047567368877795e-15f, "83550805", -14},
  {1.92993212522196699865e-08f, "19299321", -7},
  {8.08955228421837091446e-04f, "8089552", -3},
  {6.55116638183593750000e+02f, "65511664", 3},
  {1.58837175981776568320e+19f, "15883718", 20},
  {3.53780397980060065878e+36f, "3537804", 37},
  {4.78815756681687838436e+35f, "47881576", 36},
  {4.10021686584826608294e-32f, "4100217", -31},
  {2.35124855843179941002e-37f, "23512486", -36},
  {7.64003369767329966683e-35f, "76400337", -34},
  {9.42156752918383490315e+30f, "94215675", 31},
  {1.29539714028453260154e+31f, "12953971", 32},
  {7.02696948487287619188e-36f, "70269695", -35},
  {1.24057567063573515043e-06f, "12405757", -5},
  {8.71040095591958099735e-25f, "8710401", -24},
  {5.43142673443328053261e-22f, "54314267", -21},
  {5.98790049615889144218e+21f, "59879005", 22},
  {6.16145408000000000000e+09f, "6161454", 10},
  {2.85236789899698972313e-33f, "28523679", -32},
  {2.22882698290050029755e-03f, "2228827", -2},
  {2.02462828724492283072e-07f, "20246283", -6},
  {1.70287827495485544205e-03f, "17028783", -2},
  {1.43302208000000000000e+08f, "1433022", 9},
  {1.46722100395096579544e+26f, "1467221", 27},
  {1.58812890625000000000e+05f, "15881289", 6},
  {2.34453184455157351744e-23f, "23445318", -22},
  {4.91437763312657140548e+23f, "49143776", 24},
  {4.13557871083520000000e+13f, "41355787", 14},
  {1.93892429975160697753e-33f, "19389243", -32},
  {9.39154792811586604966e+35f, "9391548", 36},
  {2.56554950028657913208e-02f, "25655495", -1},
  {2.67160471523197884380e-09f, "26716047", -8},
  {2.48581450562612715771e-11f, "24858145", -10},
  {3.37159716472587423191e+33f, "33715972", 34},
  {2.78085086266759902401e+32f, "27808509", 33},
  {5.64175504411618784394e-31f, "5641755", -30},
  {1.65247477909472050722e+31f, "16524748", 32},
  {1.82971961719300356914e+29f, "18297196", 30},
  {3.61842016970146989265e-24f, "361842", -23},
  {6.09966443051341339042e+32f, "60996644", 33},
  {2.26058126075836506853e+33f, "22605813", 34},
  {4.81125517849823005105e-32f, "48112552", -31},
  {1.11894732900124287000e+25f, "11189473", 26},
  {2.53755476631101453781e+36f, "25375548", 37},
  {1.00201196670532226562e+01f, "1002012", 2},
  {1.42233321544295046749e-38f, "14223332", -37},
  {1.97117703375845003768e-24f, "1971177", -23},
  {8.44048281080862002491e-17f, "8440483", -16},
  {1.41266862080000000000e+10f, "14126686", 11},
  {9.04481364579144094987e-19f, "9044814", -18},
  {3.06522467317904834560e+19f, "30652247", 20},
  {4.04127517702584020483e-36f, "4041275", -35},
  {2.57468050851233792000e+17f, "25746805", 18},
  {6.29132553345290723712e-12f, "62913255", -11},
  {9.81860933150115625646e+28f, "9818609", 29},
  {5.54609049721289059081e-17f, "55460905", -16},
  {2.45895097656250000000e+04f, "2458951", 5},
  {6.56298978836480000000e+13f, "65629898", 14},
  {3.89992826002458546767e+35f, "38999283", 36},
  {7.55595724800000000000e+09f, "7555957", 10},
  {8.78507786240000000000e+10f, "8785078", 11},
  {1.38514988066162914038e-05f, "13851499", -4},
  {2.80605869637590216994e-38f, "28060587", -37},
  {3.38008566827501885647e+38f, "33800857", 39},
  {6.48570572248097221291e-11f, "6485706", -10},
  {1.23797145201387714142e+33f, "123797145", 34},
  {2.79452129302056708484e-31f, "27945213", -30},
  {1.51242013391925287459e-18f, "15124201", -17},
  {3.21003791216027222671e+23f, "3210038", 24},
  {1.67709294243240060115e-16f, "1677093", -15},
  {1.34276718260815799682e-24f, "13427672", -23},
  {1.03970513589213593600e+18f, "103970514", 19},
  {1.36184319377008478114e-09f, "13618432", -8},
  {2.09269772532421748890e-38f, "20926977", -37},
  {3.85653354476339200000e+15f, "38565335", 16},
  {2.17374563996412733011e+30f, "21737456", 31},
  {4.67907346014945376181e-38f, "46790735", -37},
  {1.20689739320504327878e+30f, "12068974", 31},
  {2.55450984436640959828e-25f, "25545098", -24},
  {1.12344006656000000000e+11f, "11234401", 12},
  {1.57272922224718857932e-27f, "15727292", -26},
  {1.23118893328113745357e+33f, "12311889", 34},
  {6.95864016240640000000e+13f, "695864", 14},
  {6.86705330513395722269e+28f, "68670533", 29},
  {1.12846766763148339109e-17f, "11284677", -16},
  {9.97005078125000000000e+03f, "9970051", 4},
  {5.59535226731973786852e-27f, "55953523", -26},
  {4.36032607199300312629e+25f, "4360326", 26},
  {9.16795514308722220835e-22f, "9167955", -21},
  {3.00598543866852150934e-30f, "30059854", -29},
  {4.60541079519316554070e-04f, "46054108", -3},
  {1.34762963318036946129e+28f, "13476296", 29},
  {7.04845166015625000000e+03f, "70484517", 4},
  {2.10926099680364131927e-03f, "2109261", -2},
  {6.67197187348996389194e+27f, "6671972", 28},
  {7.44384371025774044715e+31f, "74438437", 32},
  {3.70170671892822156224e-09f, "37017067", -8},
  {2.93158680249477530904e+35f, "29315868", 36},
  {1.63239011769287261050e-25f, "16323901", -24},
  {1.73617142578858451579e-24f, "17361714", -23},
  {6.91165688843799441660e-20f, "6911657", -19},
  {3.49844597735682327766e-11f, "3498446", -10},
  {3.00674900046760838653e+32f, "3006749", 33},
  {1.49228103680000000000e+10f, "1492281", 11},
  {1.15386630805680567846e-10f, "11538663", -9},
  {1.68115456000000000000e+09f, "16811546", 10},
  {4.64648551940917968750e+01f, "46464855", 2},
  {9.18556453122221228114e-10f, "91855645", -9},
  {2.93969106674194335938e+00f, "2939691", 1},
  {1.89974443143987200000e+15f, "18997444", 16},
  {1.51159679642548919630e-37f, "15115968", -36},
  {7.78888544256000000000e+11f, "77888854", 12},
  {3.40217011200000000000e+09f, "340217", 10},
  {1.78474265555763200000e+15f, "17847427", 16},
  {7.36177902221679687500e+01f, "7361779", 2},
  {6.13822897073098892275e+30f, "6138229", 31},
  {2.44245965397922652740e-20f, "24424597", -19},
  {6.62154311106560000000e+13f, "6621543", 14},
  {3.85557152577617920000e+17f, "38555715", 18},
  {3.68081708438694477081e-03f, "3680817", -2},
  {3.37597326561071952036e+22f, "33759733", 23},
  {2.53126852298440130109e-25f, "25312685", -24},
  {7.07891861448373127530e-14f, "70789186", -13},
  {3.42888315397332776868e-13f, "34288832", -12},
  {8.96093798400000000000e+10f, "8960938", 11},
  {6.58737953778159873916e-25f, "65873795", -24},
  {3.64044707900516352217e-20f, "3640447", -19},
  {4.85743140131197935451e-37f, "48574314", -36},
  {2.74067245916589552748e-28f, "27406725", -27},
  {9.16404189865716034546e-07f, "9164042", -6},
  {1.41960391899471719353e-22f, "14196039", -21},
  {3.04000646877966573811e-09f, "30400065", -8},
  {5.30744768780980925235e+21f, "53074477", 22},
  {6.02730248340058065809e-29f, "60273025", -28},
  {6.43858136675453798116e-38f, "64385814", -37},
  {8.93599812648092265788e-28f, "8935998", -27},
  {1.62287762328109711360e+19f, "16228776", 20},
  {4.66268554687500000000e+02f, "46626855", 3},
  {1.38087432861328125000e+02f, "13808743", 3},
  {6.66444426885371874017e-20f, "6664444", -19},
  {1.27789620239863138514e-21f, "12778962", -20},
  {3.45336523437500000000e+03f, "34533652", 4},
  {8.34703859739867386111e+30f, "83470386", 31},
  {6.76492427900762337416e+26f, "6764924", 27},
  {8.61522986699469967805e-21f, "861523", -20},
  {8.56609858601586893201e-07f, "85660986", -6},
  {6.01126206600485273600e+18f, "6011262", 19},
  {3.35500203073024749756e-02f, "3355002", -1},
  {8.27513522219693771472e-32f, "8275135", -31},
  {3.20538040250539779663e-03f, "32053804", -2},
  {2.03348933095572134061e+34f, "20334893", 35},
  {4.64474248936014576310e+29f, "46447425", 30},
  {1.28175652864000000000e+11f, "12817565", 12},
  {2.08776684975143010339e-18f, "20877668", -17},
  {2.08969493606761214441e-22f, "20896949", -21},
  {1.62257614832421521891e-17f, "16225761", -16},
  {2.19268345972523093224e-04f, "21926835", -3},
  {1.28588778898119926453e-03f, "12858878", -2},
  {1.29719887734708371266e-15f, "12971989", -14},
  {9.67509800000000000000e+06f, "9675098", 7},
  {1.96262098822574467960e+29f, "1962621", 30},
  {2.88207073211669921875e+01f, "28820707", 2},
  {4.74654717354887429705e+36f, "47465472", 37},
  {1.49806671462400000000e+12f, "14980667", 13},
  {2.74207817728000000000e+11f, "27420782", 12},
  {4.91192246231850867113e+37f, "49119225", 38},
  {2.21944685468214383084e+23f, "22194469", 24},
  {6.53658771554432860285e-09f, "65365877", -8},
  {3.16183853149414062500e+01f, "31618385", 2},
  {4.39830158784678543205e-14f, "43983016", -13},
  {6.81705758720000000000e+10f, "68170576", 11},
  {6.84753576668430336000e+18f, "6847536", 19},
  {2.44365087179847179514e+28f, "24436509", 29},
  {8.34656250000000000000e+02f, "83465625", 3},
  {6.61758500000000000000e+06f, "6617585", 7},
  {2.96830990432918653688e-31f, "296831", -30},
  {1.18519715825321250555e+35f, "11851972", 36},
  {5.34680535523718303281e-14f, "53468054", -13},
  {1.65540012500000000000e+06f, "16554001", 7},
  {1.33012667226718761627e-35f, "13301267", -34},
  {2.87572242620165956567e+22f, "28757224", 23},
  {4.91805343627929687500e+01f, "49180534", 2},
  {1.01940903740166312107e+33f, "1019409", 34},
  {5.29325870957109145820e-06f, "52932587", -5},
  {1.64376826504400391373e+22f, "16437683", 23},
  {3.11870819238356203658e-28f, "31187082", -27},
  {1.40222757999738880000e+16f, "14022276", 17},
  {5.20638503923064435779e-21f, "5206385", -20},
  {6.24467640000000000000e+07f, "62446764", 8},
  {2.39166419216853148106e-38f, "23916642", -37},
  {8.17241202781159686144e+24f, "8172412", 25},
  {1.71819776296615600586e-02f, "17181978", -1},
  {1.16390121459960937500e+02f, "11639012", 3},
  {5.57416020271191681925e+22f, "557416", 23},
  {3.69093580300565810935e-29f, "36909358", -28},
  {4.68835659116556185213e-26f, "46883566", -25},
  {3.84933159167987600589e+21f, "38493316", 22},
  {1.25318488401291745630e+33f, "12531849", 34},
  {5.13924140625000000000e+04f, "51392414", 5},
  {1.78346717806663788378e-16f, "17834672", -15},
  {8.01416198293988312484e-20f, "8014162", -19},
  {5.13645084759768259269e-24f, "5136451", -23},
  {1.64189616418793772989e-36f, "16418962", -35},
  {2.70118652434776309490e-30f, "27011865", -29},
  {6.81713839334490112000e+17f, "68171384", 18},
  {1.79205619200000000000e+09f, "17920562", 10},
  {1.28875246831095949900e-22f, "12887525", -21},
  {1.13238381428736000000e+14f, "11323838", 15},
  {1.60984285244552171685e+34f, "16098429", 35},
  {3.39236839487418044252e+22f, "33923684", 23},
  {2.47048065054146560000e+17f, "24704807", 18},
  {6.18321633874018304000e+17f, "6183216", 18},
  {2.36752230911270802882e-15f, "23675223", -14},
  {3.53187495936000000000e+11f, "3531875", 12},
  {4.71820288158812639713e-27f, "4718203", -26},
  {5.29130385536062352913e-32f, "5291304", -31},
  {1.72762878039535376138e+22f, "17276288", 23},
  {1.00718644152560000292e+28f, "10071864", 29},
  {4.57549037720383910965e-14f, "45754904", -13},
  {1.57417423540806566962e-09f, "15741742", -8},
  {4.09728430428817689445e+28f, "40972843", 29},
  {5.25014473222788093974e-28f, "52501447", -27},
  {4.43158588124323127160e+27f, "4431586", 28},
  {6.90257406787964100658e-09f, "6902574", -8},
  {4.60904821769573678160e+33f, "46090482", 34},
  {2.66278096188769041888e+37f, "2662781", 38},
  {5.46116679687500000000e+04f, "54611668", 5},
  {2.53209689561497600000e+16f, "2532097", 17},
  {4.79829379432603376779e+31f, "4798294", 32},
  {3.89693454879517055085e-30f, "38969345", -29},
  {1.41067315105115009713e-40f, "141067", -39},
  {5.36770002935937791919e-27f, "53677", -26},
  {3.17503333432283315479e-15f, "31750333", -14},
  {1.65995278052139245113e-36f, "16599528", -35},
  {2.38230105046318666758e-18f, "2382301", -17},
  {2.96408139779810374285e-36f, "29640814", -35},
  {4.87141441536000000000e+11f, "48714144", 12},
  {4.97029796242713928223e-02f, "4970298", -1},
  {5.68961060799774720000e+16f, "56896106", 17},
  {1.10933680000000000000e+07f, "11093368", 8},
  {2.40502101355302754047e-18f, "2405021", -17},
  {1.97360914171440526843e-05f, "19736091", -4},
  {9.91242424106713107546e-15f, "9912424", -14},
  {9.01354312500000000000e+05f, "9013543", 6},
  {9.72710628514300880292e-33f, "9727106", -32},
  {7.24712014198303222656e-03f, "724712", -2},
  {7.88306224742400000000e+12f, "7883062", 13},
  {2.78786345637986780432e+28f, "27878635", 29},
  {1.06425732484573265513e-13f, "10642573", -12},
  {5.96454808301314470605e+37f, "5964548", 38},
  {5.95101326898894995460e-20f, "5951013", -19},
  {6.30828202862860205181e-24f, "6308282", -23},
  {4.29678371062850377530e-29f, "42967837", -28},
  {3.72277556272649401246e-31f, "37227756", -30},
  {7.37969700000000000000e+06f, "7379697", 7},
  {2.84550792518723201662e-34f, "2845508", -33},
  {1.40479509510131407643e-32f, "14047951", -31},
  {5.75986183279189287742e-28f, "5759862", -27},
  {1.11156734176600575181e+21f, "111156734", 22},
  {1.12512316699397658394e+38f, "11251232", 39},
  {3.60185121936435138509e-19f, "36018512", -18},
  {1.11865129287362700902e+21f, "11186513", 22},
  {8.01249882922520187165e-28f, "8012499", -27},
  {1.89850656250000000000e+05f, "18985066", 6},
  {3.01974083192152324571e+23f, "30197408", 24},
  {3.23558253967348719016e-07f, "32355825", -6},
  {9.51882560000000000000e+07f, "9518826", 8},
  {2.16126354644075036049e-04f, "21612635", -3},
  {2.46887254005736435179e+30f, "24688725", 31},
  {7.09690027692099281720e-15f, "70969003", -14},
  {3.28894587813292898221e-36f, "3288946", -35},
  {8.62075517242881453813e-27f, "8620755", -26},
  {2.38151953582328381440e+19f, "23815195", 20},
  {5.41327399572466561040e-12f, "5413274", -11},
  {1.21425020161989017600e+18f, "12142502", 19},
  {3.61582470455012247785e+25f, "36158247", 26},
  {6.49556898032701271756e+24f, "6495569", 25},
  {1.37507552011584266438e-08f, "13750755", -7},
  {1.43760420555980800000e+15f, "14376042", 16},
  {9.81883959816317060483e-28f, "981884", -27},
  {1.16215426171351055018e-09f, "11621543", -8},
  {1.42748413355046306224e+34f, "14274841", 35},
  {1.02052101578348208832e-12f, "1020521", -11},
  {7.79994010925292968750e+00f, "779994", 1},
  {7.59712370558644102009e-36f, "7597124", -35},
  {1.22118390188363301019e+33f, "12211839", 34},
  {3.74199343750000000000e+05f, "37419934", 6},
  {1.76956504637192832142e-29f, "1769565", -28},
  {1.00734181248257859777e-33f, "10073418", -32},
  {5.95958016009340285635e-13f, "595958", -12},
  {2.72089138317037113329e-30f, "27208914", -29},
  {5.59528280912741093900e-14f, "55952828", -13},
  {9.51046493911308654810e-31f, "9510465", -30},
  {3.70443350604223226655e-19f, "37044335", -18},
  {1.79640135715190134838e+30f, "17964014", 31},
  {4.88356416808673202200e+31f, "4883564", 32},
  {1.87439482142720000000e+13f, "18743948", 14},
  {2.29440793395042419434e-01f, "2294408", 0},
  {1.43656414888782002492e-11f, "143656415", -10},
  {6.63923671875000000000e+04f, "6639237", 5},
  {2.77014197308542542676e+23f, "2770142", 24},
  {7.95229126993035606574e-09f, "7952291", -8},
  {9.70662265298616320000e+16f, "9706623", 17},
  {9.20904199218750000000e+03f, "9209042", 4},
  {7.17268389500603596800e+18f, "7172684", 19},
  {1.70930012245662510395e-04f, "17093001", -3},
  {4.64145138989735528412e-10f, "46414514", -9},
  {6.22126718750000000000e+04f, "6221267", 5},
  {3.85573069865425952076e+26f, "38557307", 27},
  {9.78632199673667385211e-34f, "9786322", -33},
  {1.00348635958476800000e+16f, "10034864", 17},
  {6.32609698489173489235e-22f, "6326097", -21},
  {1.93363465508055031340e-38f, "19336347", -37},
  {1.48798356757093519099e-35f, "14879836", -34},
  {8.32232033374699520000e+17f, "832232", 18},
  {2.29576055617071206364e-35f, "22957606", -34},
  {2.97135652747716675013e+36f, "29713565", 37},
  {4.15478686823078494951e-16f, "4154787", -15},
  {6.76859728122655177502e-26f, "6768597", -25},
  {4.28912016833869452571e-36f, "428912", -35},
  {4.06020546560000000000e+10f, "40602055", 11},
  {2.86939094501743668323e-17f, "2869391", -16},
  {4.05698599714732210941e-11f, "4056986", -10},
  {6.39765354174952243200e+18f, "63976535", 19},
  {1.78398767089843750000e+03f, "17839877", 4},
  {9.81788746974858010466e-20f, "98178875", -19},
  {4.37375139840000000000e+11f, "43737514", 12},
  {4.78479827083895858556e-23f, "47847983", -22},
  {3.79681733523957350400e+18f, "37968173", 19},
  {6.64812845625304961135e-39f, "6648128", -38},
  {5.37379570268264988672e+20f, "53737957", 21},
  {1.51524682617187500000e+03f, "15152468", 4},
  {1.21660432839121313009e-08f, "12166043", -7},
  {7.29860812425613403320e-02f, "7298608", -1},
  {1.97693949318361204996e-32f, "19769395", -31},
  {1.19980223487412795688e-28f, "11998022", -27},
  {2.03542720229321867489e+33f, "20354272", 34},
  {1.55993376392871141434e-03f, "15599338", -2},
  {1.22363564575948800000e+15f, "12236356", 16},
  {1.07073158546352137830e+21f, "10707316", 22},
  {2.39066802978515625000e+02f, "2390668", 3},
  {1.78948109663679133519e-08f, "17894811", -7},
  {1.11238084457253044025e+38f, "11123808", 39},
  {7.74483947753906250000e+02f, "77448395", 3},
  {4.38558599853422492743e-05f, "4385586", -4},
  {1.26193732658659328000e+17f, "12619373", 18},
  {2.97776125000000000000e+06f, "29777612", 7},
  {1.85342912573105422780e-07f, "18534291", -6},
  {7.62867444497816143338e-38f, "76286744", -37},
  {3.18970830104328929280e+19f, "31897083", 20},
  {1.20854107080958783627e-04f, "12085411", -3},
  {4.95911337984000000000e+11f, "49591134", 12},
  {1.32629720382388075618e-36f, "13262972", -35},
  {8.30558310850497223852e+23f, "8305583", 24},
  {4.43825465268332663982e-09f, "44382547", -8},
  {3.94560000000000000000e+05f, "39456", 6},
  {1.14123305268188533169e-34f, "1141233", -33},
  {2.68207772733715566353e-36f, "26820777", -35},
  {3.09969673765494194176e+21f, "30996967", 22},
  {6.92008482042961461248e+22f, "6920085", 23},
  {4.05681116010244287432e-36f, "4056811", -35},
  {2.32137817382812500000e+03f, "23213782", 4},
  {1.49096243706216269320e-13f, "14909624", -12},
  {7.55693599785445258021e-06f, "7556936", -5},
  {2.44740341697622543771e-37f, "24474034", -36},
  {4.56654646541210240684e-07f, "45665465", -6},
  {1.53253593750000000000e+05f, "1532536", 6},
  {7.76476399002672783229e+34f, "7764764", 35},
  {1.19850072336704614593e+29f, "11985007", 30},
  {2.72360021729835835875e-19f, "27236002", -18},
  {1.21286534954483712000e+17f, "121286535", 18},
  {4.11400193911504175048e-08f, "4114002", -7},
  {8.00960872448000000000e+11f, "8009609", 12},
  {1.79314079301632000000e+16f, "17931408", 17},
  {4.91475286812211412031e+33f, "4914753", 34},
  {4.66909059783619489426e-32f, "46690906", -31},
  {3.32274657921516336501e-06f, "33227466", -5},
  {2.10080184936523437500e+01f, "21008018", 2},
  {1.44877719879150390625e+00f, "14487772", 1},
  {4.16417169617488980293e-05f, "41641717", -4},
  {9.03917227401382930113e-19f, "9039172", -18},
  {2.96760719333546359031e+34f, "29676072", 35},
  {2.88089714689144664095e-32f, "2880897", -31},
  {2.00406023321787133806e-16f, "20040602", -15},
  {3.32575329367359488000e+19f, "33257533", 20},
  {2.12502442300319671631e-02f, "21250244", -1},
  {1.29758293766821353524e+28f, "12975829", 29},
  {6.00841763505329575821e+23f, "60084176", 24},
  {9.14049625396728515625e+00f, "9140496", 1},
  {5.57657374720000000000e+10f, "55765737", 11},
  {6.10606720000000000000e+07f, "6106067", 8},
  {6.10577929687500000000e+03f, "61057793", 4},
  {1.81615994942573206033e-25f, "181616", -24},
  {1.46840006350140871907e+33f, "14684", 34},
  {7.82476284367348010103e+36f, "7824763", 37},
  {6.99956912291327951751e-24f, "6999569", -23},
  {9.51843204949343046906e-13f, "9518432", -12},
  {1.68028820800781250000e+03f, "16802882", 4},
  {7.78326838797191380190e-28f, "77832684", -27},
  {1.65095536547941794453e-22f, "16509554", -21},
  {7.16645694020469401846e+22f, "7166457", 23},
  {1.59469723625103328137e+28f, "15946972", 29},
  {1.04137568000000000000e+09f, "10413757", 10},
  {8.26345640234649181366e-05f, "82634564", -4},
  {4.19697531250000000000e+05f, "41969753", 6},
  {7.50717871093750000000e+03f, "75071787", 4},
  {6.38921142578125000000e+02f, "63892114", 3},
  {2.28515803999052671514e+38f, "2285158", 39},
  {2.20674705001528572452e-34f, "2206747", -33},
  {1.27643277148763444801e-36f, "12764328", -35},
  {1.30280377561575733125e-05f, "13028038", -4},
  {3.37636887307209143660e-14f, "3376369", -13},
  {5.98429643141892022342e+36f, "59842964", 37},
  {6.00397338867187500000e+01f, "60039734", 2},
  {1.07001120000000000000e+09f, "10700112", 10},
  {2.77913967785934848000e+17f, "27791397", 18},
  {2.10338282581658367795e+38f, "21033828", 39},
  {2.03636754304170608521e-02f, "20363675", -1},
  {2.45303573608398437500e+02f, "24530357", 3},
  {2.75763869285583496094e+00f, "27576387", 1},
  {1.51956051287294233794e-30f, "15195605", -29},
  {2.19137229221534497127e-29f, "21913723", -28},
  {2.25031461295322813771e-35f, "22503146", -34},
  {4.67058036844634967858e-17f, "46705804", -16},
  {4.49559807564662582564e-35f, "4495598", -34},
  {2.52244642496101091741e-37f, "25224464", -36},
  {5.43905906379222869873e-02f, "5439059", -1},
  {7.13006054198217498197e-09f, "71300605", -8},
  {6.49484375000000000000e+04f, "64948438", 5},
  {7.16204185600000000000e+09f, "7162042", 10},
  {1.97735520000000000000e+08f, "19773552", 9},
  {6.83581446656034152909e-12f, "68358145", -11},
  {1.59721955657005310059e-01f, "15972196", 0},
  {2.99205449775918158579e-22f, "29920545", -21},
  {9.31552199027025447485e+22f, "9315522", 23},
  {9.04606728627580041274e-35f, "9046067", -34},
  {3.67684956655735275520e+20f, "36768496", 21},
  {8.41732757171469170299e-14f, "84173276", -13},
  {2.94159282194400877777e-35f, "29415928", -34},
  {1.34584746925464108568e+25f, "13458475", 26},
  {1.71343286781144854558e-11f, "17134329", -10},
  {6.02969005703926086426e-02f, "602969", -1},
  {6.37966220008216263561e-28f, "6379662", -27},
  {1.48132049161697754158e-13f, "14813205", -12},
  {1.16035860125712384000e+20f, "11603586", 21},
  {5.92896965652573308662e-35f, "59289697", -34},
  {1.77287082012027788255e+38f, "17728708", 39},
  {3.17782091632720233336e-21f, "3177821", -20},
  {2.40718050000000000000e+06f, "24071805", 7},
  {7.10409581661224365234e-01f, "7104096", 0},
  {8.19512101409014537268e-13f, "8195121", -12},
  {8.48485875397427200000e+15f, "8484859", 16},
  {2.64254956054687500000e+03f, "26425496", 4},
  {6.37751193600000000000e+09f, "6377512", 10},
  {6.46158266622562795520e+19f, "64615827", 20},
  {1.06920015625000000000e+05f, "106920016", 6},
  {4.83326836733249132364e-31f, "48332684", -30},
  {6.72640277540975180412e-28f, "6726403", -27},
  {1.01828625660320293964e-29f, "101828626", -28},
  {5.45597632710443008000e+17f, "54559763", 18},
  {2.10038518781491281920e+19f, "21003852", 20},
  {1.16605730727314949036e-02f, "11660573", -1},
  {1.23952439238154747829e-22f, "12395244", -21},
  {1.03120104205454622695e+36f, "103120104", 37},
  {1.49659141251259127526e-18f, "14965914", -17},
  {1.82057903329552349587e-18f, "1820579", -17},
  {5.18049128358346752000e+17f, "51804913", 18},
  {2.02374240000000000000e+07f, "20237424", 8},
  {9.03371395565141441231e-15f, "9033714", -14},
  {9.73961425781250000000e+03f, "9739614", 4},
  {5.74769221987200920489e+34f, "5747692", 35},
  {9.07361563988567565271e+22f, "9073616", 23},
  {9.95546374340608000000e+14f, "9955464", 15},
  {1.17037619434005375112e-17f, "11703762", -16},
  {7.60584748532935730135e+22f, "76058475", 23},
  {1.63699311087839305401e-04f, "16369931", -3},
  {1.09030724715613452913e-13f, "109030725", -12},
  {1.98079728236809798287e+22f, "19807973", 23},
  {8.56302561525760000000e+13f, "8563026", 14},
  {4.32389292703679513727e+31f, "4323893", 32},
  {2.03926391512249512378e-17f, "20392639", -16},
  {9.58268089687337307239e-38f, "9582681", -37},
  {5.23432768000000000000e+08f, "52343277", 9},
  {8.50963868560533808480e+24f, "85096387", 25},
  {1.03346233344000000000e+11f, "10334623", 12},
  {4.95159364899411258421e-11f, "49515936", -10},
  {1.29567645501538208919e-09f, "12956765", -8},
  {7.97482600598025011200e+18f, "7974826", 19},
  {5.46692514419555664062e+00f, "5466925", 1},
  {2.00952219963073730469e+00f, "20095222", 1},
  {6.33666710928082466125e-03f, "6336667", -2},
  {1.63210631846622827438e-19f, "16321063", -18},
  {3.98054457917426223072e+36f, "39805446", 37},
  {1.26163028541440000000e+14f, "12616303", 15},
  {2.23813899467975708510e-22f, "2238139", -21},
  {8.28579145555481831916e-21f, "82857915", -20},
  {3.82646696690692971696e+34f, "3826467", 35},
  {1.92558948677957616754e+34f, "19255895", 35},
  {2.76411016879793915130e+25f, "27641102", 26},
  {4.83015988678395726701e-19f, "483016", -18},
  {2.60798245668411254883e-01f, "26079825", 0},
  {2.14007972141650988237e+21f, "21400797", 22},
  {6.32977133021101104334e-35f, "63297713", -34},
  {3.74638105061833733604e-25f, "3746381", -24},
  {3.60969347362006539837e-35f, "36096935", -34},
  {8.17825035313563565812e+26f, "817825", 27},
  {9.90130380800000000000e+09f, "9901304", 10},
  {6.60073384839421350989e-10f, "6600734", -9},
  {2.35345817600000000000e+10f, "23534582", 11},
  {1.21639828692612786756e-15f, "12163983", -14},
  {4.11731399829535669403e-17f, "4117314", -16},
  {7.46123966923166711512e+31f, "74612397", 32},
  {1.97324558223136575785e-14f, "19732456", -13},
  {3.63399353706116724566e+30f, "36339935", 31},
  {9.21812406785540096000e+17f, "9218124", 18},
  {3.14434492168814304725e+35f, "3144345", 36},
  {2.46051516498192648394e-19f, "24605152", -18},
  {1.57007902829162129480e-30f, "1570079", -29},
  {3.65174037728460800000e+15f, "36517404", 16},
  {2.21573970257512497152e+20f, "22157397", 21},
  {5.35548256000000000000e+08f, "53554826", 9},
  {3.21536839184327163679e-26f, "32153684", -25},
  {4.73393205295022743043e-38f, "4733932", -37},
  {3.12976300000000000000e+06f, "3129763", 7},
  {6.41729464906880392557e+26f, "6417295", 27},
  {1.80202407160831630155e-21f, "1802024", -20},
  {4.14698861208942370672e+24f, "41469886", 25},
  {3.54960797298411941396e+22f, "3549608", 23},
  {4.95792053138968795065e-26f, "49579205", -25},
  {1.57252943872000000000e+11f, "15725294", 12},
  {2.39887316427097910226e-35f, "23988732", -34},
  {2.15635735347200000000e+12f, "21563574", 13},
  {4.66557452227789326571e-07f, "46655745", -6},
  {2.57868383818981342189e-31f, "25786838", -30},
  {1.37166410263753926164e+26f, "13716641", 27},
  {2.84431991167366504669e-03f, "284432", -2},
  {3.38291775500312724891e+34f, "33829178", 35},
  {1.88036903273314237595e-03f, "1880369", -2},
  {2.89954740894233965466e+26f, "28995474", 27},
  {1.04789900000000000000e+06f, "1047899", 7},
  {3.82228522411770249216e+20f, "38222852", 21},
  {1.71303644462845555984e-29f, "17130364", -28},
  {1.14877894520759582520e-01f, "114877895", 0},
  {1.03759167186595240733e-32f, "10375917", -31},
  {8.41919679492912070657e-38f, "8419197", -37},
  {1.52162685810484372655e-22f, "15216269", -21},
  {4.74267021386212555173e-36f, "47426702", -35},
  {3.33982402765379826355e-18f, "3339824", -17},
  {4.05704997049650961660e-14f, "405705", -13},
  {2.76175660518264012800e+18f, "27617566", 19},
  {1.07334574638237422671e-36f, "107334575", -35},
  {3.69307409970777677936e+33f, "3693074", 34},
  {1.46196257703329032484e+31f, "14619626", 32},
  {8.62766792262517288382e-36f, "8627668", -35},
  {1.53192615509033203125e+01f, "15319262", 2},
  {1.36356154420966195200e+19f, "13635615", 20},
  {2.59730535079557297120e-18f, "25973054", -17},
  {9.26582961291270990056e-14f, "92658296", -13},
  {6.95051879882812500000e+02f, "6950519", 3},
  {2.15949585253838449717e-05f, "21594959", -4},
  {2.35835318075342585994e+36f, "23583532", 37},
  {2.83205500000000000000e+06f, "2832055", 7},
  {6.78638690830707127561e-32f, "6786387", -31},
  {1.61222324379650672199e-09f, "16122232", -8},
  {1.16669766696960000000e+14f, "11666977", 15},
  {1.49184711207298855349e+33f, "14918471", 34},
  {7.34967130874895719274e+26f, "7349671", 27},
  {5.52673331200000000000e+09f, "55267333", 10},
  {4.00384925214325448906e-09f, "40038493", -8},
  {2.98699003527168000000e+14f, "298699", 15},
  {8.50673600285324105347e-24f, "8506736", -23},
  {2.21305663236722359404e-27f, "22130566", -26},
  {8.57369860728099639919e+23f, "85736986", 24},
  {1.58125311131648000000e+14f, "15812531", 15},
  {3.56907310514855795541e-21f, "3569073", -20},
  {1.16923880266154768125e+25f, "11692388", 26},
  {3.95680362949775966081e+30f, "39568036", 31},
  {2.82660519326925383735e-18f, "28266052", -17},
  {5.59224510285051440976e-32f, "5592245", -31},
  {2.10501600324219738265e-22f, "2105016", -21},
  {9.72307755053346222465e-39f, "9723078", -38},
  {9.85106320474971949836e-30f, "9851063", -29},
  {1.13951545167808193399e-27f, "113951545", -26},
  {2.57333980958546918705e+31f, "25733398", 32},
  {1.28890288485710058119e-26f, "12889029", -25},
  {2.91493616025600000000e+12f, "29149362", 13},
  {4.80247676928000000000e+11f, "48024768", 12},
  {5.69048006582306697965e-06f, "569048", -5},
  {4.15914691460185801885e+37f, "4159147", 38},
  {4.56874216677472381560e-25f, "4568742", -24},
  {1.88857399843235967047e+28f, "1888574", 29},
  {1.43710250675609710995e+35f, "14371025", 36},
  {2.14732369104839114752e+20f, "21473237", 21},
  {2.13243926478864578561e+35f, "21324393", 36},
  {3.32184041558492015866e-13f, "33218404", -12},
  {3.39679063472431153059e-05f, "33967906", -4},
  {4.54038347913918741788e+29f, "45403835", 30},
  {3.40873748982726461285e-25f, "34087375", -24},
  {2.69601925248495589733e-34f, "26960193", -33},
  {2.61503927594809733152e-18f, "26150393", -17},
  {1.69306259532010105853e+28f, "16930626", 29},
  {3.65453073366267379821e-19f, "36545307", -18},
  {8.95158393632300430909e-07f, "8951584", -6},
  {1.98432081838080000000e+13f, "19843208", 14},
  {9.39236001678163725912e+33f, "939236", 34},
  {5.30703384576000000000e+11f, "5307034", 12},
  {3.34230095148086547852e-01f, "3342301", 0},
  {5.29833147892608775750e+25f, "52983315", 26},
  {2.53143070355238060623e+32f, "25314307", 33},
  {3.08525150000000000000e+06f, "30852515", 7},
  {1.63429358416244283947e-35f, "16342936", -34},
  {4.50192485593498287225e+32f, "4501925", 33},
  {4.64828150631628800000e+15f, "46482815", 16},
  {2.92552261587878373135e-24f, "29255226", -23},
  {1.60160154541953393927e+25f, "16016015", 26},
  {1.01670177387025819454e+28f, "10167018", 29},
  {1.35421901676703213867e+27f, "1354219", 28},
  {1.09620941802859306335e-02f, "10962094", -1},
  {8.42843376713392760258e-17f, "8428434", -16},
  {8.12050761696634707127e+25f, "8120508", 26},
  {8.28922986496000000000e+11f, "828923", 12},
  {2.30270289348861626129e-27f, "23027029", -26},
  {1.68059600063686340772e+22f, "1680596", 23},
  {2.33994157383676792961e-07f, "23399416", -6},
  {6.73970955577857430764e-31f, "67397096", -30},
  {7.82777900630647792546e-30f, "7827779", -29},
  {1.33195615785330614469e+27f, "13319562", 28},
  {4.85502878219954546172e+37f, "4855029", 38},
  {4.19381285248434276976e-16f, "41938129", -15},
  {5.98655133455820339627e+31f, "59865513", 32},
  {1.78771863722700091443e-19f, "17877186", -18},
  {1.03286544396718601947e-26f, "103286544", -25},
  {3.00151189822334855983e-26f, "3001512", -25},
  {2.68485368217600000000e+13f, "26848537", 14},
  {3.33902923446540236352e+25f, "33390292", 26},
  {3.88525121640279976952e-31f, "38852512", -30},
  {2.07030895112971999317e-14f, "2070309", -13},
  {1.51083860727057109341e-14f, "15108386", -13},
  {3.47791207426972233261e+33f, "3477912", 34},
  {6.89122310392723379408e-21f, "6891223", -20},
  {7.77993028649163170062e+30f, "777993", 31},
  {9.02471963419892182426e+36f, "90247196", 37},
  {4.53730451895771098537e-27f, "45373045", -26},
  {5.25612240000000000000e+07f, "52561224", 8},
  {3.78882589651302853741e-26f, "3788826", -25},
  {1.12744578177672675041e+37f, "11274458", 38},
  {7.77857960201799869537e-04f, "77785796", -3},
  {7.33348812087121006775e-38f, "7333488", -37},
  {1.78636837517842650414e-04f, "17863684", -3},
  {1.02507150199184424960e+19f, "10250715", 20},
  {9.96053639630977921939e+26f, "99605364", 27},
  {1.94374844040530533379e-31f, "19437484", -30},
  {3.89596927332893190611e+30f, "38959693", 31},
  {2.38561689600000000000e+10f, "23856169", 11},
  {7.73632192611694335938e+00f, "7736322", 1},
  {3.00492459678158028800e+19f, "30049246", 20},
  {1.46978141463138811673e-11f, "14697814", -10},
  {2.94944011624982089200e+37f, "294944", 38},
  {1.82686300557724637040e-35f, "1826863", -34},
  {1.28874780794792339396e-18f, "12887478", -17},
  {7.01817270973424904533e-21f, "7018173", -20},
  {2.95397517212220466304e-23f, "29539752", -22},
  {6.28272528047091327608e-06f, "62827253", -5},
  {3.16783294994358585052e+31f, "3167833", 32},
  {1.38593072674703509627e-36f, "13859307", -35},
  {4.13961029052734375000e+02f, "41396103", 3},
  {8.62883169702333348493e-22f, "8628832", -21},
  {3.46585889328399066045e-12f, "3465859", -11},
  {1.91081862431019544601e-03f, "19108186", -2},
  {1.01140397600829601288e-03f, "1011404", -2},
  {3.90230596531045624487e-20f, "3902306", -19},
  {2.52386380452662706375e-05f, "25238638", -4},
  {7.73043392000000000000e+08f, "7730434", 9},
  {3.11386315733022312210e+26f, "3113863", 27},
  {1.50293040000000000000e+08f, "15029304", 9},
  {1.25841740000000000000e+07f, "12584174", 8},
  {3.55092966859490576266e-16f, "35509297", -15},
  {1.80327526400000000000e+09f, "18032753", 10},
  {2.95441194513720306273e-36f, "2954412", -35},
  {5.14759336416990023123e-36f, "51475934", -35},
  {2.51687970012426376343e-03f, "25168797", -2},
  {9.76793389935561328357e-29f, "9767934", -28},
  {3.23809863934436828710e+33f, "32380986", 34},
  {8.26950166552062190183e-32f, "82695017", -31},
  {1.28424271872000000000e+11f, "12842427", 12},
  {1.93760750152646158566e+33f, "19376075", 34},
  {4.04257740044198209489e+26f, "40425774", 27},
  {3.19668968674964801430e+38f, "31966897", 39},
  {7.62415257840162315930e+31f, "76241526", 32},
  {1.15605019990564315343e+30f, "11560502", 31},
  {5.91831443163381663638e-19f, "59183144", -18},
  {7.73542395481095999203e-28f, "7735424", -27},
  {4.78223721882741876720e-32f, "47822372", -31},
  {5.69507831611392000000e+14f, "5695078", 15},
  {3.55589365709738470313e-35f, "35558937", -34},
  {1.12467823784979957423e-29f, "112467824", -28},
  {3.44887337189984818726e-22f, "34488734", -21},
  {5.18950534285046865559e-18f, "51895053", -17},
  {6.59179687500000000000e-03f, "6591797", -2},
  {1.11559988740096000000e+14f, "11155999", 15},
  {8.82821319282917376000e+17f, "8828213", 18},
  {4.06115443036651520000e+16f, "40611544", 17},
  {3.91086368665467432890e-30f, "39108637", -29},
  {8.96469096872687387645e-13f, "8964691", -12},
  {1.85686464843750000000e+04f, "18568646", 5},
  {9.79387147763056640000e+16f, "97938715", 17},
  {1.91012507791182123288e+33f, "19101251", 34},
  {1.07238833264332430200e+27f, "10723883", 28},
  {2.36151132286185894138e-13f, "23615113", -12},
  {9.53754562458902665776e+35f, "9537546", 36},
  {9.14684835473578498474e+29f, "9146848", 30},
  {1.00283877680874755457e+23f, "10028388", 24},
  {1.35071635994229965740e-31f, "13507164", -30},
  {4.08710846321352944019e+24f, "40871085", 25},
  {1.27335552117099083657e+30f, "12733555", 31},
  {2.85603615385164185600e+18f, "28560362", 19},
  {1.09118678543745679360e+19f, "10911868", 20},
  {7.55583016218132480000e+17f, "755583", 18},
  {1.28833625717211136000e+18f, "12883363", 19},
  {1.16830345625600000000e+12f, "11683035", 13},
  {1.21832460800000000000e+09f, "12183246", 10},
  {1.26085163229294130680e+38f, "12608516", 39},
  {1.49435623582041064342e+23f, "14943562", 24},
  {9.67876785733632000000e+15f, "9678768", 16},
  {1.05114945716224000000e+14f, "105114946", 15},
  {9.00492790714319614291e+26f, "9004928", 27},
  {1.79567351404290725485e+25f, "17956735", 26},
  {5.69153632054957170853e+30f, "56915363", 31},
  {6.15500089220498406819e-30f, "6155001", -29},
  {1.71438740605331341963e-16f, "17143874", -15},
  {8.95389750000000000000e+05f, "89538975", 6},
  {9.17343596277748110339e+26f, "9173436", 27},
  {7.89203167576643890405e-39f, "7892032", -38},
  {5.48094466850816000000e+14f, "54809447", 15},
  {1.20222835829180070701e-24f, "12022284", -23},
  {2.95685332031250000000e+04f, "29568533", 5},
  {7.78672344381448056083e-08f, "77867234", -7},
  {3.03697541941721577093e-30f, "30369754", -29},
  {4.58138273984332045075e-08f, "45813827", -7},
  {3.10135671433986048000e+18f, "31013567", 19},
  {4.19070715565853503923e-33f, "4190707", -32},
  {5.49664527978916582973e-17f, "54966453", -16},
  {4.28094757080078125000e+02f, "42809476", 3},
  {8.94260487508074751950e-26f, "8942605", -25},
  {3.29500023802440454314e-31f, "32950002", -30},
  {7.99534575435245642439e-07f, "7995346", -6},
  {3.99230778609223895553e+31f, "39923078", 32},
  {5.73732810896315172088e+26f, "5737328", 27},
  {8.02734004537664991113e-28f, "802734", -27},
  {7.46165207040000000000e+10f, "7461652", 11},
  {9.58198249340057373047e-01f, "95819825", 0},
  {1.65596619426599272448e+20f, "16559662", 21},
  {1.34684794880000000000e+10f, "1346848", 11},
  {2.10294074189797022389e-16f, "21029407", -15},
  {2.33727623708546161652e-03f, "23372762", -2},
  {1.88597687881858662451e-15f, "18859769", -14},
  {2.72425390638999434183e-28f, "2724254", -27},
  {5.84736952863940454266e-17f, "58473695", -16},
  {1.56723358916274817047e-23f, "15672336", -22},
  {2.81802107476369650809e-19f, "2818021", -18},
  {1.67515400000000000000e+06f, "1675154", 7},
  {2.23366606978564069786e+21f, "2233666", 22},
  {3.51364853494684445998e-31f, "35136485", -30},
  {2.66114150000000000000e+06f, "26611415", 7},
  {1.79610494524240493774e-03f, "1796105", -2},
  {6.85582908853914338096e-17f, "6855829", -16},
  {1.08411078052043602977e-28f, "10841108", -27},
  {2.26910819258009926885e+28f, "22691082", 29},
  {3.45691510972301330185e-08f, "3456915", -7},
  {8.24785034179687500000e+02f, "82478503", 3},
  {1.00032872000000000000e+08f, "10003287", 9},
  {2.37486027181148529053e-02f, "23748603", -1},
  {7.69497455061735085336e+24f, "76949746", 25},
  {5.87089771261689323446e-29f, "5870898", -28},
  {3.43504453632000000000e+11f, "34350445", 12},
  {4.09557684088349094723e+32f, "4095577", 33},
  {7.53498828125000000000e+03f, "75349883", 4},
  {1.99560664062500000000e+04f, "19956066", 5},
  {3.29349014805790326784e+20f, "329349", 21},
  {1.02854890304307200000e+15f, "10285489", 16},
  {2.15701412479724772526e-24f, "21570141", -23},
  {4.47677643837999839454e-19f, "44767764", -18},
  {2.37939006183296442032e-04f, "237939", -3},
  {4.52566798612055180968e+24f, "4525668", 25},
  {1.57813554687500000000e+04f, "15781355", 5},
  {9.29649738316011167310e+31f, "9296497", 32},
  {1.22019932257163014657e-29f, "12201993", -28},
  {7.17997735936000000000e+14f, "71799774", 15},
  {7.93597226095958760291e-24f, "7935972", -23},
  {3.17655583369387539694e-14f, "3176556", -13},
  {3.27115355720034883278e+34f, "32711536", 35},
  {2.12128901492125990912e+21f, "2121289", 22},
  {9.95581884143624266927e-32f, "9955819", -31},
  {1.63298952011699936426e-35f, "16329895", -34},
  {7.75422694804239753807e-12f, "7754227", -11},
  {3.02915820312500000000e+04f, "30291582", 5},
  {1.80952041545223707431e-13f, "18095204", -12},
  {1.42423018813133239746e-01f, "14242302", 0},
  {9.51031836393667617813e-07f, "95103184", -6},
  {1.00973980190297292800e+18f, "10097398", 19},
  {1.64596708196184161326e-37f, "16459671", -36},
  {1.39654772621912450310e-37f, "13965477", -36},
  {3.36571165527144912274e-23f, "33657117", -22},
  {2.07598809255299903247e+26f, "20759881", 27},
  {1.33117552565174434224e-27f, "13311755", -26},
  {1.88314428047993718827e+27f, "18831443", 28},
  {1.18326494690090680320e+20f, "118326495", 21},
  {1.67478988216729600000e+15f, "16747899", 16},
  {5.18326039866678911494e-08f, "51832604", -7},
  {5.50240287780761718750e+01f, "5502403", 2},
  {2.44859998943525170034e-09f, "24486", -8},
  {1.74994520000000000000e+07f, "17499452", 8},
  {4.13626239786411465114e+21f, "41362624", 22},
  {9.77801213559340826739e+25f, "9778012", 26},
  {1.14132227224672533339e-07f, "11413223", -6},
  {9.53952154357680381924e-14f, "95395215", -13},
  {1.30018217554744442880e+19f, "13001822", 20},
  {2.36582916259765625000e+02f, "23658292", 3},
  {9.18592677851400177568e-38f, "9185927", -37},
  {1.67078824990159205878e+34f, "16707882", 35},
  {1.21686736429929002119e+27f, "12168674", 28},
  {5.07975681895062827887e+35f, "5079757", 36},
  {5.06461212104458240000e+16f, "5064612", 17},
  {2.05157551113567681789e+34f, "20515755", 35},
  {1.04062792155165624628e-38f, "10406279", -37},
  {5.66780075530068543486e-34f, "56678008", -33},
  {9.12223398685455322266e-01f, "9122234", 0},
  {3.35817148828382316950e-13f, "33581715", -12},
  {1.31959140625000000000e+04f, "13195914", 5},
  {1.47567123972184319695e+32f, "14756712", 33},
  {4.73223628091824655617e-34f, "47322363", -33},
  {3.56809937500000000000e+05f, "35680994", 6},
  {3.38529837559567499945e+33f, "33852984", 34},
  {2.60223906955914550477e-18f, "2602239", -17},
  {1.01488694781437516212e-07f, "101488695", -6},
  {6.01470998488597034247e-33f, "601471", -32},
  {6.44518624883541593590e-30f, "6445186", -29},
  {1.68838004429387879672e-26f, "168838", -25},
  {1.69934029190845379379e+21f, "16993403", 22},
  {5.63358116149902343750e+01f, "5633581", 2},
  {1.44371567558656000000e+14f, "14437157", 15},
  {5.66741324730491956264e-27f, "56674132", -26},
  {1.42274435311096902842e-30f, "14227444", -29},
  {8.67967319209128618240e-04f, "8679673", -3},
  {8.65812661623337995824e+37f, "8658127", 38},
  {2.74938201904296875000e+01f, "2749382", 2},
  {1.37497125905436791276e+22f, "13749713", 23},
  {1.64570117569930854400e+18f, "16457012", 19},
  {9.42903881139607888202e-36f, "9429039", -35},
  {2.12988250788473111314e+23f, "21298825", 24},
  {3.64625820385280000000e+13f, "3646258", 14},
  {1.94283068366399388522e+30f, "19428307", 31},
  {1.43004461429476556800e+20f, "14300446", 21},
  {2.68601096919951487507e-09f, "2686011", -8},
  {5.83463781989846213628e+25f, "5834638", 26},
  {2.69077516914551422976e+20f, "26907752", 21},
  {2.33579878113232553005e-04f, "23357988", -3},
  {7.57532532254072410449e-14f, "7575325", -13},
  {1.28217469493907305955e-31f, "12821747", -30},
  {1.56066912668507348893e-20f, "15606691", -19},
  {9.87988656998239057456e-27f, "98798866", -26},
  {2.47128093750000000000e+05f, "2471281", 6},
  {7.52496636161619095278e-26f, "75249664", -25},
  {3.92504534829640761018e-06f, "39250453", -5},
  {4.22198828457203205779e+36f, "42219883", 37},
  {7.62966710847506847882e-20f, "7629667", -19},
  {4.30165087890625000000e+03f, "4301651", 4},
  {9.56456051205318214558e-29f, "95645605", -28},
  {1.73674353279243470107e-37f, "17367435", -36},
  {3.48728490764174713508e-34f, "3487285", -33},
  {2.32147374251240127988e+24f, "23214737", 25},
  {1.65519041652505578578e-25f, "16551904", -24},
  {8.34544949578008566111e-26f, "83454495", -25},
  {2.94534386827394388623e-18f, "29453439", -17},
  {2.09193955891517574835e-26f, "20919396", -25},
  {3.75095935631360000000e+14f, "37509594", 15},
  {5.55477961373963703322e-35f, "55547796", -34},
  {5.30373951398523019113e+30f, "53037395", 31},
  {5.47429144204410880000e+17f, "54742914", 18},
  {1.93504972895454112461e+27f, "19350497", 28},
  {2.83720312500000000000e+05f, "2837203", 6},
  {1.53749043200000000000e+09f, "15374904", 10},
  {4.02973312000000000000e+08f, "4029733", 9},
  {1.26637898821987545888e+35f, "1266379", 36},
  {1.18415409815497696400e-04f, "11841541", -3},
  {1.54195906043597119606e-10f, "1541959", -9},
  {4.28508144523220835254e-08f, "42850814", -7},
  {1.50263741540872277197e+21f, "15026374", 22},
  {3.17346188239753246307e-03f, "31734619", -2},
  {2.92383219857583753765e-08f, "29238322", -7},
  {3.34864034072369987995e-38f, "33486403", -37},
  {4.95489280000000000000e+09f, "4954893", 10},
  {1.22793304699085360348e+36f, "122793305", 37},
  {3.88753020675630280742e-25f, "38875302", -24},
  {2.84695318630801840331e-35f, "28469532", -34},
  {7.45470408085113863296e+33f, "7454704", 34},
  {4.91073387820506468415e-06f, "4910734", -5},
  {2.06827140000000000000e+07f, "20682714", 8},
  {1.02473352690948281542e-33f, "10247335", -32},
  {1.38445058837532997131e-04f, "13844506", -3},
  {1.14732682444800000000e+12f, "11473268", 13},
  {3.96286072564334758254e+29f, "39628607", 30},
  {3.72576358400000000000e+09f, "37257636", 10},
  {1.60326036888036227070e+25f, "16032604", 26},
  {1.57385126903278858293e-27f, "15738513", -26},
  {1.27834821789899418501e+22f, "12783482", 23},
  {7.96136379241943359375e+00f, "7961364", 1},
  {1.45850631054576551115e-23f, "14585063", -22},
  {9.84797916692480000000e+13f, "9847979", 14},
  {6.40227252409994770926e-21f, "64022725", -20},
  {4.00867135174883074838e-35f, "40086714", -34},
  {4.01639743623624681514e-20f, "40163974", -19},
  {1.63595864776199214500e+27f, "16359586", 28},
  {2.56478570086400000000e+12f, "25647857", 13},
  {6.65805861526861997076e-24f, "6658059", -23},
  {2.80139233115194352837e-16f, "28013923", -15},
  {5.60800048996749517331e-37f, "56080005", -36},
  {4.84516640000000000000e+07f, "48451664", 8},
  {5.91036447377034525209e-34f, "59103645", -33},
  {2.78918683528900146484e-01f, "27891868", 0},
  {2.39239377627828157139e+38f, "23923938", 39},
  {3.01796676769503337171e-33f, "30179668", -32},
  {2.00264289380099446739e-30f, "20026429", -29},
  {4.16616935032320734697e+35f, "41661694", 36},
  {1.99348640619507283050e-19f, "19934864", -18},
  {9.38270852521080339399e-27f, "93827085", -26},
  {4.28322629451481549159e+30f, "42832263", 31},
  {1.58468472307712000000e+14f, "15846847", 15},
  {3.10770386511352299520e+19f, "31077039", 20},
  {6.77650437437042533353e+35f, "6776504", 36},
  {3.18101064182234158810e-29f, "31810106", -28},
  {5.15036973069982195739e-08f, "51503697", -7},
  {3.93068682958848943861e+26f, "3930687", 27},
  {1.84012924620405473280e+19f, "18401292", 20},
  {1.17391125893213708570e-21f, "11739113", -20},
  {1.03650607425008585159e+38f, "10365061", 39},
  {3.45235443115234375000e+02f, "34523544", 3},
  {1.58670907833424281600e+18f, "15867091", 19},
  {2.18445701796807628395e-24f, "2184457", -23},
  {4.62707089709417277795e-23f, "4627071", -22},
  {1.68262727461201732161e+36f, "16826273", 37},
  {1.34546791213045981573e-20f, "13454679", -19},
  {3.00255633192136883736e-04f, "30025563", -3},
  {3.83806127731738599752e+24f, "38380613", 25},
  {5.84077458620353883626e+30f, "58407746", 31},
  {3.39744817152000000000e+11f, "33974482", 12},
  {1.45861950030258458534e-30f, "14586195", -29},
  {5.33103481039010403468e+32f, "5331035", 33},
  {2.27676584532076511759e-20f, "22767658", -19},
  {1.43044160269677714754e-25f, "14304416", -24},
  {2.09620807822830101941e-07f, "20962081", -6},
  {7.35956000361640031180e-21f, "735956", -20},
  {7.27613916195785424932e-20f, "7276139", -19},
  {6.57761611938476562500e+01f, "6577616", 2},
  {4.43299478498906579888e-24f, "44329948", -23},
  {2.36175489425659179688e+00f, "2361755", 1},
  {1.04121558368256000000e+14f, "10412156", 15},
  {2.53723637757755989328e-32f, "25372364", -31},
  {5.40506143709189745436e-25f, "54050614", -24},
  {4.44162742496700957417e-06f, "44416274", -5},
  {2.52499142511659942054e-35f, "25249914", -34},
  {2.78353682368426367383e-15f, "27835368", -14},
  {3.66067242874212513974e+25f, "36606724", 26},
  {1.67192204339936927798e+30f, "1671922", 31},
  {7.52106483020357896437e-35f, "7521065", -34},
  {6.15543139827653151476e-35f, "61554314", -34},
  {2.43598231531426943567e+29f, "24359823", 30},
  {4.00690250000000000000e+06f, "40069025", 7},
  {1.56280469015296013763e+22f, "15628047", 23},
  {7.15577043275282672968e-34f, "71557704", -33},
  {3.13319186581854261084e+22f, "31331919", 23},
  {3.54279293075471728640e+19f, "3542793", 20},
  {1.63718318517750132529e-15f, "16371832", -14},
  {1.27972789450652133053e-20f, "12797279", -19},
  {1.97648296875000000000e+05f, "1976483", 6},
  {1.32030868734544577070e-23f, "13203087", -22},
  {7.12755235740252854507e+29f, "7127552", 30},
  {4.77436701573120000000e+13f, "4774367", 14},
  {1.03368925749163212150e-29f, "103368926", -28},
  {2.27758173135097861615e-29f, "22775817", -28},
  {1.07725237012068003657e+27f, "10772524", 28},
  {3.57471435546875000000e+02f, "35747144", 3},
  {2.75113508363400427470e-11f, "2751135", -10},
  {1.06753177746762500517e-31f, "10675318", -30},
  {3.42845698291004622352e-35f, "3428457", -34},
  {2.01581542968750000000e+04f, "20158154", 5},
  {4.23954640000000000000e+07f, "42395464", 8},
  {5.48727701796552704000e+17f, "5487277", 18},
  {8.65577779200000000000e+10f, "8655778", 11},
  {3.70787718655886596506e+21f, "37078772", 22},
  {3.45130651968476990318e-27f, "34513065", -26},
  {3.68288009814016000000e+14f, "368288", 15},
  {1.40187854668013012834e-32f, "14018785", -31},
  {2.08492180194835193209e+37f, "20849218", 38},
  {8.53192625000000000000e+05f, "8531926", 6},
  {1.71595856183657709343e-28f, "17159586", -27},
  {1.86436657743345083843e-36f, "18643666", -35},
  {2.84340028883889317513e-04f, "28434003", -3},
  {1.16015828398243840000e+17f, "11601583", 18},
  {4.57885023751543259870e+24f, "45788502", 25},
  {3.27168312072753906250e+01f, "3271683", 2},
  {5.07496404647827148438e+00f, "5074964", 1},
  {2.37806546875000000000e+05f, "23780655", 6},
  {9.02199757871337318436e+24f, "90219976", 25},
  {1.06740797731703357440e+19f, "1067408", 20},
  {6.67569147515595606948e-29f, "66756915", -28},
  {1.74998143122909552896e-37f, "17499814", -36},
  {1.10107115520000000000e+10f, "11010712", 11},
  {5.07511182440336478700e+23f, "5075112", 24},
  {3.02689453785100458378e-28f, "30268945", -27},
  {4.00774627152258662400e+19f, "40077463", 20},
  {7.80438142976000000000e+11f, "78043814", 12},
  {1.66705171005440000000e+13f, "16670517", 14},
  {1.55947343613985841955e-30f, "15594734", -29},
  {1.38554836827913584640e+19f, "13855484", 20},
  {9.50687403197071360000e+16f, "9506874", 17},
  {5.30942525440000000000e+12f, "5309425", 13},
  {8.02946467995391266470e-13f, "80294647", -12},
  {7.46536534279584884644e-05f, "7465365", -4},
  {6.51392265119316894728e-16f, "65139227", -15},
  {4.21581475696420318024e-30f, "42158148", -29},
  {4.33272680000000000000e+07f, "43327268", 8},
  {3.77548992514158393403e+37f, "377549", 38},
  {9.75003758746673157165e-24f, "97500376", -23},
  {1.31271675000000000000e+06f, "13127168", 7},
  {4.59591757812500000000e+04f, "45959176", 5},
  {2.66660906680579734562e-13f, "2666609", -12},
  {4.00234144000000000000e+08f, "40023414", 9},
  {1.84225766378008618198e-38f, "18422577", -37},
  {4.29200739024212412129e-35f, "42920074", -34},
  {2.64121331383648794144e-06f, "26412133", -5},
  {1.01735717773437500000e+02f, "10173572", 3},
  {3.44578828125000000000e+04f, "34457883", 5},
  {1.02006150219163715024e+38f, "10200615", 39},
  {1.32361125098484633256e-12f, "13236113", -11},
  {5.36840429305151774567e-16f, "53684043", -15},
  {9.60096389819419281877e-30f, "9600964", -29},
  {3.83072046306054403431e-11f, "38307205", -10},
  {9.67501902069417304796e+32f, "9675019", 33},
  {7.79199616406242664544e+32f, "7791996", 33},
  {1.81507110595703125000e+00f, "18150711", 1},
  {5.54848579747840000000e+13f, "5548486", 14},
  {8.49428312500000000000e+05f, "8494283", 6},
  {4.42099468220265034360e-26f, "44209947", -25},
  {1.46756222746335683543e+22f, "14675622", 23},
  {1.59498438491011834683e-14f, "15949844", -13},
  {6.52607624994829935093e+29f, "6526076", 30},
  {1.07486906927078962326e-04f, "10748691", -3},
  {2.07595320115200000000e+12f, "20759532", 13},
  {7.12110966439964687691e-14f, "712111", -13},
  {1.13251061055346442240e+19f, "11325106", 20},
  {1.44517809882542794342e+21f, "14451781", 22},
  {5.01060563690895165096e+32f, "50106056", 33},
  {5.78246290467454976000e+17f, "5782463", 18},
  {2.25636118258556309287e+36f, "22563612", 37},
  {8.97958159446716308594e-01f, "89795816", 0},
  {3.90149066507945101005e-17f, "39014907", -16},
  {8.30573191265017961304e-16f, "8305732", -15},
  {5.07594400388460896160e-31f, "5075944", -30},
  {1.09516820512779342826e-16f, "10951682", -15},
  {6.01399615871023307534e-12f, "6013996", -11},
  {2.13972640991210937500e+02f, "21397264", 3},
  {1.88894688137823423719e+24f, "18889469", 25},
  {3.45751357877316798704e+31f, "34575136", 32},
  {2.99318046569824218750e+01f, "29931805", 2},
  {3.28877421019002004997e-27f, "32887742", -26},
  {2.53255305477865662040e-23f, "2532553", -22},
  {4.78312038400000000000e+10f, "47831204", 11},
  {2.13448295593261718750e+01f, "2134483", 2},
  {3.54473906278033065676e-29f, "3544739", -28},
  {5.21869179687500000000e+04f, "52186918", 5},
  {5.40315016055783031899e-38f, "540315", -37},
  {2.99389017006041659867e+23f, "29938902", 24},
  {6.12294536814506603257e-29f, "61229454", -28},
  {3.84517478564078939419e-25f, "38451748", -24},
  {6.43839250000000000000e+06f, "64383925", 7},
  {1.62981552421115338802e-04f, "16298155", -3},
  {3.63816993906310551074e-34f, "363817", -33},
  {9.75075667042406888735e-37f, "9750757", -36},
  {4.82472581478619559586e-31f, "4824726", -30},
  {4.25355395350379694719e-09f, "4253554", -8},
  {1.79918439195981591347e+21f, "17991844", 22},
  {1.14669050731552737958e+29f, "11466905", 30},
  {2.99461214018411497895e-15f, "29946121", -14},
  {1.52706587314605712891e+00f, "15270659", 1},
  {3.54305986234440851764e+26f, "354306", 27},
  {4.47826345673082015842e+23f, "44782635", 24},
  {9.12704060377527431987e+21f, "91270406", 22},
  {4.09999285094943439895e-28f, "4099993", -27},
  {3.58722358209257216385e+31f, "35872236", 32},
  {1.46802521173853339546e-33f, "14680252", -32},
  {4.17055934667587280273e-01f, "41705593", 0},
  {1.09886095742695033550e-05f, "1098861", -4},
  {4.65261372981379288775e+29f, "46526137", 30},
  {2.04579482243616439519e-08f, "20457948", -7},
  {5.44583391104469350696e+34f, "5445834", 35},
  {2.23578250664400250965e-36f, "22357825", -35},
  {8.63323760000000000000e+07f, "86332376", 8},
  {3.57167650000000000000e+06f, "35716765", 7},
  {7.45465527343750000000e+03f, "74546553", 4},
  {4.87302007242096640000e+17f, "487302", 18},
  {2.61669890419823086519e-28f, "2616699", -27},
  {6.45237031250000000000e+04f, "64523703", 5},
  {2.13997940063476562500e+02f, "21399794", 3},
  {2.61683177633549974249e-18f, "26168318", -17},
  {4.21627909709076889600e+18f, "4216279", 19},
  {1.90413872415124035302e-30f, "19041387", -29},
  {6.64243364073308160000e+16f, "66424336", 17},
  {2.59551147479841764278e+23f, "25955115", 24},
  {3.03526246271812407516e-28f, "30352625", -27},
  {5.15901417369165327919e+24f, "5159014", 25},
  {1.53803490855364657528e-24f, "15380349", -23},
  {8.33167012791682288772e+31f, "833167", 32},
  {8.52410952056832000000e+14f, "85241095", 15},
  {7.72593438625335693359e-01f, "77259344", 0},
  {1.85254037887716549449e-07f, "18525404", -6},
  {4.24706665039062500000e+02f, "42470667", 3},
  {4.56044074048932200974e-16f, "4560441", -15},
  {2.45962077360957524331e-24f, "24596208", -23},
  {2.94514212208640000000e+13f, "29451421", 14},
  {2.37640103626159717337e-23f, "2376401", -22},
  {6.03837866357012291210e-19f, "60383787", -18},
  {1.73493809106707804015e-26f, "17349381", -25},
  {4.24637194240000000000e+10f, "4246372", 11},
  {3.75717178379991630380e-28f, "37571718", -27},
  {5.62054101562500000000e+04f, "5620541", 5},
  {3.24407150000000000000e+06f, "32440715", 7},
  {1.39213846144377091932e-25f, "13921385", -24},
  {6.47337101782824573817e-27f, "6473371", -26},
  {1.61558959908296099315e-26f, "16155896", -25},
  {1.68092770718711808000e+17f, "16809277", 18},
  {5.36334801937296871184e+29f, "5363348", 30},
  {6.86441323806397368096e-16f, "6864413", -15},
  {1.57580206253454669480e-17f, "1575802", -16},
  {1.62629262945301888976e-07f, "16262926", -6},
  {2.76359906250000000000e+05f, "2763599", 6},
  {9.23470541753776292800e-38f, "92347054", -37},
  {5.02759819030761718750e+01f, "5027598", 2},
  {2.63383075151377073772e-17f, "26338308", -16},
  {4.06578719759845886735e+24f, "40657872", 25},
  {2.36200080179200000000e+12f, "23620008", 13},
  {1.93737749612271869995e-31f, "19373775", -30},
  {6.35872248831143811615e-39f, "6358722", -38},
  {2.88639250000000000000e+05f, "28863925", 6},
  {2.79360131361639088783e+22f, "27936013", 23},
  {1.08612728118896484375e+00f, "10861273", 1},
  {8.79999370491696188654e+36f, "8799994", 37},
  {1.61709685762454966063e-14f, "16170969", -13},
  {8.40994718439784988017e+22f, "8409947", 23},
  {2.95159888148702675155e-26f, "2951599", -25},
  {7.70760923726664761903e+37f, "7707609", 38},
  {3.24732330255649215389e+38f, "32473233", 39},
  {2.92625395559298340231e-06f, "2926254", -5},
  {1.86502337286096171282e-27f, "18650234", -26},
  {1.96617093120000000000e+10f, "1966171", 11},
  {1.82801031250000000000e+05f, "18280103", 6},
  {1.68402790048071680000e+16f, "16840279", 17},
  {8.95396381144492196690e-23f, "8953964", -22},
  {4.01459925262060748800e+18f, "40145993", 19},
  {1.85329756662783720550e+28f, "18532976", 29},
  {2.26003799008722694452e-10f, "2260038", -9},
  {9.31363669224083423615e-04f, "93136367", -3},
  {1.44228316827237744640e+19f, "14422832", 20},
  {2.61611008819200000000e+13f, "261611", 14},
  {2.40480482814957977600e+18f, "24048048", 19},
  {3.11478685457204379534e-27f, "31147869", -26},
  {1.04443620770709921915e-20f, "10444362", -19},
  {3.71488827083189125120e+19f, "37148883", 20},
  {2.63721666478080000000e+13f, "26372167", 14},
  {4.60541076660156250000e+01f, "46054108", 2},
  {2.21314109375000000000e+05f, "22131411", 6},
  {8.94259370872417524989e-14f, "8942594", -13},
  {1.50745318400000000000e+09f, "15074532", 10},
  {3.22288500000000000000e+05f, "3222885", 6},
  {4.24477640882197221068e+30f, "42447764", 31},
  {5.61131656695579295047e-08f, "56113166", -7},
  {5.06735410830333386619e-34f, "5067354", -33},
  {5.26615359468516087756e+28f, "52661536", 29},
  {1.47109347216850944000e+17f, "14710935", 18},
  {7.07412210991722893258e+27f, "7074122", 28},
  {2.21362862812551459847e-36f, "22136286", -35},
  {1.65086334413701120000e+16f, "16508633", 17},
  {3.31077853475523413853e+27f, "33107785", 28},
  {9.81844146735966205597e-04f, "9818441", -3},
  {4.92011853081886340055e+27f, "49201185", 28},
  {9.26046818494796752930e-02f, "9260468", -1},
  {2.63323823832887967036e-37f, "26332382", -36},
  {1.21691617187500000000e+05f, "12169162", 6},
  {1.32071532842188800000e+15f, "13207153", 16},
  {1.68400250932125761536e+20f, "16840025", 21},
  {3.29631620843429118395e-06f, "32963162", -5},
  {4.29246915059624352085e-34f, "4292469", -33},
  {2.22040641127234742261e-22f, "22204064", -21},
  {6.67920208433270942783e-26f, "6679202", -25},
  {1.84637510446900838400e+18f, "18463751", 19},
  {9.06762061462020202050e+34f, "9067621", 35},
  {3.46717927534722497596e-14f, "34671793", -13},
  {3.03805935132322601006e+36f, "30380594", 37},
  {4.94674307868262400000e+15f, "4946743", 16},
  {1.46235443075582812297e+38f, "14623544", 39},
  {1.97747737169265747070e-01f, "19774774", 0},
  {1.54988035212721213152e-18f, "15498804", -17},
  {1.83630830674760478494e-14f, "18363083", -13},
  {3.91651113767421686122e-31f, "39165111", -30},
  {7.86342180117148284874e+25f, "7863422", 26},
  {1.04103329400262627129e-22f, "10410333", -21},
  {3.73750495910644531250e+00f, "3737505", 1},
  {6.75345313372160313171e+30f, "6753453", 31},
  {7.98610952013095080419e-33f, "79861095", -32},
  {8.00246553598728394104e-22f, "80024655", -21},
  {6.49506675353326714880e+19f, "64950668", 20},
  {2.78788007907683939066e-30f, "278788", -29},
  {2.23574493397769721609e+33f, "2235745", 34},
  {2.94662720000000000000e+08f, "29466272", 9},
  {4.64633812500000000000e+05f, "4646338", 6},
  {1.61464821503340765512e+22f, "16146482", 23},
  {3.89347003780487903932e-32f, "389347", -31},
  {1.96714020000000000000e+07f, "19671402", 8},
  {2.84934142252835087561e-12f, "28493414", -11},
  {8.27552194128024436736e+21f, "8275522", 22},
  {4.77896324943549721809e-12f, "47789632", -11},
  {1.52846598148415763251e+21f, "1528466", 22},
  {5.77746232110944011814e+26f, "57774623", 27},
  {1.78544796875000000000e+05f, "1785448", 6},
  {1.64762651556056652237e+34f, "16476265", 35},
  {1.53959675000000000000e+06f, "15395968", 7},
  {2.32586212158203125000e+01f, "23258621", 2},
  {7.83449641518880484270e-19f, "78344964", -18},
  {6.59892187500000000000e+03f, "6598922", 4},
  {1.64330896827954688594e-22f, "1643309", -21},
  {1.65395177070284160104e-19f, "16539518", -18},
  {1.79509732269564133062e-36f, "17950973", -35},
  {4.18422445654869079590e-02f, "41842245", -1},
  {4.76496125000000000000e+05f, "47649612", 6},
  {1.19043920607886788558e-28f, "11904392", -27},
  {4.81490500207491962936e-15f, "4814905", -14},
  {8.42538541133048525619e+21f, "84253854", 22},
  {7.19978332160000000000e+10f, "7199783", 11},
  {4.46587285091077660680e-23f, "4465873", -22},
  {1.06954564510937988319e+28f, "10695456", 29},
  {9.59272366717108008651e+27f, "95927237", 28},
  {4.81064410390167688866e+35f, "4810644", 36},
  {4.91015237840287998301e+36f, "49101524", 37},
  {3.13487756315906738749e+22f, "31348776", 23},
  {2.02552734375000000000e+05f, "20255273", 6},
  {3.31659545898437500000e+03f, "33165955", 4},
  {7.17837187500000000000e+05f, "7178372", 6},
  {1.23665802854400000000e+12f, "1236658", 13},
  {9.04697646914883444625e-29f, "90469765", -28},
  {3.14070320384045003429e+32f, "31407032", 33},
  {1.43214710988104343414e-05f, "14321471", -4},
  {6.90981075167655944824e-02f, "6909811", -1},
  {6.92579851042816000000e+14f, "69257985", 15},
  {1.21010328033719926656e-17f, "12101033", -16},
  {1.76674992917259201996e-35f, "176675", -34},
  {1.56068423680000000000e+10f, "15606842", 11},
  {3.00130296966685480909e+27f, "3001303", 28},
  {6.29611640625000000000e+04f, "62961164", 5},
  {2.05788823404135934316e+30f, "20578882", 31},
  {2.71690119291179144057e-08f, "27169012", -7},
  {1.73958248785379957146e+21f, "17395825", 22},
  {4.64032501539191193456e-28f, "4640325", -27},
  {7.75396983954124152660e-06f, "775397", -5},
  {9.82523322132896312464e-20f, "9825233", -19},
  {3.54267070285742080000e+16f, "35426707", 17},
  {1.56668031250000000000e+05f, "15666803", 6},
  {7.65271015625000000000e+04f, "765271", 5},
  {4.37680512666702270508e-01f, "4376805", 0},
  {1.64508169650575954367e-23f, "16450817", -22},
  {5.47461018771622199296e+20f, "54746102", 21},
  {6.66000110963183011847e-12f, "6660001", -11},
  {2.27302840101235430155e-34f, "22730284", -33},
  {3.75426011921121280000e+17f, "375426", 18},
  {4.76825678008725717394e-14f, "47682568", -13},
  {1.13878982290685956270e+27f, "11387898", 28},
  {1.02577688380855699176e-16f, "10257769", -15},
  {2.56919616533718203056e+28f, "25691962", 29},
  {1.15297314096096670255e-06f, "11529731", -5},
  {2.04847459513127086884e+34f, "20484746", 35},
  {5.20498303745869916881e-13f, "5204983", -12},
  {4.30679242269249584751e-10f, "43067924", -9},
  {3.73318940401077270508e-02f, "37331894", -1},
  {5.17163659659225572137e-37f, "51716366", -36},
  {8.76143575040000000000e+11f, "8761436", 12},
  {1.06392257690429687500e+02f, "10639226", 3},
  {1.31032363827200000000e+12f, "13103236", 13},
  {3.61182498931884765625e+00f, "3611825", 1},
  {9.76092893103601233417e-33f, "9760929", -32},
  {3.71736572265625000000e+03f, "37173657", 4},
  {1.65219902311526641031e+31f, "1652199", 32},
  {2.61771104322145711544e+27f, "2617711", 28},
  {2.76409683542016000000e+14f, "27640968", 15},
  {1.87074233057651917456e-13f, "18707423", -12},
  {3.68737390465938967295e-31f, "3687374", -30},
  {1.43839882227325688291e-08f, "14383988", -7},
  {4.66699405355383635361e+30f, "4666994", 31},
  {4.56267241881600000000e+12f, "45626724", 13},
  {1.06565579405850829347e+30f, "10656558", 31},
  {1.06870268739047908576e-31f, "10687027", -30},
  {3.60927901965624187142e-06f, "3609279", -5},
  {1.02456804025191440716e-20f, "1024568", -19},
  {4.08425954404774619182e-27f, "40842595", -26},
  {1.93033955358790486827e-27f, "19303396", -26},
  {7.79666640625000000000e+04f, "77966664", 5},
  {1.22053096242691566877e-39f, "1220531", -38},
  {3.18206111842300742865e-05f, "3182061", -4},
  {2.83582585325348190963e-06f, "28358259", -5},
  {1.25199449030333198607e-06f, "12519945", -5},
  {9.45578393363177838182e-10f, "9455784", -9},
  {1.50283858602051623166e-06f, "15028386", -5},
  {1.07537083843748036608e+20f, "10753708", 21},
  {6.88085811583149670400e+19f, "6880858", 20},
  {8.97730421543693328625e+30f, "8977304", 31},
  {8.65258469418193230234e+21f, "86525847", 22},
  {8.69486527221852156799e-08f, "8694865", -7},
  {1.36646292503428412601e-06f, "13664629", -5},
  {1.56248243001755326986e-05f, "15624824", -4},
  {5.13010621332467749982e+31f, "5130106", 32},
  {2.03328299522399902344e+00f, "2033283", 1},
  {9.77837848085381150679e+36f, "97783785", 37},
  {1.14476991722371234031e+24f, "11447699", 25},
  {7.81384418974129246749e-12f, "7813844", -11},
  {3.96509734502400000000e+12f, "39650973", 13},
  {3.10876389385696159266e-28f, "3108764", -27},
  {4.74523258162662386894e-04f, "47452326", -3},
  {8.34747983274862015341e-35f, "834748", -34},
  {2.07667912384611363781e-36f, "20766791", -35},
  {3.12559151866694893436e-30f, "31255915", -29},
  {1.46943259833967567262e+34f, "14694326", 35},
  {3.69561340535808860843e-29f, "36956134", -28},
  {1.91834179687500000000e+03f, "19183418", 4},
  {1.99247935968732837601e-25f, "19924794", -24},
  {2.39808229170268772312e-17f, "23980823", -16},
  {6.01344880672768000000e+14f, "6013449", 15},
  {2.57489955184443392000e+18f, "25748996", 19},
  {2.54217715440942514408e-17f, "25421772", -16},
  {2.80430807342336638092e-29f, "2804308", -28},
  {1.03622087615349523727e-26f, "10362209", -25},
  {5.15501409592934400000e+15f, "5155014", 16},
  {4.50483179092407226562e+00f, "4504832", 1},
  {2.47320200000000000000e+06f, "2473202", 7},
  {7.82247225288301706314e-04f, "7822472", -3},
  {4.31787504270856177819e-19f, "4317875", -18},
  {3.04652471095323562622e-02f, "30465247", -1},
  {9.71918398159697668809e-21f, "9719184", -20},
  {6.37727617843200000000e+12f, "6377276", 13},
  {7.01069622763703142259e+30f, "7010696", 31},
  {2.56544562216960000000e+13f, "25654456", 14},
  {4.49496625000000000000e+05f, "44949662", 6},
  {2.08505621657195661101e-08f, "20850562", -7},
  {3.56625383424000000000e+11f, "35662538", 12},
  {7.49042494696539051802e-10f, "7490425", -9},
  {2.71754524262976716800e+19f, "27175452", 20},
  {1.95490397314316850103e-15f, "1954904", -14},
  {3.67341423034667968750e+01f, "36734142", 2},
  {1.87516086812251984684e-23f, "18751609", -22},
  {2.66913678659275177552e-11f, "26691368", -10},
  {1.25184570312500000000e+04f, "12518457", 5},
  {9.93275133773533977499e-15f, "9932751", -14},
  {5.54769152183209922694e-16f, "55476915", -15},
  {7.00913245224960000000e+13f, "70091325", 14},
  {3.14756469467010381936e+27f, "31475647", 28},
  {1.83787010610103607178e-02f, "18378701", -1},
  {2.85803236676856372632e+35f, "28580324", 36},
  {2.74328442382812500000e+03f, "27432844", 4},
  {6.84466965774152999302e-23f, "68446697", -22},
  {1.05164043385455324455e-20f, "10516404", -19},
  {1.27578113310720000000e+13f, "12757811", 14},
  {1.10384756890624657899e-10f, "11038476", -9},
  {8.80920174556541424496e+33f, "8809202", 34},
  {8.15084737122337731136e-26f, "81508474", -25},
  {4.46832625028799867862e+34f, "44683263", 35},
  {9.67556879061248764629e-09f, "9675569", -8},
  {5.98095539317000657320e-06f, "59809554", -5},
  {1.95595976038021035492e-06f, "19559598", -5},
  {1.48857671680000000000e+10f, "14885767", 11},
  {5.01861620233992173989e-32f, "5018616", -31},
  {2.00103368391216923650e-14f, "20010337", -13},
  {5.29007227427621615212e-16f, "52900723", -15},
  {3.81000561459200000000e+12f, "38100056", 13},
  {6.51169999020359680000e+16f, "65117", 17},
  {3.09173024172644367188e+34f, "30917302", 35},
  {4.03586585106269040218e-36f, "4035866", -35},
  {2.50106258317828178406e-03f, "25010626", -2},
  {8.61467507437292094816e-20f, "8614675", -19},
  {2.43972246093750000000e+04f, "24397225", 5},
  {7.46513707827200000000e+12f, "7465137", 13},
  {3.82075968000000000000e+08f, "38207597", 9},
  {4.01222694068427244384e-31f, "4012227", -30},
  {1.16470799087525548520e+37f, "1164708", 38},
  {3.39238100774528237977e+31f, "3392381", 32},
  {4.76645278257192842035e+21f, "4766453", 22},
  {5.28669019990977150221e+25f, "528669", 26},
  {8.60919169287654995060e-10f, "86091917", -9},
  {1.99392159345724620800e+18f, "19939216", 19},
  {1.98612890023319721422e-10f, "19861289", -9},
  {9.57753700000000000000e+06f, "9577537", 7},
  {3.40654224618611813189e+36f, "34065422", 37},
  {3.48011617141446924236e-36f, "3480116", -35},
  {1.72488464505511289150e+35f, "17248846", 36},
  {4.01183894984876898155e+31f, "4011839", 32},
  {4.58739876662624600585e-23f, "45873988", -22},
  {1.12956552150828095814e+31f, "11295655", 32},
  {5.66934133492557777376e-16f, "56693413", -15},
  {4.47000207360000000000e+10f, "4470002", 11},
  {3.23815308605774482276e-14f, "3238153", -13},
  {1.31047543371975311471e+33f, "13104754", 34},
  {3.80129241628409856000e+17f, "38012924", 18},
  {1.06338312192000000000e+11f, "10633831", 12},
  {1.01709338501308592878e-21f, "10170934", -20},
  {1.95843763428626971290e-09f, "19584376", -8},
  {9.85736492431499300437e-12f, "9857365", -11},
  {4.36696017538533985060e-26f, "43669602", -25},
  {1.32806269448337843642e-06f, "13280627", -5},
  {3.95398551699297139897e+24f, "39539855", 25},
  {6.09642484050709754229e-07f, "6096425", -6},
  {5.00231881676837374399e+36f, "50023188", 37},
  {4.16470542550086975098e-02f, "41647054", -1},
  {3.20083720810832976655e-37f, "32008372", -36},
  {2.92569339989136085806e-33f, "29256934", -32},
  {6.97261653840541839600e-04f, "69726165", -3},
  {1.78411206646286416125e+33f, "1784112", 34},
  {2.36226112158453760337e+27f, "23622611", 28},
  {4.98093059334236515313e-17f, "49809306", -16},
  {2.17291056025040174582e-15f, "21729106", -14},
  {6.86888850000000000000e+06f, "68688885", 7},
  {1.64997234688000000000e+12f, "16499723", 13},
  {3.46061332502095087697e+30f, "34606133", 31},
  {3.14420332031250000000e+04f, "31442033", 5},
  {9.32868977065984000000e+14f, "932869", 15},
  {8.68475883830226368124e+26f, "8684759", 27},
  {1.85259641148149967194e-03f, "18525964", -2},
  {7.04904214570938784538e+30f, "7049042", 31},
  {1.39912656722403000320e+19f, "13991266", 20},
  {1.73204747309599948800e+20f, "17320475", 21},
  {4.32926788330078125000e+02f, "4329268", 3},
  {6.37968105251362432960e-34f, "6379681", -33},
  {3.33050923712512000000e+14f, "33305092", 15},
  {2.18999841184958850111e-19f, "21899984", -18},
  {1.08418396323840000000e+16f, "1084184", 17},
  {5.61419782998394699780e+31f, "5614198", 32},
  {7.29379389440000000000e+10f, "7293794", 11},
  {1.50075398207792505389e-34f, "1500754", -33},
  {3.30764604462007747409e-33f, "3307646", -32},
  {1.40011398731452682990e-34f, "1400114", -33},
  {9.45827482386556742201e+28f, "9458275", 29},
  {3.37976396083831787109e-01f, "3379764", 0},
  {1.00481234149415096683e-36f, "10048123", -35},
  {5.55340322339059611068e-12f, "55534032", -11},
  {1.68602008819580078125e+01f, "168602", 2},
  {4.86927658048461996350e-31f, "48692766", -30},
  {5.90711294445928344191e+23f, "5907113", 24},
  {4.35849760833662003279e-05f, "43584976", -4},
  {1.89868191919127857038e+35f, "1898682", 36},
  {4.31178821658101550006e-32f, "43117882", -31},
  {1.52317753726274109440e+19f, "15231775", 20},
  {1.82312792968750000000e+03f, "18231279", 4},
  {1.15265432328129740800e+19f, "11526543", 20},
  {6.98467368960000000000e+10f, "6984674", 11},
  {8.37902306193390984010e-32f, "8379023", -31},
  {1.45478707054280675948e-05f, "14547871", -4},
  {8.87188911437988281250e-02f, "8871889", -1},
  {2.61574921875000000000e+04f, "26157492", 5},
  {1.47451481905501446956e-13f, "14745148", -12},
  {1.64022716009099978885e-21f, "16402272", -20},
  {6.28904090941130936021e-15f, "6289041", -14},
  {9.84467962790648641983e+27f, "98446796", 28},
  {1.76825036351811238668e-16f, "17682504", -15},
  {3.32360970438184285321e+38f, "33236097", 39},
  {3.15240783619338761482e-30f, "31524078", -29},
  {3.05638976915011624144e+38f, "30563898", 39},
  {2.71266851029605519943e+31f, "27126685", 32},
  {3.90872689315298672640e+19f, "3908727", 20},
  {6.52339671633866872635e-35f, "6523397", -34},
  {1.50026397830986940538e+37f, "1500264", 38},
  {9.14808698317988907975e+23f, "9148087", 24},
  {1.00513690405999442721e+33f, "10051369", 34},
  {6.88573066145181655884e-03f, "68857307", -2},
  {1.43063216378192400545e+26f, "14306322", 27},
  {7.46046602170763955382e-18f, "7460466", -17},
  {1.93164433668199566530e+37f, "19316443", 38},
  {1.12523005529258782824e+34f, "112523", 35},
  {6.34580780526223774519e-33f, "6345808", -32},
  {1.18704042506578844041e-06f, "11870404", -5},
  {3.10900117939494972905e+30f, "31090012", 31},
  {4.59792324099449700933e-26f, "45979232", -25},
  {2.45069655042618130978e-26f, "24506966", -25},
  {7.68038262322079390287e-06f, "7680383", -5},
  {8.34374294472182242051e+31f, "8343743", 32},
  {2.89014632990822042173e+23f, "28901463", 24},
  {1.09193664550781250000e+02f, "109193665", 3},
  {1.76011256351055189739e-12f, "17601126", -11},
  {3.69715554708292679564e-17f, "36971555", -16},
  {4.01418537304745991595e-33f, "40141854", -32},
  {4.33563358986240000000e+13f, "43356336", 14},
  {1.01478328704833984375e+01f, "10147833", 2},
  {3.99680910589950144640e-09f, "3996809", -8},
  {6.24833740234375000000e+02f, "62483374", 3},
  {2.81253201450605767295e+23f, "2812532", 24},
  {1.91168392227325512067e-09f, "1911684", -8},
  {3.34926151680000000000e+11f, "33492615", 12},
  {1.25241845031043277521e+23f, "125241845", 24},
  {7.57048005056045717094e-17f, "757048", -16},
  {1.90424458423876785673e-08f, "19042446", -7},
  {1.25331340822245722554e+27f, "12533134", 28},
  {1.53923567501699692575e-18f, "15392357", -17},
  {2.37082000312933955905e-23f, "237082", -22},
  {1.84299456470994596659e+21f, "18429946", 22},
  {1.77246112248653414400e+18f, "17724611", 19},
  {4.93636849441485864026e-36f, "49363685", -35},
  {1.96955656902864487434e-35f, "19695566", -34},
  {4.87784718616494080000e+16f, "4877847", 17},
  {9.16607408497977145659e+36f, "9166074", 37},
  {2.10267373908986772931e-29f, "21026737", -28},
  {8.07074966372878753784e-29f, "80707497", -28},
  {3.86283179492152690111e+28f, "38628318", 29},
  {1.60387832614749506650e-16f, "16038783", -15},
  {3.31892575615517679798e-16f, "33189258", -15},
  {4.34522396227298920990e-16f, "4345224", -15},
  {1.94961955570015862072e-23f, "19496196", -22},
  {1.38765532952140938450e-31f, "13876553", -30},
  {8.04209327492061882378e+24f, "8042093", 25},
  {5.76862255859375000000e+03f, "57686226", 4},
  {8.09920241984229960508e-10f, "80992024", -9},
  {4.98375196110598303145e+30f, "4983752", 31},
  {3.47414014493197027162e-22f, "34741401", -21},
  {1.27749971888062978538e+30f, "12774997", 31},
  {2.88277406558405462859e-17f, "2882774", -16},
  {3.43292950900501381120e+19f, "34329295", 20},
  {5.26061855047680000000e+14f, "52606186", 15},
  {9.36745474457600000000e+12f, "9367455", 13},
  {1.60850444075322229764e-08f, "16085044", -7},
  {9.54068228602409362793e-02f, "9540682", -1},
  {1.18694473344787089118e+35f, "11869447", 36},
  {5.12798363366873167299e+22f, "51279836", 23},
  {1.74955820772711156952e-13f, "17495582", -12},
  {2.54819414704527191872e-22f, "25481941", -21},
  {1.95442373908496489744e+38f, "19544237", 39},
  {4.33875388066472615215e-31f, "4338754", -30},
  {7.23064980831689337116e+34f, "723065", 35},
  {1.34596686042481363165e-36f, "13459669", -35},
  {1.40253026712631923698e-27f, "14025303", -26},
  {4.81405855334400000000e+12f, "48140586", 13},
  {1.77857439390022697786e-38f, "17785744", -37},
  {4.86471370251213489208e-18f, "48647137", -17},
  {6.39660396378261490237e+22f, "6396604", 23},
  {1.15932623776107134667e+29f, "11593262", 30},
  {1.21032109375000000000e+05f, "12103211", 6},
  {2.92834597636238827621e-32f, "2928346", -31},
  {7.34221194177977067408e-26f, "7342212", -25},
  {3.89564076964198744064e+20f, "38956408", 21},
  {6.59729502632216109443e-25f, "6597295", -24},
  {9.21532497286489864812e+37f, "9215325", 38},
  {3.06998790809438065752e-15f, "3069988", -14},
  {8.74524531250000000000e+04f, "8745245", 5},
  {6.64882604420014524247e+29f, "6648826", 30},
  {1.75214843750000000000e+02f, "17521484", 3},
  {1.63841323228552937508e-04f, "16384132", -3},
  {2.81145404388902078083e-26f, "2811454", -25},
  {8.53387348719932697667e-18f, "85338735", -17},
  {1.22293421832429847411e-28f, "12229342", -27},
  {4.45884736507907478504e+25f, "44588474", 26},
  {2.30336222986240000000e+13f, "23033622", 14},
  {1.86578163200000000000e+09f, "18657816", 10},
  {7.46756209438114185216e+21f, "7467562", 22},
  {1.62761320825666189194e-03f, "16276132", -2},
  {5.30267406831759070460e+34f, "5302674", 35},
  {3.03645621699164737975e+38f, "30364562", 39},
  {4.43208729848265647888e-04f, "44320873", -3},
  {3.31398891570984357159e-35f, "3313989", -34},
  {3.16809901033796663811e+34f, "3168099", 35},
  {1.00279986858367919922e-01f, "10027999", 0},
  {7.36406230417064802220e-24f, "7364062", -23},
  {2.17429296000000000000e+08f, "2174293", 9},
  {2.79380887746810913086e-01f, "2793809", 0},
  {5.91790582984685897827e-03f, "5917906", -2},
  {1.95673326430778615759e-08f, "19567333", -7},
  {4.60073056041121475346e-11f, "46007306", -10},
  {1.02449491246173105982e-36f, "10244949", -35},
  {9.38137322664260864258e-02f, "9381373", -1},
  {5.12506591796875000000e+02f, "5125066", 3},
  {6.35321403317271385866e+22f, "6353214", 23},
  {9.64181780070400000000e+12f, "9641818", 13},
  {6.93917236328125000000e+01f, "6939172", 2},
  {2.78059944322603840496e-31f, "27805994", -30},
  {1.21173679854957354629e-21f, "12117368", -20},
  {6.75467006772123568226e-08f, "675467", -7},
  {7.63987660800000000000e+09f, "76398766", 10},
  {3.11866278543360000000e+13f, "31186628", 14},
  {3.20044843750000000000e+05f, "32004484", 6},
  {1.02290090841044457289e+31f, "10229009", 32},
  {5.99593942149374777754e+23f, "59959394", 24},
  {2.04661372293912791065e-08f, "20466137", -7},
  {3.45497406250000000000e+05f, "3454974", 6},
  {1.64178322847874369472e-06f, "16417832", -5},
  {2.02119217100414303476e-25f, "20211922", -24},
  {7.46540075310889104754e-37f, "74654008", -36},
  {1.16305125252846863759e-10f, "116305125", -9},
  {8.99272342706073433359e-26f, "89927234", -25},
  {5.62508404254913330078e-02f, "5625084", -1},
  {6.55500457469315733761e-07f, "65550046", -6},
  {3.99109935753897717444e-30f, "39910994", -29},
  {9.33454801887660371463e+35f, "9334548", 36},
  {7.98600704000000000000e+08f, "7986007", 9},
  {1.35814467991633920000e+17f, "13581447", 18},
  {3.71589412679895758629e-04f, "3715894", -3},
  {6.17834394130821761109e-33f, "6178344", -32},
  {3.78005053755505528056e-30f, "37800505", -29},
  {2.66647772054584414123e+24f, "26664777", 25},
  {1.07622789659591215659e-30f, "10762279", -29},
  {5.70078280000000000000e+07f, "57007828", 8},
  {2.00783465374720915264e-12f, "20078347", -11},
  {1.06073230765397300951e+31f, "10607323", 32},
  {7.78506358479475306321e-19f, "77850636", -18},
  {2.35320409490704191081e+28f, "2353204", 29},
  {1.53209984302520751953e-01f, "15320998", 0},
  {2.29210755121708905074e-18f, "22921076", -17},
  {5.30296012800000000000e+09f, "530296", 10},
  {6.45728988797860119624e-27f, "645729", -26},
  {1.19320734898942126577e+26f, "119320735", 27},
  {7.95743865966796875000e+01f, "7957439", 2},
  {6.58740259608137921256e+35f, "65874026", 36},
  {3.24522644272747073307e-21f, "32452264", -20},
  {3.84894554440519554981e-32f, "38489455", -31},
  {1.58684221318594609329e-09f, "15868422", -8},
  {1.11485761067342536990e-07f, "11148576", -6},
  {4.87819547930227495485e-30f, "48781955", -29},
  {3.13957276983995924480e+19f, "31395728", 20},
  {1.68806725000000000000e+06f, "16880672", 7},
  {4.51638880000000000000e+07f, "4516389", 8},
  {2.78307477282369488113e-26f, "27830748", -25},
  {1.05536023638835200000e+15f, "105536024", 16},
  {5.73602382812500000000e+04f, "5736024", 5},
  {3.69326750936767607603e+21f, "36932675", 22},
  {2.09748833412959356792e-07f, "20974883", -6},
  {2.99169374861948225667e-38f, "29916937", -37},
  {3.87884557578326201151e+27f, "38788456", 28},
  {1.25276588439941406250e+02f, "12527659", 3},
  {1.33016185689231447189e+25f, "13301619", 26},
  {6.41662946090838300345e+35f, "64166295", 36},
  {1.04534316490941311933e-29f, "10453432", -28},
  {3.82357491123922300548e-26f, "3823575", -25},
  {9.78911980564390432648e+27f, "978912", 28},
  {1.35183875205058257052e-09f, "13518388", -8},
  {1.25429082082167486968e-36f, "12542908", -35},
  {7.09483854138176770743e+27f, "70948385", 28},
  {3.32204810818911633161e+28f, "3322048", 29},
  {4.41546469881964409945e-16f, "44154647", -15},
  {5.21088391542434692383e-02f, "5210884", -1},
  {3.15152876616117668740e-37f, "31515288", -36},
  {7.72822603238505574643e-29f, "7728226", -28},
  {3.52610045901652354225e+37f, "35261005", 38},
  {4.20950982404910689638e-11f, "42095098", -10},
  {3.62913133341089254711e-32f, "36291313", -31},
  {7.92685569961371072623e-11f, "7926856", -10},
  {7.77299903585917599744e+20f, "7772999", 21},
  {2.69492113945667659626e-23f, "2694921", -22},
  {3.35672699803862594561e-30f, "3356727", -29},
  {1.75229047851693797710e-12f, "17522905", -11},
  {2.06137140848136489533e+23f, "20613714", 24},
  {1.58267725691384243962e-17f, "15826773", -16},
  {2.71038548092924615377e-36f, "27103855", -35},
  {1.62195170488876883041e-11f, "16219517", -10},
  {8.20734460533003543902e-35f, "82073446", -34},
  {9.52673872234299778938e-05f, "9526739", -4},
  {8.07411637548938188047e-11f, "80741164", -10},
  {5.15681090110963681244e+31f, "5156811", 32},
  {2.01817692379363010065e+36f, "2018177", 37},
  {1.45788742944409699686e-24f, "14578874", -23},
  {4.76235028764345421276e+28f, "47623503", 29},
  {2.89590820975144725243e-32f, "28959082", -31},
  {9.03420567521795447874e-12f, "9034206", -11},
  {6.79695273424846848000e+17f, "6796953", 18},
  {6.35252287611365318298e-03f, "6352523", -2},
  {1.77779257981569571712e-09f, "17777926", -8},
  {6.76069200000000000000e+06f, "6760692", 7},
  {2.96370566976733584852e-13f, "29637057", -12},
  {1.33520383016960000000e+14f, "13352038", 15},
  {4.92790603998475132104e-34f, "4927906", -33},
  {1.43997877857793277201e-11f, "14399788", -10},
  {1.72655370811390564080e+24f, "17265537", 25},
  {4.58444587612867208936e-34f, "4584446", -33},
  {7.44446984526220267853e-13f, "744447", -12},
  {9.69118765181682242917e-26f, "96911877", -25},
  {2.68565634437452974810e-27f, "26856563", -26},
  {9.00215374191001600000e+15f, "9002154", 16},
  {1.23716397467475227000e+34f, "1237164", 35},
  {1.22269061195168227130e-11f, "12226906", -10},
  {5.13875157824818794358e+24f, "51387516", 25},
  {3.10309924656571891038e-17f, "31030992", -16},
  {3.37513753112821023498e-27f, "33751375", -26},
  {1.18635615372275560900e-31f, "11863562", -30},
  {1.36379402644040345627e-14f, "1363794", -13},
  {9.27320957183837890625e+00f, "927321", 1},
  {1.54103332648393286463e-27f, "15410333", -26},
  {2.18443458343094714368e+20f, "21844346", 21},
  {1.22508434100906423973e+29f, "12250843", 30},
  {1.13529611744401159484e-34f, "11352961", -33},
  {5.76039364472078336000e+17f, "57603936", 18},
  {2.52056409324400776297e-34f, "2520564", -33},
  {8.96414510624746083227e+32f, "8964145", 33},
  {2.83676393854589928787e+24f, "2836764", 25},
  {3.69644993725160020404e-07f, "369645", -6},
  {8.57744736256000000000e+11f, "85774474", 12},
  {2.49731335952638658208e-17f, "24973134", -16},
  {1.10261116266554333331e+23f, "11026112", 24},
  {7.94247999739620092776e-21f, "794248", -20},
  {1.18428940800000000000e+09f, "11842894", 10},
  {2.11989451199769973755e-02f, "21198945", -1},
  {6.44578043877333658682e-16f, "64457804", -15},
  {2.87657492592340215189e+36f, "2876575", 37},
  {4.95410446433278042321e-17f, "49541045", -16},
  {4.77783333729941972479e-11f, "47778333", -10},
  {3.05374139264956954987e-15f, "30537414", -14},
  {8.10279569122940301895e-04f, "81027957", -3},
  {2.08638687133789062500e+01f, "20863869", 2},
  {4.03895920060710586396e-38f, "40389592", -37},
  {1.37895215246430780098e-08f, "137895215", -7},
  {3.93059846230567874037e+28f, "39305985", 29},
  {3.44428243621687340177e+25f, "34442824", 26},
  {6.92712583987200000000e+13f, "6927126", 14},
  {1.93533308487125056468e-37f, "1935333", -36},
  {6.43767041827110679064e+32f, "64376704", 33},
  {1.60628347990574128921e+38f, "16062835", 39},
  {3.04166595458984375000e+02f, "3041666", 3},
  {1.45713343005869947977e-33f, "14571334", -32},
  {5.04853298325907046400e+19f, "5048533", 20},
  {5.16898843727631174261e-08f, "51689884", -7},
  {2.70213568431430065588e-29f, "27021357", -28},
  {4.27170507609844207764e-02f, "4271705", -1},
  {2.03745393082499504089e-03f, "2037454", -2},
  {3.49453118746609343162e-35f, "34945312", -34},
  {1.70996959983779020942e-16f, "17099696", -15},
  {1.26256406373166678072e+29f, "12625641", 30},
  {4.55674233146572800000e+15f, "45567423", 16},
  {7.02392625000000000000e+05f, "7023926", 6},
  {1.85223484538880000000e+13f, "18522348", 14},
  {6.14717757504746820474e+33f, "61471776", 34},
  {1.19334302348584384054e-24f, "1193343", -23},
  {5.69335369402236846171e-28f, "56933537", -27},
  {5.54082894350810856432e-21f, "5540829", -20},
  {4.92660506456834704666e-27f, "4926605", -26},
  {4.55669578514061868191e-06f, "4556696", -5},
  {4.28495160000000000000e+07f, "42849516", 8},
  {2.42932420223951339722e-03f, "24293242", -2},
  {5.87544332972194618668e+29f, "58754433", 30},
  {1.24719461616594762524e-30f, "12471946", -29},
  {1.53265418484807014465e-02f, "15326542", -1},
  {1.18291575611799011885e-17f, "118291576", -16},
  {8.32337102338775014210e+36f, "8323371", 37},
  {7.73803084376344227011e-16f, "7738031", -15},
  {1.39034669989472601093e+35f, "13903467", 36},
  {2.71281893403049931804e+38f, "2712819", 39},
  {7.31078371148285198544e-22f, "73107837", -21},
  {3.24361979002257911886e+34f, "32436198", 35},
  {1.14086555480957031250e+02f, "114086555", 3},
  {1.79598261925791220523e-16f, "17959826", -15},
  {2.17315990201958400000e+15f, "21731599", 16},
  {9.84606906448485680736e+32f, "9846069", 33},
  {8.04950559540884569287e-07f, "80495056", -6},
  {1.34116929554082626110e-25f, "13411693", -24},
  {2.90610557840409455821e-09f, "29061056", -8},
  {4.45185601711273193359e-03f, "4451856", -2},
  {3.58848273754119873047e-03f, "35884827", -2},
  {5.00373805146149882252e-19f, "5003738", -18},
  {2.97649391417136281512e-26f, "2976494", -25},
  {3.54193796201951321678e-36f, "3541938", -35},
  {1.56633040515917693916e+33f, "15663304", 34},
  {2.63357002041840767021e-31f, "263357", -30},
  {6.85958607082617306105e-22f, "6859586", -21},
  {1.24512393217378028658e-33f, "12451239", -32},
  {2.24047505808372404701e-13f, "2240475", -12},
  {5.32895561011770269033e-10f, "53289556", -9},
  {9.05386865139007568359e-01f, "90538687", 0},
  {1.61968237125977370489e+33f, "16196824", 34},
  {2.14813312415783635175e+26f, "21481331", 27},
  {7.75203456981898852973e-10f, "77520346", -9},
  {2.75161961870418420776e-36f, "27516196", -35},
  {4.79614872800739402980e-15f, "47961487", -14},
  {1.50577912217600000000e+12f, "15057791", 13},
  {3.27778844828989420913e-38f, "32777884", -37},
  {5.86502208000000000000e+08f, "5865022", 9},
  {2.79996192000000000000e+08f, "2799962", 9},
  {1.16217444839949439178e-38f, "11621744", -37},
  {7.03558311685820271622e+25f, "7035583", 26},
  {1.31466298828125000000e+04f, "1314663", 5},
  {2.26722702026367187500e+02f, "2267227", 3},
  {1.81290704652742472752e-29f, "1812907", -28},
  {4.16053624291302611569e-20f, "41605362", -19},
  {3.14525968860834836960e-04f, "31452597", -3},
  {2.30284619140625000000e+03f, "23028462", 4},
  {8.73597286954463925213e-07f, "8735973", -6},
  {1.43020908770659347689e+26f, "14302091", 27},
  {1.48595636961869013696e-38f, "14859564", -37},
  {5.29044299224247124032e+29f, "5290443", 30},
  {9.88329789295661246375e-32f, "9883298", -31},
  {7.31841422694054868201e-26f, "7318414", -25},
  {2.99592340825218887437e+32f, "29959234", 33},
  {2.27376818795010591650e-37f, "22737682", -36},
  {3.03744153729013857278e-18f, "30374415", -17},
  {2.96067312190195081780e-28f, "29606731", -27},
  {4.49947969345039785203e-32f, "44994797", -31},
  {1.15541904000000000000e+08f, "1155419", 9},
  {2.57670211791992187500e+01f, "25767021", 2},
  {6.86179550000000000000e+06f, "68617955", 7},
  {2.52091705322265625000e+02f, "2520917", 3},
  {7.27100064185082217705e-12f, "72710006", -11},
  {8.64474326825641040351e+35f, "8644743", 36},
  {1.17848890625000000000e+05f, "11784889", 6},
  {5.93135193292800000000e+12f, "5931352", 13},
  {1.79337920000000000000e+09f, "17933792", 10},
  {6.25186375000000000000e+05f, "6251864", 6},
  {4.99974680160835389486e-18f, "4999747", -17},
  {7.25602994890229265660e-22f, "725603", -21},
  {1.23849100000000000000e+06f, "1238491", 7},
  {4.96877653490884265407e-31f, "49687765", -30},
  {1.55613173473258294477e+21f, "15561317", 22},
  {3.85040697775685535875e-31f, "3850407", -30},
  {1.43662501297448992105e-21f, "1436625", -20},
  {8.71305468809189214561e-38f, "87130547", -37},
  {2.03274101562500000000e+04f, "2032741", 5},
  {5.37317997617109532672e+20f, "537318", 21},
  {1.28565070554031990469e-05f, "12856507", -4},
  {4.05754363441701570991e-09f, "40575436", -8},
  {1.28048863806439502643e+21f, "12804886", 22},
  {9.62428480823489945761e-15f, "9624285", -14},
  {6.82171285152435302734e-02f, "6821713", -1},
  {1.55790012633714644590e+34f, "15579001", 35},
  {4.06873300818963482579e-21f, "4068733", -20},
  {2.60083341598510742188e+00f, "26008334", 1},
  {6.62363398754222336919e-23f, "6623634", -22},
  {1.94056465341319039908e-10f, "19405647", -9},
  {1.88848120000000000000e+07f, "18884812", 8},
  {1.19253134787671384864e+24f, "119253135", 25},
  {8.09630239559159385993e+29f, "80963024", 30},
  {1.82145394565686369425e-25f, "1821454", -24},
  {4.41637937158290139195e-13f, "44163794", -12},
  {8.64657144959864979598e-21f, "86465714", -20},
  {2.14533525402923243910e-28f, "21453353", -27},
  {8.82576657287405913383e+30f, "88257666", 31},
  {8.23791369936533974402e+30f, "8237914", 31},
  {6.39191892890369392640e+19f, "6391919", 20},
  {7.55087519064545631409e-03f, "7550875", -2},
  {5.50964799960851699561e-26f, "5509648", -25},
  {7.68726965662092565546e+36f, "76872697", 37},
  {1.34109857467770086941e-35f, "13410986", -34},
  {4.59859729174463759366e-18f, "45985973", -17},
  {1.62691942802480168960e+19f, "16269194", 20},
  {8.61535582782972492241e-28f, "8615356", -27},
  {1.02152299880981445312e+00f, "1021523", 1},
  {2.38622856820318797824e+20f, "23862286", 21},
  {2.94358885387468800000e+15f, "29435889", 16},
  {7.98851951319770997833e-19f, "79885195", -18},
  {4.30828573663493909509e-24f, "43082857", -23},
  {1.72120173401779838266e-32f, "17212017", -31},
  {1.44944528589698344971e-36f, "14494453", -35},
  {6.62638854980468750000e+00f, "66263885", 1},
  {1.95019250000000000000e+05f, "19501925", 6},
  {3.79320863817133403331e+36f, "37932086", 37},
  {4.28304611605374566400e+18f, "4283046", 19},
  {6.88826373434917570944e-34f, "68882637", -33},
  {3.47005490843299521579e-25f, "3470055", -24},
  {1.20254557913979451437e-30f, "12025456", -29},
  {2.10437524684800000000e+12f, "21043752", 13},
  {7.02212311871131183984e+37f, "7022123", 38},
  {1.53278398257198034767e+38f, "1532784", 39},
  {6.48185520961401519415e+25f, "6481855", 26},
  {4.52825304380136128835e-14f, "4528253", -13},
  {1.82584327856847058748e-21f, "18258433", -20},
  {2.30998407062581742478e+36f, "2309984", 37},
  {5.64891808413986535923e-22f, "5648918", -21},
  {2.14876831443306883016e-29f, "21487683", -28},
  {2.11902931786530816000e+17f, "21190293", 18},
  {7.13165897728000000000e+14f, "7131659", 15},
  {1.96304160395589777626e-16f, "19630416", -15},
  {2.15743441613619200000e+15f, "21574344", 16},
  {1.59215949491208192000e+18f, "15921595", 19},
  {1.43341140625000000000e+05f, "14334114", 6},
  {5.12724691361654549837e-05f, "5127247", -4},
  {2.29366756782923528923e+29f, "22936676", 30},
  {2.14766055096471496896e-34f, "21476606", -33},
  {1.71665473089209985637e-23f, "17166547", -22},
  {9.19980625000000000000e+05f, "9199806", 6},
  {2.78128638419835108597e-14f, "27812864", -13},
  {1.19147234300953641650e-08f, "11914723", -7},
  {2.53135840870400000000e+12f, "25313584", 13},
  {6.85322285032263778248e-12f, "6853223", -11},
  {1.27349636102897594087e+31f, "12734964", 32},
  {6.94146655112674836704e-22f, "69414666", -21},
  {3.72508014018224642427e-14f, "372508", -13},
  {7.65012377600000000000e+10f, "7650124", 11},
  {7.92312302755957388687e-17f, "7923123", -16},
  {1.98866164684295654297e+00f, "19886616", 1},
  {1.51046289475030220800e+19f, "15104629", 20},
  {2.78560722946378983890e+34f, "27856072", 35},
  {2.04944372177124023438e-01f, "20494437", 0},
  {3.31909052808717926400e+18f, "33190905", 19},
  {2.40071274273913700352e+21f, "24007127", 22},
  {1.49035453534991282497e+24f, "14903545", 25},
  {1.00836146427758416076e+36f, "10083615", 37},
  {8.09157325012913356800e+18f, "8091573", 19},
  {1.17858294716231197998e-36f, "117858295", -35},
  {3.00665329578394119199e-32f, "30066533", -31},
  {2.39248480647802352905e-03f, "23924848", -2},
  {1.32113460312932352000e+17f, "13211346", 18},
  {9.25638787840910026716e-10f, "9256388", -9},
  {7.37443737198123565927e-27f, "7374437", -26},
  {2.96489481115713715553e-04f, "29648948", -3},
  {2.24598050075901757941e+34f, "22459805", 35},
  {6.11105120000000000000e+07f, "6111051", 8},
  {9.44697065800165214355e-14f, "94469707", -13},
  {2.31019325997207234648e-39f, "2310193", -38},
  {1.68993144475044529832e+23f, "16899314", 24},
  {1.43665625374387925379e+31f, "14366563", 32},
  {3.27897228141228735954e-14f, "32789723", -13},
  {2.84131585576619313143e-24f, "28413159", -23},
  {5.13730507812500000000e+04f, "5137305", 5},
  {3.65032751759360000000e+13f, "36503275", 14},
  {4.86439839647814255257e-32f, "48643984", -31},
  {5.69889775267108565811e+21f, "5698898", 22},
  {2.29372695239987747286e+38f, "2293727", 39},
  {6.26309585849810944000e+17f, "6263096", 18},
  {6.29429148983096252118e-34f, "62942915", -33},
  {6.68396651744842529297e-01f, "66839665", 0},
  {1.34696969762444496155e-02f, "13469697", -1},
  {2.32196893148717951425e-38f, "2321969", -37},
  {2.10161397152203721121e+37f, "2101614", 38},
  {6.15976799805416400737e-23f, "6159768", -22},
  {9.40720953659399287603e+21f, "94072095", 22},
  {4.56800425456163325215e+22f, "45680043", 23},
  {8.68933122069822641672e-26f, "8689331", -25},
  {1.11784606933593750000e+02f, "11178461", 3},
  {8.58698184828113611076e+24f, "8586982", 25},
  {4.12084553218331761964e-19f, "41208455", -18},
  {4.19310118945909118901e+37f, "41931012", 38},
  {1.64780932617187500000e+03f, "16478093", 4},
  {6.48780144640000000000e+10f, "64878014", 11},
  {4.49426345137455616108e-28f, "44942635", -27},
  {7.75677785462781999847e+37f, "7756778", 38},
  {2.06527425000000000000e+06f, "20652742", 7},
  {4.45941025505017856000e+18f, "44594103", 19},
  {1.05553849284712418510e-14f, "10555385", -13},
  {2.44554875000000000000e+06f, "24455488", 7},
  {1.07751818847656250000e+03f, "10775182", 4},
  {2.01402298041774345437e-22f, "2014023", -21},
  {1.33845085728363231326e+31f, "13384509", 32},
  {5.10091069354934272000e+17f, "51009107", 18},
  {1.73543664292182831923e+21f, "17354366", 22},
  {7.11616062500000000000e+05f, "71161606", 6},
  {4.21423881168351724254e+24f, "42142388", 25},
  {1.37360224609375000000e+04f, "13736022", 5},
  {2.23534312500000000000e+05f, "22353431", 6},
  {3.74669775390625000000e+03f, "37466978", 4},
  {1.40751667200000000000e+09f, "14075167", 10},
  {2.00725188335631983574e-34f, "20072519", -33},
  {7.30482035688805296012e-38f, "73048204", -37},
  {5.52403558400000000000e+09f, "55240356", 10},
  {6.13031352911954443723e-36f, "61303135", -35},
  {7.27224741450069863498e-22f, "72722474", -21},
  {7.61877885224748752080e-08f, "7618779", -7},
  {4.74948780834401668196e+25f, "4749488", 26},
  {1.04149577850876084995e-08f, "10414958", -7},
  {1.33033586051251338113e+33f, "13303359", 34},
  {5.51657996288000000000e+11f, "551658", 12},
  {7.13735077888000000000e+11f, "7137351", 12},
  {8.09852346433053534701e+31f, "80985235", 32},
  {1.33395185920753949515e-24f, "13339519", -23},
  {6.58626085307546229805e-17f, "6586261", -16},
  {5.34043958350984245755e-35f, "53404396", -34},
  {1.48505666183652372892e-25f, "14850567", -24},
  {2.28984103426816601571e+28f, "2289841", 29},
  {3.94082216181491229000e+22f, "3940822", 23},
  {2.40224629640579223633e-01f, "24022463", 0},
  {8.07008618721738457680e-05f, "8070086", -4},
  {6.22657578708968317827e-14f, "6226576", -13},
  {8.21451150065664000000e+15f, "82145115", 16},
  {1.49340609323367345951e-12f, "14934061", -11},
  {4.49012439308968405571e-35f, "44901244", -34},
  {2.02181246131658554077e-02f, "20218125", -1},
  {1.62203888683861899541e+32f, "16220389", 33},
  {3.18515638470201519963e+28f, "31851564", 29},
  {3.70651335926865192629e-37f, "37065134", -36},
  {5.32733984291553497314e-02f, "532734", -1},
  {1.71367560142243746668e-07f, "17136756", -6},
  {8.80690053120000000000e+10f, "88069005", 11},
  {1.78890100097656250000e+03f, "1788901", 4},
  {1.89885986401350237429e-06f, "18988599", -5},
  {6.79897744066722600686e-19f, "67989774", -18},
  {1.85130987500000000000e+06f, "18513099", 7},
  {2.34774560768000000000e+11f, "23477456", 12},
  {8.11860230144000000000e+12f, "81186023", 13},
  {1.18807584215119277360e-07f, "118807584", -6},
  {3.32849361486318454915e-36f, "33284936", -35},
  {1.56934910000000000000e+07f, "15693491", 8},
  {9.61385975631551465134e-35f, "961386", -34},
  {3.95291710717952000000e+14f, "3952917", 15},
  {1.86725020408630371094e+00f, "18672502", 1},
  {2.18110240747900746699e-20f, "21811024", -19},
  {4.22916096858077343680e+36f, "4229161", 37},
  {1.61908007812500000000e+04f, "16190801", 5},
  {4.98594374676031293347e-07f, "4985944", -6},
  {1.35160446749574491537e+26f, "13516045", 27},
  {9.27269003768438349056e-13f, "927269", -12},
  {1.99520621609612356996e+31f, "19952062", 32},
  {1.48368921475411166019e-17f, "14836892", -16},
  {9.80706184396800000000e+12f, "9807062", 13},
  {2.40439424000000000000e+08f, "24043942", 9},
  {3.67461964800000000000e+09f, "36746196", 10},
  {7.13391276136857600000e+16f, "71339128", 17},
  {6.68912929751911841014e-33f, "6689129", -32},
  {8.75748046875000000000e+02f, "87574805", 3},
  {3.33059525000000000000e+06f, "33305952", 7},
  {4.16555607281682998181e-31f, "4165556", -30},
  {6.65421149288668364226e-38f, "66542115", -37},
  {8.72557982585224431856e+37f, "872558", 38},
  {6.16889849832328396800e+18f, "61688985", 19},
  {1.90409589843750000000e+04f, "19040959", 5},
  {2.42420640006457688287e-07f, "24242064", -6},
  {4.86623575527418403070e-29f, "48662358", -28},
  {8.30555176300583827833e-35f, "8305552", -34},
  {7.70256561766400000000e+12f, "77025656", 13},
  {9.83539306640625000000e+02f, "9835393", 3},
  {4.51395414313924808926e-32f, "4513954", -31},
  {1.75876085343910937528e-19f, "17587609", -18},
  {1.60867980000000000000e+07f, "16086798", 8},
  {2.91708984651390386176e+21f, "29170898", 22},
  {5.49499275835007303680e+19f, "54949928", 20},
  {5.90754765351259545356e+25f, "59075477", 26},
  {1.68443598078539202560e+19f, "1684436", 20},
  {1.30192479179717067461e-15f, "13019248", -14},
  {4.26279418431790671231e-20f, "42627942", -19},
  {3.29919125000000000000e+06f, "32991912", 7},
  {2.04149080064000000000e+11f, "20414908", 12},
  {1.24409806989017537017e-27f, "12440981", -26},
  {8.13221554406900163916e+27f, "81322155", 28},
  {2.84272875658781506297e-15f, "28427288", -14},
  {4.91248645131248599040e+19f, "49124865", 20},
  {4.22942489385604858398e-02f, "4229425", -1},
  {2.97235044882569677379e-37f, "29723504", -36},
  {5.48138728257294265022e+25f, "54813873", 26},
  {5.00225268289914340317e-38f, "50022527", -37},
  {1.56836672000000000000e+08f, "15683667", 9},
  {3.82412490814660570602e+33f, "3824125", 34},
  {5.56358941799734161084e-37f, "55635894", -36},
  {2.00355400000000000000e+07f, "2003554", 8},
  {3.18535725219840000000e+13f, "31853573", 14},
  {1.72094775000000000000e+06f, "17209478", 7},
  {2.48025904549792512066e-39f, "2480259", -38},
  {3.01894257868800000000e+13f, "30189426", 14},
  {1.41317394839633920000e+16f, "1413174", 17},
  {9.32146586804178840775e-35f, "9321466", -34},
  {3.33655141276228972558e-13f, "33365514", -12},
  {2.01920926755302847438e-20f, "20192093", -19},
  {7.13713911389441223917e-28f, "7137139", -27},
  {9.14023900000000000000e+06f, "9140239", 7},
  {5.44542489383264403660e+25f, "5445425", 26},
  {3.25331686836106083283e+32f, "3253317", 33},
  {7.18056202605316107324e-13f, "7180562", -12},
  {4.25439448268800000000e+12f, "42543945", 13},
  {8.04303667200000000000e+12f, "80430367", 13},
  {1.43604367360000000000e+11f, "14360437", 12},
  {3.05730593974466268652e+31f, "3057306", 32},
  {3.79999794070442497665e-20f, "3799998", -19},
  {4.24726738124988755386e-17f, "42472674", -16},
  {5.04346654780893837717e-35f, "50434665", -34},
  {4.11879913932078234498e-31f, "4118799", -30},
  {1.89675380000000000000e+07f, "18967538", 8},
  {4.16782961384023148986e+23f, "41678296", 24},
  {2.93109650000000000000e+06f, "29310965", 7},
  {9.18546432000000000000e+08f, "9185464", 9},
  {3.08537487360000000000e+10f, "30853749", 11},
  {2.45201900000000000000e+07f, "2452019", 8},
  {1.98994543097746014973e-22f, "19899454", -21},
  {1.66320406250000000000e+05f, "1663204", 6},
  {2.08367436800000000000e+09f, "20836744", 10},
  {6.48988594200042941710e+23f, "6489886", 24},
  {7.31558614521254370288e-21f, "7315586", -20},
  {5.23372607468139077943e-24f, "5233726", -23},
  {7.76528518034542326448e+23f, "7765285", 24},
  {3.64203144305062099212e+31f, "36420314", 32},
  {1.16698383079924707597e+31f, "11669838", 32},
  {1.20887458193829003906e+28f, "12088746", 29},
  {1.71180746461944261839e-20f, "17118075", -19},
  {3.31326322795313011841e-28f, "33132632", -27},
  {1.16106097663974189214e-38f, "1161061", -37},
  {2.61648779350506925080e+25f, "26164878", 26},
  {2.78674730291532947416e+36f, "27867473", 37},
  {6.45865620993082992306e+32f, "64586562", 33},
  {2.49668282711749087062e-26f, "24966828", -25},
  {1.70332600320000000000e+10f, "1703326", 11},
  {7.62944700000000000000e+06f, "7629447", 7},
  {5.97382854876320959037e+23f, "59738285", 24},
  {7.63033935546875000000e+02f, "76303394", 3},
  {4.72333585927071865063e+25f, "4723336", 26},
  {3.71458183812880479850e-32f, "37145818", -31},
  {6.44994900000000000000e+06f, "6449949", 7},
  {3.28463002005601733953e+33f, "328463", 34},
  {1.15219451871232000000e+14f, "11521945", 15},
  {3.57033091979985783837e-09f, "3570331", -8},
  {1.33027935028076171875e+01f, "133027935", 2},
  {1.49690587349425943426e-16f, "14969059", -15},
  {1.61064494393517596030e-37f, "16106449", -36},
  {4.43484349087834322220e-31f, "44348435", -30},
  {4.91097307205200195312e+00f, "4910973", 1},
  {4.15583275000000000000e+06f, "41558328", 7},
  {1.53473938993709056000e+17f, "15347394", 18},
  {4.62351875467575772205e-15f, "46235188", -14},
  {5.13186806040493276371e+24f, "5131868", 25},
  {1.33599098338291325040e+32f, "1335991", 33},
  {5.00473396670501577111e-30f, "5004734", -29},
  {2.67608314018267136000e+17f, "26760831", 18},
  {2.17300901394522800180e+24f, "2173009", 25},
  {9.60614406145140220624e+36f, "9606144", 37},
  {7.44365462420128989995e+35f, "7443655", 36},
  {1.19474286437854050143e+35f, "11947429", 36},
  {1.90817201110792967841e+37f, "1908172", 38},
  {2.78183115599025809654e+22f, "27818312", 23},
  {4.82356991864847086541e+32f, "482357", 33},
  {1.80986374351711142631e+31f, "18098637", 32},
  {1.16673313401446634450e+35f, "11667331", 36},
  {1.20365859375000000000e+04f, "12036586", 5},
  {2.00458168983459472656e-01f, "20045817", 0},
  {1.01898190082187198464e+20f, "10189819", 21},
  {1.20770318990840589126e-32f, "12077032", -31},
  {1.29646981491355825500e-14f, "12964698", -13},
  {5.84243175373704515893e+26f, "58424318", 27},
  {1.31712543621120000000e+13f, "13171254", 14},
  {5.90788549356711291715e-20f, "59078855", -19},
  {9.76101379394531250000e+01f, "9761014", 2},
  {6.80914975029647023046e-35f, "680915", -34},
  {1.29323607680966721536e+20f, "12932361", 21},
  {2.26486371136913625894e+24f, "22648637", 25},
  {1.73632068521868540221e-33f, "17363207", -32},
  {9.29459299726198472100e+27f, "9294593", 28},
  {1.56489167598642536783e-14f, "15648917", -13},
  {1.21890983116800000000e+12f, "12189098", 13},
  {2.03630050000000000000e+06f, "20363005", 7},
  {1.20482375680000000000e+10f, "12048238", 11},
  {9.13935620337724685669e-03f, "9139356", -2},
  {3.97175878286361694336e-01f, "39717588", 0},
  {9.17108915944239923200e+18f, "9171089", 19},
  {3.39720858352029898319e-24f, "33972086", -23},
  {1.23117032976800605190e-15f, "12311703", -14},
  {1.29370608298360832000e+17f, "12937061", 18},
  {3.70531664967802468495e-27f, "37053166", -26},
  {1.97790348667731019180e-19f, "19779035", -18},
  {3.57994328804556800000e+15f, "35799433", 16},
  {1.68171146142623446871e+34f, "16817115", 35},
  {1.35520239148760941641e-25f, "13552024", -24},
  {9.22396320000000000000e+07f, "9223963", 8},
  {2.59572542854098229475e+30f, "25957254", 31},
  {2.56522316232523776000e+17f, "25652232", 18},
  {2.43824946766275359009e-32f, "24382495", -31},
  {3.86151579648000000000e+11f, "38615158", 12},
  {5.25759299756080481960e+23f, "5257593", 24},
  {5.37264952527038985863e-08f, "53726495", -7},
  {3.23150694370269775391e-01f, "3231507", 0},
  {9.66398324817419052124e-03f, "9663983", -2},
  {5.20226963456000000000e+11f, "52022696", 12},
  {4.27353600301569451171e-38f, "4273536", -37},
  {1.05676483154296875000e+02f, "10567648", 3},
  {9.80637295810993236955e-08f, "9806373", -7},
  {1.63564039992154648939e+25f, "16356404", 26},
  {2.98320980000000000000e+07f, "29832098", 8},
  {1.32035406896084487403e-18f, "13203541", -17},
  {3.61973742296844315333e-28f, "36197374", -27},
  {5.11397498997976299524e-20f, "5113975", -19},
  {4.53157881867801533096e+26f, "4531579", 27},
  {7.05407394621830463488e+20f, "7054074", 21},
  {7.61332688937287680000e+16f, "7613327", 17},
  {2.39409864545916950540e-13f, "23940986", -12},
  {9.46935653686523437500e+00f, "9469357", 1},
  {4.39440570153229369022e+31f, "43944057", 32},
  {4.94474526720000000000e+10f, "49447453", 11},
  {1.67631836692020250880e-21f, "16763184", -20},
  {2.36897973451940628424e-34f, "23689797", -33},
  {1.60155515602715272041e+30f, "16015552", 31},
  {1.01824939706986254110e+33f, "10182494", 34},
  {3.03155929356362957194e-34f, "30315593", -33},
  {1.24373710632324218750e+02f, "12437371", 3},
  {2.37469888098238670919e+30f, "23746989", 31},
  {1.27887041027578779402e+22f, "12788704", 23},
  {5.15793952000000000000e+08f, "51579395", 9},
  {1.30879321289062500000e+03f, "13087932", 4},
  {9.17418800000000000000e+06f, "9174188", 7},
  {4.05367871993606660744e-38f, "40536787", -37},
  {5.90839628124542047888e-37f, "59083963", -36},
  {1.28135806340152246956e-34f, "12813581", -33},
  {3.55542237184000000000e+12f, "35554224", 13},
  {4.17831203264631331729e-36f, "4178312", -35},
  {2.07810287500000000000e+06f, "20781029", 7},
  {4.86126056124541630885e-34f, "48612606", -33},
  {1.06927800498896324605e+28f, "1069278", 29},
  {9.09880611358791210004e-26f, "9098806", -25},
  {1.01426848961739396460e-13f, "10142685", -12},
  {7.85202416864194674417e-07f, "7852024", -6},
  {6.45486298513707995260e-26f, "6454863", -25},
  {6.29909754156033245184e+20f, "62990975", 21},
  {8.59921581267203074075e-29f, "8599216", -28},
  {2.60297560691833496094e+00f, "26029756", 1},
  {8.67901721492278163672e-18f, "8679017", -17},
  {5.37621783185521935241e-36f, "5376218", -35},
  {1.75755491714607413759e-28f, "17575549", -27},
  {2.45965123176574707031e+00f, "24596512", 1},
  {2.00488884032744956280e-31f, "20048888", -30},
  {3.77663747333202586011e-37f, "37766375", -36},
  {3.43072360919904895127e-06f, "34307236", -5},
  {1.84009040981391896562e-31f, "18400904", -30},
  {1.94513135073433021393e-32f, "19451314", -31},
  {7.23609476378568618776e+34f, "7236095", 35},
  {7.39850632902747634435e+37f, "73985063", 38},
  {3.82698738048827728956e+28f, "38269874", 29},
  {5.45098515625000000000e+04f, "5450985", 5},
  {1.30239852905273437500e+02f, "13023985", 3},
  {5.00870752148330211639e-04f, "50087075", -3},
  {3.63791093750000000000e+05f, "3637911", 6},
  {1.30106982421875000000e+04f, "13010698", 5},
  {1.08513727188110351562e+01f, "10851373", 2},
  {1.70181101922848195680e-21f, "1701811", -20},
  {8.29089050000000000000e+06f, "82908905", 7},
  {3.29905340132075733159e-32f, "32990534", -31},
  {1.40623880507566908354e-16f, "14062388", -15},
  {1.28954736283048987389e-04f, "12895474", -3},
  {4.76277051625502779363e-19f, "47627705", -18},
  {2.25689216000000000000e+09f, "22568922", 10},
  {1.17706251330673694611e-04f, "11770625", -3},
  {6.13935250145280000000e+13f, "61393525", 14},
  {2.45468495027845652808e+22f, "2454685", 23},
  {1.05646600077251838712e-22f, "1056466", -21},
  {8.75358462618916045718e+23f, "87535846", 24},
  {8.88726489721668167204e-17f, "8887265", -16},
  {1.55798256397247314453e-01f, "15579826", 0},
  {7.64250894370051863435e+26f, "7642509", 27},
  {2.55887107414309866726e-06f, "2558871", -5},
  {6.27911000179713882782e+37f, "627911", 38},
  {2.59887610634997522116e+34f, "2598876", 35},
  {1.64256329298950731754e-04f, "16425633", -3},
  {3.03959581060553318821e-07f, "30395958", -6},
  {6.72502657040723457148e-36f, "67250266", -35},
  {4.92458496093750000000e+02f, "4924585", 3},
  {2.95964225349720777558e-11f, "29596423", -10},
  {6.98438184972682836898e-37f, "6984382", -36},
  {2.76535878640515875304e-08f, "27653588", -7},
  {2.72666003744788150248e+32f, "272666", 33},
  {1.53539873046875000000e+04f, "15353987", 5},
  {2.32928837820952102307e+27f, "23292884", 28},
  {1.33523359894752502441e-01f, "13352336", 0},
  {2.88424513112674113912e-31f, "28842451", -30},
  {3.60307096658463166250e-11f, "3603071", -10},
  {3.86502088332410880000e+16f, "3865021", 17},
  {4.05095510441984000000e+14f, "4050955", 15},
  {1.92414649063721299171e-04f, "19241465", -3},
  {3.98946449806807473013e-39f, "3989464", -38},
  {7.55077746769339966605e-29f, "75507775", -28},
  {1.50823832502927360000e+16f, "15082383", 17},
  {2.98571827200000000000e+09f, "29857183", 10},
  {1.49326112500000000000e+06f, "14932611", 7},
  {1.32190980384194745056e-09f, "13219098", -8},
  {1.00721891271859931294e-07f, "10072189", -6},
  {2.68172356721319713178e+22f, "26817236", 23},
  {1.54480027828443512515e-24f, "15448003", -23},
  {1.45333438906368000000e+15f, "14533344", 16},
  {5.78037162133536578962e-18f, "57803716", -17},
  {1.65850081110459764867e-36f, "16585008", -35},
  {5.15096395931453928457e-30f, "5150964", -29},
  {4.95389473268846760305e-19f, "49538947", -18},
  {7.19684606300702917753e+36f, "7196846", 37},
  {1.29629789062500000000e+05f, "12962979", 6},
  {2.49314567782400000000e+13f, "24931457", 14},
  {6.91643479295762947096e-38f, "6916435", -37},
  {9.37590574812615405038e-32f, "9375906", -31},
  {1.07890789235084943661e-36f, "10789079", -35},
  {7.99098605959328076589e-36f, "7990986", -35},
  {4.39365118741989135742e-01f, "43936512", 0},
  {4.62965360585563800774e+34f, "46296536", 35},
  {2.01661520000000000000e+07f, "20166152", 8},
  {1.49070241827614635710e-12f, "14907024", -11},
  {9.02355623111361637712e-06f, "9023556", -5},
  {9.37020331393024000000e+14f, "9370203", 15},
  {8.45348348100608000000e+15f, "84534835", 16},
  {5.07090132119867747975e-28f, "50709013", -27},
  {5.13936782020607552113e-10f, "5139368", -9},
  {2.34795107678803885787e-27f, "2347951", -26},
  {6.44167136650159846837e-28f, "64416714", -27},
  {6.39702606201171875000e+00f, "6397026", 1},
  {5.58455667555024319953e+27f, "55845567", 28},
  {2.92965875975519731712e+20f, "29296588", 21},
  {1.26136553558100028550e-32f, "12613655", -31},
  {1.04841144062939873525e-20f, "104841144", -19},
  {4.32989480619643196622e-26f, "43298948", -25},
  {5.71644682263617501851e+28f, "5716447", 29},
  {2.69838551503198686987e-06f, "26983855", -5},
  {9.73450268579046508606e+27f, "97345027", 28},
  {4.47967068018593407502e-28f, "44796707", -27},
  {7.40719784516841173172e-04f, "7407198", -3},
  {8.49787643884046831562e+36f, "84978764", 37},
  {3.72947219773323013214e-08f, "37294722", -7},
  {7.13565987098263576627e-06f, "713566", -5},
  {1.61409692382812500000e+03f, "16140969", 4},
  {1.28543686808675753073e-33f, "12854369", -32},
  {8.18807020550593733788e-05f, "818807", -4},
  {2.53905776640000000000e+10f, "25390578", 11},
  {2.17470639662012116318e-31f, "21747064", -30},
  {1.04328982532024383545e-01f, "10432898", 0},
  {1.55927711917931629096e-29f, "15592771", -28},
  {1.46521826553818290395e-35f, "14652183", -34},
  {2.88313279020991677901e-33f, "28831328", -32},
  {3.66099853999912738800e-03f, "36609985", -2},
  {2.18748636543750762939e-02f, "21874864", -1},
  {4.53271223236795826176e+20f, "45327122", 21},
  {4.52747395622397632966e-26f, "4527474", -25},
  {1.77756428800000000000e+09f, "17775643", 10},
  {3.31076914867514864798e-28f, "33107691", -27},
  {1.71211379492233750632e-14f, "17121138", -13},
  {1.84521501524810006528e+20f, "1845215", 21},
  {3.40483014656000000000e+11f, "340483", 12},
  {1.37786094187588569113e-25f, "1377861", -24},
  {7.90771408081054687500e+01f, "7907714", 2},
  {7.27500046135721984000e+17f, "72750005", 18},
  {2.24085752620339917485e-07f, "22408575", -6},
  {5.37793793097728000000e+14f, "5377938", 15},
  {5.72118320000000000000e+07f, "5721183", 8},
  {1.00156984329831558400e+26f, "10015698", 27},
  {7.68612158203125000000e+03f, "76861216", 4},
  {4.18316400588541132800e+18f, "4183164", 19},
  {1.00558050814691127229e-16f, "10055805", -15},
  {9.43851165771484375000e+01f, "9438512", 2},
  {2.15188413806387818621e-28f, "21518841", -27},
  {1.21205428792066048000e+17f, "12120543", 18},
  {2.02421780250528752714e-34f, "20242178", -33},
  {4.59026738042199169318e-23f, "45902674", -22},
  {1.32296780926704870308e-26f, "13229678", -25},
  {8.60728022007808000000e+14f, "860728", 15},
  {1.63146041882761445863e-15f, "16314604", -14},
  {2.32664973312000000000e+11f, "23266497", 12},
  {2.13296430309534223408e+24f, "21329643", 25},
  {3.83485474278466575981e-12f, "38348547", -11},
  {1.12706770845040640000e+17f, "11270677", 18},
  {1.13713064746868999463e-17f, "113713065", -16},
  {1.40632719495900614298e+25f, "14063272", 26},
  {6.87414556741714477539e-02f, "68741456", -1},
  {8.48547206260263919830e-05f, "8485472", -4},
  {3.38621211994905024767e-05f, "3386212", -4},
  {3.73506867200000000000e+09f, "37350687", 10},
  {2.35388234348890161152e+20f, "23538823", 21},
  {8.99946246855881113219e-24f, "89994625", -23},
  {1.71559544129940117507e-18f, "17155954", -17},
  {5.00443450581311403029e+33f, "50044345", 34},
  {1.14970819905454080000e+17f, "11497082", 18},
  {2.10967970270213337555e+38f, "21096797", 39},
  {1.64382580897931562802e-12f, "16438258", -11},
  {8.97746090799955709372e-08f, "8977461", -7},
  {1.63158740000000000000e+07f, "16315874", 8},
  {2.27868487537491570208e-25f, "22786849", -24},
  {1.14867119270048007497e+35f, "11486712", 36},
  {9.99967862962310161112e-14f, "99996786", -13},
  {3.73710389249026775360e-03f, "3737104", -2},
  {1.45111726596951484680e-02f, "14511173", -1},
  {3.56391305103898048401e-03f, "3563913", -2},
  {6.59867010948757447063e-25f, "659867", -24},
  {4.88566833496093750000e+02f, "48856683", 3},
  {2.74240624394240000000e+13f, "27424062", 14},
  {1.47252403413095089846e-12f, "1472524", -11},
  {6.08772871531840186786e-22f, "60877287", -21},
  {7.42101929662728960723e+36f, "7421019", 37},
  {5.58028110008404079724e+37f, "5580281", 38},
  {1.80822423829392763300e-36f, "18082242", -35},
  {4.12073736136102375394e-14f, "41207374", -13},
  {8.44892652070502400000e+15f, "84489265", 16},
  {3.26947200222753048965e-15f, "3269472", -14},
  {7.69004856383871061852e-28f, "76900486", -27},
  {8.17213848053625953842e-25f, "81721385", -24},
  {4.54088318705907793920e+19f, "4540883", 20},
  {4.25116950000000000000e+06f, "42511695", 7},
  {5.18380962414566850953e+23f, "51838096", 24},
  {1.46068935394287109375e+01f, "14606894", 2},
  {6.48625588307478183936e+21f, "6486256", 22},
  {1.30433661319607212207e-33f, "13043366", -32},
  {1.07025131001137197018e-04f, "10702513", -3},
  {9.84529376029968261719e-01f, "9845294", 0},
  {3.72298438195107789919e-34f, "37229844", -33},
  {2.94846704436274287084e+22f, "2948467", 23},
  {1.49605779103129974999e+31f, "14960578", 32},
  {1.03248973004800000000e+12f, "10324897", 13},
  {1.10512670133621839522e+36f, "11051267", 37},
  {2.29995584152303399086e+27f, "22999558", 28},
  {1.74102277208833592010e+37f, "17410228", 38},
  {6.01275269218604080379e-06f, "60127527", -5},
  {4.87523162031461287924e-14f, "48752316", -13},
  {8.92317766556516289711e-05f, "8923178", -4},
  {6.29034240000000000000e+08f, "62903424", 9},
  {4.02029402874884613589e+27f, "4020294", 28},
  {3.22123782645098390334e-30f, "3221238", -29},
  {1.48767602166342117890e+35f, "1487676", 36},
  {3.27010038771282897912e-33f, "32701004", -32},
  {3.49216302552666731225e-32f, "3492163", -31},
  {1.14504972290955462352e+34f, "11450497", 35},
  {9.96315063480119144091e-31f, "9963151", -30},
  {2.22497604340787802357e-07f, "2224976", -6},
  {1.35973945344000000000e+11f, "135973945", 12},
  {5.26203393746982328594e-07f, "5262034", -6},
  {2.90063808593750000000e+04f, "2900638", 5},
  {1.89035684673229318070e+25f, "18903568", 26},
  {3.44918152562133080263e-26f, "34491815", -25},
  {1.80134611036844348541e-28f, "18013461", -27},
  {1.43431464960000000000e+10f, "14343146", 11},
  {8.16417582612480000000e+13f, "8164176", 14},
  {1.87812661034824158519e+32f, "18781266", 33},
  {3.06895035931033600000e+15f, "30689504", 16},
  {1.20771380462239381652e-29f, "12077138", -28},
  {2.68588962626381544396e-07f, "26858896", -6},
  {1.91251673771078057984e+20f, "19125167", 21},
  {5.98170595987318796254e+31f, "5981706", 32},
  {5.69063246096688027387e-15f, "56906325", -14},
  {2.79917628631665138528e-07f, "27991763", -6},
  {9.01152384301335380193e+28f, "9011524", 29},
  {1.88656655558868511886e-26f, "18865666", -25},
  {6.74765399111265651300e-09f, "6747654", -8},
  {7.61000763713746714717e-16f, "76100076", -15},
  {1.46872475743293762207e-01f, "14687248", 0},
  {9.85155100318045508039e+25f, "9851551", 26},
  {7.64764055636575186661e+31f, "76476406", 32},
  {8.17983051085158230364e-13f, "81798305", -12},
  {5.37562290377658387929e+34f, "5375623", 35},
  {1.65984381665132696972e+28f, "16598438", 29},
  {4.43451881437795236707e-07f, "44345188", -6},
  {2.57401102469805323963e-36f, "2574011", -35},
  {2.68783004298394506101e+23f, "268783", 24},
  {7.18688888549804687500e+01f, "7186889", 2},
  {9.62627600529231131077e-05f, "9626276", -4},
  {5.36297011421993374825e-05f, "536297", -4},
  {6.36824766932301212885e+33f, "63682477", 34},
  {1.48485496039138264209e-18f, "1484855", -17},
  {3.07816949046720604725e-31f, "30781695", -30},
  {1.14256841175180027542e-28f, "11425684", -27},
  {3.50298315268389459297e+30f, "35029832", 31},
  {4.06363537994830105805e+21f, "40636354", 22},
  {3.10322645202725374106e-35f, "31032265", -34},
  {1.46345220000000000000e+07f, "14634522", 8},
  {8.28899262863278724860e+30f, "82889926", 31},
  {1.38239609077572822571e-03f, "13823961", -2},
  {3.78547280327490298646e-12f, "3785473", -11},
  {6.70542749959044097638e+23f, "67054275", 24},
  {1.20106808084818139546e+21f, "12010681", 22},
  {1.79243687381810806784e+20f, "17924369", 21},
  {8.77311243059200000000e+13f, "87731124", 14},
  {3.83452267602157343630e+33f, "38345227", 34},
  {1.65745049531479420705e-27f, "16574505", -26},
  {1.04230383906480768842e+37f, "104230384", 38},
  {7.87727515216829488054e-07f, "7877275", -6},
  {2.76308280151026888769e+37f, "27630828", 38},
  {1.16981623821359493585e+30f, "116981624", 31},
  {1.07046314629666963456e+20f, "107046315", 21},
  {2.06825984801514553054e+33f, "20682598", 34},
  {2.80696456507492925440e+19f, "28069646", 20},
  {6.77626402314916848350e-26f, "6776264", -25},
  {8.66692002322577813424e+35f, "866692", 36},
  {1.06521826171875000000e+04f, "10652183", 5},
  {8.07085289766912000000e+14f, "8070853", 15},
  {1.12129583840214763768e-07f, "112129584", -6},
  {8.99751927497464463752e+37f, "8997519", 38},
  {7.13029580800000000000e+09f, "7130296", 10},
  {7.32422122950993070845e-08f, "7324221", -7},
  {1.91857667142832922144e-19f, "19185767", -18},
  {3.51920308745142272000e+17f, "3519203", 18},
  {1.39299365234375000000e+03f, "13929937", 4},
  {9.29978703367622763817e-28f, "9299787", -27},
  {1.94198536872863769531e+00f, "19419854", 1},
  {6.91798100000000000000e+06f, "6917981", 7},
  {2.18574197972218675200e+18f, "2185742", 19},
  {2.34946746502373571275e-08f, "23494675", -7},
  {1.28188562962835757970e-35f, "12818856", -34},
  {1.19338126061157484583e-32f, "119338126", -31},
  {2.23143017444295930346e-23f, "22314302", -22},
  {2.61682427364618875909e+24f, "26168243", 25},
  {3.56209284394478055880e+26f, "3562093", 27},
  {3.06257291219769597700e+29f, "3062573", 30},
  {1.43819826267286405120e+19f, "14381983", 20},
  {1.00118425792532646754e+38f, "10011843", 39},
  {4.68711549281454920894e+27f, "46871155", 28},
  {1.56554531096162975087e-26f, "15655453", -25},
  {3.92409831633464957487e+36f, "39240983", 37},
  {8.01859426534712934400e+18f, "8018594", 19},
  {2.69679802227835105514e+32f, "2696798", 33},
  {1.08451175763321080391e+31f, "10845118", 32},
  {3.15103530883789062500e-01f, "31510353", 0},
  {2.43160234098244125980e-32f, "24316023", -31},
  {1.36021332314727220489e+28f, "13602133", 29},
  {4.69664915084995220584e-36f, "4696649", -35},
  {3.32081925723418263552e+21f, "33208193", 22},
  {2.17653449641663943877e-18f, "21765345", -17},
  {6.08767952780990903478e-37f, "60876795", -36},
  {3.17863531051898462465e-08f, "31786353", -7},
  {2.60977815715840000000e+13f, "26097782", 14},
  {1.92617790291077807248e-17f, "19261779", -16},
  {1.62510630745813344393e-29f, "16251063", -28},
  {4.88058397076142845781e-23f, "4880584", -22},
  {2.93582024823990650475e-06f, "29358202", -5},
  {5.28077977600000000000e+09f, "528078", 10},
  {5.64117961984670538138e+22f, "56411796", 23},
  {9.27375635714088419710e-27f, "9273756", -26},
  {1.69856891161178945048e-37f, "16985689", -36},
  {1.20556537624672150569e+26f, "12055654", 27},
  {1.85861538280012593657e-20f, "18586154", -19},
  {6.31992140307243030585e-22f, "63199214", -21},
  {4.50923429888000000000e+11f, "45092343", 12},
  {9.38245574958572968916e-33f, "9382456", -32},
  {2.81032581456737274038e-31f, "28103258", -30},
  {8.93881590968703676481e-09f, "8938816", -8},
  {1.30907532479782446859e-33f, "13090753", -32},
  {2.19009478707271365804e+35f, "21900948", 36},
  {2.31183085937500000000e+04f, "23118309", 5},
  {7.07393329665029641630e-36f, "7073933", -35},
  {2.37986177980825600000e+15f, "23798618", 16},
  {8.38327873498201370239e-03f, "8383279", -2},
  {1.29264300029935015825e+34f, "1292643", 35},
  {1.08963266356779525000e-24f, "10896327", -23},
  {3.42690976562500000000e+04f, "34269098", 5},
  {2.44540667936214410592e+23f, "24454067", 24},
  {7.95370055296367286310e-22f, "79537006", -21},
  {1.65099609873188557518e-13f, "16509961", -12},
  {7.21423015454211919522e-34f, "721423", -33},
  {8.11198578389708200319e-20f, "8111986", -19},
  {8.75531282312855552000e+17f, "8755313", 18},
  {3.12766472905765683200e+18f, "31276647", 19},
  {2.41197402954101562500e+02f, "2411974", 3},
  {2.23614870134602524150e+27f, "22361487", 28},
  {2.49280296649579955523e+34f, "2492803", 35},
  {1.18265581590536433409e+35f, "11826558", 36},
  {1.61855295300483703613e-02f, "1618553", -1},
  {1.95241351768021401600e+18f, "19524135", 19},
  {1.46618827332865913014e-30f, "14661883", -29},
  {4.60525572299957275391e-01f, "46052557", 0},
  {3.28100875000000000000e+05f, "32810088", 6},
  {4.47482545809507747947e-12f, "44748255", -11},
  {4.80750807726161920000e+16f, "4807508", 17},
  {2.00329156909860648049e-22f, "20032916", -21},
  {6.68495613354025408626e-06f, "6684956", -5},
  {2.12693106486173460385e+24f, "2126931", 25},
  {2.93078656000000000000e+08f, "29307866", 9},
  {1.45169806480407714844e+00f, "14516981", 1},
  {6.36026909087397576704e+20f, "6360269", 21},
  {9.71182838229120486424e-27f, "9711828", -26},
  {1.66610620117187500000e+03f, "16661062", 4},
  {2.21551256254315376282e-03f, "22155126", -2},
  {1.35368130560000000000e+10f, "13536813", 11},
  {2.92472951114177703857e-02f, "29247295", -1},
  {3.99020326912000000000e+11f, "39902033", 12},
  {6.70720356498014432735e-25f, "67072036", -24},
  {1.03393771538310715432e-17f, "10339377", -16},
  {5.26725485054896607882e+28f, "5267255", 29},
  {1.71829433441162109375e+01f, "17182943", 2},
  {1.23962537283694995693e-12f, "12396254", -11},
  {5.76196410569681306956e-30f, "5761964", -29},
  {2.15856335137407135548e-20f, "21585634", -19},
  {5.29828254491626467088e-33f, "52982825", -32},
  {2.35074781184000000000e+11f, "23507478", 12},
  {6.89802243131031309796e-32f, "68980224", -31},
  {1.80521321783688818286e-37f, "18052132", -36},
  {3.80495280000000000000e+07f, "3804953", 8},
  {1.88082968750000000000e+05f, "18808297", 6},
  {5.95121751610967982080e+19f, "59512175", 20},
  {8.97377689298534400000e+15f, "8973777", 16},
  {1.22976545563181399435e-34f, "12297655", -33},
  {2.64987853979426618567e-14f, "26498785", -13},
  {5.88665013798057777399e-35f, "588665", -34},
  {9.51210343846503251968e+20f, "95121034", 21},
  {8.99451721191406250000e+02f, "8994517", 3},
  {6.17197044193744659424e-02f, "61719704", -1},
  {2.87471125000000000000e+06f, "28747112", 7},
  {3.73310632617982559820e-28f, "37331063", -27},
  {1.51715821138923106426e+37f, "15171582", 38},
  {2.63433459074535747391e-12f, "26343346", -11},
  {6.00132160492091587534e-16f, "60013216", -15},
  {3.37211380004882812500e+01f, "33721138", 2},
  {9.56612839441498762117e+23f, "95661284", 24},
  {1.25086970402569642918e+33f, "12508697", 34},
  {1.63812990534491495953e+38f, "16381299", 39},
  {5.04985742736607789993e-04f, "50498574", -3},
  {1.22192365053287395683e-30f, "122192365", -29},
  {2.45580266533342360071e-18f, "24558027", -17},
  {3.87630296513463007413e-14f, "3876303", -13},
  {3.48516454400000000000e+09f, "34851645", 10},
  {4.77454432000000000000e+08f, "47745443", 9},
  {3.63126273441594094038e-05f, "36312627", -4},
  {1.20391633324960105506e+28f, "12039163", 29},
  {4.21662843469824000000e+14f, "42166284", 15},
  {1.17114186258317720929e-32f, "117114186", -31},
  {1.34146530046830034256e+35f, "13414653", 36},
  {1.27693200230973440000e+16f, "1276932", 17},
  {7.27789170851840000000e+13f, "7277892", 14},
  {3.35900573730468750000e+01f, "33590057", 2},
  {1.00660161115229129791e-03f, "10066016", -2},
  {9.56309476052297213755e-10f, "9563095", -9},
  {6.95599500000000000000e+05f, "6955995", 6},
  {4.47549603979579726234e+21f, "4475496", 22},
  {9.53246217250125482678e-06f, "9532462", -5},
  {8.81374834227344194915e-13f, "88137483", -12},
  {5.86975113019095814937e-15f, "5869751", -14},
  {9.93407712329962156621e+31f, "9934077", 32},
  {4.24773050368700793010e+32f, "42477305", 33},
  {3.66389838745817542076e-04f, "36638984", -3},
  {2.09314247544577880366e+30f, "20931425", 31},
  {1.52410530084248322004e-18f, "15241053", -17},
  {3.41654040858371031040e+19f, "34165404", 20},
  {1.01624955561874230625e-07f, "101624956", -6},
  {2.06422244665766239479e-33f, "20642224", -32},
  {6.26063751249920000000e+13f, "62606375", 14},
  {2.42977797881849255646e-08f, "2429778", -7},
  {1.75867874145507812500e+02f, "17586787", 3},
  {1.25459353130446576681e+22f, "12545935", 23},
  {9.20309045657600000000e+12f, "920309", 13},
  {1.07565886658061671066e+27f, "10756589", 28},
  {5.81520431808257853845e-08f, "58152043", -7},
  {6.33148608112280207269e-18f, "6331486", -17},
  {5.35047816421186056383e-17f, "5350478", -16},
  {1.01212765096707461187e-18f, "10121277", -17},
  {4.39633548138420924544e+35f, "43963355", 36},
  {1.06403559574363981710e-10f, "10640356", -9},
  {1.88637821775927296399e-22f, "18863782", -21},
  {7.65547459379200000000e+12f, "76554746", 13},
  {1.12080093187410073419e-35f, "11208009", -34},
  {1.05568591892656947200e+18f, "10556859", 19},
  {1.11791912652466180790e-29f, "11179191", -28},
  {1.80156655460450565442e-06f, "18015666", -5},
  {1.02857624828989364929e-15f, "10285762", -14},
  {8.45198363441069039782e+30f, "84519836", 31},
  {2.81883486083944422898e+27f, "2818835", 28},
  {1.50665756672000000000e+11f, "15066576", 12},
  {6.98298158688701625808e-23f, "69829816", -22},
  {4.02283016368078979072e+20f, "402283", 21},
  {9.20892656250000000000e+04f, "92089266", 5},
  {4.00174035763200000000e+12f, "40017404", 13},
  {1.11510945792000000000e+12f, "11151095", 13},
  {2.24830115808736806217e+25f, "22483012", 26},
  {1.99304949433098954614e-07f, "19930495", -6},
  {1.65550058131835676251e-34f, "16555006", -33},
  {7.61655967800636955784e+30f, "76165597", 31},
  {1.78883012807251237478e-32f, "17888301", -31},
  {6.59065670333802700043e-04f, "65906567", -3},
  {1.78915911419608164579e-06f, "17891591", -5},
  {3.52490845802201668543e+28f, "35249085", 29},
  {8.81023047749209514225e-30f, "88102305", -29},
  {2.79965296057528539837e-18f, "2799653", -17},
  {3.00260296463608956794e-18f, "3002603", -17},
  {9.09688591121948775253e-09f, "9096886", -8},
  {2.52576230468750000000e+04f, "25257623", 5},
  {4.85833343505859375000e+02f, "48583334", 3},
  {5.61681170324623835199e-12f, "56168117", -11},
  {4.44461326124747936238e+32f, "44446133", 33},
  {1.54899187125966602240e+19f, "15489919", 20},
  {6.04011766426869040763e-38f, "60401177", -37},
  {8.18706198045213389131e+35f, "8187062", 36},
  {2.36053671687841415405e-02f, "23605367", -1},
  {1.06629207667496532366e-28f, "10662921", -27},
  {2.08789785460794519167e-09f, "20878979", -8},
  {3.94038368009619243008e+21f, "39403837", 22},
  {1.29613910847716948989e-36f, "12961391", -35},
  {8.53436569197553870599e-21f, "8534366", -20},
  {8.41643895910237915814e-07f, "8416439", -6},
  {1.41205465897127142945e-20f, "14120547", -19},
  {1.24439757820800289829e+37f, "12443976", 38},
  {9.43990632940447902041e+30f, "94399063", 31},
  {8.99743678464000000000e+11f, "8997437", 12},
  {4.02744700913554028495e+23f, "4027447", 24},
  {2.72419306012491695135e-15f, "2724193", -14},
  {2.44238190074920960000e+16f, "2442382", 17},
  {4.13131400963686400000e+15f, "4131314", 16},
  {7.39416394779368602030e-09f, "7394164", -8},
  {2.20438567205300449304e-26f, "22043857", -25},
  {1.07962953274436688560e-29f, "10796295", -28},
  {3.82610557029418848982e-19f, "38261056", -18},
  {3.05754740284915873996e-17f, "30575474", -16},
  {4.93463625517165382917e-09f, "49346363", -8},
  {1.91406417846679687500e+02f, "19140642", 3},
  {4.65334750412800000000e+13f, "46533475", 14},
  {1.93800850125368710246e+34f, "19380085", 35},
  {1.34155382045131156147e-34f, "13415538", -33},
  {3.51049345226177633923e-37f, "35104935", -36},
  {1.22391331218047463946e+28f, "12239133", 29},
  {3.24164273319327760908e+23f, "32416427", 24},
  {3.46393375254069196285e-36f, "34639338", -35},
  {1.41946150732378826510e+25f, "14194615", 26},
  {1.09864416695425151009e-17f, "10986442", -16},
  {6.24052947718853104507e-26f, "62405295", -25},
  {4.20504356566413917505e-23f, "42050436", -22},
  {6.02878967510281064658e-35f, "60287897", -34},
  {1.27713929982640268696e-23f, "12771393", -22},
  {5.63986395718529820442e-05f, "5639864", -4},
  {7.94676411896944046021e-03f, "7946764", -2},
  {3.00883602903923019767e-05f, "3008836", -4},
  {4.48763603344559669495e-05f, "4487636", -4},
  {1.44947713124565780163e-04f, "14494771", -3},
  {4.16904195627704199367e-13f, "4169042", -12},
  {5.45858610543744161981e-32f, "5458586", -31},
  {8.23983947226422357140e-20f, "82398395", -19},
  {1.87899461632000000000e+11f, "18789946", 12},
  {2.21071293385279168053e+23f, "2210713", 24},
  {5.62701287308231319417e+34f, "5627013", 35},
  {2.03426995807248222361e-36f, "203427", -35},
  {7.76593418998706351656e+35f, "7765934", 36},
  {8.20750818730756686086e-34f, "8207508", -33},
  {1.23954642682516701438e-16f, "12395464", -15},
  {3.44257352113768849686e-20f, "34425735", -19},
  {6.78724027238786220551e-04f, "678724", -3},
  {3.89720643873409339910e+24f, "38972064", 25},
  {2.58421666025564035949e+32f, "25842167", 33},
  {1.87197510825853896677e-08f, "18719751", -7},
  {7.96239818281255055161e+28f, "7962398", 29},
  {1.51526274791607152139e+34f, "15152627", 35},
  {3.23547147106747733374e-19f, "32354715", -18},
  {3.79134672896000000000e+13f, "37913467", 14},
  {8.56147446945391858470e+36f, "85614745", 37},
  {6.03905888099531550034e-33f, "6039059", -32},
  {6.89902052707281142008e+34f, "68990205", 35},
  {7.34013068558536860766e-28f, "73401307", -27},
  {4.29769330400785518455e-17f, "42976933", -16},
  {1.58914797553783015971e-12f, "1589148", -11},
  {4.02507326910627840000e+17f, "40250733", 18},
  {7.53982504829764366150e-03f, "7539825", -2},
  {8.11849211832295017677e+21f, "8118492", 22},
  {2.41302351182122036474e-26f, "24130235", -25},
  {1.81342083849171272661e+32f, "18134208", 33},
  {4.89952552959455585505e-30f, "48995255", -29},
  {2.14034443988864949812e-19f, "21403444", -18},
  {2.11653430060258295411e-26f, "21165343", -25},
  {1.41661412374194683904e+20f, "14166141", 21},
  {6.91912734872047260587e-35f, "69191273", -34},
  {1.57160275108893117675e-30f, "157160275", -29},
  {4.80500618495200560415e+22f, "4805006", 23},
  {7.54918663036841477992e-38f, "75491866", -37},
  {2.18714545593306949218e-25f, "21871455", -24},
  {8.55642117558352297872e-33f, "8556421", -32},
  {4.06710257380998172032e-19f, "40671026", -18},
  {2.48707051520000000000e+10f, "24870705", 11},
  {5.07164449496942541634e+30f, "50716445", 31},
  {1.51815196526039043060e-25f, "1518152", -24},
  {6.40946025469220250871e-37f, "64094603", -36},
  {5.93366209773409665024e+20f, "5933662", 21},
  {3.04091906190490244685e-30f, "3040919", -29},
  {3.31963527859740028299e-17f, "33196353", -16},
  {3.30434304487425833941e-05f, "3304343", -4},
  {3.79058959672656161433e-32f, "37905896", -31},
  {3.36385364008151555026e-11f, "33638536", -10},
  {3.24779358962246078590e-09f, "32477936", -8},
  {4.59083099313977951816e-21f, "4590831", -20},
  {2.34226024448000000000e+11f, "23422602", 12},
  {3.08576098007051768946e-09f, "3085761", -8},
  {1.15580425000000000000e+06f, "11558042", 7},
  {1.28137930821559109518e-10f, "12813793", -9},
  {3.92885159991408422274e+27f, "39288516", 28},
  {1.32525631094115858843e-11f, "13252563", -10},
  {5.03726837158203125000e+02f, "50372684", 3},
  {1.00613406347084431360e+21f, "100613406", 22},
  {1.07354698702692985535e-02f, "1073547", -1},
  {1.83398049746577323459e+22f, "18339805", 23},
  {3.48415191103774029189e+33f, "3484152", 34},
  {2.19213868513901977398e-21f, "21921387", -20},
  {2.13366534278082595041e+26f, "21336653", 27},
  {8.03046456096901097227e-36f, "80304646", -35},
  {1.47255101601554249343e-37f, "1472551", -36},
  {2.45654759563360776035e+27f, "24565476", 28},
  {2.94752311033283821633e-22f, "2947523", -21},
  {1.92703291073661240542e-31f, "19270329", -30},
  {1.46728392810317356788e-30f, "14672839", -29},
  {1.13865353836164299653e+27f, "113865354", 28},
  {1.66266137834848363665e+38f, "16626614", 39},
  {3.68668939622841584708e-17f, "36866894", -16},
  {1.22290317437795640800e+29f, "12229032", 30},
  {1.44596695003984560128e+20f, "144596695", 21},
  {1.87111091065617074491e-08f, "18711109", -7},
  {5.62077454258564938178e-27f, "56207745", -26},
  {6.89814212088539314564e-24f, "6898142", -23},
  {1.12082943320274353027e-01f, "11208294", 0},
  {3.03257102966308593750e+01f, "3032571", 2},
  {3.74564700000000000000e+06f, "3745647", 7},
  {8.27438248576942080000e+16f, "82743825", 17},
  {1.03370145163744563081e-26f, "103370145", -25},
  {1.91770246185056555270e+36f, "19177025", 37},
  {1.38840293818445368809e-16f, "1388403", -15},
  {2.17634811401367187500e+02f, "21763481", 3},
  {9.95738527737024796951e+24f, "9957385", 25},
  {2.94663782400000000000e+11f, "29466378", 12},
  {1.60618227961100093965e-34f, "16061823", -33},
  {1.45460720000000000000e+07f, "14546072", 8},
  {4.56315246085251853501e-30f, "45631525", -29},
  {4.98195791991204140462e+26f, "4981958", 27},
  {6.88687057495117187500e+01f, "68868706", 2},
  {1.58264005199748591934e-12f, "158264", -11},
  {1.39935730368512000000e+14f, "13993573", 15},
  {9.24295703125000000000e+04f, "9242957", 5},
  {3.80100673158523250095e-11f, "38010067", -10},
  {5.05085357666015625000e+02f, "50508536", 3},
  {4.25554107841995236966e+21f, "4255541", 22},
  {1.23072229325771331787e-03f, "12307223", -2},
  {1.25962330112000000000e+11f, "12596233", 12},
  {7.05184614400000000000e+09f, "7051846", 10},
  {2.96559737762436270714e-04f, "29655974", -3},
  {7.53702771243363606394e+32f, "7537028", 33},
  {1.18540668487548828125e+00f, "11854067", 1},
  {6.21700648315955227036e-23f, "62170065", -22},
  {2.01359907887150788031e-14f, "2013599", -13},
  {1.05825370112000000000e+12f, "10582537", 13},
  {7.25255659972390276380e-08f, "72525566", -7},
  {3.65782109533452552372e+23f, "3657821", 24},
  {4.70538889929614036210e-26f, "4705389", -25},
  {4.26561283203310627595e+37f, "4265613", 38},
  {4.34743309020996093750e+01f, "4347433", 2},
  {8.07110996960125337552e-14f, "807111", -13},
  {1.20092404754749711939e+35f, "1200924", 36},
  {9.72662443534348565086e+23f, "97266244", 24},
  {2.77337352415257369256e+27f, "27733735", 28},
  {1.74152522814305651917e+21f, "17415252", 22},
  {4.10428619943559169769e-04f, "41042862", -3},
  {7.25344272937171481065e+31f, "72534427", 32},
  {3.51910792173448783160e-11f, "3519108", -10},
  {2.95498281250000000000e+05f, "29549828", 6},
  {5.15722674453914583040e+19f, "51572267", 20},
  {4.07305582525849555011e+29f, "4073056", 30},
  {7.57494301112904575582e+31f, "7574943", 32},
  {1.05779681689455173910e-05f, "10577968", -4},
  {5.17453954671509563923e-05f, "51745395", -4},
  {4.07099213214657091014e-18f, "4070992", -17},
  {9.03519629104083305468e+35f, "9035196", 36},
  {3.17189458931039861952e-22f, "31718946", -21},
  {8.26439050205331456000e+17f, "82643905", 18},
  {1.60049056000000000000e+08f, "16004906", 9},
  {3.52741960591407313720e+26f, "35274196", 27},
  {3.40871209836687781153e-25f, "3408712", -24},
  {1.73276336669921875000e+02f, "17327634", 3},
  {6.02620980460349953134e-13f, "602621", -12},
  {3.39506445179438287596e-09f, "33950645", -8},
  {5.47994511612126003747e+26f, "5479945", 27},
  {1.06349283434822458167e+38f, "10634928", 39},
  {3.92707672539221479916e+22f, "39270767", 23},
  {2.72257957888000000000e+11f, "27225796", 12},
  {6.91754978164622945275e-27f, "691755", -26},
  {2.46113050206514918195e+21f, "24611305", 22},
  {1.73127635898241347637e-26f, "17312764", -25},
  {9.31452289223670959473e-02f, "9314523", -1},
  {4.28854855327547392000e+17f, "42885486", 18},
  {2.59019379902916673518e+36f, "25901938", 37},
  {3.66180826980033735651e-13f, "36618083", -12},
  {9.81509208679199218750e-01f, "9815092", 0},
  {1.55426107539824442938e-06f, "15542611", -5},
  {3.79089152226552576612e-20f, "37908915", -19},
  {5.80432793781746182460e+27f, "5804328", 28},
  {7.47344019836840753202e+37f, "747344", 38},
  {3.05652038786796375820e+38f, "30565204", 39},
  {3.36054596474503168000e+18f, "3360546", 19},
  {8.23650892756294754492e+30f, "8236509", 31},
  {4.51254572908510453999e-06f, "45125457", -5},
  {2.38434317938698785234e-25f, "23843432", -24},
  {4.64707143243130375851e-26f, "46470714", -25},
  {5.74589531510127926595e-09f, "57458953", -8},
  {1.23000338803080921934e-08f, "12300034", -7},
  {6.24389875877186442966e+30f, "6243899", 31},
  {1.47585602518078696693e+38f, "1475856", 39},
  {6.06696953136403609556e-21f, "60669695", -20},
  {2.89620410372006830011e-33f, "28962041", -32},
  {3.48346176147460937500e+01f, "34834618", 2},
  {5.85016750000000000000e+05f, "58501675", 6},
  {1.66255410294979810715e-03f, "16625541", -2},
  {2.70556146930722718480e-11f, "27055615", -10},
  {8.95196015625000000000e+04f, "895196", 5},
  {9.44309710407963172160e-20f, "9443097", -19},
  {9.87632775448741719398e-39f, "9876328", -38},
  {1.03503506333237248000e+17f, "10350351", 18},
  {3.35584503270011806743e-37f, "3355845", -36},
  {3.04944074489376486225e-26f, "30494407", -25},
  {1.27499856798790442723e-23f, "12749986", -22},
  {2.34672549036231229440e+19f, "23467255", 20},
  {1.13933272907460819499e-28f, "11393327", -27},
  {7.87048339843750000000e+02f, "78704834", 3},
  {3.34796473857693595655e-20f, "33479647", -19},
  {2.88047324218750000000e+04f, "28804732", 5},
  {4.57076884548788997325e+21f, "45707688", 22},
  {2.77551966193839497173e-31f, "27755197", -30},
  {3.10292236328125000000e+03f, "31029224", 4},
  {2.04508824996363947213e+21f, "20450882", 22},
  {1.44278838365905786287e+26f, "14427884", 27},
  {3.47736749972682446241e-05f, "34773675", -4},
  {1.26736902085696888945e-23f, "1267369", -22},
  {4.78547461306502285194e-38f, "47854746", -37},
  {2.60008256000000000000e+08f, "26000826", 9},
  {1.22272010000000000000e+07f, "12227201", 8},
  {9.94587239233624131884e-08f, "99458724", -7},
  {2.33720898628234863281e+00f, "2337209", 1},
  {2.50076225000000000000e+06f, "25007622", 7},
  {1.00281917440000000000e+11f, "10028192", 12},
  {1.09927300000000000000e+06f, "1099273", 7},
  {1.26320127572132068134e-31f, "12632013", -30},
  {8.33864157686422175292e-23f, "83386416", -22},
  {2.63431681215167662476e-36f, "26343168", -35},
  {5.56780258193612098694e-04f, "55678026", -3},
  {1.14581475402611215565e+21f, "114581475", 22},
  {4.14320739844622662994e-17f, "41432074", -16},
  {9.67026862781494855881e-04f, "96702686", -3},
  {1.72185674309730529785e-01f, "17218567", 0},
  {2.26844528878884614531e-15f, "22684453", -14},
  {4.98287616000000000000e+09f, "4982876", 10},
  {3.67102162632704000000e+14f, "36710216", 15},
  {7.45904774567623651176e-35f, "7459048", -34},
  {9.50750167443953418240e+19f, "9507502", 20},
  {3.89934298860431674428e-22f, "3899343", -21},
  {3.96208528454365552056e-16f, "39620853", -15},
  {3.71829887910982322119e-15f, "3718299", -14},
  {3.02376368788577820091e+38f, "30237637", 39},
  {1.77580172788793788641e-08f, "17758017", -7},
  {1.93329950187682756235e+27f, "19332995", 28},
  {8.91031275300741709824e+20f, "8910313", 21},
  {3.57949566164608279875e-21f, "35794957", -20},
  {9.44339496664833323841e-17f, "9443395", -16},
  {1.89369759625934368664e+36f, "18936976", 37},
  {2.91172939367950265094e-20f, "29117294", -19},
  {4.15379506948941444825e+30f, "4153795", 31},
  {3.08388769531250000000e+04f, "30838877", 5},
  {4.79078973440000000000e+11f, "47907897", 12},
  {1.34631079617975046858e-08f, "13463108", -7},
  {1.08518195868137990552e-28f, "1085182", -27},
  {6.67340135275771857270e-17f, "66734014", -16},
  {2.46616496282693642819e+36f, "2466165", 37},
  {2.29673058449687836167e-21f, "22967306", -20},
  {8.88648986816406250000e-01f, "888649", 0},
  {7.12514306519539626565e-39f, "7125143", -38},
  {2.10548406878208000000e+14f, "2105484", 15},
  {1.49046024641477166500e-18f, "14904602", -17},
  {6.10005401518414326709e-17f, "6100054", -16},
  {2.98178299928113626159e-28f, "2981783", -27},
  {4.04304367340675399680e+19f, "40430437", 20},
  {2.30839260000000000000e+07f, "23083926", 8},
  {2.41530405368809652224e+20f, "2415304", 21},
  {2.13634957617614418268e-05f, "21363496", -4},
  {2.64582742016000000000e+11f, "26458274", 12},
  {3.08028869628906250000e+01f, "30802887", 2},
  {1.36503348428800000000e+12f, "13650335", 13},
  {1.77520217872111352953e+34f, "17752022", 35},
  {1.90699684751613334242e+25f, "19069968", 26},
  {5.60035856384000000000e+11f, "56003586", 12},
  {4.32277802962788282315e-13f, "4322778", -12},
  {5.39550778654720000000e+13f, "53955078", 14},
  {7.28685847661836305633e-07f, "72868585", -6},
  {2.56594218750000000000e+05f, "25659422", 6},
  {8.20576537277687627349e+35f, "8205765", 36},
  {1.81870973836595339890e-09f, "18187097", -8},
  {1.24748700871846208209e+24f, "1247487", 25},
  {4.63744623244353663929e+27f, "46374462", 28},
  {9.52828273824507379986e+33f, "9528283", 34},
  {8.66589951328933238983e-04f, "86658995", -3},
  {9.10750152851377215221e-20f, "91075015", -19},
  {1.47125074987009052078e-33f, "147125075", -32},
  {9.11706960341395046400e+18f, "91170696", 19},
  {3.25128050210204783314e-22f, "32512805", -21},
  {5.62014036739312767069e-16f, "56201404", -15},
  {1.18872429463505019892e-20f, "11887243", -19},
  {4.83449960020263079567e-22f, "48344996", -21},
  {1.87323264496925915118e+37f, "18732326", 38},
  {2.94526219367980957031e+00f, "29452622", 1},
  {4.96160793304443359375e+00f, "4961608", 1},
  {7.81342706663887038703e-30f, "7813427", -29},
  {1.70057141153238881798e-19f, "17005714", -18},
  {1.59380588805534182278e-31f, "15938059", -30},
  {2.97067679380900856985e+29f, "29706768", 30},
  {5.54105542017024000000e+14f, "55410554", 15},
  {7.10847186618810368000e+18f, "7108472", 19},
  {1.34106059590521908831e-08f, "13410606", -7},
  {1.10055139914549959812e-12f, "11005514", -11},
  {1.76043126161408000000e+14f, "17604313", 15},
  {3.75178333773023318435e-22f, "37517833", -21},
  {1.04532050522768881278e+38f, "10453205", 39},
  {1.08337276556981974176e-37f, "10833728", -36},
  {3.30913884883215158892e+30f, "33091388", 31},
  {1.04721394222906383220e-07f, "104721394", -6},
  {4.65441100000000000000e+06f, "4654411", 7},
  {3.81258664195792837822e+27f, "38125866", 28},
  {3.22964185615823462728e+22f, "32296419", 23},
  {8.50554648934576107422e-09f, "85055465", -8},
  {2.54532861611212800000e+16f, "25453286", 17},
  {4.45269430058876928000e+17f, "44526943", 18},
  {1.18617648316619131243e+27f, "11861765", 28},
  {3.63204476991704288865e+35f, "36320448", 36},
  {1.09908835696502158393e+23f, "10990884", 24},
  {1.58823260000000000000e+07f, "15882326", 8},
  {1.68367704662920160755e-25f, "1683677", -24},
  {8.48111474630282551016e-32f, "8481115", -31},
  {3.18686042851126582266e+25f, "31868604", 26},
  {1.31865327546165644890e-08f, "13186533", -7},
  {2.28300343485179106997e-33f, "22830034", -32},
  {1.27351932168243142662e-13f, "12735193", -12},
  {1.02453404630016197545e+31f, "1024534", 32},
  {2.84523807218695200213e-24f, "2845238", -23},
  {3.54146000000000000000e+06f, "354146", 7},
  {2.76748205615330093500e+38f, "2767482", 39},
  {1.22843632049591938755e-33f, "12284363", -32},
  {2.87491936528240421604e-18f, "28749194", -17},
  {2.69318748666173849600e+18f, "26931875", 19},
  {2.72371596656739711761e-03f, "2723716", -2},
  {5.01262208000000000000e+08f, "5012622", 9},
  {6.76558272516558645293e-07f, "6765583", -6},
  {1.64138231791616000000e+14f, "16413823", 15},
  {7.35590800000000000000e+07f, "7355908", 8},
  {1.19849019029061309993e-05f, "11984902", -4},
  {7.71488437500000000000e+05f, "77148844", 6},
  {1.00275446743696368537e-38f, "10027545", -37},
  {7.90206385173223313443e-38f, "7902064", -37},
  {3.85814291803399100900e-06f, "3858143", -5},
  {5.90411913157099263099e+22f, "5904119", 23},
  {1.08610294091704417951e-07f, "108610294", -6},
  {1.43820600082315395520e-28f, "1438206", -27},
  {3.54446754455566406250e+01f, "35444675", 2},
  {1.88493950106583106245e-19f, "18849395", -18},
  {7.48091070082233292653e-32f, "74809107", -31},
  {5.55032441786952081275e-15f, "55503244", -14},
  {5.05039497149062236693e+26f, "5050395", 27},
  {1.98740585321098380862e-18f, "19874059", -17},
  {7.64400951425159291830e-08f, "76440095", -7},
  {2.25081284362240000000e+13f, "22508128", 14},
  {4.21229048627200000000e+12f, "42122905", 13},
  {2.75657176971435546875e-02f, "27565718", -1},
  {6.31045000000000000000e+04f, "631045", 5},
  {1.30538148986880000000e+13f, "13053815", 14},
  {2.28241050000000000000e+06f, "22824105", 7},
  {2.54341347656250000000e+04f, "25434135", 5},
  {2.48719398319790489600e+18f, "2487194", 19},
  {1.08048416589541765517e+27f, "10804842", 28},
  {9.54991796244393205753e-17f, "9549918", -16},
  {9.74876121052208397455e-24f, "9748761", -23},
  {7.87579920142889022827e-04f, "7875799", -3},
  {1.02610548272660480000e+16f, "10261055", 17},
  {2.59783349293893530437e+29f, "25978335", 30},
  {8.22891791132124954950e-35f, "8228918", -34},
  {1.72675063065057249374e-28f, "17267506", -27},
  {2.71230674115940928459e-04f, "27123067", -3},
  {1.50427506979499263443e-34f, "15042751", -33},
  {2.24675539897614481465e-27f, "22467554", -26},
  {1.77843433939972059254e+29f, "17784343", 30},
  {1.39260314940955956335e+27f, "13926031", 28},
  {3.97427539062500000000e+04f, "39742754", 5},
  {3.63622742325861776260e-38f, "36362274", -37},
  {7.17457135368526621733e-11f, "71745714", -10},
  {1.17955038848356324475e+24f, "11795504", 25},
  {4.19669679896107369355e-31f, "4196697", -30},
  {6.31510054993920000000e+13f, "63151005", 14},
  {8.70413565952000000000e+11f, "87041357", 12},
  {1.40821854177630712002e-10f, "14082185", -9},
  {6.63944482472970663682e-33f, "6639445", -32},
  {2.64707299726637049209e-14f, "2647073", -13},
  {8.46490277878418754600e-37f, "8464903", -36},
  {3.01714218750000000000e+04f, "30171422", 5},
  {1.79390787028712792028e-14f, "17939079", -13},
  {8.81621800000000000000e+06f, "8816218", 7},
  {5.61398353672433389563e-22f, "56139835", -21},
  {6.84880534435497758592e+30f, "68488053", 31},
  {3.23794251524057580824e-28f, "32379425", -27},
  {2.33314895923806306034e+35f, "2333149", 36},
  {1.01116289980280340480e+19f, "10111629", 20},
  {5.04956005897838622332e-06f, "504956", -5},
  {3.03310989896753107133e-27f, "30331099", -26},
  {1.13109913705073773555e-23f, "11310991", -22},
  {7.38584744764026061872e-29f, "73858474", -28},
  {1.14116428726681296710e-36f, "11411643", -35},
  {1.53777606312735882386e-19f, "1537776", -18},
  {2.03484590211181877532e-18f, "2034846", -17},
  {5.08696362376213073730e-02f, "50869636", -1},
  {3.51803318532459448342e-15f, "35180332", -14},
  {7.45622173781157471240e-07f, "7456222", -6},
  {1.27342233979810259825e-11f, "12734223", -10},
  {7.14356151247996035457e-27f, "71435615", -26},
  {4.72284179041195635018e+36f, "47228418", 37},
  {7.54870957409004006422e-11f, "75487096", -10},
  {8.56316528320312500000e+01f, "8563165", 2},
  {8.15995676009215033344e+21f, "8159957", 22},
  {5.31581090763211250305e-03f, "5315811", -2},
  {7.49659961371773543664e-24f, "74966", -23},
  {1.00037477750447578728e-05f, "10003748", -4},
  {1.21511405661531614944e+26f, "12151141", 27},
  {8.39721084229637850936e-18f, "8397211", -17},
  {4.33101236579105505280e+19f, "43310124", 20},
  {1.67931684902092616699e+28f, "16793168", 29},
  {4.06850227009573276164e+25f, "40685023", 26},
  {1.10646509810917951791e-33f, "11064651", -32},
  {2.13214341783896088600e-04f, "21321434", -3},
  {3.31560292455482026714e-35f, "3315603", -34},
  {1.18764029729362424636e+36f, "11876403", 37},
  {1.13246490000000000000e+07f, "11324649", 8},
  {9.18602430888711878295e-39f, "9186024", -38},
  {1.69629658193592320000e+16f, "16962966", 17},
  {7.86977120888156058999e-38f, "7869771", -37},
  {5.36008066531339313671e-27f, "53600807", -26},
  {3.23004741582808566589e+31f, "32300474", 32},
  {9.18164856495757020370e-28f, "9181649", -27},
  {9.72542828266745688737e-25f, "9725428", -24},
  {6.53268734899943933776e-27f, "6532687", -26},
  {3.12242974587206845172e-07f, "31224297", -6},
  {7.93214346854400000000e+12f, "79321435", 13},
  {3.88937722891569137573e-03f, "38893772", -2},
  {3.62353751883164136275e+25f, "36235375", 26},
  {1.46112908828476948248e-37f, "14611291", -36},
  {4.71060736000000000000e+09f, "47106074", 10},
  {2.49319905875178490429e+23f, "2493199", 24},
  {1.72350311800073541235e-09f, "17235031", -8},
  {5.79498309125773851044e-28f, "5794983", -27},
  {2.88945350000000000000e+06f, "28894535", 7},
  {1.49969623863831442913e+27f, "14996962", 28},
  {7.12872198337793916423e-13f, "7128722", -12},
  {3.97084348355474083096e-38f, "39708435", -37},
  {2.50786210643968000000e+14f, "25078621", 15},
  {9.54442752000000000000e+08f, "95444275", 9},
  {2.74920444849855397888e+20f, "27492044", 21},
  {6.05233105468750000000e+03f, "6052331", 4},
  {5.58310348424129188061e-05f, "55831035", -4},
  {5.02606445392716241673e+25f, "50260645", 26},
  {2.08299048555288021547e+38f, "20829905", 39},
  {3.01679760217666625977e-01f, "30167976", 0},
  {8.20686636640083210404e+22f, "8206866", 23},
  {3.30149450000000000000e+06f, "33014945", 7},
  {4.97044891119003295898e-01f, "4970449", 0},
  {1.96943724155426025391e+00f, "19694372", 1},
  {4.18756120000000000000e+07f, "41875612", 8},
  {4.52736090112000000000e+11f, "4527361", 12},
  {9.31008798943366855383e-08f, "9310088", -7},
  {6.38544951243702272000e+18f, "63854495", 19},
  {7.05152479308670251072e+25f, "7051525", 26},
  {1.03078828125000000000e+05f, "10307883", 6},
  {2.73723371125019211786e-27f, "27372337", -26},
  {8.13168525695800781250e-01f, "8131685", 0},
  {5.88393880257623514362e-37f, "5883939", -36},
  {1.66694824308929944914e+37f, "16669482", 38},
  {1.88812160491943359375e+01f, "18881216", 2},
  {4.56570273792000000000e+11f, "45657027", 12},
  {5.74925137420480833126e+21f, "57492514", 22},
  {5.22613554330961810783e+30f, "52261355", 31},
  {4.13966914580223906284e+22f, "4139669", 23},
  {2.32139463901548381841e-11f, "23213946", -10},
  {1.14565208347980595200e+19f, "11456521", 20},
  {4.19897114543104465543e-29f, "4198971", -28},
  {1.49507572988483161680e-10f, "14950757", -9},
  {3.90648528991732746363e-06f, "39064853", -5},
  {6.64623332958037606400e+18f, "66462333", 19},
  {5.79184791804951913887e-29f, "5791848", -28},
  {3.99215467410910252675e+36f, "39921547", 37},
  {5.25525823030462460191e-25f, "5255258", -24},
  {4.80649135976349172340e+35f, "48064914", 36},
  {1.14709282905391152940e+36f, "11470928", 37},
  {2.59900361932800000000e+13f, "25990036", 14},
  {5.65418752849855119360e+19f, "56541875", 20},
  {5.32573681640625000000e+03f, "5325737", 4},
  {1.89416889441396151818e-26f, "18941689", -25},
  {1.62848029470291965072e-19f, "16284803", -18},
  {3.12660402367306360677e-28f, "3126604", -27},
  {1.34503454430174279788e+24f, "13450345", 25},
  {2.33972013465600000000e+12f, "23397201", 13},
  {3.06271193866695165935e+29f, "3062712", 30},
  {1.32997128192000000000e+11f, "13299713", 12},
  {3.46614273618371207162e-22f, "34661427", -21},
  {1.22410043955834555961e-36f, "12241004", -35},
  {1.57691412357159621379e-28f, "15769141", -27},
  {3.25547657568813088523e-20f, "32554766", -19},
  {2.80872424631474083697e-38f, "28087242", -37},
  {4.78775771136000000000e+11f, "47877577", 12},
  {2.36043113845929485567e+30f, "23604311", 31},
  {2.66747710533195467325e+22f, "2667477", 23},
  {3.62997680664062500000e+03f, "36299768", 4},
  {1.37768860647424000000e+14f, "13776886", 15},
  {8.13771942383185726915e-28f, "8137719", -27},
  {5.63198493202039698457e-17f, "5631985", -16},
  {9.79953519129482265362e+23f, "9799535", 24},
  {2.06665782928466796875e+01f, "20666578", 2},
  {3.74205854662000640000e+16f, "37420585", 17},
  {8.70292871093750000000e+03f, "8702929", 4},
  {1.97754716160000000000e+11f, "19775472", 12},
  {2.16779582341120000000e+14f, "21677958", 15},
  {7.68429572638113792000e+17f, "7684296", 18},
  {1.26517376000000000000e+08f, "12651738", 9},
  {3.48068315136000000000e+11f, "3480683", 12},
  {2.69766946559002462891e-08f, "26976695", -7},
  {1.03160457606832345334e-11f, "10316046", -10},
  {2.59154671595511637360e-24f, "25915467", -23},
  {8.36185312500000000000e+04f, "8361853", 5},
  {2.57675824000000000000e+08f, "25767582", 9},
  {1.26728217763466544099e-13f, "12672822", -12},
  {1.61643143314904591534e-10f, "16164314", -9},
  {8.60343058792102822820e-19f, "86034306", -18},
  {5.54571614507523171080e-23f, "5545716", -22},
  {3.11239655366195042981e-38f, "31123966", -37},
  {5.06454929709434509277e-02f, "50645493", -1},
  {1.13479696545799447241e-20f, "1134797", -19},
  {7.61574522361927886569e-28f, "7615745", -27},
  {2.62536747915673600000e+17f, "26253675", 18},
  {5.06692133782256686159e-20f, "50669213", -19},
  {6.14792915351806096179e+22f, "6147929", 23},
  {9.03965312000000000000e+08f, "9039653", 9},
  {1.92820892832017405309e-36f, "1928209", -35},
  {3.18276085825228149950e-13f, "31827609", -12},
  {1.82251976444869540940e-16f, "18225198", -15},
  {2.66541481295530012174e-25f, "26654148", -24},
  {3.03731763200000000000e+09f, "30373176", 10},
  {2.49038846081875861139e-31f, "24903885", -30},
  {8.89785556140032000000e+14f, "88978556", 15},
  {1.65185966576227027947e-13f, "16518597", -12},
  {3.64253446144000000000e+11f, "36425345", 12},
  {2.31791907716327738598e-13f, "2317919", -12},
  {4.68623241374399638727e-38f, "46862324", -37},
  {3.86070259095205869926e-10f, "38607026", -9},
  {4.94485152326727921363e+33f, "49448515", 34},
  {2.76981927116800000000e+12f, "27698193", 13},
  {1.73373948954975141888e+21f, "17337395", 22},
  {7.34142778324411342597e-17f, "7341428", -16},
  {1.13027753596055814269e+27f, "11302775", 28},
  {1.98321244951511765908e-13f, "19832124", -12},
  {3.14972777463758226035e+30f, "31497278", 31},
  {2.00671447798155797482e-25f, "20067145", -24},
  {5.10238088232960000000e+15f, "5102381", 16},
  {3.96195143699949039173e-27f, "39619514", -26},
  {1.85177784217671614897e-09f, "18517778", -8},
  {2.62437942193029120000e+16f, "26243794", 17},
  {3.17281320960000000000e+10f, "31728132", 11},
  {3.57125708800000000000e+09f, "3571257", 10},
  {3.32359769372088896981e+27f, "33235977", 28},
  {1.21401907623996940799e-11f, "12140191", -10},
  {3.03515206620192992380e+28f, "3035152", 29},
  {2.70718156800000000000e+11f, "27071816", 12},
  {1.79751730072455226579e+36f, "17975173", 37},
  {9.19743812239347091999e+30f, "9197438", 31},
  {1.45633075792763961337e+37f, "14563308", 38},
  {4.32354148839849144059e-19f, "43235415", -18},
  {3.39823514942421242893e-33f, "3398235", -32},
  {5.98573520000000000000e+07f, "5985735", 8},
  {1.82867887499327252954e-11f, "18286789", -10},
  {4.96842247809838088192e+20f, "49684225", 21},
  {1.60556103448914046142e+33f, "1605561", 34},
  {6.83908339798659243361e-39f, "6839083", -38},
  {1.67908917870184960377e-31f, "16790892", -30},
  {1.27749408045060710275e+34f, "12774941", 35},
  {5.77403236334816938324e-10f, "57740324", -9},
  {1.20933824228335533950e-36f, "12093382", -35},
  {4.99877160000000000000e+07f, "49987716", 8},
  {1.38011417591060176017e-27f, "13801142", -26},
  {1.37134769685742785583e-14f, "13713477", -13},
  {8.03107905085198581219e-05f, "8031079", -4},
  {4.54047098755836486816e-02f, "4540471", -1},
  {6.20636317182631037908e-23f, "6206363", -22},
  {2.69850035200000000000e+09f, "26985004", 10},
  {3.27957852641059275778e-25f, "32795785", -24},
  {4.07020979420469330989e-11f, "40702098", -10},
  {2.87900272741694479264e-39f, "2879003", -38},
  {1.32181757938615502447e+30f, "13218176", 31},
  {2.11882585248880405981e+38f, "21188259", 39},
  {4.09721548800000000000e+09f, "40972155", 10},
  {6.38774144442512179200e+18f, "63877414", 19},
  {3.48130747319930211603e-12f, "34813075", -11},
  {1.80034354329109191895e-01f, "18003435", 0},
  {2.52361309627247010212e-09f, "2523613", -8},
  {8.99668421629629816438e-15f, "8996684", -14},
  {2.33603580923613662890e-09f, "23360358", -8},
  {5.01861018020743898660e-11f, "50186102", -10},
  {6.60630312500000000000e+05f, "6606303", 6},
  {1.32513674907386302948e-03f, "13251367", -2},
  {5.01208487622069453756e+35f, "5012085", 36},
  {1.96880328103144334724e+33f, "19688033", 34},
  {8.81174443335482256848e-22f, "8811744", -21},
  {1.10611944793537464292e+30f, "110611945", 31},
  {2.85191024571888141386e+33f, "28519102", 34},
  {2.47710245327922851111e-14f, "24771025", -13},
  {1.91042275376707258821e+25f, "19104228", 26},
  {2.37761788305279522099e-15f, "23776179", -14},
  {4.91342556918628048379e-12f, "49134256", -11},
  {1.39721009873028378934e-06f, "13972101", -5},
  {5.11219957843422889709e-04f, "51121996", -3},
  {1.12642102394880000000e+13f, "1126421", 14},
  {1.76371096879126202705e+28f, "1763711", 29},
  {3.89403880980528684243e+33f, "38940388", 34},
  {1.15113869320040161319e+29f, "11511387", 30},
  {6.48425072431564331055e-02f, "6484251", -1},
  {1.71314741129517318378e-30f, "17131474", -29},
  {6.27297264290990215135e-21f, "62729726", -20},
  {8.01499113440513610840e-02f, "8014991", -1},
  {1.85803223662414739099e-21f, "18580322", -20},
  {4.69495829142151998871e-31f, "46949583", -30},
  {3.49032462070631628800e+18f, "34903246", 19},
  {1.05975137500000000000e+06f, "10597514", 7},
  {1.36783650000000000000e+07f, "13678365", 8},
  {1.17921553335506976762e-29f, "11792155", -28},
  {1.61857229809550314433e+30f, "16185723", 31},
  {5.01049294475129542423e+36f, "5010493", 37},
  {9.95576828718185424805e-02f, "9955768", -1},
  {1.50086008943617343903e-03f, "15008601", -2},
  {9.47325133893173187971e-06f, "9473251", -5},
  {6.72114547342061996460e-05f, "67211455", -4},
  {3.92493504364210821223e-09f, "3924935", -8},
  {1.40955759411200000000e+12f, "14095576", 13},
  {1.04952349166010511228e-13f, "10495235", -12},
  {1.63724336686840374333e-14f, "16372434", -13},
  {5.45031889848238223971e+36f, "5450319", 37},
  {2.94306997776550565307e-27f, "294307", -26},
  {6.40202444800000000000e+09f, "64020244", 10},
  {3.90992678500883678039e-14f, "39099268", -13},
  {6.74629187500000000000e+05f, "6746292", 6},
  {4.73799124412048323344e-33f, "47379912", -32},
  {7.04501739561167375412e+37f, "70450174", 38},
  {1.62909855134785175323e-05f, "16290986", -4},
  {2.43913962362047055349e-38f, "24391396", -37},
  {1.09851523841686786523e+28f, "10985152", 29},
  {1.79316968687405301204e+32f, "17931697", 33},
  {7.08921797455489213143e-30f, "7089218", -29},
  {9.66685823236993254291e-32f, "9666858", -31},
  {2.06757313492289540591e-08f, "20675731", -7},
  {3.95029296452588808854e-30f, "3950293", -29},
  {3.00548329984235557122e-14f, "30054833", -13},
  {1.57783818244934082031e+00f, "15778382", 1},
  {2.18568829701517941659e+27f, "21856883", 28},
  {5.41600278344628388555e+30f, "5416003", 31},
  {2.97900096667519770065e-32f, "2979001", -31},
  {4.34425350187669484062e+36f, "43442535", 37},
  {1.27026617059770577715e+22f, "12702662", 23},
  {2.10535790719197868722e-34f, "2105358", -33},
  {5.99145248997956514359e-04f, "59914525", -3},
  {2.55035179395484428948e-20f, "25503518", -19},
  {3.33710610866546630859e-01f, "3337106", 0},
  {6.73498679182698967106e+30f, "6734987", 31},
  {1.66251243520000000000e+10f, "16625124", 11},
  {6.53031469960445148255e-28f, "65303147", -27},
  {9.94910666845369010959e-22f, "9949107", -21},
  {4.51740958249363257822e+34f, "45174096", 35},
  {5.18098213537352174464e-30f, "5180982", -29},
  {4.64789429166501122381e-10f, "46478943", -9},
  {4.13693187500000000000e+05f, "4136932", 6},
  {3.10547475237399339676e-05f, "31054748", -4},
  {5.32940862140599777702e+34f, "53294086", 35},
  {3.06675875840000000000e+11f, "30667588", 12},
  {3.19266837323084473610e-06f, "31926684", -5},
  {1.25789512139817816205e-09f, "12578951", -8},
  {1.26793010380800000000e+12f, "12679301", 13},
  {4.94908182365335843917e-17f, "49490818", -16},
  {3.23248260281652722778e-16f, "32324826", -15},
  {1.50703363233247815270e+21f, "15070336", 22},
  {8.12004519179509998139e-10f, "8120045", -9},
  {1.03768879477555200000e+15f, "10376888", 16},
  {9.68741802381919190193e+29f, "9687418", 30},
  {4.05600256340787200000e+15f, "40560026", 16},
  {2.35108514874951602881e-24f, "23510851", -23},
  {2.98373783234805760000e+18f, "29837378", 19},
  {3.13624080000000000000e+07f, "31362408", 8},
  {1.13074150441733040887e-17f, "11307415", -16},
  {1.73669300421263360000e+16f, "1736693", 17},
  {5.65448687872560640244e-10f, "5654487", -9},
  {3.91704491108438301872e-13f, "3917045", -12},
  {1.49301710037193971332e-26f, "14930171", -25},
  {2.35389824000000000000e+09f, "23538982", 10},
  {2.04565145346971980509e+25f, "20456515", 26},
  {1.42847003346322977629e-34f, "142847", -33},
  {5.59198134022399030580e-20f, "55919813", -19},
  {2.22566565712633663203e+36f, "22256657", 37},
  {2.30092513111078181515e-17f, "23009251", -16},
  {3.70267643083586311106e-24f, "37026764", -23},
  {1.62249400401131237276e-32f, "1622494", -31},
  {1.81886346854400000000e+12f, "18188635", 13},
  {2.50459512909699481600e+20f, "25045951", 21},
  {8.53712310791015625000e+01f, "8537123", 2},
  {1.30007000000000000000e+08f, "130007", 9},
  {1.08054877046015462838e-07f, "10805488", -6},
  {4.18625071846447907164e+34f, "41862507", 35},
  {2.73908135857566763785e+37f, "27390814", 38},
  {1.89322353599115866548e-34f, "18932235", -33},
  {3.03389916378186150793e-21f, "30338992", -20},
  {1.20992841435570555651e-17f, "12099284", -16},
  {4.80685533773884601653e+25f, "48068553", 26},
  {4.11958336000000000000e+08f, "41195834", 9},
  {2.10947993364404340888e+36f, "210948", 37},
  {6.38051279112765440000e+16f, "6380513", 17},
  {2.37301976469862525160e-15f, "23730198", -14},
  {6.51495261569954391513e-27f, "6514953", -26},
  {2.59994645603001117706e-04f, "25999465", -3},
  {1.22225507302395419160e+31f, "12222551", 32},
  {1.24947382573736831546e-05f, "12494738", -4},
  {6.43990682948655088288e-27f, "6439907", -26},
  {9.84995754644059655272e-18f, "98499575", -17},
  {8.03064997054104207360e+20f, "803065", 21},
  {1.63171969561276899996e-14f, "16317197", -13},
  {3.84262360814970697183e+30f, "38426236", 31},
  {2.37904620000000000000e+07f, "23790462", 8},
  {3.79893172475220808337e-10f, "37989317", -9},
  {3.12451800080204918194e-28f, "3124518", -27},
  {7.15932812500000000000e+04f, "7159328", 5},
  {1.41795236249600000000e+12f, "14179524", 13},
  {1.89430882004820722031e-13f, "18943088", -12},
  {1.93617166336000000000e+11f, "19361717", 12},
  {3.45300117200796150702e-15f, "34530012", -14},
  {6.72223547960529575715e-32f, "67222355", -31},
  {2.25235581066142845779e-26f, "22523558", -25},
  {7.63073783912622796734e+31f, "7630738", 32},
  {1.17629146575927734375e+00f, "11762915", 1},
  {1.38088452908044704135e-30f, "13808845", -29},
  {2.96384817631691533696e+30f, "29638482", 31},
  {3.74317773437500000000e+04f, "37431777", 5},
  {7.00937138192747610788e-13f, "70093714", -12},
  {4.94427231328299114054e-26f, "49442723", -25},
  {2.57952170734654373518e-09f, "25795217", -8},
  {4.46970184925965259318e+34f, "4469702", 35},
  {1.51432922446941012171e-28f, "15143292", -27},
  {2.27944952604675158495e-31f, "22794495", -30},
  {1.53082076664549497522e-19f, "15308208", -18},
  {1.67405990273674016352e-16f, "16740599", -15},
  {1.00004355468750000000e+04f, "10000436", 5},
  {2.61267842914282529099e-27f, "26126784", -26},
  {3.30187946026074112000e+17f, "33018795", 18},
  {1.09330368204636160000e+16f, "10933037", 17},
  {3.95468941860599443316e-06f, "39546894", -5},
  {3.76503646373748779297e-01f, "37650365", 0},
  {2.56169690705062618955e-37f, "2561697", -36},
  {2.20601616536747827113e-14f, "22060162", -13},
  {1.18577911823961633334e-32f, "11857791", -31},
  {1.48539278654880035901e-08f, "14853928", -7},
  {1.07376195956021547318e-03f, "1073762", -2},
  {1.39701682176000000000e+11f, "13970168", 12},
  {3.08938569481254249059e-35f, "30893857", -34},
  {3.33547171862183254426e+22f, "33354717", 23},
  {3.95576297768579021943e-17f, "3955763", -16},
  {1.78573475451138108383e-11f, "17857348", -10},
  {3.57862632123795547366e+29f, "35786263", 30},
  {1.42564662382937967777e-04f, "14256466", -3},
  {1.92254145150187245221e-18f, "19225415", -17},
  {6.07923988926728497972e-10f, "607924", -9},
  {3.14305566406250000000e+04f, "31430557", 5},
  {8.25436934129649780902e-27f, "8254369", -26},
  {3.75879231308830994067e+33f, "37587923", 34},
  {3.70089579415009572785e+30f, "37008958", 31},
  {6.76450608310015522040e-14f, "6764506", -13},
  {1.30221473117501582162e-14f, "13022147", -13},
  {2.37651617510888998615e+26f, "23765162", 27},
  {1.65014015510678291321e-03f, "16501402", -2},
  {4.74100744440875132568e-07f, "47410074", -6},
  {4.80150210186945753160e-32f, "4801502", -31},
  {4.41837384227367157760e+19f, "4418374", 20},
  {8.03703711647837322693e+35f, "8037037", 36},
  {2.12082178189791896445e-20f, "21208218", -19},
  {2.09870655089616775513e-02f, "20987066", -1},
  {1.25176318525440000000e+13f, "12517632", 14},
  {1.40877202718720000000e+13f, "1408772", 14},
  {1.22899541742200737398e+36f, "12289954", 37},
  {5.02467083108352000000e+14f, "50246708", 15},
  {4.90829343218017529600e+37f, "49082934", 38},
  {2.13444017122514349850e-35f, "21344402", -34},
  {1.09625912554755424899e-32f, "10962591", -31},
  {7.65055301599204540253e-05f, "7650553", -4},
  {5.03752117190656000000e+14f, "50375212", 15},
  {5.36204716015723402871e-29f, "5362047", -28},
  {3.45335546499314775623e-21f, "34533555", -20},
  {3.22976044716804011542e+36f, "32297604", 37},
  {1.61151304841041564941e-01f, "1611513", 0},
  {1.81195984258348693483e-30f, "18119598", -29},
  {6.59365980482107261196e-07f, "659366", -6},
  {5.15579166196257259520e+19f, "51557917", 20},
  {1.81746616959571838379e-01f, "18174662", 0},
  {3.45907558853547630063e+36f, "34590756", 37},
  {6.79372257366554839098e+31f, "67937226", 32},
  {9.06852278603764716536e-07f, "9068523", -6},
  {1.74391646132334147869e+28f, "17439165", 29},
  {6.31820989045246279864e-21f, "631821", -20},
  {1.99975546471527219200e+18f, "19997555", 19},
  {5.83978757547622400000e+15f, "58397876", 16},
  {1.75026762416128000000e+15f, "17502676", 16},
  {1.39185580040955298227e-27f, "13918558", -26},
  {4.70126306537574980649e+22f, "4701263", 23},
  {1.06942912680096924305e-04f, "10694291", -3},
  {1.52432624908982008884e-30f, "152432625", -29},
  {1.36116922236302984870e-36f, "13611692", -35},
  {3.55453243871997956132e+32f, "35545324", 33},
  {3.20035500407643963392e+21f, "3200355", 22},
  {3.17704770682880000000e+15f, "31770477", 16},
  {6.16240378478795893645e+29f, "61624038", 30},
  {2.22758739255368709564e-03f, "22275874", -2},
  {2.20229800034304000000e+14f, "2202298", 15},
  {2.22974788819988410202e+33f, "22297479", 34},
  {3.93074047851562500000e+03f, "39307405", 4},
  {2.29500898993525261657e-29f, "2295009", -28},
  {1.61858240000000000000e+09f, "16185824", 10},
  {3.48566249799680000000e+13f, "34856625", 14},
  {1.33698928664327532090e-11f, "13369893", -10},
  {7.22394700000000000000e+06f, "7223947", 7},
  {8.21093191733078809159e-27f, "8210932", -26},
  {3.87892615981400012970e-03f, "38789262", -2},
  {1.23560753260458637564e-39f, "1235608", -38},
  {6.76645694430028789042e+31f, "6766457", 32},
  {1.19629118074447551225e+35f, "11962912", 36},
  {3.73851616993713713284e+36f, "37385162", 37},
  {6.49358710826059354761e+24f, "6493587", 25},
  {1.56204937873383187252e-10f, "15620494", -9},
  {9.03061186231934416291e+25f, "9030612", 26},
  {5.81461781862535539232e-35f, "5814618", -34},
  {4.24526117257094567966e-31f, "4245261", -30},
  {7.49502746582031250000e+02f, "74950275", 3},
  {1.62534151888778035200e+19f, "16253415", 20},
  {9.75421847327157858465e-20f, "97542185", -19},
  {4.85524232038576919468e-14f, "48552423", -13},
  {2.50528438153874612217e-24f, "25052844", -23},
  {2.51988065830266450007e-11f, "25198807", -10},
  {1.10419260540561836592e-11f, "11041926", -10},
  {1.26981084535712423954e-30f, "12698108", -29},
  {1.09764188282721465207e-28f, "10976419", -27},
  {4.64265482961626814016e-35f, "46426548", -34},
  {1.32215714214889082756e+38f, "13221571", 39},
  {4.11906360000000000000e+07f, "41190636", 8},
  {1.72166945771932876800e+18f, "17216695", 19},
  {4.12762788221311399591e+32f, "4127628", 33},
  {2.31611275850539570709e-28f, "23161128", -27},
  {6.49474736234596969413e+27f, "64947474", 28},
  {9.11025085449218750000e+02f, "9110251", 3},
  {1.36397459466423600415e+24f, "13639746", 25},
  {1.21670763199442460356e-22f, "12167076", -21},
  {9.47686404435189388728e-30f, "9476864", -29},
  {1.85936866726721306327e+36f, "18593687", 37},
  {7.98796472647680000000e+13f, "7987965", 14},
  {1.01402265395717724364e-29f, "101402265", -28},
  {1.69056092167580086398e+29f, "1690561", 30},
  {1.35303598080000000000e+10f, "1353036", 11},
  {4.99475425476540471462e-32f, "4994754", -31},
  {1.58722207567052800000e+15f, "15872221", 16},
  {3.26148975436825869962e+38f, "32614898", 39},
  {7.66016792927892649997e+32f, "7660168", 33},
  {1.49177460556415631360e+19f, "14917746", 20},
  {1.96547956937008679849e-31f, "19654796", -30},
  {8.02787253633141517639e-04f, "80278725", -3},
  {3.44896018505096435547e-01f, "34489602", 0},
  {3.26066365748112207967e-12f, "32606637", -11},
  {6.38650396607829245952e+21f, "6386504", 22},
  {1.33273875382272000000e+14f, "133273875", 15},
  {1.37289316811407360000e+16f, "13728932", 17},
  {9.44101451353317144965e-29f, "94410145", -28},
  {2.84024306833723479818e+22f, "2840243", 23},
  {2.49331874497433002184e+26f, "24933187", 27},
  {7.43829322788342685945e-25f, "7438293", -24},
  {4.99532121203526965658e+21f, "4995321", 22},
  {1.40292822834453545511e-05f, "14029282", -4},
  {2.09603171748522129629e+32f, "20960317", 33},
  {2.99427215232204800000e+15f, "29942722", 16},
  {5.20547093750000000000e+05f, "5205471", 6},
  {1.89294061047739160986e+21f, "18929406", 22},
  {3.75767472767526647002e-21f, "37576747", -20},
  {1.03747743729343255836e-09f, "10374774", -8},
  {3.72722108617645355182e+37f, "3727221", 38},
  {5.85983388548538819407e-12f, "5859834", -11},
  {2.75179727095287152139e-12f, "27517973", -11},
  {4.15107226009600000000e+12f, "41510723", 13},
  {9.51188988983631134033e-03f, "951189", -2},
  {6.69033413345370486545e-22f, "6690334", -21},
  {8.12033942920446674511e-17f, "81203394", -16},
  {8.06471953125000000000e+04f, "80647195", 5},
  {1.61403105892355726093e+32f, "16140311", 33},
  {3.82960833897634788390e-17f, "38296083", -16},
  {8.81758928298950195312e-02f, "8817589", -1},
  {3.53346125824000000000e+12f, "35334613", 13},
  {1.27870114496886344568e-09f, "12787011", -8},
  {1.09549436416694120842e+34f, "10954944", 35},
  {1.60461434062748033993e-27f, "16046143", -26},
  {6.71901728848740352000e+17f, "6719017", 18},
  {1.01407914480107520000e+17f, "101407914", 18},
  {3.63712977161805332449e+25f, "36371298", 26},
  {1.28920082715922035277e-05f, "12892008", -4},
  {1.58122479691205447054e+27f, "15812248", 28},
  {1.48602022400000000000e+09f, "14860202", 10},
  {4.51392667065340340434e-18f, "45139267", -17},
  {1.61864205337758825994e-36f, "1618642", -35},
  {1.07419833028643552097e-08f, "10741983", -7},
  {1.02672782348779520000e+16f, "10267278", 17},
  {5.68058646139844302510e+34f, "56805865", 35},
  {4.36705643447362699182e-32f, "43670564", -31},
  {7.81060247601459808529e-18f, "78106025", -17},
  {1.42020798813569024000e+17f, "1420208", 18},
  {2.67243418014670094940e-14f, "26724342", -13},
  {1.36296503705600000000e+12f, "1362965", 13},
  {7.76179886220902400000e+15f, "7761799", 16},
  {2.62351785820160000000e+13f, "26235179", 14},
  {4.68907725148515197588e-11f, "46890773", -10},
  {3.45093303372030460847e-28f, "3450933", -27},
  {5.64181757868640724081e-22f, "56418176", -21},
  {5.90429487104000000000e+11f, "5904295", 12},
  {4.36713563147468800000e+15f, "43671356", 16},
  {1.33445832139020099544e-28f, "13344583", -27},
  {3.77414246009043883473e+33f, "37741425", 34},
  {5.58434634805954257051e-25f, "55843463", -24},
  {7.28534836748757321646e+22f, "72853484", 23},
  {6.48989020889719631091e-15f, "648989", -14},
  {8.86764726395913961111e-30f, "8867647", -29},
  {1.98847523145322241451e+34f, "19884752", 35},
  {5.99537597554405790513e-36f, "5995376", -35},
  {1.40231714949854279210e+26f, "140231715", 27},
  {1.05968960360213905408e+21f, "10596896", 22},
  {1.31413023918867111206e-02f, "13141302", -1},
  {3.06738947424256000000e+14f, "30673895", 15},
  {2.19633466969071378116e-09f, "21963347", -8},
  {9.14560742771287654400e+18f, "91456074", 19},
  {8.39851305357803520000e+16f, "8398513", 17},
  {3.82727211628008518451e+21f, "3827272", 22},
  {1.37089155032299458981e-04f, "13708916", -3},
  {6.74255444377600000000e+12f, "67425544", 13},
  {2.75793498655803314082e+28f, "2757935", 29},
  {1.79951003624275968000e+17f, "179951", 18},
  {1.40072209386943313802e-09f, "14007221", -8},
  {1.05296759198448045280e-24f, "10529676", -23},
  {3.46514955618104636415e-10f, "34651496", -9},
  {1.51298524416229577409e-32f, "15129852", -31},
  {4.36808894151456602206e+27f, "4368089", 28},
  {2.88872148423990893207e-10f, "28887215", -9},
  {1.12221321614924818277e-04f, "11222132", -3},
  {2.50630952416899910529e+38f, "25063095", 39},
  {2.63877580000000000000e+07f, "26387758", 8},
  {9.42994087244475296254e-32f, "9429941", -31},
  {1.59030452001177600000e+15f, "15903045", 16},
  {5.46028366390624256000e+17f, "54602837", 18},
  {5.13969775357785590674e-37f, "51396978", -36},
  {1.39654392882176566076e+29f, "13965439", 30},
  {5.83306312561035156250e+01f, "5833063", 2},
  {5.42562631107579296241e-13f, "54256263", -12},
  {1.98694475746755602231e+38f, "19869448", 39},
  {1.69693771749734878540e-03f, "16969377", -2},
  {5.52001055975637200390e-10f, "55200106", -9},
  {3.83040622440324791565e+25f, "38304062", 26},
  {2.59674612500269883993e-21f, "25967461", -20},
  {1.15592655300343055680e+27f, "115592655", 28},
  {1.71204681396484375000e+01f, "17120468", 2},
  {9.19121152000000000000e+08f, "91912115", 9},
  {1.55242730000000000000e+07f, "15524273", 8},
  {2.09311510878651387966e-21f, "20931151", -20},
  {4.96547469808206187736e-09f, "49654747", -8},
  {2.96965161524573346370e-36f, "29696516", -35},
  {2.24201307653485563229e+30f, "22420131", 31},
  {1.87058572023953393831e-19f, "18705857", -18},
  {9.01922527312095477760e+19f, "9019225", 20},
  {4.41539332967639302423e-18f, "44153933", -17},
  {3.04911900457227602601e-05f, "3049119", -4},
  {4.31816995895470878743e-29f, "431817", -28},
  {1.09148818455695462148e-11f, "10914882", -10},
  {1.95679883878573557428e-16f, "19567988", -15},
  {1.95129978656768798828e+00f, "19512998", 1},
  {2.02308324560134169690e+23f, "20230832", 24},
  {6.85898031580072539519e-17f, "685898", -16},
  {7.51455452463721761729e-32f, "75145545", -31},
  {3.17263389660473044663e+30f, "3172634", 31},
  {1.75253734955044901905e+37f, "17525373", 38},
  {6.85968349699044252267e+24f, "68596835", 25},
  {2.62494856268262099901e+32f, "26249486", 33},
  {3.49288361165927411467e+27f, "34928836", 28},
  {5.64514960384870922994e-13f, "56451496", -12},
  {1.96333541437357354893e-19f, "19633354", -18},
  {9.77097175125023627992e+26f, "9770972", 27},
  {1.49532468988428039487e+23f, "14953247", 24},
  {1.71478343680000000000e+10f, "17147834", 11},
  {5.48474831503360000000e+13f, "54847483", 14},
  {5.68711354131594279769e-37f, "56871135", -36},
  {2.91214175522327423096e-02f, "29121418", -1},
  {1.34738497713209549468e-24f, "1347385", -23},
  {8.41051340800000000000e+10f, "8410513", 11},
  {6.60366048080327225530e-34f, "66036605", -33},
  {4.44518491349299438298e-07f, "4445185", -6},
  {5.85603166339951354669e-37f, "58560317", -36},
  {3.32915140520110413320e-31f, "33291514", -30},
  {1.45046832448244688435e-15f, "14504683", -14},
  {1.77928650798912137555e-17f, "17792865", -16},
  {4.72995414521599601614e+27f, "4729954", 28},
  {9.99152750000000000000e+05f, "99915275", 6},
  {9.22612232775270400000e+16f, "9226122", 17},
  {3.44752108007945601246e+37f, "3447521", 38},
  {1.82491410593019556309e+33f, "18249141", 34},
  {2.45186817809131859687e-38f, "24518682", -37},
  {9.82697755098342895508e-02f, "98269776", -1},
  {5.02854461778034688000e+17f, "50285446", 18},
  {2.83887009799659809778e-16f, "283887", -15},
  {1.14971037500000000000e+06f, "11497104", 7},
  {2.14319974400000000000e+09f, "21431997", 10},
  {6.68420747484398881564e-18f, "66842075", -17},
  {1.12876188396171528439e-08f, "11287619", -7},
  {8.26244995117187500000e+02f, "826245", 3},
  {3.37596169673672429531e-29f, "33759617", -28},
  {1.01248418292590182400e+18f, "10124842", 19},
  {2.69102575224353089126e+22f, "26910258", 23},
  {5.09344704929228058509e+36f, "5093447", 37},
  {2.22134506225585937500e+02f, "2221345", 3},
  {6.77532113968482008204e-07f, "6775321", -6},
  {4.05390262272000000000e+11f, "40539026", 12},
  {2.04360917968750000000e+04f, "20436092", 5},
  {3.25699636707489811433e+30f, "32569964", 31},
  {8.53938521334569934363e+25f, "8539385", 26},
  {2.43391416329113813161e-24f, "24339142", -23},
  {3.32151949432188552917e+35f, "33215195", 36},
  {5.33464157424962205383e-20f, "53346416", -19},
  {2.17689814488563949662e-22f, "21768981", -21},
  {1.62466371403531588102e-34f, "16246637", -33},
  {1.31171748046875000000e+04f, "13117175", 5},
  {6.55061066150665283203e-01f, "65506107", 0},
  {1.29609507733871251925e+32f, "12960951", 33},
  {1.90203863296383528705e-29f, "19020386", -28},
  {8.42005770208154776252e-23f, "8420058", -22},
  {6.17892080935630753346e+30f, "6178921", 31},
  {4.60492966875234183161e-35f, "46049297", -34},
  {3.45888723533959612880e-22f, "34588872", -21},
  {8.33949853618065617411e-10f, "83394985", -9},
  {3.91351914536897400013e+21f, "39135191", 22},
  {1.52954149246215820312e+01f, "15295415", 2},
  {1.56794316249385695045e+35f, "15679432", 36},
  {1.23191634671115934907e-08f, "123191635", -7},
  {1.73643162881700281713e+22f, "17364316", 23},
  {2.55084430141050422236e-12f, "25508443", -11},
  {1.64493263424107760636e+33f, "16449326", 34},
  {9.53982900499148854168e+31f, "9539829", 32},
  {3.57058649848376085531e-33f, "35705865", -32},
  {6.09544979873792000000e+16f, "609545", 17},
  {6.92021024565906075446e+29f, "692021", 30},
  {1.27114088000000000000e+08f, "12711409", 9},
  {5.61777514743850931034e-29f, "5617775", -28},
  {4.01054168701171875000e+02f, "40105417", 3},
  {3.68828064376195295149e-27f, "36882806", -26},
  {2.62816755575781246030e-37f, "26281676", -36},
  {4.86123467868804226555e-11f, "48612347", -10},
  {1.46672246830598096423e-12f, "14667225", -11},
  {1.48495012523381228009e+37f, "14849501", 38},
  {4.39816192000000000000e+08f, "4398162", 9},
  {5.37621132812500000000e+04f, "53762113", 5},
  {3.26080296208179394886e-36f, "3260803", -35},
  {8.01111899671654563652e-27f, "8011119", -26},
  {4.69640815441901885234e-35f, "46964082", -34},
  {6.98321679055273584579e+34f, "6983217", 35},
  {2.42390951740455341682e-17f, "24239095", -16},
  {6.68439069534966931127e-19f, "66843907", -18},
  {5.87936582472142642318e+26f, "5879366", 27},
  {1.88654661011956881200e-13f, "18865466", -12},
  {3.67102809250354766846e-02f, "3671028", -1},
  {7.16005094650360742763e-22f, "7160051", -21},
  {1.03882234979907404712e-30f, "103882235", -29},
  {9.24424566071874556498e+37f, "9244246", 38},
  {1.63157475599161683033e-25f, "16315748", -24},
  {1.97031402587890625000e+00f, "1970314", 1},
  {2.27284471253148526182e+21f, "22728447", 22},
  {6.33697204589843750000e+01f, "6336972", 2},
  {4.72077954327687621117e-06f, "47207795", -5},
  {3.09917793648640000000e+14f, "3099178", 15},
  {3.82193520000000000000e+07f, "3821935", 8},
  {3.89629374074515876969e-28f, "38962937", -27},
  {3.12702625000000000000e+05f, "31270262", 6},
  {6.83696516882459845912e-24f, "6836965", -23},
  {3.61539345846155156224e-18f, "36153935", -17},
  {1.73498487547893003261e-31f, "17349849", -30},
  {4.27331737704039760217e-12f, "42733174", -11},
  {1.59809917916705658547e-16f, "15980992", -15},
  {1.39628048054873943329e-03f, "13962805", -2},
  {1.00617111679795200000e+15f, "10061711", 16},
  {3.18474441320750977332e-18f, "31847444", -17},
  {8.22937697400766930807e-34f, "8229377", -33},
  {7.74124924946449701279e-20f, "7741249", -19},
  {1.70482998920230832685e-15f, "170483", -14},
  {1.10783000911068130292e-21f, "110783", -20},
  {6.12319111718508850631e-16f, "6123191", -15},
  {1.73539157941780851795e-19f, "17353916", -18},
  {4.21802330017089843750e+00f, "42180233", 1},
  {6.29190078125000000000e+04f, "62919008", 5},
  {1.47945121151977788498e-31f, "14794512", -30},
  {1.32608893109298986358e+26f, "13260889", 27},
  {3.29473868903901977161e-36f, "32947387", -35},
  {1.69245737894176476179e-14f, "16924574", -13},
  {2.14087443966353165255e+34f, "21408744", 35},
  {4.44438645962963061045e-37f, "44443865", -36},
  {4.42230820655822753906e-01f, "44223082", 0},
  {6.11027571721933782101e-05f, "6110276", -4},
  {1.67239010434582231122e+23f, "16723901", 24},
  {4.11241330428916272008e-38f, "41124133", -37},
  {4.90672530917763472802e+28f, "49067253", 29},
  {7.54840075969696044922e-02f, "7548401", -1},
  {2.53436976000000000000e+08f, "25343698", 9},
  {2.74591440576769529133e-38f, "27459144", -37},
  {3.37184585226122902232e-35f, "33718459", -34},
  {2.90357624414102433563e+23f, "29035762", 24},
  {1.67928037193146032966e-17f, "16792804", -16},
  {9.37116199741521859888e-28f, "9371162", -27},
  {1.77079031698401640466e-27f, "17707903", -26},
  {4.32403593750000000000e+05f, "4324036", 6},
  {2.13390752000000000000e+08f, "21339075", 9},
  {2.91439722238911658081e+26f, "29143972", 27},
  {2.29849733125610207145e+26f, "22984973", 27},
  {2.91699414794240000000e+13f, "29169941", 14},
  {3.23283457192947311497e-32f, "32328346", -31},
  {5.67409150568357952232e-28f, "56740915", -27},
  {4.98443802650861433350e+30f, "4984438", 31},
  {3.14826809066914847790e-09f, "3148268", -8},
  {1.49824206374660207075e-08f, "1498242", -7},
  {3.04138652040819579270e-08f, "30413865", -7},
  {3.34456463947001116846e+34f, "33445646", 35},
  {3.76448750495910644531e-01f, "37644875", 0},
  {5.87654431485994627238e-21f, "58765443", -20},
  {1.81329457516878782603e+37f, "18132946", 38},
  {1.02562607218891828075e+24f, "10256261", 25},
  {1.82521878432703097309e-25f, "18252188", -24},
  {1.04235151866277577127e-38f, "10423515", -37},
  {6.50892409801318450741e-16f, "6508924", -15},
  {1.89660492800000000000e+09f, "18966049", 10},
  {3.01238573315408684646e+23f, "30123857", 24},
  {4.31621520141189755904e-15f, "4316215", -14},
  {1.25622823834419250488e-01f, "12562282", 0},
  {3.33392697434884647395e-17f, "3333927", -16},
  {1.78997812271027039102e+32f, "17899781", 33},
  {5.86482763290405273438e-01f, "58648276", 0},
  {1.82101743081454492401e-13f, "18210174", -12},
  {7.38291134287052800000e+16f, "7382911", 17},
  {1.63277540056605759898e+21f, "16327754", 22},
  {2.75293365120887756348e-02f, "27529337", -1},
  {2.21967776589395783150e+28f, "22196778", 29},
  {9.39056449787700753262e-13f, "9390564", -12},
  {8.33087980917521993849e-33f, "833088", -32},
  {9.04355185793433600000e+15f, "9043552", 16},
  {3.13888690959765547325e-25f, "3138887", -24},
  {3.72580642129570693120e+19f, "37258064", 20},
  {4.96955195273742773125e+22f, "4969552", 23},
  {2.73233465611063056078e-14f, "27323347", -13},
  {2.71565078528000000000e+11f, "27156508", 12},
  {2.07962100284208388588e-25f, "2079621", -24},
  {6.94693866158161920000e+16f, "69469387", 17},
  {1.20154915727953021615e-35f, "120154916", -34},
  {1.01983459895419644359e-29f, "10198346", -28},
  {3.79565473256883244649e-23f, "37956547", -22},
  {1.20102935717167631888e-17f, "120102936", -16},
  {2.60562029123890614014e-31f, "26056203", -30},
  {5.31659083337771490867e-38f, "5316591", -37},
  {3.65260988473892211914e-04f, "365261", -3},
  {4.76448784187717763697e-31f, "4764488", -30},
  {5.67152805635803315687e-15f, "5671528", -14},
  {9.72563801923043483943e-34f, "9725638", -33},
  {2.43666953675221574422e+31f, "24366695", 32},
  {3.88973670400000000000e+09f, "38897367", 10},
  {2.07657812500000000000e+04f, "20765781", 5},
  {1.16015771596307207904e-24f, "11601577", -23},
  {9.80203002929687500000e+02f, "980203", 3},
  {1.73382833872957963923e-35f, "17338283", -34},
  {3.21385116577148437500e+01f, "3213851", 2},
  {1.05115772873068880391e-19f, "10511577", -18},
  {4.40876578077868365028e+24f, "44087658", 25},
  {1.50252201897104394585e+38f, "1502522", 39},
  {3.34380671645077188758e-30f, "33438067", -29},
  {5.99682122350500136337e-27f, "59968212", -26},
  {1.72250348380873867649e-33f, "17225035", -32},
  {5.14388553770820223317e+24f, "51438855", 25},
  {3.12365693207194983216e-13f, "3123657", -12},
  {1.09079010355498214972e+25f, "10907901", 26},
  {3.70215456000000000000e+08f, "37021546", 9},
  {1.42552609587200000000e+12f, "14255261", 13},
  {4.31150989606976509094e-03f, "431151", -2},
  {1.30790962067307275223e+22f, "13079096", 23},
  {1.42570497074778756996e-10f, "1425705", -9},
  {8.80130004882812500000e+00f, "88013", 1},
  {2.02985463454918864942e+31f, "20298546", 32},
  {8.69599312500000000000e+05f, "8695993", 6},
  {1.72935726193233855775e+22f, "17293573", 23},
  {3.78511594561251530631e-39f, "3785116", -38},
  {7.50504850000000000000e+06f, "75050485", 7},
  {8.99303249487479087381e-21f, "89930325", -20},
  {6.03456199796888606892e-31f, "6034562", -30},
  {7.02651743983832807460e+30f, "70265174", 31},
  {1.41184605730737414500e-15f, "14118461", -14},
  {2.03514990064055806384e-38f, "20351499", -37},
  {3.83051567077636718750e+01f, "38305157", 2},
  {4.59780845907375991348e+27f, "45978085", 28},
  {3.75162406671346906207e-24f, "3751624", -23},
  {5.35165441950628614682e-35f, "53516544", -34},
  {1.31576887016344067922e+31f, "13157689", 32},
  {2.05037594067599360000e+16f, "2050376", 17},
  {9.33066083706919624507e-16f, "9330661", -15},
  {8.07672809080750080000e+16f, "8076728", 17},
  {4.28831278104576000000e+15f, "42883128", 16},
  {5.29400665527646197006e-07f, "52940067", -6},
  {7.83090152691380384581e+28f, "78309015", 29},
  {1.20699228468301057229e+21f, "12069923", 22},
  {3.97754603917846688043e-21f, "3977546", -20},
  {3.57499897778148026195e-23f, "3574999", -22},
  {1.92973680000000000000e+07f, "19297368", 8},
  {2.40334364395016726126e+26f, "24033436", 27},
  {8.15606821717397621714e+27f, "8156068", 28},
  {1.20751899545376180829e-34f, "1207519", -33},
  {4.16166784000000000000e+09f, "41616678", 10},
  {1.58545613092294698250e-21f, "15854561", -20},
  {1.77487468750000000000e+05f, "17748747", 6},
  {1.24078285217285156250e+02f, "124078285", 3},
  {2.31268307632774426132e+23f, "2312683", 24},
  {4.31155154981266441894e-12f, "43115515", -11},
  {1.61372848510742187500e+02f, "16137285", 3},
  {2.45822273647888778214e-09f, "24582227", -8},
  {6.34299400000000000000e+06f, "6342994", 7},
  {1.53817262080000000000e+10f, "15381726", 11},
  {2.36683537862737459210e-17f, "23668354", -16},
  {1.39680513235666614658e+30f, "13968051", 31},
  {5.22949304320000000000e+10f, "5229493", 11},
  {1.43750405513238116565e+23f, "14375041", 24},
  {9.03394762386571264000e+18f, "90339476", 19},
  {3.20286344016381070142e+25f, "32028634", 26},
  {1.25529089918715888947e+27f, "12552909", 28},
  {1.72674646016000000000e+11f, "17267465", 12},
  {9.18542785644531250000e+02f, "9185428", 3},
  {1.71988124779905640574e-27f, "17198812", -26},
  {2.00415465473335885349e-11f, "20041547", -10},
  {5.75447903285547192137e-21f, "5754479", -20},
  {1.53981906250000000000e+05f, "1539819", 6},
  {2.29383666404329318428e-21f, "22938367", -20},
  {8.47278300872428744129e-39f, "8472783", -38},
  {1.01908902527219596788e+23f, "1019089", 24},
  {1.30053604152635671198e-05f, "1300536", -4},
  {3.13901280000000000000e+07f, "31390128", 8},
  {3.26740070400000000000e+10f, "32674007", 11},
  {1.50073671234711501603e-16f, "15007367", -15},
  {6.18451566592000000000e+11f, "61845157", 12},
  {1.99472084401233751289e-19f, "19947208", -18},
  {3.91526298522949218750e+01f, "3915263", 2},
  {1.56603568810095195962e-22f, "15660357", -21},
  {4.19943157508747349197e+21f, "41994316", 22},
  {1.24623872826230483457e-14f, "12462387", -13},
  {1.09066921875000000000e+05f, "10906692", 6},
  {9.23042825204704268233e-16f, "9230428", -15},
  {4.83539497779200000000e+15f, "4835395", 16},
  {9.50382679273941675976e-28f, "9503827", -27},
  {2.37537528585879347075e+33f, "23753753", 34},
  {1.89192529395516459911e+37f, "18919253", 38},
  {1.92352513864991306772e-36f, "19235251", -35},
  {1.77196937500000000000e+05f, "17719694", 6},
  {3.97075173385852839526e+21f, "39707517", 22},
  {2.92155544701941841920e+21f, "29215554", 22},
  {7.50829975970646046335e-09f, "75083", -8},
  {7.28295372800000000000e+09f, "72829537", 10},
  {7.12251846834988100454e-07f, "71225185", -6},
  {1.16941936176966237866e+33f, "11694194", 34},
  {2.07813608624174923776e+21f, "20781361", 22},
  {2.20882196244125135667e+21f, "2208822", 22},
  {9.69480393195479945419e-27f, "9694804", -26},
  {4.39976803904770785714e-13f, "4399768", -12},
  {2.64471122937569267765e-39f, "2644711", -38},
  {1.57808342304838175823e-26f, "15780834", -25},
  {6.48149093106677676325e-29f, "6481491", -28},
  {1.47218761412659659982e-05f, "14721876", -4},
  {8.05739361176576327680e+19f, "8057394", 20},
  {3.49947775813941198848e+20f, "34994778", 21},
  {3.69329563542487040000e+17f, "36932956", 18},
  {7.25351156916076433845e-08f, "72535116", -7},
  {9.64351518684541349093e-38f, "9643515", -37},
  {2.03950491936384127685e-20f, "2039505", -19},
  {1.82108352000000000000e+09f, "18210835", 10},
  {6.81533019237705140142e+22f, "681533", 23},
  {4.12488203125000000000e+04f, "4124882", 5},
  {2.81292144843224830357e-25f, "28129214", -24},
  {9.08795782744307732471e-32f, "9087958", -31},
  {2.88937186494493071558e-19f, "28893719", -18},
  {4.36774063910985027581e-14f, "43677406", -13},
  {3.14690066969708182756e-37f, "31469007", -36},
  {7.53280345095154199177e-21f, "75328035", -20},
  {1.32070561084662863038e-11f, "13207056", -10},
  {8.59903400000000000000e+06f, "8599034", 7},
  {4.21608556857530566143e-38f, "42160856", -37},
  {5.31372076302769731307e-29f, "5313721", -28},
  {1.09829501533893840992e+37f, "1098295", 38},
  {5.11623127040000000000e+10f, "51162313", 11},
  {6.33319921875000000000e+03f, "6333199", 4},
  {1.86051302054826789168e+31f, "1860513", 32},
  {1.48924470977362943813e-07f, "14892447", -6},
  {2.01387182348052376502e-14f, "20138718", -13},
  {2.57074254916725337101e-34f, "25707425", -33},
  {1.09233093723732049920e+19f, "10923309", 20},
  {2.33359779254222604594e-14f, "23335978", -13},
  {6.58902167402925658449e-22f, "65890217", -21},
  {1.16314795450832809315e+29f, "1163148", 30},
  {5.79873152610923970560e+19f, "57987315", 20},
  {8.76104387257434930995e+36f, "8761044", 37},
  {5.68230461440000000000e+10f, "56823046", 11},
  {2.89549790322780609131e-02f, "28954979", -1},
  {8.68321692326645688809e-10f, "8683217", -9},
  {9.23173453824000000000e+11f, "92317345", 12},
  {9.78547653455380480000e+16f, "97854765", 17},
  {2.65543228994611935478e+38f, "26554323", 39},
  {9.05301349121145904064e-05f, "90530135", -4},
  {5.60947776114313537805e-18f, "56094778", -17},
  {9.93117331402944491043e-26f, "99311733", -25},
  {1.35833862304687500000e+03f, "13583386", 4},
  {2.49511611938476562500e+02f, "24951161", 3},
  {7.28865206241607666016e-01f, "7288652", 0},
  {6.55255781250000000000e+04f, "6552558", 5},
  {3.13138659790791114752e+20f, "31313866", 21},
  {1.57576692184947787808e+27f, "15757669", 28},
  {8.27799934615616256060e-28f, "8277999", -27},
  {2.18914686156917650227e+21f, "21891469", 22},
  {1.40939143091202859815e+37f, "14093914", 38},
  {1.33487678985592988453e-29f, "13348768", -28},
  {1.60133694748765265103e-07f, "1601337", -6},
  {1.19780899047851562500e+02f, "1197809", 3},
  {3.55884363026708553547e-37f, "35588436", -36},
  {3.85059295761171012072e+24f, "3850593", 25},
  {3.98837311872091247423e+26f, "3988373", 27},
  {1.51240866418321744207e-32f, "15124087", -31},
  {5.82246562500000000000e+04f, "58224656", 5},
  {1.24777380348553562916e-26f, "12477738", -25},
  {1.58344497978396515567e-15f, "1583445", -14},
  {9.49840250541456043720e-06f, "94984025", -5},
  {1.21904240101536109915e+32f, "12190424", 33},
  {1.98531436839117410580e-17f, "19853144", -16},
  {7.31369212947855078695e-34f, "7313692", -33},
  {5.05039254861117115070e-09f, "50503925", -8},
  {2.84834293350400000000e+12f, "2848343", 13},
  {1.13705857547501568000e+17f, "11370586", 18},
  {6.75940237753902992581e-31f, "67594024", -30},
  {1.02034643353600000000e+12f, "102034643", 13},
  {1.37160955816567938472e-26f, "13716096", -25},
  {6.19578166549672459951e-10f, "61957817", -9},
  {1.71857765302984739756e+25f, "17185777", 26},
  {3.12489928766259200000e+15f, "31248993", 16},
  {2.59583090731874367114e+31f, "2595831", 32},
  {1.75461147076515916465e-14f, "17546115", -13},
  {3.00847889381614828459e-19f, "3008479", -18},
  {1.17937893539840000000e+13f, "11793789", 14},
  {3.89703542599639201615e-26f, "38970354", -25},
  {4.20863237593493977329e-08f, "42086324", -7},
  {3.64708903362043201923e-05f, "3647089", -4},
  {7.40333874339518549474e-28f, "74033387", -27},
  {9.40659866333007812500e+01f, "9406599", 2},
  {9.52209270742632469981e+26f, "9522093", 27},
  {1.49934194032640000000e+13f, "14993419", 14},
  {5.57869873046875000000e+03f, "55786987", 4},
  {4.97394856755200000000e+12f, "49739486", 13},
  {7.97306966781616210938e+00f, "79730697", 1},
  {1.36493946880000000000e+10f, "13649395", 11},
  {4.03996697439969716842e-22f, "4039967", -21},
  {1.69245965025280000000e+13f, "16924597", 14},
  {3.56139441772899087952e+33f, "35613944", 34},
  {6.33755795456000000000e+11f, "6337558", 12},
  {2.99198500000000000000e+06f, "2991985", 7},
  {9.54166266147967905469e-23f, "95416627", -22},
  {7.57713062298910720000e+16f, "7577131", 17},
  {2.36920807284318018831e+36f, "2369208", 37},
  {4.34822188669155238878e+28f, "4348222", 29},
  {1.24322814372135326266e-05f, "12432281", -4},
  {2.30511650397167377380e-33f, "23051165", -32},
  {6.25166358947753906250e+01f, "62516636", 2},
  {2.83661700000000000000e+07f, "2836617", 8},
  {2.22978545934893190861e-04f, "22297855", -3},
  {1.57398291449062366354e-12f, "15739829", -11},
  {1.19736405370300484901e-16f, "1197364", -15},
  {8.05072848664156737186e-12f, "80507285", -11},
  {4.32176391782400000000e+12f, "4321764", 13},
  {6.00434960937500000000e+03f, "60043496", 4},
  {1.36101774760423019327e-37f, "13610177", -36},
  {2.84900923313847907029e+25f, "28490092", 26},
  {3.90063715400868184783e+34f, "39006372", 35},
  {8.01933871116489171982e-04f, "8019339", -3},
  {3.47162754786628617111e+36f, "34716275", 37},
  {5.26511529460549354553e-03f, "52651153", -2},
  {1.04870566864403687649e-15f, "10487057", -14},
  {6.94366044160000000000e+10f, "69436604", 11},
  {4.01985333682511557809e-38f, "40198533", -37},
  {8.71762604723490731030e+35f, "8717626", 36},
  {8.10784825039441124107e-28f, "8107848", -27},
  {8.92566568960000000000e+10f, "8925666", 11},
  {5.04374637920643810098e-25f, "50437464", -24},
  {2.33057548133052003333e+24f, "23305755", 25},
  {4.37952062500000000000e+05f, "43795206", 6},
  {5.30882121994360269402e+25f, "5308821", 26},
  {1.00917851852955209324e-08f, "10091785", -7},
  {6.95615752754494544282e+21f, "69561575", 22},
  {5.83203369140625000000e+03f, "58320337", 4},
  {3.30878692500480298122e-11f, "3308787", -10},
  {4.31742287872000000000e+11f, "4317423", 12},
  {1.12012484603028867997e+37f, "11201248", 38},
  {1.24587768368655815721e-05f, "12458777", -4},
  {3.94025976507305472981e-26f, "39402598", -25},
  {4.57209500000000000000e+05f, "4572095", 6},
  {4.62577444325039223135e+29f, "46257744", 30},
  {1.00394144058227539062e+01f, "10039414", 2},
  {9.02510525095892482982e+27f, "9025105", 28},
  {5.30622347734380734846e-21f, "53062235", -20},
  {6.30847998341200594946e-26f, "630848", -25},
  {7.68012569096754305065e-08f, "7680126", -7},
  {1.09873392639047117051e-19f, "10987339", -18},
  {2.88072970147167418288e+38f, "28807297", 39},
  {4.24406516874586969834e-12f, "4244065", -11},
  {1.49137939727646720000e+16f, "14913794", 17},
  {1.32857792871148633401e+36f, "13285779", 37},
  {3.66176199721005384047e+24f, "3661762", 25},
  {2.15879697388641911014e-38f, "2158797", -37},
  {1.35487088000000000000e+08f, "13548709", 9},
  {2.36819069833982302277e+25f, "23681907", 26},
  {3.05239647961180728459e+36f, "30523965", 37},
  {1.86895140420992368640e+19f, "18689514", 20},
  {2.97496328130364418030e-03f, "29749633", -2},
  {2.20961749926553130698e-27f, "22096175", -26},
  {6.36016210937500000000e+04f, "6360162", 5},
  {1.79628436822996474046e-36f, "17962844", -35},
  {1.85026953464130484404e+37f, "18502695", 38},
  {1.07622941748157819205e+35f, "10762294", 36},
  {2.01510949636029266736e+24f, "20151095", 25},
  {1.48969146728515625000e+02f, "14896915", 3},
  {5.08874567172455140318e-15f, "50887457", -14},
  {1.20852421969175338745e-03f, "12085242", -2},
  {2.43436360359191894531e+00f, "24343636", 1},
  {9.82613200778297344000e+18f, "9826132", 19},
  {7.56705792000000000000e+09f, "7567058", 10},
  {1.51092882699812757168e-33f, "15109288", -32},
  {6.54977536000000000000e+09f, "65497754", 10},
  {1.02667509586581226115e-28f, "10266751", -27},
  {2.31563879874808726693e+33f, "23156388", 34},
  {5.40291143908247265509e+27f, "54029114", 28},
  {1.09868315363088235939e-15f, "10986832", -14},
  {2.43838830420520236153e-13f, "24383883", -12},
  {8.71306693563956683033e-31f, "8713067", -30},
  {4.28578951324872707389e-16f, "42857895", -15},
  {1.74375756103680000000e+14f, "17437576", 15},
  {2.12804334588330405947e+24f, "21280433", 25},
  {8.36644075748517157114e-19f, "8366441", -18},
  {8.76741826534271240234e-01f, "8767418", 0},
  {7.72154247376951103508e+24f, "77215425", 25},
  {1.91992366444721395370e+28f, "19199237", 29},
  {2.81063641463389149444e-14f, "28106364", -13},
  {3.29613908091622958039e+22f, "3296139", 23},
  {5.23929120000000000000e+08f, "52392912", 9},
  {1.41764568027347046892e+22f, "14176457", 23},
  {1.15544024883529253432e+34f, "11554402", 35},
  {4.89265831521978652555e-26f, "48926583", -25},
  {4.09783899188728151671e+24f, "4097839", 25},
  {3.00606987429918167245e+32f, "30060699", 33},
  {7.49871958129661268095e-30f, "74987196", -29},
  {1.16967936000000000000e+10f, "11696794", 11},
  {6.20395003352314233780e-05f, "620395", -4},
  {6.18200010649161413312e-06f, "6182", -5},
  {1.97118441977877998311e-32f, "19711844", -31},
  {2.56216375654492798373e+34f, "25621638", 35},
  {8.71603108085204664676e-26f, "8716031", -25},
  {2.45186390004858880000e+16f, "2451864", 17},
  {5.61855607893568400936e-38f, "5618556", -37},
  {9.14940851945454467809e+22f, "91494085", 23},
  {4.26417002043206250625e+26f, "426417", 27},
  {2.05494295563054090931e+34f, "2054943", 35},
  {7.15794939904000000000e+11f, "71579494", 12},
  {6.52226671984934332073e-28f, "65222667", -27},
  {7.29453028210705199013e-18f, "729453", -17},
  {1.03784028445683482624e+20f, "10378403", 21},
  {4.71491403004620224237e-05f, "4714914", -4},
  {2.14382375753072671394e+35f, "21438238", 36},
  {3.05872781250000000000e+05f, "30587278", 6},
  {6.63899508991590400000e+15f, "6638995", 16},
  {2.54821934504434466362e-04f, "25482193", -3},
  {3.28494165202641852375e-09f, "32849417", -8},
  {1.85175968750000000000e+05f, "18517597", 6},
  {1.20604540286135592550e+21f, "12060454", 22},
  {1.55980530017025714333e-25f, "15598053", -24},
  {1.41093085383936559149e-25f, "14109309", -24},
  {2.49454746093750000000e+04f, "24945475", 5},
  {2.55780198038361404347e-30f, "2557802", -29},
  {1.14352960694369398809e-12f, "11435296", -11},
  {1.41721384627757629460e-10f, "14172138", -9},
  {1.10878886691325582707e-36f, "11087889", -35},
  {1.41166383400559425354e-03f, "14116638", -2},
  {2.68663738559362555928e+38f, "26866374", 39},
  {1.16428779438138008118e-02f, "11642878", -1},
  {1.35146512507065673852e+30f, "13514651", 31},
  {7.26170084086114643239e-33f, "7261701", -32},
  {4.11015861345731536858e-07f, "41101586", -6},
  {1.68715662122712692560e-34f, "16871566", -33},
  {2.90772387925384746762e+22f, "29077239", 23},
  {3.65993537343456409872e-06f, "36599354", -5},
  {2.43002398156071262898e+27f, "2430024", 28},
  {1.64683130880000000000e+10f, "16468313", 11},
  {1.10460578184312652184e-10f, "11046058", -9},
  {2.52996230125427246094e+00f, "25299623", 1},
  {1.80866517286287258419e+21f, "18086652", 22},
  {1.33930893312000000000e+11f, "13393089", 12},
  {3.62452475694231271930e-19f, "36245248", -18},
  {1.14029906958569674153e-22f, "11402991", -21},
  {4.15812560000000000000e+07f, "41581256", 8},
  {1.77792278868152885675e+25f, "17779228", 26},
  {1.25843026807312697854e+32f, "12584303", 33},
  {1.54431732632276270936e-35f, "15443173", -34},
  {8.48048697177637397405e-23f, "8480487", -22},
  {3.06861810386180877686e-02f, "30686181", -1},
  {3.15415717592626507442e+24f, "31541572", 25},
  {2.06841122007972444408e-09f, "20684112", -8},
  {7.30341900288000000000e+11f, "7303419", 12},
  {1.06350039885683145258e-10f, "10635004", -9},
  {8.65834712982177734375e-01f, "8658347", 0},
  {1.34905658647368583720e+38f, "13490566", 39},
  {2.40835432656194764800e+18f, "24083543", 19},
  {1.54304351806640625000e+02f, "15430435", 3},
  {2.51794961513951420784e-04f, "25179496", -3},
  {9.35895982506246144000e+17f, "935896", 18},
  {2.88523908959885405877e+38f, "2885239", 39},
  {4.99071649891907886953e-13f, "49907165", -12},
  {1.08912077409694308840e+24f, "10891208", 25},
  {1.69243406844543642364e-07f, "1692434", -6},
  {1.37799514021708091605e-08f, "13779951", -7},
  {4.50010360000000000000e+07f, "45001036", 8},
  {1.03567372257318796029e+26f, "10356737", 27},
  {4.91271419212736867730e-20f, "49127142", -19},
  {1.06582100758422573960e-21f, "1065821", -20},
  {1.63619659835807424351e-23f, "16361966", -22},
  {1.98754956623300526080e+19f, "19875496", 20},
  {3.04603478775106791762e+38f, "30460348", 39},
  {3.66809742769923397136e+26f, "36680974", 27},
  {8.80409901113692556546e-39f, "8804099", -38},
  {4.94265028460676931304e-23f, "49426503", -22},
  {2.17352935578674077988e-05f, "21735294", -4},
  {3.07028277057294449068e+25f, "30702828", 26},
  {8.95146057541005710513e-30f, "89514606", -29},
  {5.33566512167453765869e-02f, "5335665", -1},
  {3.57867216048270970141e-36f, "3578672", -35},
  {4.63833400000000000000e+07f, "4638334", 8},
  {2.24696188626851691902e-16f, "2246962", -15},
  {1.23947870633855927736e-06f, "12394787", -5},
  {4.63717451397227314533e-20f, "46371745", -19},
  {4.04405092352000000000e+12f, "4044051", 13},
  {1.67347268419115617824e+32f, "16734727", 33},
  {8.78626480671781012983e-21f, "8786265", -20},
  {1.40330103093333491415e-08f, "1403301", -7},
  {3.77459691662807017565e-05f, "3774597", -4},
  {3.73792010403840000000e+14f, "373792", 15},
  {1.90210077429719715645e-29f, "19021008", -28},
  {1.47449572978075593710e-05f, "14744957", -4},
  {2.68096623981602864783e-37f, "26809662", -36},
  {3.39783561334353768818e+33f, "33978356", 34},
  {4.18537549099097510491e+26f, "41853755", 27},
  {6.07948322794982232153e-07f, "6079483", -6},
  {2.11191574096679687500e+02f, "21119157", 3},
  {5.94948265082880000000e+13f, "59494827", 14},
  {4.78257505894400000000e+12f, "4782575", 13},
  {3.52006954384579624960e+19f, "35200695", 20},
  {1.52690088879353660638e+29f, "15269009", 30},
  {1.38865047460967616644e-07f, "13886505", -6},
  {1.56661924167617085440e+19f, "15666192", 20},
  {8.01601958707200000000e+16f, "801602", 17},
  {2.28149218628459493630e-07f, "22814922", -6},
  {1.30082610582343673607e+35f, "13008261", 36},
  {2.48298033630496122821e-27f, "24829803", -26},
  {1.01722115776053766233e-20f, "101722116", -19},
  {1.52859366019060565520e-33f, "15285937", -32},
  {2.13769687040000000000e+10f, "21376969", 11},
  {5.86465346753870005593e-18f, "58646535", -17},
  {1.20203824332800000000e+13f, "12020382", 14},
  {8.15349631948444517987e+32f, "8153496", 33},
  {1.12030356445593600000e+15f, "112030356", 16},
  {8.74070292542851498121e+31f, "8740703", 32},
  {4.59388100000000000000e+06f, "4593881", 7},
  {2.74184288000000000000e+08f, "2741843", 9},
  {1.10990726397454198296e-27f, "11099073", -26},
  {1.05208148167448806744e+37f, "10520815", 38},
  {1.51459462449826610687e-35f, "15145946", -34},
  {6.58419590106054841556e+25f, "6584196", 26},
  {2.93011503658565827780e-31f, "2930115", -30},
  {3.72164733707904815674e-02f, "37216473", -1},
  {2.79135895205048791571e+27f, "2791359", 28},
  {1.35006457102535540553e-36f, "13500646", -35},
  {2.19315397006342172048e-14f, "2193154", -13},
  {2.43274314460212970996e-18f, "24327431", -17},
  {4.73326484375000000000e+04f, "4733265", 5},
  {2.09994982516706959621e+38f, "20999498", 39},
  {1.93388733696590410726e+33f, "19338873", 34},
  {2.40289800488007344176e-15f, "2402898", -14},
  {4.60101488688604736671e+28f, "4601015", 29},
  {3.76234579515383193993e-13f, "37623458", -12},
  {5.06155240083355277140e-35f, "50615524", -34},
  {5.34314750000000000000e+06f, "53431475", 7},
  {1.44673344158580080640e+19f, "14467334", 20},
  {7.25345576167822679038e-39f, "7253456", -38},
  {2.08770581213793484800e+18f, "20877058", 19},
  {2.27501095328991582094e+37f, "2275011", 38},
  {2.46716850213710348581e-33f, "24671685", -32},
  {6.14148731870045594405e-11f, "6141487", -10},
  {1.90827853129598544971e-19f, "19082785", -18},
  {4.53753742815133696000e+18f, "45375374", 19},
  {7.27942430976060859873e-17f, "7279424", -16},
  {3.63488881336329712129e+34f, "36348888", 35},
  {5.74614667264000000000e+11f, "5746147", 12},
  {5.57216058159187245258e+28f, "55721606", 29},
  {1.45125488281250000000e+04f, "14512549", 5},
  {1.07232985949102959231e+23f, "10723299", 24},
  {8.57494094361289303018e+26f, "8574941", 27},
  {3.45552760000000000000e+07f, "34555276", 8},
  {9.63096166400000000000e+09f, "9630962", 10},
  {3.88612552569216290610e+34f, "38861255", 35},
  {1.88087030718434051716e-33f, "18808703", -32},
  {3.90191376209259033203e-02f, "39019138", -1},
  {8.85608787780236115167e+36f, "8856088", 37},
  {6.57159660022443858907e-09f, "65715966", -8},
  {1.52277269708139397120e+19f, "15227727", 20},
  {5.68382873535156250000e+02f, "5683829", 3},
  {1.86105175714601500658e-09f, "18610518", -8},
  {4.01385455616000000000e+13f, "40138546", 14},
  {2.26362615966148374636e+26f, "22636262", 27},
  {1.25740190203280297935e-19f, "12574019", -18},
  {2.11060393749089929888e-38f, "2110604", -37},
  {1.91932130771285799898e+30f, "19193213", 31},
  {1.10923629422636949005e+26f, "11092363", 27},
  {5.03247439603307642880e+19f, "50324744", 20},
  {2.86776365886830932113e+30f, "28677637", 31},
  {3.26225218750000000000e+05f, "32622522", 6},
  {1.65301265314611200000e+18f, "16530127", 19},
  {1.15138873848175997032e+36f, "11513887", 37},
  {3.37382452834155845237e+33f, "33738245", 34},
  {5.07801815692425274799e+37f, "5078018", 38},
  {7.65729264422092800000e+15f, "76572926", 16},
  {3.41120166646981706574e-22f, "34112017", -21},
  {2.52341945195939772311e+33f, "25234195", 34},
  {6.35001383073041658633e-12f, "6350014", -11},
  {2.50834507742304971090e-32f, "2508345", -31},
  {5.36100938916206359863e-02f, "53610094", -1},
  {9.40833340830686444446e-28f, "9408333", -27},
  {3.64203816467817804946e+33f, "36420382", 34},
  {2.68913820242882993183e-33f, "26891382", -32},
  {1.51810713939125207040e+21f, "15181071", 22},
  {2.01867566727206668307e+29f, "20186757", 30},
  {7.94103527270876909808e-28f, "79410353", -27},
  {8.31853730649554791297e-20f, "8318537", -19},
  {2.40111896661487788933e+27f, "2401119", 28},
  {8.85839172363281250000e+02f, "8858392", 3},
  {2.01701140146400925855e+38f, "20170114", 39},
  {1.95527682933516189223e-09f, "19552768", -8},
  {2.80456031584188113139e+32f, "28045603", 33},
  {1.16662479093760000000e+13f, "11666248", 14},
  {6.40596403972669650549e-22f, "6405964", -21},
  {4.88086299579398578732e-26f, "4880863", -25},
  {3.94699063951360000000e+13f, "39469906", 14},
  {1.61975711226923634898e-30f, "16197571", -29},
  {3.78329005371350006967e-39f, "378329", -38},
  {2.83404756373784039170e-06f, "28340476", -5},
  {1.85465214869703918898e-39f, "1854652", -38},
  {4.10595406250000000000e+05f, "4105954", 6},
  {6.20261723808447720534e-27f, "62026172", -26},
  {1.25624919227345167773e+36f, "12562492", 37},
  {1.86584711074829101562e+00f, "18658471", 1},
  {4.49720242046969108299e-28f, "44972024", -27},
  {1.39897832734720000000e+13f, "13989783", 14},
  {1.06410443278385152000e+17f, "10641044", 18},
  {1.62922121124427447138e-33f, "16292212", -32},
  {1.25630510328623393473e-37f, "12563051", -36},
  {4.51608504668944777347e+23f, "4516085", 24},
  {1.45239912109375000000e+04f, "14523991", 5},
  {1.93951637866131672064e-26f, "19395164", -25},
  {2.18721821152142950400e+18f, "21872182", 19},
  {6.52104294400000000000e+09f, "6521043", 10},
  {4.63805779509134056162e+33f, "46380578", 34},
  {6.28714944000000000000e+08f, "62871494", 9},
  {8.76237372737294696448e+20f, "8762374", 21},
  {5.46358653461217855707e-25f, "54635865", -24},
  {2.16929963789880275726e-03f, "21692996", -2},
  {1.07874463332722657014e-15f, "10787446", -14},
  {1.55769164598233059482e-25f, "15576916", -24},
  {7.18260652637099926758e+26f, "71826065", 27},
  {4.11446750315974886477e-22f, "41144675", -21},
  {2.83612971642621506135e+26f, "28361297", 27},
  {6.44407747995205013701e-34f, "64440775", -33},
  {3.41086603405926780397e-09f, "3410866", -8},
  {1.56368646621704101562e+01f, "15636865", 2},
  {1.75736713223574157674e-25f, "17573671", -24},
  {4.29541424651347369945e-09f, "42954142", -8},
  {7.47932299441240699049e+33f, "7479323", 34},
  {1.92050418373302902201e-25f, "19205042", -24},
  {2.85674134386039378894e+35f, "28567413", 36},
  {6.70572331045929508453e-32f, "67057233", -31},
  {3.52923267857433987569e-28f, "35292327", -27},
  {7.74016487412154674530e-04f, "7740165", -3},
  {4.99253340538832789488e-21f, "49925334", -20},
  {8.08798935063676049162e+23f, "8087989", 24},
  {1.09800711233000835870e-25f, "10980071", -24},
  {1.35976634242456189544e-15f, "13597663", -14},
  {1.61897249843729484197e+25f, "16189725", 26},
  {8.27404356940636916551e+36f, "82740436", 37},
  {3.22832217904156280151e+27f, "32283222", 28},
  {4.99622325547464629150e+37f, "49962233", 38},
  {2.61800375772774400000e+16f, "26180038", 17},
  {2.84719951450824737549e-02f, "28471995", -1},
  {3.18210146617920225741e+32f, "31821015", 33},
  {2.30834994267023821402e-14f, "230835", -13},
  {3.54157767005490933228e-20f, "35415777", -19},
  {2.52856663654250519399e-31f, "25285666", -30},
  {8.19348662226787709747e+21f, "81934866", 22},
  {6.23071240234375000000e+03f, "62307124", 4},
  {6.20560077242080700296e-18f, "62056008", -17},
  {8.14090035200000000000e+09f, "81409004", 10},
  {4.32147405843963314176e+20f, "4321474", 21},
  {2.55819468953633675328e-30f, "25581947", -29},
  {8.82947162898432000000e+14f, "88294716", 15},
  {2.09277845548035194054e-27f, "20927785", -26},
  {6.76911155200000000000e+09f, "67691116", 10},
  {2.51163287909424249023e+28f, "25116329", 29},
  {1.48317041015625000000e+03f, "14831704", 4},
  {6.66187734375000000000e+04f, "6661877", 5},
  {6.77354512843601703774e-36f, "6773545", -35},
  {5.83873629570007324219e-01f, "5838736", 0},
  {7.56796096512000000000e+11f, "7567961", 12},
  {3.87335511584657986998e-25f, "3873355", -24},
  {7.28139891263938967846e+34f, "7281399", 35},
  {5.86332724848417719534e+29f, "58633272", 30},
  {5.15138673130402211799e+37f, "51513867", 38},
  {1.14533797424346757320e-29f, "1145338", -28},
  {1.14241978407872501809e-24f, "11424198", -23},
  {1.13945098591980268972e+24f, "1139451", 25},
  {1.35194498663777911230e-31f, "1351945", -30},
  {5.07064167557282720470e-36f, "50706417", -35},
  {8.00664083056756722237e+22f, "8006641", 23},
  {5.51366623122121046360e+23f, "55136662", 24},
  {2.41154785156250000000e+01f, "24115479", 2},
  {3.67778908549939200000e+16f, "3677789", 17},
  {1.82848616468147150780e-29f, "18284862", -28},
  {1.33836953379405824000e+20f, "13383695", 21},
  {1.57514225629614533771e+24f, "15751423", 25},
  {2.40085801076809943003e+31f, "2400858", 32},
  {1.18571737714803782104e-15f, "11857174", -14},
  {1.34546363404829149511e-32f, "13454636", -31},
  {2.76266357421875000000e+02f, "27626636", 3},
  {6.93015633263156656042e-34f, "69301563", -33},
  {5.66790210071009953043e-24f, "5667902", -23},
  {3.48891746606180477085e-22f, "34889175", -21},
  {2.31777582834813899815e-22f, "23177758", -21},
  {6.23358370930617123812e+24f, "62335837", 25},
  {1.18060753084317367945e-32f, "11806075", -31},
  {5.69247076415910707200e+19f, "56924708", 20},
  {6.07965844334756866374e-10f, "60796584", -9},
  {1.31404469777856691847e-29f, "13140447", -28},
  {4.63684719601894649805e-20f, "46368472", -19},
  {6.32773652825277917713e-37f, "63277365", -36},
  {8.50045843447683885374e-16f, "85004584", -15},
  {4.84273781663081676174e-24f, "4842738", -23},
  {6.21591260961811361011e+31f, "62159126", 32},
  {6.24621616767777321482e-17f, "6246216", -16},
  {9.08420474260429600122e-15f, "9084205", -14},
  {9.43399515246073903216e-32f, "9433995", -31},
  {9.96214887851542068750e-32f, "9962149", -31},
  {1.96638495708612026647e-07f, "1966385", -6},
  {8.07011711611267785507e-29f, "8070117", -28},
  {1.35632530909696245146e+30f, "13563253", 31},
  {1.56049132122356901793e-22f, "15604913", -21},
  {3.03923920896000000000e+11f, "30392392", 12},
  {7.31985600000000000000e+07f, "7319856", 8},
  {4.37130095575638533134e-13f, "4371301", -12},
  {5.72054936753829679219e-08f, "57205494", -7},
  {1.66138491408673871774e-07f, "16613849", -6},
  {1.49922511680886890195e-20f, "14992251", -19},
  {1.12995038312529920000e+16f, "11299504", 17},
  {3.71310144662857055664e-01f, "37131014", 0},
  {6.99735673841110745088e+20f, "6997357", 21},
  {1.24395206018744503501e+21f, "1243952", 22},
  {3.37279889440768000000e+14f, "3372799", 15},
  {3.89834504365306292341e+37f, "3898345", 38},
  {4.88393273706546936595e+37f, "48839327", 38},
  {2.97466778755187988281e+00f, "29746678", 1},
  {6.73551008016974260760e-34f, "673551", -33},
  {3.89953673516338380800e+18f, "38995367", 19},
  {2.84101194386896699943e+29f, "2841012", 30},
  {1.48043149639350307224e-24f, "14804315", -23},
  {2.98140341907433560507e+37f, "29814034", 38},
  {2.99192215393146115931e+31f, "29919222", 32},
  {2.12983131408691406250e-01f, "21298313", 0},
  {1.92885785094077021469e-25f, "19288579", -24},
  {2.43591878389757609666e+24f, "24359188", 25},
  {2.15940044529290602086e+21f, "21594004", 22},
  {2.85991281270980834961e-01f, "28599128", 0},
  {3.89607632371025878152e+31f, "38960763", 32},
  {3.64323821169322624644e+28f, "36432382", 29},
  {9.09406650233568282315e+30f, "90940665", 31},
  {4.57217366918833932879e-36f, "45721737", -35},
  {7.04413735177483714560e+19f, "70441374", 20},
  {1.99949557820632884193e-30f, "19994956", -29},
  {2.28703233638400000000e+14f, "22870323", 15},
  {7.27639996866979998913e-12f, "72764", -11},
  {1.45245285239070653915e-04f, "14524529", -3},
  {1.90378274919698083969e-32f, "19037827", -31},
  {2.05678480188336242688e+20f, "20567848", 21},
  {3.64814723448832000000e+14f, "36481472", 15},
  {3.39826968664590537196e+22f, "33982697", 23},
  {1.01859285586069786275e-19f, "101859286", -18},
  {3.61689599230885505676e-04f, "3616896", -3},
  {6.07091875000000000000e+04f, "60709188", 5},
  {5.59330339443056050367e+33f, "55933034", 34},
  {2.00572758330963551998e-05f, "20057276", -4},
  {4.09970507812500000000e+03f, "4099705", 4},
  {2.38733664446044713259e-05f, "23873366", -4},
  {2.12622404098510742188e+00f, "2126224", 1},
  {2.34820363163798517554e-17f, "23482036", -16},
  {9.64558683982539785684e-15f, "9645587", -14},
  {5.21529221709824000000e+14f, "52152922", 15},
  {9.48814109508923613222e-19f, "9488141", -18},
  {3.88073899788656374331e-22f, "3880739", -21},
  {1.60959943310297181631e-25f, "16095994", -24},
  {2.98978429782437160611e-05f, "29897843", -4},
  {1.38433705802952776831e-36f, "13843371", -35},
  {5.75635631461895972435e+34f, "57563563", 35},
  {1.43223039566108321021e+33f, "14322304", 34},
  {9.14370552358071684904e+33f, "91437055", 34},
  {2.96224964448956542301e+24f, "29622496", 25},
  {1.83450979021773935592e+25f, "18345098", 26},
  {6.80766211692976001251e+36f, "6807662", 37},
  {2.97395812500000000000e+05f, "2973958", 6},
  {6.04471389696583692208e+33f, "6044714", 34},
  {2.09502391500800000000e+12f, "20950239", 13},
  {3.68177952164559924641e+32f, "36817795", 33},
  {1.26102839281827527884e-09f, "12610284", -8},
  {6.68669205894764953600e+18f, "6686692", 19},
  {1.07542264938496000000e+14f, "107542265", 15},
  {6.35595856632357282979e-34f, "63559586", -33},
  {3.19737396240234375000e+02f, "3197374", 3},
  {1.82670153660441874154e+33f, "18267015", 34},
  {3.62106170654296875000e+01f, "36210617", 2},
  {2.71583040979234085665e-32f, "27158304", -31},
  {1.47014859815853268457e+28f, "14701486", 29},
  {1.20133583592216500829e+35f, "12013358", 36},
  {1.89421158400000000000e+10f, "18942116", 11},
  {4.65865474011905016799e-16f, "4658655", -15},
  {3.68449109373614192009e-04f, "3684491", -3},
  {7.27990563199275119743e+31f, "72799056", 32},
  {7.55125824000000000000e+08f, "7551258", 9},
  {2.75056042424162264475e-28f, "27505604", -27},
  {9.76354098796756210570e-26f, "9763541", -25},
  {4.79376276113253066227e+25f, "47937628", 26},
  {6.81666493203606470297e-15f, "6816665", -14},
  {4.96049536000000000000e+08f, "49604954", 9},
  {1.06884567233745653003e+28f, "10688457", 29},
  {5.65742321739824024465e-19f, "5657423", -18},
  {9.99054748535156250000e+02f, "99905475", 3},
  {1.39047017199198210621e+23f, "13904702", 24},
  {2.35683090856816178485e-33f, "2356831", -32},
  {2.68936487662907453000e-11f, "26893649", -10},
  {1.32303104751942028493e+21f, "1323031", 22},
  {1.14359230464000000000e+11f, "11435923", 12},
  {2.24772871578357807780e-16f, "22477287", -15},
  {3.91412413591751828790e-06f, "3914124", -5},
  {5.89392031250000000000e+04f, "58939203", 5},
  {4.80726168371200000000e+13f, "48072617", 14},
  {3.81539479343063043541e-26f, "38153948", -25},
  {8.99175779662614958702e-21f, "8991758", -20},
  {4.68735056036023500800e+18f, "46873506", 19},
  {1.94215897831833600000e+15f, "1942159", 16},
  {2.24138663814457206824e-26f, "22413866", -25},
  {2.48930415222606892088e-19f, "24893042", -18},
  {8.62613617947029222195e+21f, "8626136", 22},
  {4.58408806925141465345e-37f, "4584088", -36},
  {4.21940020305043741310e-23f, "42194002", -22},
  {2.29982333621592260897e-07f, "22998233", -6},
  {3.60300710707667226629e-14f, "3603007", -13},
  {2.42598857932800000000e+12f, "24259886", 13},
  {2.44976226262093310648e-14f, "24497623", -13},
  {4.34654148494022278759e+33f, "43465415", 34},
  {1.10709152371883659756e+23f, "11070915", 24},
  {4.03102606534957885742e-01f, "4031026", 0},
  {2.82365880196317315072e+20f, "28236588", 21},
  {1.09173934389117079941e-30f, "10917393", -29},
  {2.88001076537620909506e-31f, "28800108", -30},
  {4.27917030400000000000e+09f, "42791703", 10},
  {9.82811401706307208315e-11f, "9828114", -10},
  {4.85028167680000000000e+10f, "48502817", 11},
  {8.74002410000684903935e-07f, "8740024", -6},
  {3.71743117284495383501e-05f, "3717431", -4},
  {2.14332842305868753330e+38f, "21433284", 39},
  {1.61595257370697581120e-24f, "16159526", -23},
  {5.80020357169601152623e-33f, "58002036", -32},
  {7.06114193401970527408e-17f, "7061142", -16},
  {1.06280627200000000000e+09f, "10628063", 10},
  {5.77571880960000000000e+10f, "5775719", 11},
  {5.44427925642575735499e+35f, "54442793", 36},
  {6.87406760238709630566e+21f, "68740676", 22},
  {7.98544333124895442025e+28f, "7985443", 29},
  {3.72613270051225600000e+15f, "37261327", 16},
  {1.84472519904375076294e-02f, "18447252", -1},
  {2.62121106176539548442e-36f, "2621211", -35},
  {1.49764470714137220352e+35f, "14976447", 36},
  {2.18418927750399344144e-19f, "21841893", -18},
  {1.88813676785896753227e-34f, "18881368", -33},
  {9.02640609289532047691e-27f, "9026406", -26},
  {8.51686614630400000000e+12f, "8516866", 13},
  {1.14408205131866225202e-09f, "1144082", -8},
  {3.62673047729257479510e+24f, "36267305", 25},
  {3.53123368335708773438e+37f, "35312337", 38},
  {6.75966215578469205305e-15f, "6759662", -14},
  {5.27530464000000000000e+08f, "52753046", 9},
  {1.98873206973075866699e-02f, "1988732", -1},
  {2.79808559025693196182e-33f, "27980856", -32},
  {9.72163699965952000000e+16f, "9721637", 17},
  {9.08657937500000000000e+05f, "90865794", 6},
  {2.03642116243456000000e+15f, "20364212", 16},
  {1.27894725764945538697e-32f, "12789473", -31},
  {6.06023142229954926820e-23f, "60602314", -22},
  {2.59002162226281648358e-30f, "25900216", -29},
  {8.03669281005859375000e+01f, "8036693", 2},
  {1.85881456576107317282e-23f, "18588146", -22},
  {7.08405788101207833582e-16f, "7084058", -15},
  {7.63703520000000000000e+07f, "7637035", 8},
  {2.09562867879867553711e-01f, "20956287", 0},
  {1.27764503176414746381e+32f, "1277645", 33},
  {6.16288451612254082899e-21f, "61628845", -20},
  {1.60501847858540713787e-04f, "16050185", -3},
  {1.16019428117708800000e+15f, "11601943", 16},
  {7.20572018522986032273e-31f, "720572", -30},
  {7.95501607965756213995e-28f, "7955016", -27},
  {3.13057786233486584406e-26f, "3130578", -25},
  {3.16849107403354159934e-28f, "3168491", -27},
  {1.74761368148755419622e-31f, "17476137", -30},
  {1.16192165933171054348e-06f, "11619217", -5},
  {1.01227988198717215011e-23f, "10122799", -22},
  {2.53499373185437682732e-19f, "25349937", -18},
  {1.42349250824549338153e-32f, "14234925", -31},
  {1.84356737500000000000e+06f, "18435674", 7},
  {1.28578180221032694572e-33f, "12857818", -32},
  {6.99209799725768926275e-34f, "6992098", -33},
  {2.10536305320908073450e+30f, "2105363", 31},
  {1.14999720673280000000e+14f, "11499972", 15},
  {2.22830786132812500000e+03f, "22283079", 4},
  {9.81568401191160304132e+35f, "9815684", 36},
  {1.47774255054855530034e-08f, "147774255", -7},
  {2.87329714098047074797e-30f, "28732971", -29},
  {2.82707597721600000000e+12f, "2827076", 13},
  {3.19061838090419769287e-02f, "31906184", -1},
  {2.79373150047917961913e-14f, "27937315", -13},
  {1.13763375419676111667e+21f, "113763375", 22},
  {8.77052459716796875000e+01f, "87705246", 2},
  {1.17282561130393628336e-33f, "11728256", -32},
  {4.74707320000000000000e+07f, "47470732", 8},
  {2.46124398585642308293e-38f, "2461244", -37},
  {2.33355815685181673279e+37f, "23335582", 38},
  {4.77264769552855902401e+25f, "47726477", 26},
  {6.64906518068164587021e-04f, "6649065", -3},
  {3.96771805102080000000e+13f, "3967718", 14},
  {5.50678252714486599088e+33f, "55067825", 34},
  {8.93417040000000000000e+07f, "89341704", 8},
  {2.07165698151193276685e+26f, "2071657", 27},
  {2.51068622135950614926e-33f, "25106862", -32},
  {2.48505492412825600000e+15f, "2485055", 16},
  {3.37650938442294847180e-19f, "33765094", -18},
  {4.02193080924513200920e-18f, "4021931", -17},
  {1.05727259407199330682e+35f, "10572726", 36},
  {7.78534029778621405882e-13f, "77853403", -12},
  {1.18681651139857273904e+27f, "11868165", 28},
  {1.82595254721277262150e-37f, "18259525", -36},
  {9.10321986680173722561e-08f, "910322", -7},
  {3.63918337682230476800e+18f, "36391834", 19},
  {3.54867914735616000000e+15f, "35486791", 16},
  {3.35486306265682624697e+34f, "3354863", 35},
  {4.75194698445619200000e+15f, "4751947", 16},
  {7.68805455208271019775e-32f, "76880546", -31},
  {1.38327629347706973373e-34f, "13832763", -33},
  {1.95104748329510968574e-11f, "19510475", -10},
  {4.14271562500000000000e+05f, "41427156", 6},
  {6.53038789710791434118e-10f, "6530388", -9},
  {3.20082184056590241391e-29f, "32008218", -28},
  {2.43407484375000000000e+05f, "24340748", 6},
  {8.98908580201198765487e+30f, "8989086", 31},
  {5.92390639711604316557e-24f, "59239064", -23},
  {1.64374977635781340089e-26f, "16437498", -25},
  {3.69075357143272977712e+31f, "36907536", 32},
  {1.95175811324078686505e-25f, "19517581", -24},
  {1.28072961064909616291e+38f, "12807296", 39},
  {3.43835723781715785208e-11f, "34383572", -10},
  {1.25690270189734333525e+27f, "12569027", 28},
  {1.01642985732587039810e+33f, "101642986", 34},
  {5.02682725656053627418e+35f, "50268273", 36},
  {3.81143820009472000000e+14f, "38114382", 15},
  {1.77713171660800000000e+12f, "17771317", 13},
  {1.98473987117868270807e+34f, "19847399", 35},
  {2.35025421237650413114e-18f, "23502542", -17},
  {2.53528896000000000000e+08f, "2535289", 9},
  {2.25271108931078098045e-17f, "22527111", -16},
  {4.01446517596778614504e-30f, "4014465", -29},
  {7.86246758400000000000e+09f, "78624676", 10},
  {3.23841540751360000000e+14f, "32384154", 15},
  {2.29078205433424934633e+27f, "2290782", 28},
  {3.99766550700404732499e-14f, "39976655", -13},
  {1.51683133440000000000e+10f, "15168313", 11},
  {1.56108662109375000000e+04f, "15610866", 5},
  {4.68701415456962422468e-07f, "46870142", -6},
  {3.38417485348864000000e+14f, "3384175", 15},
  {5.05588929011787972308e+31f, "50558893", 32},
  {3.28839695671472710602e+37f, "3288397", 38},
  {3.09052158510564664439e-34f, "30905216", -33},
  {2.27853928411988819527e-36f, "22785393", -35},
  {1.14954121093750000000e+04f, "11495412", 5},
  {4.57744630720206666531e+35f, "45774463", 36},
  {2.21031565598244577861e-21f, "22103157", -20},
  {3.01748102816071680000e+16f, "3017481", 17},
  {2.37121402008108602025e+28f, "2371214", 29},
  {7.10704739503853488714e-08f, "71070474", -7},
  {5.31662942031052800000e+15f, "53166294", 16},
  {1.16769225820860913471e-21f, "11676923", -20},
  {1.30937223820283188265e-19f, "13093722", -18},
  {7.50153420800000000000e+09f, "7501534", 10},
  {7.82212385511809117916e-25f, "7822124", -24},
  {8.10921288314163346735e+33f, "8109213", 34},
  {4.17078630400000000000e+09f, "41707863", 10},
  {2.33284443085158630818e+26f, "23328444", 27},
  {2.33408176908429302775e+29f, "23340818", 30},
  {1.64414667046226826903e+30f, "16441467", 31},
  {8.52357770781964063644e-05f, "8523578", -4},
  {7.08442775946749466494e-27f, "7084428", -26},
  {6.69135851387747021799e-39f, "6691359", -38},
  {9.45343760861814888836e-34f, "9453438", -33},
  {3.85859252652985482060e+26f, "38585925", 27},
  {3.51504892419033833254e+27f, "3515049", 28},
  {6.08593175854821311077e-09f, "60859318", -8},
  {7.91095755994319915771e-03f, "7910958", -2},
  {7.89964360592421144247e-08f, "78996436", -7},
  {4.83436199840309470822e+23f, "4834362", 24},
  {3.92556330181622683497e-27f, "39255633", -26},
  {5.58384701730653063012e-15f, "5583847", -14},
  {2.16426627506780546007e+22f, "21642663", 23},
  {1.92656960802945241490e-22f, "19265696", -21},
  {1.97553583734799698135e-12f, "19755358", -11},
  {3.52202208370178126984e-13f, "3522022", -12},
  {1.23774001662406923232e-25f, "123774", -24},
  {7.29181000000000000000e+05f, "729181", 6},
  {1.47338473703403227244e-35f, "14733847", -34},
  {4.19559576000917275703e-36f, "41955958", -35},
  {8.41756063211120815720e+36f, "84175606", 37},
  {1.29548627133637591040e+19f, "12954863", 20},
  {7.68826690951379776470e-19f, "7688267", -18},
  {1.51690888928999583329e-21f, "15169089", -20},
  {1.34012204111577659660e-10f, "1340122", -9},
  {1.01566598459612578154e-04f, "1015666", -3},
  {1.74823008917126098711e-26f, "17482301", -25},
  {9.30102119580176750341e+37f, "9301021", 38},
  {3.25193385418238517992e-17f, "3251934", -16},
  {5.49383614355956659661e-36f, "5493836", -35},
  {2.20307028911799634930e+29f, "22030703", 30},
  {4.51984319368396800000e+17f, "45198432", 18},
  {6.35904167800550066693e-24f, "63590417", -23},
  {3.10506363244260115592e+29f, "31050636", 30},
  {6.78230799846931997655e+22f, "6782308", 23},
  {3.51687117635726402187e-36f, "3516871", -35},
  {1.59021033567394201600e+18f, "15902103", 19},
  {5.90996495694568537656e-25f, "5909965", -24},
  {4.72513389587402343750e+00f, "4725134", 1},
  {1.72123428580736135345e-28f, "17212343", -27},
  {4.37474690044771491029e+37f, "4374747", 38},
  {3.07024678092800000000e+12f, "30702468", 13},
  {1.55803354573436081409e-04f, "15580335", -3},
  {1.38631112588360312422e+21f, "13863111", 22},
  {9.63240264318841984997e+28f, "9632403", 29},
  {5.14701494497407391498e+22f, "5147015", 23},
  {6.79703418348851430917e-31f, "6797034", -30},
  {1.70065506162990926383e-35f, "1700655", -34},
  {5.10250071361628698696e-11f, "51025007", -10},
  {1.57301079320505799320e-27f, "15730108", -26},
  {1.11369582100047665074e-32f, "11136958", -31},
  {6.07712122811798760580e-13f, "6077121", -12},
  {3.42737753638810549170e+30f, "34273775", 31},
  {1.43688197191266242569e-12f, "1436882", -11},
  {1.47747375000000000000e+05f, "14774738", 6},
  {6.51830213413091257571e-19f, "6518302", -18},
  {2.34972811060262438175e+22f, "2349728", 23},
  {4.26537909449916416000e+17f, "4265379", 18},
  {8.65381945815743231171e-20f, "86538195", -19},
  {1.09051419078149802437e-33f, "10905142", -32},
  {3.85312890022193528832e+20f, "3853129", 21},
  {2.50754363477861388186e-29f, "25075436", -28},
  {7.49422171532531492454e+22f, "74942217", 23},
  {4.07871373927264922924e+35f, "40787137", 36},
  {1.11231316618219588580e-38f, "11123132", -37},
  {7.46152400000000000000e+06f, "7461524", 7},
  {2.37529712475107546884e+38f, "23752971", 39},
  {3.05648509505450803200e+18f, "3056485", 19},
  {7.13022911222969794560e+20f, "7130229", 21},
  {1.57735776901245117188e+00f, "15773578", 1},
  {8.16182371938413566898e+28f, "8161824", 29},
  {4.56153289503801344000e+19f, "4561533", 20},
  {6.37686574980291236915e-27f, "63768657", -26},
  {1.85665979796469440832e-14f, "18566598", -13},
  {9.02820587158203125000e+01f, "9028206", 2},
  {8.94748306496713950874e-37f, "8947483", -36},
  {1.31653919083055987834e-30f, "13165392", -29},
  {9.74021324800000000000e+09f, "9740213", 10},
  {2.46853905508176534665e-33f, "2468539", -32},
  {1.11102936789393424988e-02f, "11110294", -1},
  {2.55291864754556397158e+21f, "25529186", 22},
  {4.55352701206527355041e-27f, "4553527", -26},
  {1.06294246635574598304e+24f, "10629425", 25},
  {1.26053745950720000000e+13f, "12605375", 14},
  {9.94558393955230712891e-01f, "9945584", 0},
  {2.19525980726942293586e-10f, "21952598", -9},
  {1.25658991546222435009e+33f, "12565899", 34},
  {3.42240816836792869585e-17f, "34224082", -16},
  {1.34655052551242055270e-31f, "13465505", -30},
  {1.58449676976319125362e-25f, "15844968", -24},
  {5.99764769099175865108e-12f, "59976477", -11},
  {8.27466572902476448703e+27f, "8274666", 28},
  {6.74621243725259623833e-16f, "67462124", -15},
  {6.59290742279703664777e-28f, "65929074", -27},
  {4.59016731500465340862e+24f, "45901673", 25},
  {1.30150413405974050771e-15f, "13015041", -14},
  {8.13553736000471040000e+17f, "81355374", 18},
  {1.56498227965198557459e+24f, "15649823", 25},
  {5.38930116146607129568e-36f, "5389301", -35},
  {8.09599339962005615234e-01f, "80959934", 0},
  {3.32512820785100561560e-15f, "33251282", -14},
  {7.38713590148158526767e+31f, "7387136", 32},
  {5.02962647818893578335e-20f, "50296265", -19},
  {3.60434595495462417603e-03f, "3604346", -2},
  {1.91019106334508754768e-21f, "1910191", -20},
  {7.47469044816633921536e+20f, "74746904", 21},
  {5.17374813556671142578e-01f, "5173748", 0},
  {4.08474415316412153842e-13f, "40847442", -12},
  {1.04320934113388830156e-08f, "10432093", -7},
  {2.14554796875000000000e+05f, "2145548", 6},
  {7.36602774272413177741e+23f, "7366028", 24},
  {3.82926457051812955313e-26f, "38292646", -25},
  {1.50769209108856832000e+17f, "15076921", 18},
  {1.06144633600000000000e+09f, "106144634", 10},
  {7.40613162727024149156e+25f, "74061316", 26},
  {2.19230832178807850035e-22f, "21923083", -21},
  {3.96176256082104069262e+37f, "39617626", 38},
  {1.36544531549129801728e+20f, "13654453", 21},
  {1.26834094524383544922e+00f, "1268341", 1},
  {7.57045324831225141352e-33f, "7570453", -32},
  {3.59035571546306252971e+33f, "35903557", 34},
  {1.18654187627280335123e+27f, "11865419", 28},
  {9.86241327733853186178e+33f, "9862413", 34},
  {3.22222633844420001165e-21f, "32222263", -20},
  {1.31798738297052409890e+38f, "13179874", 39},
  {6.63300840372148633600e+19f, "66330084", 20},
  {7.00124206542968750000e+02f, "7001242", 3},
  {1.41274496706281472000e+17f, "1412745", 18},
  {1.43183515625000000000e+05f, "14318352", 6},
  {6.07299937500000000000e+05f, "60729994", 6},
  {1.67265307934083050076e-22f, "16726531", -21},
  {7.78133179041641775393e+28f, "7781332", 29},
  {6.18563219904899597168e-02f, "61856322", -1},
  {1.40173907857388257980e-03f, "14017391", -2},
  {4.11480284524465278473e-13f, "41148028", -12},
  {1.99415803999682560000e+16f, "1994158", 17},
  {1.44134737416685808491e-21f, "14413474", -20},
  {3.56770268328503637055e+25f, "35677027", 26},
  {1.14560907147099871167e-35f, "11456091", -34},
  {2.36612864000000000000e+09f, "23661286", 10},
  {1.10371578543322357291e-08f, "11037158", -7},
  {1.38906358815669617459e+27f, "13890636", 28},
  {1.49528019431996197437e+22f, "14952802", 23},
  {2.41005494178469331864e-30f, "2410055", -29},
  {2.14682542718946933746e-03f, "21468254", -2},
  {1.60806758400000000000e+09f, "16080676", 10},
  {8.88372966227450600041e-14f, "888373", -13},
  {1.19750147860031574965e-04f, "11975015", -3},
  {3.13891357350826183392e-10f, "31389136", -9},
  {1.77101171601431357324e+25f, "17710117", 26},
  {1.52366424560546875000e+02f, "15236642", 3},
  {1.53753261766922987366e-15f, "15375326", -14},
  {3.07536917954560000000e+13f, "30753692", 14},
  {2.12850491516292095184e-03f, "2128505", -2},
  {8.36185363769531250000e+02f, "83618536", 3},
  {5.70616499404800000000e+12f, "5706165", 13},
  {1.99865369806463110789e-22f, "19986537", -21},
  {7.70837859226903830639e-34f, "7708379", -33},
  {1.17161247370489718378e-09f, "11716125", -8},
  {4.67532835508659735757e+21f, "46753284", 22},
  {7.96415754240000000000e+10f, "79641575", 11},
  {3.08329240000000000000e+07f, "30832924", 8},
  {5.34462398464000000000e+11f, "5344624", 12},
  {7.18393385505036424340e-30f, "7183934", -29},
  {6.13007332189990619147e-35f, "61300733", -34},
  {3.73049923062864375305e+37f, "37304992", 38},
  {2.40879889957508538696e+25f, "2408799", 26},
  {1.37029904823115886061e-17f, "137029905", -16},
  {1.93250584108934975036e+24f, "19325058", 25},
  {4.55082368695951562952e+28f, "45508237", 29},
  {5.45913060759812597404e+30f, "54591306", 31},
  {2.85850785646108199116e-23f, "2858508", -22},
  {9.15755489285898240000e+16f, "9157555", 17},
  {1.16798968037376000000e+14f, "11679897", 15},
  {1.14217437794500963066e-14f, "11421744", -13},
  {2.83317767084509371577e-25f, "28331777", -24},
  {2.57003957529041630707e-16f, "25700396", -15},
  {1.60846151680000000000e+11f, "16084615", 12},
  {5.72101273600000000000e+09f, "57210127", 10},
  {1.32433628364800000000e+13f, "13243363", 14},
  {3.91208194196224212646e-03f, "3912082", -2},
  {1.22977675852721466501e-27f, "12297768", -26},
  {3.28772313703817579069e+36f, "3287723", 37},
  {1.76668298248811896612e-28f, "1766683", -27},
  {4.32767456000000000000e+08f, "43276746", 9},
  {3.73975706100463867188e+00f, "3739757", 1},
  {1.58228712703297608221e+23f, "15822871", 24},
  {1.45057505409216186239e+25f, "1450575", 26},
  {4.90335968750000000000e+05f, "49033597", 6},
  {2.69884032862371168133e-25f, "26988403", -24},
  {9.93169600000000000000e+07f, "9931696", 8},
  {5.44970798637748951323e-23f, "5449708", -22},
  {1.34925649331201717043e+21f, "13492565", 22},
  {7.72115069928401911145e-20f, "7721151", -19},
  {6.63794987401135350158e-14f, "663795", -13},
  {1.36950126801175700098e+25f, "13695013", 26},
  {3.99248375781843815754e-21f, "39924838", -20},
  {2.28295440783886954485e-27f, "22829544", -26},
  {2.74294859426807070054e-31f, "27429486", -30},
  {1.06943554521090191380e-35f, "106943555", -34},
  {1.46877524532938856033e-37f, "14687752", -36},
  {2.49676036290350386234e+38f, "24967604", 39},
  {5.03291613671096796099e-20f, "5032916", -19},
  {2.11300062689073561600e+18f, "21130006", 19},
  {3.96625381949440000000e+13f, "3966254", 14},
  {9.59634453125000000000e+04f, "95963445", 5},
  {9.75808266962077954266e+31f, "9758083", 32},
  {1.70768587476467890336e+36f, "17076859", 37},
  {2.16336946435102502372e-23f, "21633695", -22},
  {7.85819519042968750000e+02f, "7858195", 3},
  {3.07573964800000000000e+10f, "30757396", 11},
  {1.43911897006080000000e+13f, "1439119", 14},
  {1.48786777161728000000e+14f, "14878678", 15},
  {1.37844304000000000000e+08f, "1378443", 9},
  {4.18810265763483232502e+23f, "41881027", 24},
  {9.26690969638748938096e-17f, "926691", -16},
  {7.48194631134540736182e-31f, "74819463", -30},
  {9.61533600000000000000e+07f, "9615336", 8},
  {1.84473149660983552116e-30f, "18447315", -29},
  {6.21842268160000000000e+13f, "62184227", 14},
  {4.10344354147955900416e+21f, "41034435", 22},
  {2.97089051142389760000e+16f, "29708905", 17},
  {5.69429561817497837371e+29f, "56942956", 30},
  {7.70351367187500000000e+03f, "77035137", 4},
  {3.56723732140281237446e+35f, "35672373", 36},
  {5.20015594108752957785e-23f, "5200156", -22},
  {1.50964102330064520174e-10f, "1509641", -9},
  {2.07101152283392149197e-24f, "20710115", -23},
  {2.00473561362546348619e-11f, "20047356", -10},
  {6.59223413094878196716e-03f, "6592234", -2},
  {3.48555492436519486184e-21f, "3485555", -20},
  {4.51578191507095993984e-10f, "4515782", -9},
  {2.25600763224065303802e-03f, "22560076", -2},
  {2.94620729982852935791e-02f, "29462073", -1},
  {1.39805831346686453028e-30f, "13980583", -29},
  {1.29484567392342280421e-28f, "12948457", -27},
  {4.06208309155376255731e-36f, "4062083", -35},
  {1.85730564746908466258e-37f, "18573056", -36},
  {3.09050677387682628357e-31f, "30905068", -30},
  {1.34471860281776041292e-20f, "13447186", -19},
  {2.47370527343750000000e+04f, "24737053", 5},
  {1.56496321223799603200e+18f, "15649632", 19},
  {3.28685218045497393863e+31f, "32868522", 32},
  {5.30928218768504957433e-21f, "5309282", -20},
  {3.14778259881409727683e-13f, "31477826", -12},
  {1.81273518543994880000e+16f, "18127352", 17},
  {7.91296997070312500000e+01f, "791297", 2},
  {3.91024223063141107559e-05f, "39102422", -4},
  {2.55629651866077448746e-15f, "25562965", -14},
  {2.41486950400000000000e+10f, "24148695", 11},
  {3.30908280140657764616e-30f, "33090828", -29},
  {1.45069418220749037840e-32f, "14506942", -31},
  {9.59348269227722205699e-13f, "9593483", -12},
  {3.13994376398464740730e+38f, "31399438", 39},
  {1.81708656640000000000e+10f, "18170866", 11},
  {5.01061863492248535032e-16f, "50106186", -15},
  {2.39558992000891724133e-23f, "23955899", -22},
  {1.72517582774162292480e-01f, "17251758", 0},
  {7.78371328125000000000e+04f, "7783713", 5},
  {4.07057534903287887573e-03f, "40705753", -2},
  {1.01521576494628864000e+17f, "10152158", 18},
  {5.85282947705648512333e+33f, "58528295", 34},
  {1.55398071532726598554e+33f, "15539807", 34},
  {4.28303390462836189669e-24f, "4283034", -23},
  {1.14319803096444457521e-35f, "1143198", -34},
  {2.84940611241039834857e-34f, "2849406", -33},
  {2.78559695184481029305e-21f, "2785597", -20},
  {3.61013577632843632354e-34f, "36101358", -33},
  {1.35265917788488673882e-26f, "13526592", -25},
  {6.36242469772696495056e-03f, "63624247", -2},
  {1.48640179200000000000e+09f, "14864018", 10},
  {3.55945812234719199487e+30f, "3559458", 31},
  {2.90880902698020804564e-10f, "2908809", -9},
  {1.20782285189297393320e+27f, "120782285", 28},
  {1.51480670750621391396e-21f, "15148067", -20},
  {7.73819702685856110483e-33f, "7738197", -32},
  {1.38271671890066727428e-10f, "13827167", -9},
  {9.40897206272000000000e+12f, "9408972", 13},
  {3.15655257487890139600e-09f, "31565526", -8},
  {5.28133638012026853786e+21f, "52813364", 22},
  {7.31095392256975173950e-03f, "7310954", -2},
  {7.49513786538896775724e-13f, "7495138", -12},
  {2.31851627930260288307e+21f, "23185163", 22},
  {1.90242464179875830982e-31f, "19024246", -30},
  {6.10397061120000000000e+10f, "61039706", 11},
  {9.43175653750450525805e+36f, "94317565", 37},
  {1.26586847240333645170e-31f, "12658685", -30},
  {1.45987220112236888069e-29f, "14598722", -28},
  {1.00434771728515625000e+03f, "10043477", 4},
  {8.68883125000000000000e+04f, "8688831", 5},
  {2.42253231607052141104e+26f, "24225323", 27},
  {8.50648898631334304810e-03f, "8506489", -2},
  {1.90369218587875366211e-01f, "19036922", 0},
  {1.39930283594541509784e-36f, "13993028", -35},
  {1.59063529968261718750e+01f, "15906353", 2},
  {8.21207031250000000000e+03f, "821207", 4},
  {6.52394247193275853317e-19f, "65239425", -18},
  {9.76635187500000000000e+05f, "9766352", 6},
  {1.88974545229578240000e+16f, "18897455", 17},
  {6.53187353749225472000e+17f, "65318735", 18},
  {2.06315939859857784571e-24f, "20631594", -23},
  {9.75077120000000000000e+07f, "9750771", 8},
  {2.72634967363897934310e-31f, "27263497", -30},
  {3.60644342976033036407e-36f, "36064434", -35},
  {2.40111283307247338091e+25f, "24011128", 26},
  {3.38734136340637483859e-25f, "33873414", -24},
  {8.26234227702116186265e-08f, "8262342", -7},
  {3.27755630016326904297e-01f, "32775563", 0},
  {1.74676906250000000000e+05f, "1746769", 6},
  {5.89959228136649471708e-08f, "58995923", -7},
  {2.47959465449713319747e-18f, "24795947", -17},
  {1.81200402229888339237e-36f, "1812004", -35},
  {7.50677764993135411200e+18f, "75067776", 19},
  {8.38531046094016540498e-36f, "83853105", -35},
  {5.72307115417612808353e-29f, "5723071", -28},
  {6.53910536829727107033e-10f, "65391054", -9},
  {1.09759661760597951094e-37f, "10975966", -36},
  {1.20051180011748340621e-21f, "12005118", -20},
  {1.56089210510253906250e+00f, "15608921", 1},
  {1.84939570312500000000e+04f, "18493957", 5},
  {1.64633464129166099087e+22f, "16463346", 23},
  {5.12235165308488893388e-13f, "51223517", -12},
  {2.29007414529649807188e-37f, "22900741", -36},
  {4.39259168250106253985e-18f, "43925917", -17},
  {1.15624253227419870882e-10f, "11562425", -9},
  {6.17424072265625000000e+02f, "6174241", 3},
  {6.13422723988216237942e+24f, "6134227", 25},
  {1.28052582400000000000e+10f, "12805258", 11},
  {8.43047997449285022907e-31f, "843048", -30},
  {1.68646133422851562500e+02f, "16864613", 3},
  {1.18149023550784271208e-11f, "11814902", -10},
  {2.92164877504718875113e-16f, "29216488", -15},
  {2.23471805395276400870e-29f, "2234718", -28},
  {4.91333659738302230835e-04f, "49133366", -3},
  {1.72149173713852243761e-13f, "17214917", -12},
  {8.40630611316973187952e+34f, "8406306", 35},
  {2.82483281920000000000e+10f, "28248328", 11},
  {2.19104794795992678400e+18f, "2191048", 19},
  {4.03715457650832831860e-05f, "40371546", -4},
  {6.54117270051157004105e-24f, "65411727", -23},
  {1.89832089604009415769e-28f, "18983209", -27},
  {1.57831694416609280000e+16f, "15783169", 17},
  {2.00108379354949529741e-21f, "20010838", -20},
  {2.38917100752685716096e+29f, "2389171", 30},
  {2.11313468484595220480e+19f, "21131347", 20},
  {1.91328931864465090484e-11f, "19132893", -10},
  {2.07303920913765315302e-19f, "20730392", -18},
  {3.87439926052451778560e+20f, "38743993", 21},
  {3.63251175000000000000e+06f, "36325118", 7},
  {5.43416469646894694400e+19f, "54341647", 20},
  {1.02423257863307887172e-14f, "10242326", -13},
  {8.58703386175108107636e-11f, "8587034", -10},
  {3.94270297382678120144e-32f, "3942703", -31},
  {3.77233726027437210604e-13f, "37723373", -12},
  {5.98312878080000000000e+10f, "59831288", 11},
  {7.74296815507113933563e-04f, "7742968", -3},
  {3.69400884598720608910e+28f, "36940088", 29},
  {4.93089901283383369446e-04f, "4930899", -3},
  {1.32687421944759398767e-32f, "13268742", -31},
  {5.14062488476832454167e+36f, "5140625", 37},
  {1.41152957717943355268e+37f, "14115296", 38},
  {2.59447642747545614839e-05f, "25944764", -4},
  {2.16750561323547000345e-18f, "21675056", -17},
  {4.33053905594343967813e-31f, "4330539", -30},
  {2.16333119737532965526e+30f, "21633312", 31},
  {5.91806920000000000000e+07f, "59180692", 8},
  {5.34346556310824826797e-35f, "53434656", -34},
  {8.64535369873046875000e+01f, "8645354", 2},
  {1.89192316869292442849e-13f, "18919232", -12},
  {3.58172297477722167969e-01f, "3581723", 0},
  {9.56769678183628800000e+16f, "9567697", 17},
  {6.03187177330255508423e-03f, "6031872", -2},
  {7.84149354578488790303e-24f, "78414935", -23},
  {3.13410369133114295331e+34f, "31341037", 35},
  {1.91346439561146386410e-12f, "19134644", -11},
  {2.76335203861353298647e+34f, "2763352", 35},
  {8.09938092241363916807e-16f, "8099381", -15},
  {6.59002120000000000000e+07f, "65900212", 8},
  {1.48006591654789120000e+16f, "14800659", 17},
  {4.93095492157527196107e+29f, "4930955", 30},
  {5.22745778955280293587e-12f, "5227458", -11},
  {2.04006097531653867724e-37f, "2040061", -36},
  {5.59001743250403042212e-20f, "55900174", -19},
  {3.16242403641808778048e-05f, "3162424", -4},
  {1.26876252559693369903e-11f, "12687625", -10},
  {5.61726362052777146184e+29f, "56172636", 30},
  {4.11231682461843652127e+30f, "41123168", 31},
  {6.81341360028148031631e-22f, "68134136", -21},
  {4.05258102466679592801e-13f, "4052581", -12},
  {9.03083478069442280289e+36f, "9030835", 37},
  {5.10357230835942865216e-24f, "51035723", -23},
  {7.88517708972310410465e-15f, "7885177", -14},
  {3.33506420702178729698e-07f, "33350642", -6},
  {1.74994335975497961044e-03f, "17499434", -2},
  {5.75858166484977118671e-07f, "57585817", -6},
  {9.81787736470342200373e-16f, "9817877", -15},
  {1.49805000068792320016e-34f, "149805", -33},
  {5.14631439000368118286e-03f, "51463144", -2},
  {1.40838043286656047676e+25f, "14083804", 26},
  {4.54417348194624537427e-09f, "45441735", -8},
  {2.90792828281598454953e+35f, "29079283", 36},
  {1.82683227539062500000e+03f, "18268323", 4},
  {4.36739445849367900486e+27f, "43673945", 28},
  {3.12635302685306134026e-27f, "3126353", -26},
  {8.08144956827163696289e-02f, "80814496", -1},
  {1.20167158026489571688e-23f, "12016716", -22},
  {1.24800201621575342164e-31f, "1248002", -30},
  {1.05483535652253125837e+22f, "10548354", 23},
  {1.34484996877461464547e+23f, "134485", 24},
  {2.88453880794018886975e+23f, "28845388", 24},
  {7.35698799820800000000e+12f, "7356988", 13},
  {9.82928680514649916572e-28f, "9829287", -27},
  {9.64002345710088271954e+24f, "96400235", 25},
  {6.91208995137500027103e+31f, "691209", 32},
  {5.25575600000000000000e+06f, "5255756", 7},
  {1.79630962060052614686e-25f, "17963096", -24},
  {5.57789909112255980503e+22f, "5577899", 23},
  {2.92983278632164001465e-02f, "29298328", -1},
  {2.00577972009341465309e-08f, "20057797", -7},
  {3.17766223205809209227e-29f, "31776622", -28},
  {3.84180719265714287758e-04f, "38418072", -3},
  {1.58420210000000000000e+07f, "15842021", 8},
  {4.17645787820219993591e-05f, "4176458", -4},
  {1.95340170103589758604e+28f, "19534017", 29},
  {4.04555564385106044989e-35f, "40455556", -34},
  {3.90249194050251622186e+27f, "3902492", 28},
  {2.78611589324308010203e-26f, "2786116", -25},
  {9.75128423498638562962e-31f, "9751284", -30},
  {2.69105331958006607773e-14f, "26910533", -13},
  {6.52515996918095797207e+37f, "652516", 38},
  {7.27969706058502197266e-01f, "7279697", 0},
  {1.14061969529243866536e-17f, "11406197", -16},
  {1.68713424682617187500e+02f, "16871342", 3},
  {4.43802850372265744738e-12f, "44380285", -11},
  {6.02312093178625218570e-06f, "6023121", -5},
  {1.89384562596512572756e-38f, "18938456", -37},
  {8.48552539062500000000e+03f, "8485525", 4},
  {1.18051162719726562500e+02f, "11805116", 3},
  {3.26401670621404678062e+22f, "32640167", 23},
  {1.65139213068044021782e-12f, "16513921", -11},
  {4.98339772767898703254e-14f, "49833977", -13},
  {3.41977924108505249023e-04f, "34197792", -3},
  {2.58132934570312500000e-01f, "25813293", 0},
  {7.05562172158579199765e-28f, "70556217", -27},
  {3.21510977563388422595e-11f, "32151098", -10},
  {1.98078291890041937176e-33f, "1980783", -32},
  {2.10913456973960480867e-14f, "21091346", -13},
  {2.55450321146368112864e-27f, "25545032", -26},
  {9.50841015625000000000e+03f, "950841", 4},
  {6.59408948884930560000e+16f, "65940895", 17},
  {1.27673052800875300790e-17f, "12767305", -16},
  {1.52655094138719627656e-15f, "15265509", -14},
  {8.70819222152806400000e+16f, "8708192", 17},
  {1.69026412094235250678e+28f, "16902641", 29},
  {1.01805317648251403284e-11f, "10180532", -10},
  {4.67850593750000000000e+05f, "4678506", 6},
  {6.71275729431066591554e-37f, "67127573", -36},
  {1.59699586220085620880e-03f, "15969959", -2},
  {2.12758522539378194434e+30f, "21275852", 31},
  {6.20009662318864028357e-38f, "62000966", -37},
  {1.81317195374166449912e+35f, "1813172", 36},
  {3.41774233706036246261e-26f, "34177423", -25},
  {1.67596899414062500000e+03f, "1675969", 4},
  {1.16456114110358556826e-15f, "11645611", -14},
  {3.18951660000000000000e+07f, "31895166", 8},
  {5.11096484375000000000e+03f, "5110965", 4},
  {1.66751763267119962526e+27f, "16675176", 28},
  {5.50829881947863189858e-30f, "5508299", -29},
  {2.24616793264090230942e-13f, "2246168", -12},
  {3.84716734967976451739e-24f, "38471673", -23},
  {4.57466667285189032555e-05f, "45746667", -4},
  {1.30005973393257529344e+22f, "13000597", 23},
  {1.68218836598784000000e+14f, "16821884", 15},
  {5.22574250000000000000e+06f, "52257425", 7},
  {5.98249933436305734203e-28f, "59824993", -27},
  {5.46343985326545960960e+19f, "546344", 20},
  {1.75451525093253093588e+31f, "17545153", 32},
  {2.35890443708866516699e-16f, "23589044", -15},
  {7.29000441301630485239e-16f, "72900044", -15},
  {1.67537344000000000000e+09f, "16753734", 10},
  {4.98681437500000000000e+05f, "49868144", 6},
  {6.11005469496435837592e-16f, "61100547", -15},
  {4.15077620037896377701e+32f, "41507762", 33},
  {6.16630721178270052932e-17f, "6166307", -16},
  {1.39921814910445928812e-26f, "13992181", -25},
  {5.82262814292763720839e-18f, "5822628", -17},
  {4.69310876617712114742e+27f, "46931088", 28},
  {1.54446994278037382645e-24f, "15444699", -23},
  {1.51445700817715200000e+18f, "1514457", 19},
  {1.45166695025963171840e+19f, "1451667", 20},
  {1.56934615866693004008e-23f, "15693462", -22},
  {3.95428814127104000000e+14f, "3954288", 15},
  {7.69139593391055590911e+31f, "7691396", 32},
  {4.20229028552848179200e+18f, "42022903", 19},
  {7.29916156560807018874e+37f, "72991616", 38},
  {3.59435129165649414062e+00f, "35943513", 1},
  {2.97053230374776550430e-17f, "29705323", -16},
  {1.64496645114760155099e+26f, "16449665", 27},
  {3.31319193600000000000e+09f, "3313192", 10},
  {1.12313100800000000000e+09f, "1123131", 10},
  {9.22166583085977334822e-37f, "9221666", -36},
  {2.00653395936510473944e-34f, "2006534", -33},
  {2.11967403629387263209e-08f, "2119674", -7},
  {2.55991153332060160000e+16f, "25599115", 17},
  {1.76989224960000000000e+11f, "17698922", 12},
  {1.94937268066406250000e+03f, "19493727", 4},
  {1.85732892714440822601e-03f, "18573289", -2},
  {4.16912109375000000000e+03f, "4169121", 4},
  {7.60575030125227834794e+25f, "76057503", 26},
  {2.27775655642820247552e+20f, "22777566", 21},
  {1.01986518573097885100e-26f, "10198652", -25},
  {5.56814434560237714322e-08f, "55681443", -7},
  {1.84824744613089306209e-34f, "18482474", -33},
  {5.72300628628361948182e-33f, "57230063", -32},
  {5.57090309406720000000e+14f, "5570903", 15},
  {4.24330679055534122007e-22f, "4243307", -21},
  {5.58604378031457571296e-12f, "55860438", -11},
  {3.83941430664062500000e+03f, "38394143", 4},
  {1.11405377367645996856e-07f, "11140538", -6},
  {1.13957256589230307680e-32f, "11395726", -31},
  {8.04142573702241786251e-17f, "8041426", -16},
  {2.83155520000000000000e+08f, "28315552", 9},
  {7.40176380013781712896e+20f, "7401764", 21},
  {8.89841175318271518295e-24f, "8898412", -23},
  {1.70738477609649885736e-12f, "17073848", -11},
  {7.26776702174819778560e+19f, "7267767", 20},
  {5.14250554055065600000e+15f, "51425055", 16},
  {8.36460544000000000000e+09f, "83646054", 10},
  {1.73303080000000000000e+07f, "17330308", 8},
  {2.39408966690992860982e-14f, "23940897", -13},
  {1.35087108174105033478e-20f, "13508711", -19},
  {2.70311628800000000000e+09f, "27031163", 10},
  {8.03984157027315404775e-10f, "80398416", -9},
  {4.86541803520000000000e+10f, "4865418", 11},
  {9.54840386987489131432e-14f, "9548404", -13},
  {1.90770329068658813555e-37f, "19077033", -36},
  {1.36454533957430433420e-25f, "13645453", -24},
  {2.98770488129618968576e+22f, "29877049", 23},
  {1.35287390625000000000e+05f, "13528739", 6},
  {1.51138923609695340439e-38f, "15113892", -37},
  {9.21719335937500000000e+03f, "9217193", 4},
  {2.32072407446192128000e+17f, "2320724", 18},
  {1.37580272507875633892e-07f, "13758027", -6},
  {2.80374272000000000000e+08f, "28037427", 9},
  {2.21769513457108180271e+23f, "22176951", 24},
  {1.11750956548492570978e-31f, "11175096", -30},
  {2.02402818006651746868e+25f, "20240282", 26},
  {1.62047861076538687910e-27f, "16204786", -26},
  {6.92694630400000000000e+10f, "6926946", 11},
  {3.24493280976588574717e-21f, "32449328", -20},
  {3.13756230248612356871e-21f, "31375623", -20},
  {9.45399024266744027342e+32f, "945399", 33},
  {1.52445101286872562530e+26f, "1524451", 27},
  {1.13678511496270383561e-29f, "11367851", -28},
  {3.82073957258253567195e-25f, "38207396", -24},
  {3.96947974843877294080e+19f, "39694797", 20},
  {9.39661059859775293804e+24f, "93966106", 25},
  {5.42545584661577041183e+23f, "5425456", 24},
  {1.00853548602730658246e-12f, "10085355", -11},
  {3.28744613704861922180e-28f, "32874461", -27},
  {1.07651455528857419416e-35f, "107651456", -34},
  {4.54474052557536577543e+35f, "45447405", 36},
  {4.33410339355468750000e+01f, "43341034", 2},
  {8.47724958187520000000e+13f, "847725", 14},
  {5.81427237796993279934e-17f, "58142724", -16},
  {1.40156555175781250000e+03f, "14015656", 4},
  {1.88711210134321581799e+27f, "18871121", 28},
  {2.51000131222915985081e-33f, "25100013", -32},
  {2.76274321383930752880e-31f, "27627432", -30},
  {4.48170140524687502273e+27f, "44817014", 28},
  {3.76717977600000000000e+09f, "37671798", 10},
  {9.77975696699848026961e+24f, "9779757", 25},
  {8.51858408755204995138e-19f, "8518584", -18},
  {1.52356268490093263892e-21f, "15235627", -20},
  {3.17559296000000000000e+09f, "3175593", 10},
  {1.59713249570092585827e-11f, "15971325", -10},
  {4.44192510690301335577e-35f, "4441925", -34},
  {8.74687571515525824512e+20f, "8746876", 21},
  {1.88098661016073518478e+38f, "18809866", 39},
  {2.44328688499809813252e-17f, "24432869", -16},
  {2.53475341198907502222e+32f, "25347534", 33},
  {5.46169582872276794852e-30f, "5461696", -29},
  {2.44980455643008988014e+38f, "24498046", 39},
  {4.10304423396707470774e-36f, "41030442", -35},
  {3.50492254466919640581e-16f, "35049225", -15},
  {1.39807444454741114880e+19f, "13980744", 20},
  {6.47018751486018538679e+27f, "64701875", 28},
  {2.70896740357450001326e-31f, "27089674", -30},
  {2.00258745748740968831e-32f, "20025875", -31},
  {3.29139555885655497811e+38f, "32913956", 39},
  {4.69439646154555577475e-28f, "46943965", -27},
  {1.19908703327823819708e-35f, "1199087", -34},
  {2.06226520538330078125e+01f, "20622652", 2},
  {6.61024201193972353833e+24f, "6610242", 25},
  {1.18203759497462201900e-13f, "11820376", -12},
  {3.99060443979529893984e-35f, "39906044", -34},
  {1.66366051041280000000e+13f, "16636605", 14},
  {4.97345737926480069291e-08f, "49734574", -7},
  {1.71011427927208541656e-27f, "17101143", -26},
  {1.08896499633789062500e+02f, "1088965", 3},
  {2.67645047143683406533e-37f, "26764505", -36},
  {2.84378397402199842785e+36f, "2843784", 37},
  {1.57326542618743495721e+22f, "15732654", 23},
  {6.62312271984757366550e-20f, "6623123", -19},
  {1.29894530000000000000e+07f, "12989453", 8},
  {3.56095731884201556988e-28f, "35609573", -27},
  {4.73778349926036283779e-16f, "47377835", -15},
  {1.49919920228169800680e-11f, "14991992", -10},
  {9.43525718670566885647e-29f, "9435257", -28},
  {1.91619687500000000000e+06f, "19161969", 7},
  {9.92520822473696995303e-12f, "9925208", -11},
  {3.44502582833250080042e-35f, "34450258", -34},
  {1.75449924068966400000e+15f, "17544992", 16},
  {3.28141311865814966353e-12f, "32814131", -11},
  {2.21186497793132326415e-32f, "2211865", -31},
  {9.67069853444272467440e+37f, "9670699", 38},
  {6.50697542759966600183e-32f, "65069754", -31},
  {2.28694096560287652780e+34f, "2286941", 35},
  {3.72341068232424329440e-32f, "37234107", -31},
  {2.01052800416071936298e-25f, "2010528", -24},
  {1.07546016154116625674e+34f, "10754602", 35},
  {2.83361523068997537005e-21f, "28336152", -20},
  {4.10130905082517271713e-22f, "4101309", -21},
  {3.23375570587813854218e-04f, "32337557", -3},
  {2.50283553769663305330e-35f, "25028355", -34},
  {8.09582519531250000000e+03f, "8095825", 4},
  {1.98217856884002685547e+00f, "19821786", 1},
  {6.95716154273955840000e+16f, "69571615", 17},
  {6.83445502155985884062e+34f, "6834455", 35},
  {5.72124299264000000000e+11f, "5721243", 12},
  {1.10623047687393172878e-20f, "11062305", -19},
  {2.84024215824496075490e+36f, "2840242", 37},
  {2.38456755200000000000e+09f, "23845676", 10},
  {2.44176997294188538112e-37f, "244177", -36},
  {2.73195834828342035357e-22f, "27319583", -21},
  {4.39097713439164539238e-23f, "4390977", -22},
  {1.37204481833311090003e-26f, "13720448", -25},
  {2.17117595672607421875e+01f, "2171176", 2},
  {1.10697257812500000000e+05f, "11069726", 6},
  {2.14318962996912644025e-16f, "21431896", -15},
  {5.83960555458839919235e-32f, "58396056", -31},
  {1.70894121374173142984e+32f, "17089412", 33},
  {1.23820550167186294033e-12f, "12382055", -11},
  {1.64595352417319476265e+22f, "16459535", 23},
  {8.05428812671391836312e-19f, "8054288", -18},
  {4.40940630141994915903e-06f, "44094063", -5},
  {2.21892944737995430298e+21f, "22189294", 22},
  {8.56353876699245120108e-12f, "8563539", -11},
  {1.46336567863336597384e-10f, "14633657", -9},
  {1.37649143847288594368e+28f, "13764914", 29},
  {2.87085357666015625000e+02f, "28708536", 3},
  {2.29621124055807892400e-15f, "22962112", -14},
  {5.23888621126875608457e-32f, "5238886", -31},
  {1.95206326825118597120e+19f, "19520633", 20},
  {1.19328176171273682944e+20f, "11932818", 21},
  {2.22589449619052003079e-28f, "22258945", -27},
  {2.29757422244932950003e-16f, "22975742", -15},
  {3.46809585582058538725e-19f, "34680959", -18},
  {2.55810356258724537744e+27f, "25581036", 28},
  {2.27692029545076525323e-20f, "22769203", -19},
  {3.32644716068415619628e+31f, "33264472", 32},
  {4.10631151018369193809e-32f, "41063115", -31},
  {9.25622249371195649664e-23f, "92562225", -22},
  {1.12029815673828125000e+02f, "112029816", 3},
  {1.54931133449677377693e-30f, "15493113", -29},
  {3.96187579099205322564e-06f, "3961876", -5},
  {8.12423506766594048000e+17f, "8124235", 18},
  {3.55810458359735397153e-18f, "35581046", -17},
  {1.44923956800686040665e+34f, "14492396", 35},
  {1.21950920071337649744e-16f, "12195092", -15},
  {1.28186281250000000000e+05f, "12818628", 6},
  {1.18864458402702017530e-36f, "11886446", -35},
  {3.04839929812226306891e-23f, "30483993", -22},
  {2.67198187005176093163e+31f, "26719819", 32},
  {3.19809443800607970925e+24f, "31980944", 25},
  {3.94080113619565963745e-03f, "3940801", -2},
  {1.67493474059927927033e-13f, "16749347", -12},
  {1.00848450000000000000e+07f, "10084845", 8},
  {5.73421997093731221425e+24f, "573422", 25},
  {3.89631111593984000000e+15f, "3896311", 16},
  {1.94349166122265160084e-04f, "19434917", -3},
  {2.37784856908784814067e-12f, "23778486", -11},
  {1.20248588158241926943e-38f, "12024859", -37},
  {1.69439318847656250000e+03f, "16943932", 4},
  {6.73219661873416382149e-32f, "67321966", -31},
  {2.42044924034050686976e+20f, "24204492", 21},
  {6.18150861209600000000e+13f, "61815086", 14},
  {2.60805199658875608293e-09f, "2608052", -8},
  {1.16565521773293866439e-37f, "11656552", -36},
  {2.29132843017578125000e+02f, "22913284", 3},
  {9.27934464000000000000e+09f, "9279345", 10},
  {6.09965824081321696352e+32f, "60996582", 33},
  {1.56317286400000000000e+09f, "15631729", 10},
  {1.41489506194520164987e+26f, "14148951", 27},
  {9.94914662442170083523e-05f, "99491466", -4},
  {4.09230565636571136000e+17f, "40923057", 18},
  {8.09808372123342125901e-19f, "80980837", -18},
  {1.07471266609641408400e-25f, "10747127", -24},
  {2.45914845971039616819e+38f, "24591485", 39},
  {1.67137853255348301641e-23f, "16713785", -22},
  {2.22233310341835021973e-03f, "2222333", -2},
  {4.59186171875000000000e+04f, "45918617", 5},
  {3.12188828000988072448e-21f, "31218883", -20},
  {1.13424497377280000000e+13f, "1134245", 14},
  {1.67843140661716461182e-03f, "16784314", -2},
  {1.40296585255193559886e-35f, "14029659", -34},
  {6.55490316757506484689e-29f, "6554903", -28},
  {4.50325600271892763116e+22f, "4503256", 23},
  {2.34976911360000000000e+10f, "23497691", 11},
  {6.16488147934329235659e+34f, "61648815", 35},
  {2.40288972854614257812e-01f, "24028897", 0},
  {6.03926679655861719244e-33f, "60392668", -32},
  {1.98882833089497287372e-16f, "19888283", -15},
  {4.86318409442901611328e-01f, "4863184", 0},
  {1.73359372800000000000e+09f, "17335937", 10},
  {2.15476214648901986948e-09f, "21547621", -8},
  {1.71893081447497397863e-19f, "17189308", -18},
  {1.52258804480390782903e-16f, "1522588", -15},
  {9.19100241453305036800e+20f, "91910024", 21},
  {3.16582017515352160617e-18f, "31658202", -17},
  {5.61679376277160024290e+24f, "5616794", 25},
  {1.21986438728072243975e-08f, "12198644", -7},
  {2.81998012650835934089e-24f, "28199801", -23},
  {1.23393556350492872298e-05f, "12339356", -4},
  {2.48347226233569298349e-21f, "24834723", -20},
  {4.58579353600000000000e+10f, "45857935", 11},
  {6.70241031053455337476e-27f, "670241", -26},
  {3.33318561315536499023e-01f, "33331856", 0},
  {8.30556149122676086014e+23f, "83055615", 24},
  {2.39511652334709894774e-27f, "23951165", -26},
  {8.98542524694528000000e+14f, "8985425", 15},
  {2.62268428596446555155e-18f, "26226843", -17},
  {1.69680349545103360000e+16f, "16968035", 17},
  {4.66972414655375567838e+32f, "4669724", 33},
  {4.67660260563953998320e+33f, "46766026", 34},
  {4.14247932774580347480e-26f, "41424793", -25},
  {1.06637866312352964990e+36f, "10663787", 37},
  {4.23586817924918879743e-34f, "4235868", -33},
  {2.98170099212992293050e+35f, "2981701", 36},
  {3.30889320000000000000e+07f, "33088932", 8},
  {3.72357932485015528946e-38f, "37235793", -37},
  {1.04788683529477566481e-04f, "10478868", -3},
  {3.39900062760960000000e+13f, "33990006", 14},
  {1.22143442719314671702e-15f, "12214344", -14},
  {8.63027979580741966306e+33f, "863028", 34},
  {8.58559411305206260628e-17f, "8585594", -16},
  {4.31231493734400000000e+14f, "4312315", 15},
  {2.06392380481573700615e-24f, "20639238", -23},
  {2.01124062500000000000e+06f, "20112406", 7},
  {5.31766796484589576721e-04f, "5317668", -3},
  {1.04739889502525329590e-03f, "10473989", -2},
  {1.60872097865194518818e-08f, "1608721", -7},
  {1.06854816324903574238e+27f, "10685482", 28},
  {4.88488271872000000000e+11f, "48848827", 12},
  {3.28235622498494819357e+25f, "32823562", 26},
  {3.67410751051487950059e-33f, "36741075", -32},
  {3.08573043893557545647e-17f, "30857304", -16},
  {3.68799338482227094734e+37f, "36879934", 38},
  {1.99962171875000000000e+05f, "19996217", 6},
  {3.66275899417845343142e-32f, "3662759", -31},
  {1.22844346130083968647e-28f, "12284435", -27},
  {2.43234811416084735468e-19f, "2432348", -18},
  {1.45349340202605148420e-11f, "14534934", -10},
  {3.40564047343242773868e+26f, "34056405", 27},
  {1.61371814984484058342e-25f, "16137181", -24},
  {9.98661109235680693672e-17f, "9986611", -16},
  {2.00182674289922104893e-38f, "20018267", -37},
  {2.35310409494724134612e-28f, "2353104", -27},
  {6.90751102150333196050e-12f, "6907511", -11},
  {9.95267346630689179424e+35f, "99526735", 36},
  {1.31139603966355046400e+18f, "1311396", 19},
  {4.31481100848785104063e-11f, "4314811", -10},
  {1.44764157994359266013e-07f, "14476416", -6},
  {6.37509174339356832206e-08f, "6375092", -7},
  {8.17056186368000000000e+12f, "8170562", 13},
  {1.70666790162005144182e-12f, "17066679", -11},
  {9.09843120521216000000e+14f, "9098431", 15},
  {5.05610917717058683252e-12f, "5056109", -11},
  {5.75522094726562500000e+02f, "5755221", 3},
  {2.66154233601006285612e-18f, "26615423", -17},
  {4.46961366314250728899e+23f, "44696137", 24},
  {1.01795740501935432595e+38f, "10179574", 39},
  {7.09787123712000000000e+12f, "7097871", 13},
  {6.62567780352000000000e+11f, "6625678", 12},
  {6.78162677760000000000e+10f, "67816268", 11},
  {3.27701866626739501953e-01f, "32770187", 0},
  {4.02807665383702528000e+17f, "40280767", 18},
  {3.52253439669828841798e+32f, "35225344", 33},
  {1.63264628499746322632e-02f, "16326463", -1},
  {1.06754063736631832088e-16f, "106754064", -15},
  {1.84700288076982931003e-38f, "18470029", -37},
  {3.38627328000000000000e+08f, "33862733", 9},
  {4.27963525390625000000e+03f, "42796353", 4},
  {4.56616515431829128602e-11f, "4566165", -10},
  {1.66248399182222783566e-04f, "1662484", -3},
  {1.15690287057076224000e+17f, "11569029", 18},
  {7.52038707200000000000e+11f, "7520387", 12},
  {5.19957393407821655273e-04f, "5199574", -3},
  {4.38410514258912360316e+27f, "4384105", 28},
  {3.13472148027618768546e-39f, "3134721", -38},
  {7.45003035262925550342e-07f, "74500304", -6},
  {8.00349050000000000000e+06f, "80034905", 7},
  {5.09093045497621687900e-11f, "50909305", -10},
  {1.71837139537267323264e+25f, "17183714", 26},
  {8.41239153325865750617e+37f, "84123915", 38},
  {6.04486616029684005575e-37f, "6044866", -36},
  {4.27356582348057629591e-26f, "42735658", -25},
  {1.12164253728768000000e+14f, "11216425", 15},
  {4.64919436282684728212e-10f, "46491944", -9},
  {4.00217400672256000000e+15f, "4002174", 16},
  {4.68646168390641268025e+34f, "46864617", 35},
  {3.05164480993700072516e-25f, "30516448", -24},
  {5.55610626064384000000e+14f, "55561063", 15},
  {4.67639712000000000000e+08f, "4676397", 9},
  {3.25131173821470054642e+25f, "32513117", 26},
  {5.53552192419318883632e-14f, "5535522", -13},
  {2.07648138336880032564e-31f, "20764814", -30},
  {1.76686464843750000000e+04f, "17668646", 5},
  {2.80023255569074364794e-20f, "28002326", -19},
  {5.75560625000000000000e+05f, "5755606", 6},
  {3.09955069753831335519e+26f, "30995507", 27},
  {8.69725161019529472107e-20f, "86972516", -19},
  {2.81092489078494049900e-25f, "2810925", -24},
  {1.94898186478553725465e-09f, "19489819", -8},
  {6.29901120000000000000e+08f, "6299011", 9},
  {7.39244083200000000000e+09f, "7392441", 10},
  {3.25775281872763904779e-31f, "32577528", -30},
  {6.68403138877109158987e-19f, "66840314", -18},
  {5.50372075387359880293e-33f, "55037208", -32},
  {2.36370468660453310176e+35f, "23637047", 36},
  {7.84053948655138755551e-19f, "78405395", -18},
  {6.74222052097320556641e-01f, "67422205", 0},
  {2.72544531250000000000e+03f, "27254453", 4},
  {6.68784742400000000000e+09f, "66878474", 10},
  {1.59900338683825055108e-14f, "15990034", -13},
  {3.34983062744140625000e+02f, "33498306", 3},
  {6.39991021568000000000e+11f, "639991", 12},
  {1.11153393983840942383e-01f, "111153394", 0},
  {5.03581601969081916088e-23f, "5035816", -22},
  {4.36701146679245434318e-37f, "43670115", -36},
  {6.43454118866148804379e-25f, "6434541", -24},
  {3.33037814884867311886e-27f, "3330378", -26},
  {2.16606926191305341452e-23f, "21660693", -22},
  {6.05977467185700539966e+28f, "60597747", 29},
  {2.61618482808277172224e+20f, "26161848", 21},
  {9.91195218061880699648e-37f, "9911952", -36},
  {4.88811072931641369775e-24f, "48881107", -23},
  {9.04041339220895714349e+27f, "90404134", 28},
  {2.92748400000000000000e+06f, "2927484", 7},
  {2.30475507123628631234e-05f, "2304755", -4},
  {7.33753859094576910138e-06f, "73375386", -5},
  {1.33271407776192063466e-06f, "13327141", -5},
  {3.13789471784960000000e+14f, "31378947", 15},
  {3.44341376000000000000e+08f, "34434138", 9},
  {4.36362919210370174288e+23f, "43636292", 24},
  {2.86012638980794476479e-16f, "28601264", -15},
  {3.40154318171242756914e-21f, "3401543", -20},
  {2.22230450291429715944e+31f, "22223045", 32},
  {2.99715644531250000000e+04f, "29971564", 5},
  {3.17971043849933458769e-15f, "31797104", -14},
  {7.51817685562604812873e+27f, "7518177", 28},
  {3.95856578590039825030e+24f, "39585658", 25},
  {3.44079046756372018364e+23f, "34407905", 24},
  {2.75532539006917431834e-08f, "27553254", -7},
  {3.64489824278280138969e-05f, "36448982", -4},
  {7.97481999597852075152e-30f, "797482", -29},
  {1.50264457983814055092e+33f, "15026446", 34},
  {3.34895431200751425859e-32f, "33489543", -31},
  {1.39870304000000000000e+08f, "1398703", 9},
  {1.07039996487572177353e-28f, "10704", -27},
  {2.39726631556413135682e-30f, "23972663", -29},
  {1.50916591787105205617e+22f, "15091659", 23},
  {6.05501767042532614352e-17f, "6055018", -16},
  {8.21446877126473865016e-15f, "8214469", -14},
  {1.23980244582400000000e+12f, "12398024", 13},
  {2.24319176577543669122e-35f, "22431918", -34},
  {1.34023890076273577421e-12f, "13402389", -11},
  {9.93406458069424306444e+26f, "99340646", 27},
  {3.42624229459719637417e+31f, "34262423", 32},
  {6.06700873284585188881e+32f, "60670087", 33},
  {3.09579855047932588812e-17f, "30957986", -16},
  {3.66699075618481806771e-13f, "36669908", -12},
  {1.15232378760515841165e-12f, "11523238", -11},
  {1.63519384908370234828e+36f, "16351938", 37},
  {1.96843223945316853664e+34f, "19684322", 35},
  {6.90985482484992747126e-28f, "6909855", -27},
  {6.58444452988641835988e-19f, "65844445", -18},
  {9.82013128085827223618e-26f, "9820131", -25},
  {2.17446882462004517097e-35f, "21744688", -34},
  {3.25826944655677717689e+24f, "32582694", 25},
  {5.27971126139163970947e-02f, "52797113", -1},
  {2.68693604065522997160e+31f, "2686936", 32},
  {1.70494156800000000000e+10f, "17049416", 11},
  {2.53681752034844905657e-17f, "25368175", -16},
  {1.04256997373236353840e-15f, "104257", -14},
  {9.08402197848293660057e-34f, "9084022", -33},
  {3.25331193096189963399e-08f, "3253312", -7},
  {2.25552119762750378298e-21f, "22555212", -20},
  {4.96848210009311422560e-27f, "4968482", -26},
  {1.57216859516919229010e-39f, "1572169", -38},
  {4.04979071111366550895e-11f, "40497907", -10},
  {1.83380875321754348224e-18f, "18338088", -17},
  {1.63548479424938136044e+22f, "16354848", 23},
  {4.07443963904000000000e+11f, "40744396", 12},
  {2.54427025000000000000e+06f, "25442702", 7},
  {2.83696099359076470137e-05f, "2836961", -4},
  {1.51528499734118400000e+15f, "1515285", 16},
  {5.47401417693372951966e+32f, "5474014", 33},
  {4.06387548374647093654e-17f, "40638755", -16},
  {6.94651440000000000000e+07f, "69465144", 8},
  {4.81667693768601119310e+26f, "4816677", 27},
  {2.07034046875000000000e+05f, "20703405", 6},
  {4.27811744411882160634e+33f, "42781174", 34},
  {7.54118090448494308731e-25f, "7541181", -24},
  {4.63290283203125000000e+02f, "46329028", 3},
  {1.22280919928494730206e+29f, "12228092", 30},
  {8.72059314951240116542e-14f, "8720593", -13},
  {5.01703160216894392238e+22f, "50170316", 23},
  {1.73681801460841049375e-35f, "1736818", -34},
  {3.12137649061128286121e-10f, "31213765", -9},
  {2.24893344000000000000e+08f, "22489334", 9},
  {1.44947143554687500000e+02f, "14494714", 3},
  {1.15559141622546470037e-17f, "11555914", -16},
  {5.62565130700530648522e-21f, "56256513", -20},
  {5.92485244324751073083e+23f, "59248524", 24},
  {1.92855375000000000000e+06f, "19285538", 7},
  {8.16934372627447624032e-16f, "81693437", -15},
  {2.78461967309009905302e-23f, "27846197", -22},
  {7.07606582258768862511e+23f, "7076066", 24},
  {6.72482186928391456604e-04f, "6724822", -3},
  {3.13864056805847758179e-23f, "31386406", -22},
  {4.03802305053806184129e-26f, "4038023", -25},
  {2.06713391522250752000e+17f, "2067134", 18},
  {8.15564005950771164932e+37f, "815564", 38},
  {2.52522120134066094631e+24f, "25252212", 25},
  {7.31665789288843751437e-16f, "7316658", -15},
  {3.38861946147517301142e-06f, "33886195", -5},
  {5.56100177764892578125e+00f, "5561002", 1},
  {5.65130107516235699170e-22f, "5651301", -21},
  {2.23518688018432000000e+16f, "22351869", 17},
  {5.62206081176251123903e-31f, "5622061", -30},
  {3.64140966577881904570e-34f, "36414097", -33},
  {6.31551239631379055526e-18f, "63155124", -17},
  {3.22964238902409242304e-36f, "32296424", -35},
  {4.64600628259841060839e-20f, "46460063", -19},
  {4.92652438175354491765e+23f, "49265244", 24},
  {6.55785050771152163026e+31f, "65578505", 32},
  {6.54425062500000000000e+05f, "65442506", 6},
  {3.28505840000000000000e+07f, "32850584", 8},
  {1.76044105596907701225e+35f, "1760441", 36},
  {3.29988688827618608019e+34f, "3299887", 35},
  {1.08104788476672758903e-23f, "10810479", -22},
  {3.72477024793624877930e-02f, "37247702", -1},
  {5.31183037249198172843e-22f, "53118304", -21},
  {9.87268504104577004910e-06f, "9872685", -5},
  {3.19826306731749453226e-17f, "3198263", -16},
  {1.65234890586003850920e+23f, "16523489", 24},
  {1.30695799841698611200e+18f, "1306958", 19},
  {1.50536909699440002441e-01f, "15053691", 0},
  {1.69660560000000000000e+08f, "16966056", 9},
  {1.24974490187972258998e-24f, "12497449", -23},
  {7.82523042889728000000e+14f, "78252304", 15},
  {1.07800067673707406950e+21f, "10780007", 22},
  {3.94535697582102952520e+31f, "3945357", 32},
  {9.20016471982080000000e+13f, "9200165", 14},
  {3.92295625000000000000e+06f, "39229562", 7},
  {4.21604344212654096367e-23f, "42160434", -22},
  {4.27576242978834206700e-31f, "42757624", -30},
  {3.10826420296337054646e-32f, "31082642", -31},
  {3.67575057680369354784e-06f, "36757506", -5},
  {1.60160021955980364140e+24f, "16016002", 25},
  {2.78962298393841805934e-24f, "2789623", -23},
  {2.27235004305839538574e-01f, "227235", 0},
  {1.41148806606130847593e-32f, "1411488", -31},
  {1.49031753675647352713e-21f, "14903175", -20},
  {1.76622249351053312000e+18f, "17662225", 19},
  {1.12515738506907464542e+30f, "11251574", 31},
  {1.38949718622903484904e-28f, "13894972", -27},
  {1.58110907467367460891e-15f, "15811091", -14},
  {5.41635230183601379395e-02f, "54163523", -1},
  {3.53907259696416922312e-32f, "35390726", -31},
  {7.42140887962835839240e-20f, "7421409", -19},
  {9.61846601318400000000e+13f, "9618466", 14},
  {2.13325562500000000000e+05f, "21332556", 6},
  {6.34073745459318161011e-03f, "63407375", -2},
  {1.31021813452822214239e-30f, "13102181", -29},
  {1.10166803785478423006e+27f, "110166804", 28},
  {1.48896656502365403528e-18f, "14889666", -17},
  {2.77686069665226774620e+26f, "27768607", 27},
  {2.25570145786883891059e-13f, "22557015", -12},
  {3.92324266815363683751e+28f, "39232427", 29},
  {4.91019241846747449096e-37f, "49101924", -36},
  {2.58453829622687499978e-37f, "25845383", -36},
  {6.20858327040000000000e+10f, "62085833", 11},
  {3.24665063862076151539e+33f, "32466506", 34},
  {3.78662275147366400000e+15f, "37866228", 16},
  {3.55234364989000181507e-22f, "35523436", -21},
  {1.86129826323665222607e-28f, "18612983", -27},
  {2.66814895232436580385e+23f, "2668149", 24},
  {1.72165280468860757909e-15f, "17216528", -14},
  {1.16030992187500000000e+05f, "11603099", 6},
  {5.85428480000000000000e+08f, "5854285", 9},
  {8.12316179275512695312e-01f, "8123162", 0},
  {3.82386762598492460241e-35f, "38238676", -34},
  {1.39114017560985600000e+15f, "13911402", 16},
  {1.99468211190628352000e+17f, "19946821", 18},
  {1.05811825547090298143e+22f, "10581183", 23},
  {2.11973000000000000000e+06f, "211973", 7},
  {4.35799488315743215542e+27f, "4357995", 28},
  {2.34254321554429843855e-32f, "23425432", -31},
  {1.67940983794871957695e-34f, "16794098", -33},
  {2.48357635179499775897e+34f, "24835764", 35},
  {2.88652050395646342373e-13f, "28865205", -12},
  {2.56148056218324172800e+18f, "25614806", 19},
  {7.29337406158447265625e+00f, "7293374", 1},
  {2.86021882952043290690e+23f, "28602188", 24},
  {5.48334374424940028526e+26f, "54833437", 27},
  {1.16647004555492372901e-11f, "116647005", -10},
  {6.19916644620059206442e-34f, "61991664", -33},
  {2.20432653352960000000e+14f, "22043265", 15},
  {4.46790918733824000000e+14f, "44679092", 15},
  {4.12820569072645044716e+33f, "41282057", 34},
  {1.68580655381217280000e+16f, "16858066", 17},
  {1.76675895640064000000e+16f, "1766759", 17},
  {3.66231593750000000000e+05f, "3662316", 6},
  {7.71160064000000000000e+10f, "7711601", 11},
  {9.79360805786200216971e-08f, "9793608", -7},
  {2.02987998808697670205e+22f, "202988", 23},
  {2.32048364865232201318e+21f, "23204836", 22},
  {3.72887134605463202907e-23f, "37288713", -22},
  {4.99456558792209773748e-32f, "49945656", -31},
  {3.94724942835711356537e-13f, "39472494", -12},
  {3.62477858118527540317e+24f, "36247786", 25},
  {6.86880450000000000000e+06f, "68688045", 7},
  {2.46687070770690297650e-09f, "24668707", -8},
  {6.93901634216308593750e+00f, "69390163", 1},
  {1.81497370674028445786e-15f, "18149737", -14},
  {3.73450727651032203937e-26f, "37345073", -25},
  {2.15151965300071645985e-32f, "21515197", -31},
  {1.15153855083840535061e-26f, "115153855", -25},
  {1.45848433906561555069e-19f, "14584843", -18},
  {6.01611933043725312470e-28f, "60161193", -27},
  {3.90036125588713961761e-31f, "39003613", -30},
  {6.77262500000000000000e+06f, "6772625", 7},
  {2.53590985682770290583e+29f, "25359099", 30},
  {4.83468800000000000000e+08f, "4834688", 9},
  {2.80785128481397805444e-09f, "28078513", -8},
  {1.97747389593812992000e+17f, "19774739", 18},
  {9.33281450668079161092e+35f, "93328145", 36},
  {2.72668286925181746483e-04f, "2726683", -3},
  {5.77693093362086074194e-08f, "5776931", -7},
  {5.47437543424000000000e+11f, "54743754", 12},
  {1.58974566843994580267e-09f, "15897457", -8},
  {1.42786790980823708365e-30f, "14278679", -29},
  {1.42104010850130357824e-11f, "14210401", -10},
  {9.17199777662055671545e+34f, "9171998", 35},
  {1.78216145387142512640e+19f, "17821615", 20},
  {2.35551278729149808640e+20f, "23555128", 21},
  {2.71777861397276262400e+18f, "27177786", 19},
  {6.07279815673828125000e+01f, "6072798", 2},
  {1.33572169444091000654e+36f, "13357217", 37},
  {2.30501913150650189915e+25f, "23050191", 26},
  {4.04501384639923765247e+27f, "40450138", 28},
  {7.10271591841864980890e+21f, "7102716", 22},
  {2.18071647850592853501e-07f, "21807165", -6},
  {1.32690037309741526727e-20f, "13269004", -19},
  {6.87679183049470722951e-17f, "6876792", -16},
  {6.66913588190904320000e+16f, "6669136", 17},
  {8.36179765428823884577e-08f, "8361798", -7},
  {2.31006755391227613927e-10f, "23100676", -9},
  {1.29377739502616061730e+29f, "12937774", 30},
  {1.92204662374400000000e+12f, "19220466", 13},
  {2.35816307067871093750e+01f, "2358163", 2},
  {8.56392230276295929567e+36f, "8563922", 37},
  {1.84695310551540858194e-20f, "18469531", -19},
  {8.00368304965104471194e-09f, "8003683", -8},
  {5.92133600000000000000e+06f, "5921336", 7},
  {8.03272499200000000000e+09f, "8032725", 10},
  {2.28199207330780615994e-30f, "2281992", -29},
  {7.43834570312500000000e+03f, "74383457", 4},
  {3.06163381143418892888e-33f, "30616338", -32},
  {2.21568107604980468750e+01f, "2215681", 2},
  {5.98074264204585923463e-24f, "59807426", -23},
  {8.27192561700940132141e-04f, "82719256", -3},
  {5.13179136000000000000e+09f, "51317914", 10},
  {1.44230917968750000000e+04f, "14423092", 5},
  {1.07176866492864064639e-07f, "10717687", -6},
  {1.31207239517650009475e-10f, "13120724", -9},
  {4.82028239074056355506e-15f, "48202824", -14},
  {3.99207144058575125069e-28f, "39920714", -27},
  {1.29910246769850594959e+30f, "12991025", 31},
  {9.44851273309819882063e-18f, "9448513", -17},
  {1.55312979372040243299e+36f, "15531298", 37},
  {7.64884664686791884800e+18f, "76488466", 19},
  {8.98317661659125506873e-35f, "89831766", -34},
  {4.65140370664585134364e-10f, "46514037", -9},
  {1.71921132233068895938e+37f, "17192113", 38},
  {1.00457836493816898837e-12f, "10045784", -11},
  {4.55769252469181917400e-32f, "45576925", -31},
  {1.89918170079295123287e-09f, "18991817", -8},
  {3.92309829009408000000e+16f, "39230983", 17},
  {9.84822618738271197534e+35f, "9848226", 36},
  {5.31949900973786063183e-36f, "5319499", -35},
  {1.32368416320545768342e-21f, "13236842", -20},
  {1.13450767312300818217e+34f, "11345077", 35},
  {1.56890833930952976216e-17f, "15689083", -16},
  {1.75767948800000000000e+09f, "17576795", 10},
  {9.62718505859375000000e+01f, "9627185", 2},
  {2.02982755461082928172e+31f, "20298276", 32},
  {6.24509272998281216000e+17f, "6245093", 18},
  {1.01708372191501830549e-33f, "10170837", -32},
  {1.05694691482575404612e+37f, "10569469", 38},
  {1.98971640130639169546e-20f, "19897164", -19},
  {9.78226790934931033028e-19f, "9782268", -18},
  {1.28325391415273770690e-05f, "12832539", -4},
  {1.64694549901750303601e+28f, "16469455", 29},
  {2.28299599610246429304e+24f, "2282996", 25},
  {2.29036858901258122044e+26f, "22903686", 27},
  {3.03246533020053179688e-21f, "30324653", -20},
  {1.57171245762570471920e-29f, "15717125", -28},
  {1.54923547600270629515e+37f, "15492355", 38},
  {5.72669701822299086553e-30f, "5726697", -29},
  {2.39448709749012778047e-08f, "23944871", -7},
  {3.37569734592999133992e+34f, "33756973", 35},
  {7.29613177389732776948e+27f, "7296132", 28},
  {3.59532714355736970901e-04f, "3595327", -3},
  {2.30656643009649955922e-14f, "23065664", -13},
  {1.68697282334993073064e+26f, "16869728", 27},
  {5.95846136611469598392e+22f, "59584614", 23},
  {1.75466723817407910246e-07f, "17546672", -6},
  {4.70016958847121052748e-22f, "47001696", -21},
  {3.33214020729064941406e+00f, "33321402", 1},
  {2.27442703559788128587e-10f, "2274427", -9},
  {4.07118548561475518036e-19f, "40711855", -18},
  {7.08355280953409536000e+17f, "7083553", 18},
  {3.71688136947259314957e-15f, "37168814", -14},
  {1.03221301269531250000e+03f, "1032213", 4},
  {1.69690541999834021425e-12f, "16969054", -11},
  {5.99803954007198318723e+25f, "59980395", 26},
  {3.07862173940520733595e-05f, "30786217", -4},
  {1.50154599435566560960e-33f, "1501546", -32},
  {9.48561158340373949831e+30f, "94856116", 31},
  {4.76050132647287682630e-07f, "47605013", -6},
  {5.03515389715177182073e-15f, "5035154", -14},
  {1.29151698808921626415e-26f, "1291517", -25},
  {1.03905602533282297512e+27f, "1039056", 28},
  {1.11696245380633774612e-25f, "11169625", -24},
  {5.01644234593081656187e+36f, "50164423", 37},
  {3.26173640884224000000e+14f, "32617364", 15},
  {5.57396226952278084354e-08f, "55739623", -7},
  {1.11644997487709449982e-31f, "111645", -30},
  {7.10590490214400000000e+12f, "7105905", 13},
  {5.39255752563476562500e+01f, "53925575", 2},
  {4.34781998395919799805e-01f, "434782", 0},
  {3.33137760000000000000e+08f, "33313776", 9},
  {5.39522759801513984712e-10f, "53952276", -9},
  {2.51675611590394023525e+34f, "2516756", 35},
  {1.20989388872535034208e+33f, "12098939", 34},
  {1.32221519060396580761e-22f, "13222152", -21},
  {2.06253689146651443200e+18f, "20625369", 19},
  {3.03784476957461024860e-13f, "30378448", -12},
  {1.03652428151690401137e-05f, "10365243", -4},
  {9.85970532712225699594e-21f, "9859705", -20},
  {1.16172712816148480000e+16f, "11617271", 17},
  {6.95860199424000000000e+14f, "6958602", 15},
  {1.11910112309680936761e+36f, "11191011", 37},
  {6.28177270548027657137e-38f, "62817727", -37},
  {1.05380780457918773159e-21f, "10538078", -20},
  {2.75264870847145154409e-15f, "27526487", -14},
  {5.83825577981363879064e+26f, "58382558", 27},
  {5.51039795200000000000e+12f, "5510398", 13},
  {6.97896684886956109040e-10f, "6978967", -9},
  {8.10342048791841996800e+18f, "81034205", 19},
  {3.85068439442364941860e-33f, "38506844", -32},
  {5.39303675428864000000e+14f, "53930368", 15},
  {1.78046605257637856574e+31f, "1780466", 32},
  {6.25770449820373235649e+32f, "62577045", 33},
  {9.88495787223050234127e+27f, "9884958", 28},
  {1.30144217361717668105e+29f, "13014422", 30},
  {2.91817728000000000000e+08f, "29181773", 9},
  {8.09492544225711723022e-19f, "80949254", -18},
  {2.35920123900497854541e+36f, "23592012", 37},
  {2.95388967797738235339e-18f, "29538897", -17},
  {7.32787056703927064986e+21f, "73278706", 22},
  {1.47850951179862022400e-03f, "14785095", -2},
  {1.54006580762715094592e+29f, "15400658", 30},
  {5.52644942725736236374e-27f, "55264494", -26},
  {5.14318863054086250486e-08f, "51431886", -7},
  {2.73213159223041844052e+23f, "27321316", 24},
  {1.14037557175095116690e-10f, "11403756", -9},
  {1.52948978387976186974e-28f, "15294898", -27},
  {1.15517639176210979073e-28f, "11551764", -27},
  {1.99131755598964664041e+23f, "19913176", 24},
  {2.29311292176959113931e-10f, "22931129", -9},
  {2.21870962911408614785e+26f, "22187096", 27},
  {1.94229945540428161621e-01f, "19422995", 0},
  {3.75986324322938325615e-13f, "37598632", -12},
  {2.19089736239368981462e+27f, "21908974", 28},
  {3.23890999984128000000e+16f, "323891", 17},
  {1.65367758848000000000e+11f, "16536776", 12},
  {1.86475494349209600000e+15f, "1864755", 16},
  {2.44676057192805274099e-10f, "24467606", -9},
  {1.60048777214636395624e-37f, "16004878", -36},
  {2.15665331779746338725e-05f, "21566533", -4},
  {1.58751732669770717621e-04f, "15875173", -3},
  {1.45729464418959360000e+16f, "14572946", 17},
  {5.31626663264478382942e-13f, "53162666", -12},
  {1.43050959966473101304e-10f, "14305096", -9},
  {2.11572937500000000000e+05f, "21157294", 6},
  {9.59111477390617384275e-23f, "9591115", -22},
  {6.99654649314086699214e+36f, "69965465", 37},
  {2.86416046638342041051e+25f, "28641605", 26},
  {3.28096273078022275193e-25f, "32809627", -24},
  {2.76120707911928678212e-20f, "2761207", -19},
  {2.77152416000000000000e+08f, "27715242", 9},
  {7.56305920000000000000e+10f, "7563059", 11},
  {6.19269043843698084232e-30f, "61926904", -29},
  {2.57195807236710989824e+20f, "2571958", 21},
  {5.49593544560455317697e-36f, "54959354", -35},
  {2.87282477845509318158e+32f, "28728248", 33},
  {4.29639370981476536004e-29f, "42963937", -28},
  {1.38663504729420639493e-25f, "1386635", -24},
  {4.60910244410902055729e-35f, "46091024", -34},
  {1.32367264825105982180e+33f, "13236726", 34},
  {5.36920166015625000000e+03f, "53692017", 4},
  {1.70924143233514542877e+30f, "17092414", 31},
  {3.75165910782015998848e-07f, "3751659", -6},
  {3.11278829064062000677e+29f, "31127883", 30},
  {5.15654075923457638400e+18f, "5156541", 19},
  {1.73109670221866995880e-29f, "17310967", -28},
  {7.47298812866210937500e+01f, "7472988", 2},
  {1.35374575620517134666e-05f, "13537458", -4},
  {7.11195945739746093750e-01f, "71119595", 0},
  {1.91445507812500000000e+03f, "19144551", 4},
  {4.70522618148342154943e+28f, "4705226", 29},
  {1.78914720188165155271e+34f, "17891472", 35},
  {4.03189608672910561414e-20f, "4031896", -19},
  {3.59148711733368567390e-23f, "3591487", -22},
  {3.46688806541995894750e-15f, "3466888", -14},
  {1.33185016632062312343e+24f, "13318502", 25},
  {5.57201360606995876878e-07f, "55720136", -6},
  {3.51826516647302375493e-17f, "35182652", -16},
  {5.43714304000000000000e+10f, "5437143", 11},
  {2.94458960000000000000e+07f, "29445896", 8},
  {1.64645660400390625000e+02f, "16464566", 3},
  {2.18858419149606424661e-20f, "21885842", -19},
  {3.14364781532271364096e-21f, "31436478", -20},
  {1.71638734848000000000e+11f, "17163873", 12},
  {4.20493936033037320149e-39f, "420494", -38},
  {2.91783949252109630127e-18f, "29178395", -17},
  {6.68041953125000000000e+04f, "66804195", 5},
  {5.35008532964326643103e-29f, "53500853", -28},
  {6.24445310677401721478e-05f, "6244453", -4},
  {5.19126624000000000000e+08f, "51912662", 9},
  {1.03943788217118977575e-34f, "10394379", -33},
  {5.67391687226025909892e+37f, "5673917", 38},
  {1.28225111961364746094e+00f, "12822511", 1},
  {6.45692925900220870972e-03f, "64569293", -2},
  {2.57170067240137194690e+28f, "25717007", 29},
  {9.48946445482235026509e-21f, "94894645", -20},
  {1.71880920000000000000e+07f, "17188092", 8},
  {2.73069633571765280067e-09f, "27306963", -8},
  {2.06669380321280000000e+13f, "20666938", 14},
  {1.78341976838605894374e-32f, "17834198", -31},
  {8.66864649773246690056e+32f, "86686465", 33},
  {1.39524658203125000000e+03f, "13952466", 4},
  {4.40017851988486557347e-37f, "44001785", -36},
  {4.71266429225405758426e-26f, "47126643", -25},
  {7.92919957196242944000e+18f, "79291996", 19},
  {2.54988819772469788028e-13f, "25498882", -12},
  {1.02340152066962449135e+37f, "10234015", 38},
  {6.10015660948510962562e-27f, "61001566", -26},
  {1.49147174400000000000e+09f, "14914717", 10},
  {8.09183232000000000000e+08f, "8091832", 9},
  {3.03083546789942394880e+19f, "30308355", 20},
  {3.38331339263162570926e-28f, "33833134", -27},
  {2.77821306435379954085e+27f, "2778213", 28},
  {1.59369261637801041437e+37f, "15936926", 38},
  {9.08664444101766781338e+21f, "90866444", 22},
  {3.66387696022912181562e+27f, "3663877", 28},
  {6.40070354665486787952e-20f, "64007035", -19},
  {8.83811958080765736057e-13f, "88381196", -12},
  {3.27420053764277116496e+37f, "32742005", 38},
  {6.77686246637568000000e+14f, "67768625", 15},
  {7.79849934162530158724e+34f, "77984993", 35},
  {4.87180742315097708423e-36f, "48718074", -35},
  {5.41045586657280000000e+13f, "5410456", 14},
  {1.41561482450924813747e-04f, "14156148", -3},
  {5.08763885498046875000e+00f, "5087639", 1},
  {1.88018798828125000000e+03f, "1880188", 4},
  {2.19560254898176000000e+14f, "21956025", 15},
  {1.27834893102488684263e-31f, "12783489", -30},
  {8.45145301268994514478e+32f, "8451453", 33},
  {6.31134337500394160259e-12f, "63113434", -11},
  {3.60502235330242253340e-25f, "36050224", -24},
  {1.01372997388519306784e+27f, "101373", 28},
  {1.39111275401928321328e+30f, "13911128", 31},
  {2.53190050903785779944e-23f, "25319005", -22},
  {6.86908491784809390213e-38f, "6869085", -37},
  {1.56058972160000000000e+10f, "15605897", 11},
  {1.05933068847656250000e+03f, "10593307", 4},
  {1.17882074500759636312e+38f, "11788207", 39},
  {1.61001772648653599539e+22f, "16100177", 23},
  {2.29985945051872294628e-27f, "22998595", -26},
  {1.27031600000000000000e+08f, "1270316", 9},
  {6.90018188476562500000e+02f, "6900182", 3},
  {1.22000153861396805951e-16f, "12200015", -15},
  {4.95619955472648143768e-04f, "49561996", -3},
  {1.47711448669433593750e+01f, "14771145", 2},
  {1.57626041529393020360e-33f, "15762604", -32},
  {2.65540085579718532216e-15f, "26554009", -14},
  {1.51575348082036965376e+20f, "15157535", 21},
  {2.34433954915402864572e-07f, "23443395", -6},
  {1.14839204976410942400e-16f, "1148392", -15},
  {1.50259656948037445545e-04f, "15025966", -3},
  {2.68336602937679913339e-11f, "2683366", -10},
  {9.39800944314492237019e-14f, "93980094", -13},
  {1.11618842268205913756e-29f, "11161884", -28},
  {6.06679329342327212737e+23f, "6066793", 24},
  {7.44785355067895406993e+25f, "74478536", 26},
  {3.52897545011200000000e+12f, "35289755", 13},
  {1.95467025041580200195e-01f, "19546703", 0},
  {1.58575971933325607191e+33f, "15857597", 34},
  {3.99915325000000000000e+06f, "39991532", 7},
  {2.00946304599765806519e+26f, "2009463", 27},
  {7.75019036062113073982e-31f, "77501904", -30},
  {5.89261617278680205345e-06f, "5892616", -5},
  {4.02363703204249600000e+17f, "4023637", 18},
  {3.33592131342315672410e-15f, "33359213", -14},
  {6.13773663644678890705e-05f, "6137737", -4},
  {8.82388172945836046779e-12f, "8823882", -11},
  {5.91877507982561803506e+26f, "5918775", 27},
  {1.06148063423461280763e-05f, "10614806", -4},
  {1.93609704893427759533e-28f, "1936097", -27},
  {2.27309203451731433640e+38f, "2273092", 39},
  {1.93228287289876087806e-36f, "19322829", -35},
  {2.22560402800640000000e+13f, "2225604", 14},
  {3.98260068722395069174e-17f, "39826007", -16},
  {1.62406489253044128418e-01f, "16240649", 0},
  {4.59706720365281577074e-25f, "4597067", -24},
  {1.06078713521529088837e-11f, "10607871", -10},
  {6.77795526942946639217e+22f, "67779553", 23},
  {1.18240765844508918676e+34f, "11824077", 35},
  {4.20440931931311308800e+20f, "42044093", 21},
  {1.12689361035593695734e-32f, "11268936", -31},
  {2.55097520884817186015e-09f, "25509752", -8},
  {1.60107762306291838211e-29f, "16010776", -28},
  {1.76644888938426447567e-07f, "17664489", -6},
  {4.55286216735839843750e+00f, "4552862", 1},
  {1.65137255306794506522e+33f, "16513726", 34},
  {1.90688104842516832287e-20f, "1906881", -19},
  {2.25278490785303793394e-26f, "22527849", -25},
  {4.37714419376789010130e-07f, "43771442", -6},
  {4.20997377375844748174e-26f, "42099738", -25},
  {1.52181282343034552320e+19f, "15218128", 20},
  {1.23001925107697140087e-19f, "12300193", -18},
  {5.52877719340184944506e-18f, "5528777", -17},
  {1.23525646062730389375e-25f, "12352565", -24},
  {8.13738513027406500900e+36f, "8137385", 37},
  {3.08599750000000000000e+06f, "30859975", 7},
  {1.28878387200000000000e+09f, "12887839", 10},
  {9.90904271613510245764e-14f, "9909043", -13},
  {2.63972788161481730640e-06f, "26397279", -5},
  {1.91579162129591166639e-35f, "19157916", -34},
  {3.24342749081552028656e-03f, "32434275", -2},
  {8.20150944491615518928e-07f, "82015094", -6},
  {5.78025396319461877936e-33f, "5780254", -32},
  {9.72252468423871560924e-29f, "97225247", -28},
  {5.20104648166604800000e+15f, "52010465", 16},
  {1.54016359375000000000e+05f, "15401636", 6},
  {7.37008364900355525395e-15f, "7370084", -14},
  {7.76534495409643163734e-35f, "7765345", -34},
  {1.43275348182814177278e-11f, "14327535", -10},
  {1.27487454150933715206e-19f, "12748745", -18},
  {5.01611589426390993417e+24f, "5016116", 25},
  {2.74299745797179639339e-05f, "27429975", -4},
  {5.30998353920000000000e+10f, "53099835", 11},
  {1.35603357692101698330e+34f, "13560336", 35},
  {7.91944696100006833924e+26f, "7919447", 27},
  {3.40005213126078127287e-28f, "34000521", -27},
  {3.12551950733644759809e+28f, "31255195", 29},
  {2.07875390782252751296e-32f, "20787539", -31},
  {1.26710390261025682840e-15f, "12671039", -14},
  {1.96216853136296030661e-17f, "19621685", -16},
  {1.42587791329454089103e-19f, "14258779", -18},
  {2.59178395544415741615e-35f, "2591784", -34},
  {3.96386291503906250000e+02f, "3963863", 3},
  {1.22156913757324218750e+02f, "12215691", 3},
  {5.38396027956853565778e-22f, "53839603", -21},
  {4.31542444229125976562e+00f, "43154244", 1},
  {5.44400821224571902128e-31f, "5444008", -30},
  {1.13853747144793121603e+26f, "11385375", 27},
  {7.04880482067303403734e+25f, "7048805", 26},
  {2.25817321777343750000e+02f, "22581732", 3},
  {3.36910663186190683225e+29f, "33691066", 30},
  {3.29227359977202422084e-16f, "32922736", -15},
  {3.08251922507013687141e+34f, "30825192", 35},
  {3.22155395448073135820e+35f, "3221554", 36},
  {5.37282039658748544753e-06f, "53728204", -5},
  {2.25268400128000000000e+11f, "2252684", 12},
  {7.12930450439453125000e+01f, "71293045", 2},
  {6.66711305539184230400e+18f, "6667113", 19},
  {2.81889870551449600000e+15f, "28188987", 16},
  {1.71626476244206034288e+29f, "17162648", 30},
  {1.37947411615628224734e+38f, "13794741", 39},
  {2.06264152526855468750e+01f, "20626415", 2},
  {6.68182363958028449624e-15f, "66818236", -14},
  {1.00242186240000000000e+10f, "10024219", 11},
  {3.89395456295460462570e-04f, "38939546", -3},
  {7.49775774780826139052e-27f, "7497758", -26},
  {5.46199799769725927424e+20f, "5461998", 21},
  {1.66685919624279255125e-14f, "16668592", -13},
  {2.50275514296194684216e-20f, "25027551", -19},
  {9.83941485213049331125e-34f, "9839415", -33},
  {5.32454960000000000000e+07f, "53245496", 8},
  {5.80923855304718017578e-01f, "58092386", 0},
  {4.27188376862836884714e-30f, "42718838", -29},
  {2.86570672005043145991e-29f, "28657067", -28},
  {1.00673990039934989761e-37f, "10067399", -36},
  {3.69497157480178084477e-13f, "36949716", -12},
  {2.08577269760000000000e+10f, "20857727", 11},
  {9.15564375606879231370e-30f, "9155644", -29},
  {5.66924195630571413083e-26f, "5669242", -25},
  {2.02373601496219635010e-03f, "2023736", -2},
  {3.33967720448000000000e+11f, "33396772", 12},
  {2.79186049819098848805e-35f, "27918605", -34},
  {1.12072173484138037248e+20f, "11207217", 21},
  {1.42534740000000000000e+07f, "14253474", 8},
  {1.29139308433951091075e-38f, "12913931", -37},
  {7.97118306746412746485e-25f, "7971183", -24},
  {4.53396353771710928499e-21f, "45339635", -20},
  {1.55206359863281250000e+02f, "15520636", 3},
  {8.91136785381010230434e+32f, "8911368", 33},
  {2.06397997981432614959e+33f, "206398", 34},
  {3.86138268027025333140e-08f, "38613827", -7},
  {1.61819363230565435210e+32f, "16181936", 33},
  {5.73481229366734623909e-05f, "57348123", -4},
  {4.23854001566515200000e+16f, "423854", 17},
  {2.37885498046875000000e+03f, "2378855", 4},
  {3.73740716729118695087e+30f, "37374072", 31},
  {5.29502850454466732322e+28f, "52950285", 29},
  {1.79793479197331695224e-15f, "17979348", -14},
  {8.71964877231148691874e-23f, "8719649", -22},
  {1.86701360328673440846e-30f, "18670136", -29},
  {3.00206332015662269441e-10f, "30020633", -9},
  {7.45867651483433800040e+23f, "74586765", 24},
  {1.80550784000000000000e+08f, "18055078", 9},
  {2.05398812890052795410e-01f, "20539881", 0},
  {3.55453746785138915818e+33f, "35545375", 34},
  {3.04031667200000000000e+09f, "30403167", 10},
  {1.22658212070478027204e+25f, "12265821", 26},
  {1.03759054687500000000e+05f, "103759055", 6},
  {4.30391924479544524800e+18f, "43039192", 19},
  {1.16108357498510694082e+38f, "11610836", 39},
  {3.04573499205198454598e-37f, "3045735", -36},
  {2.01444128045125125936e-09f, "20144413", -8},
  {4.58774767790006991651e-36f, "45877477", -35},
  {5.37524149890052417126e+21f, "53752415", 22},
  {4.73375689590522151945e+36f, "4733757", 37},
  {9.76889758887313738959e-36f, "97688976", -35},
  {7.08189724959790864921e+35f, "7081897", 36},
  {2.96152173108591095038e-23f, "29615217", -22},
  {2.40607062500000000000e+05f, "24060706", 6},
  {9.11807818696486858781e+29f, "9118078", 30},
  {8.62755707550990415835e-29f, "8627557", -28},
  {1.50382373134290030777e+36f, "15038237", 37},
  {2.16572521616709213225e+23f, "21657252", 24},
  {8.32594000000000000000e+05f, "832594", 6},
  {9.20270059601920000000e+13f, "9202701", 14},
  {7.25188843437446495344e-13f, "72518884", -12},
  {4.14919620379805564880e-03f, "4149196", -2},
  {6.73560791015625000000e+03f, "6735608", 4},
  {2.20844392448000000000e+11f, "2208444", 12},
  {6.01402753679360000000e+13f, "60140275", 14},
  {2.00968306688000000000e+12f, "20096831", 13},
  {8.91603445220749908812e-38f, "89160345", -37},
  {6.07257485389709472656e-02f, "6072575", -1},
  {5.08709510973999880389e-19f, "5087095", -18},
  {3.07884263992309570312e+00f, "30788426", 1},
  {3.12896247578464681283e-07f, "31289625", -6},
  {2.51749394980712649299e+29f, "2517494", 30},
  {5.13772882473461506292e-14f, "51377288", -13},
  {5.03942136527380373328e+36f, "50394214", 37},
  {1.56260518400000000000e+09f, "15626052", 10},
  {8.33128986128415724433e-15f, "833129", -14},
  {2.57765614513538044027e+38f, "25776561", 39},
  {6.17388822357622935044e-12f, "61738882", -11},
  {1.95182700519260946432e+21f, "1951827", 22},
  {3.50231863654841183315e+36f, "35023186", 37},
  {9.83627135298092980520e-09f, "9836271", -8},
  {1.98167289648486809600e+18f, "19816729", 19},
  {1.48505518272232643952e-25f, "14850552", -24},
  {3.84109738794961848379e+35f, "38410974", 36},
  {2.48551142400000000000e+09f, "24855114", 10},
  {2.03414348184233467060e-15f, "20341435", -14},
  {8.35466157586831947454e+32f, "83546616", 33},
  {7.58439625769824488088e-07f, "7584396", -6},
  {2.74631432878798200396e+29f, "27463143", 30},
  {1.07040112000000000000e+08f, "10704011", 9},
  {8.74575122262329917440e+19f, "8745751", 20},
  {1.63287254811156357093e-12f, "16328725", -11},
  {1.00122578535830641207e-27f, "10012258", -26},
  {2.67047397528585861437e-08f, "2670474", -7},
  {1.41496773848073565050e-37f, "14149677", -36},
  {3.22557605145064081719e+23f, "3225576", 24},
  {4.02535363264178158715e-07f, "40253536", -6},
  {1.44787573814392089844e+00f, "14478757", 1},
  {2.38864997944148642184e-34f, "238865", -33},
  {1.99218208815835757507e+32f, "1992182", 33},
  {7.14045410441889233872e+31f, "7140454", 32},
  {9.49681492141645907596e+33f, "9496815", 34},
  {1.40330270034954826242e-20f, "14033027", -19},
  {5.24768517494929495427e+29f, "5247685", 30},
  {2.10421289062500000000e+04f, "21042129", 5},
  {1.97915351562500000000e+04f, "19791535", 5},
  {1.85534544446496604150e+29f, "18553454", 30},
  {1.49184023437500000000e+04f, "14918402", 5},
  {1.93194518312958337011e+31f, "19319452", 32},
  {5.01418360832000000000e+11f, "50141836", 12},
  {7.28652801513671875000e+01f, "7286528", 2},
  {2.72059491710453988690e-16f, "2720595", -15},
  {1.43700895627318914194e-09f, "1437009", -8},
  {1.77304155403059200000e+15f, "17730416", 16},
  {1.49742994100917276478e-19f, "149743", -18},
  {1.72505908734338215668e-25f, "17250591", -24},
  {6.15571195794473169371e-07f, "6155712", -6},
  {2.30247534800376512191e+29f, "23024753", 30},
  {2.98311120967627177984e+21f, "29831112", 22},
  {7.63186132835671347982e-26f, "76318613", -25},
  {5.28730071108969815750e-22f, "52873007", -21},
  {4.87704119122035375965e+32f, "4877041", 33},
  {3.32488125000000000000e+05f, "33248812", 6},
  {1.18793346473300975547e-20f, "11879335", -19},
  {2.26276400619847680000e+17f, "2262764", 18},
  {2.08071738520257496364e+37f, "20807174", 38},
  {2.76921651669919334400e+18f, "27692165", 19},
  {8.54921132013508362240e+21f, "85492113", 22},
  {6.00599787350736039825e+30f, "6005998", 31},
  {2.69547208704000000000e+11f, "26954721", 12},
  {1.18130215028260864000e+17f, "118130215", 18},
  {1.23181347759165277660e-28f, "12318135", -27},
  {2.06987716674804687500e+02f, "20698772", 3},
  {3.33708006276680673249e-18f, "333708", -17},
  {4.01920489422848000000e+14f, "4019205", 15},
  {5.32859303348232060671e-08f, "5328593", -7},
  {8.43728536720147849255e+24f, "84372854", 25},
  {1.11816240000000000000e+07f, "11181624", 8},
  {3.88105818121731362940e-35f, "38810582", -34},
  {8.56430106953992575924e-13f, "8564301", -12},
  {4.93813480757582696965e+29f, "49381348", 30},
  {8.81275263964198529720e-06f, "8812753", -5},
  {2.19388543138117395660e-36f, "21938854", -35},
  {9.79114436445101758066e-29f, "97911444", -28},
  {7.07812614564318209887e-06f, "7078126", -5},
  {1.77243512035662266340e-36f, "17724351", -35},
  {2.85586793166562376983e-15f, "2855868", -14},
  {7.09608686944672378020e+26f, "7096087", 27},
  {6.61633108530955970195e+31f, "6616331", 32},
  {1.15315907653590092860e-32f, "11531591", -31},
  {7.62966992740721778342e-38f, "762967", -37},
  {4.74447485307137725401e-29f, "4744475", -28},
  {4.39590130855623764783e-39f, "4395901", -38},
  {3.96569950000000000000e+06f, "39656995", 7},
  {9.50275344524520448886e-11f, "95027534", -10},
  {2.80169993847439360000e+17f, "28017", 18},
  {1.21090218750000000000e+05f, "12109022", 6},
  {3.61597437779044392972e-31f, "36159744", -30},
  {3.50887179374694824219e+00f, "35088718", 1},
  {1.00797310005873441696e-03f, "10079731", -2},
  {1.65534708125862461440e+19f, "16553471", 20},
  {5.90306559130153598563e-22f, "59030656", -21},
  {2.10066420000000000000e+07f, "21006642", 8},
  {4.89824305505166559236e-18f, "4898243", -17},
  {3.29379409551620483398e-01f, "3293794", 0},
  {1.16573546294944749996e-17f, "11657355", -16},
  {4.22142646681600000000e+13f, "42214265", 14},
  {3.77407388110415076277e-15f, "3774074", -14},
  {2.00636493008787380497e+28f, "2006365", 29},
  {2.61126641432920064000e+17f, "26112664", 18},
  {5.34807183360000000000e+11f, "53480718", 12},
  {1.44913565459016581120e+19f, "14491357", 20},
  {3.17791671962611856065e-27f, "31779167", -26},
  {1.97553798774784000000e+14f, "1975538", 15},
  {2.39347006107820237117e+29f, "239347", 30},
  {3.82210875000000000000e+06f, "38221088", 7},
  {5.69863691126702080000e+16f, "5698637", 17},
  {9.24955583020193372587e-25f, "9249556", -24},
  {3.75548961528693325818e-06f, "37554896", -5},
  {5.20868300800000000000e+09f, "5208683", 10},
  {1.72545160849070020720e-18f, "17254516", -17},
  {4.85720702272374182940e-05f, "4857207", -4},
  {4.02958477147347353600e+19f, "40295848", 20},
  {2.36490027230236803915e-18f, "23649003", -17},
  {2.78846533810436551862e-37f, "27884653", -36},
  {5.44245157560658611527e-30f, "54424516", -29},
  {1.11216372137772334912e+38f, "11121637", 39},
  {5.57965200000000000000e+06f, "5579652", 7},
  {3.29982561381415571066e-22f, "32998256", -21},
  {5.30889034271240234375e-01f, "53088903", 0},
  {8.19999073448222154589e-36f, "8199991", -35},
  {8.99242338294425716674e+35f, "8992423", 36},
  {5.24435177791815680000e+16f, "52443518", 17},
  {2.77377679360000000000e+10f, "27737768", 11},
  {5.97955091934267271475e-21f, "5979551", -20},
  {2.34670168535747443251e-23f, "23467017", -22},
  {5.25132859024973128813e+31f, "52513286", 32},
  {3.98479068534587519132e+31f, "39847907", 32},
  {1.46834001541137695312e+01f, "146834", 2},
  {1.54363283839174626509e+21f, "15436328", 22},
  {1.52607365120000000000e+10f, "15260737", 11},
  {1.15097155706277774837e-26f, "115097156", -25},
  {3.00586223602294921875e+01f, "30058622", 2},
  {8.23400719696518971392e+21f, "8234007", 22},
  {3.66661283373618182664e+26f, "3666613", 27},
  {1.03500177317528141430e-08f, "10350018", -7},
  {4.55807405708164026237e-11f, "4558074", -10},
  {2.89412871093750000000e+04f, "28941287", 5},
  {1.58058012500000000000e+06f, "15805801", 7},
  {2.89972300933584241295e+22f, "2899723", 23},
  {2.04642105208875895935e-25f, "2046421", -24},
  {4.63196599992714271086e+26f, "4631966", 27},
  {1.90872128295002872556e-21f, "19087213", -20},
  {1.39075429784236091881e+33f, "13907543", 34},
  {1.46723493349863129494e-30f, "14672349", -29},
  {8.72410137589088315375e-20f, "87241014", -19},
  {1.08103652077009740673e-35f, "10810365", -34},
  {2.30206063008255861408e-31f, "23020606", -30},
  {7.50348478028784549296e+25f, "7503485", 26},
  {5.87411455258992844822e-19f, "58741146", -18},
  {2.06202300000000000000e+07f, "2062023", 8},
  {1.03160020260423673779e+29f, "10316002", 30},
  {7.23157854250180701005e-22f, "72315785", -21},
  {1.49627999555557731140e-15f, "149628", -14},
  {3.83322620391845703125e+00f, "38332262", 1},
  {7.18925846740603446960e-04f, "71892585", -3},
  {5.83111667633056640625e+00f, "58311167", 1},
  {2.88764397282648133114e-07f, "2887644", -6},
  {4.18226044074376801518e-11f, "41822604", -10},
  {1.21612337428916696215e-37f, "12161234", -36},
  {6.28108654195917343295e-25f, "62810865", -24},
  {1.03241440234869318185e+38f, "10324144", 39},
  {2.22148974803703064896e-25f, "22214897", -24},
  {3.14652444799795200000e+15f, "31465244", 16},
  {1.15533648953828022682e+21f, "11553365", 22},
  {1.18395135521030349797e-37f, "11839514", -36},
  {4.40404630295812732398e-32f, "44040463", -31},
  {7.69099539914761999335e-29f, "76909954", -28},
  {5.37620125000000000000e+05f, "5376201", 6},
  {1.13808433479680000000e+13f, "11380843", 14},
  {3.43489636589839130483e+32f, "34348964", 33},
  {1.85317099342575697920e+19f, "1853171", 20},
  {7.16208457946777343750e+00f, "71620846", 1},
  {9.57372167931614612973e-28f, "9573722", -27},
  {3.78585302958080000000e+13f, "3785853", 14},
  {1.77217049600000000000e+09f, "17721705", 10},
  {1.33699327165004433482e-08f, "13369933", -7},
  {6.74525429880586240000e+16f, "67452543", 17},
  {6.54911946327326720000e+16f, "65491195", 17},
  {1.46882921813374283627e-21f, "14688292", -20},
  {6.52205853522243958601e+36f, "65220585", 37},
  {1.85950328756862709456e-15f, "18595033", -14},
  {2.04344552523216092197e-31f, "20434455", -30},
  {6.39963527689681610292e-24f, "63996353", -23},
  {4.64787616000000000000e+08f, "46478762", 9},
  {1.31047720000000000000e+08f, "13104772", 9},
  {7.73248712704000000000e+11f, "7732487", 12},
  {3.75260490737296038026e-30f, "3752605", -29},
  {5.47276722878487296100e-38f, "5472767", -37},
  {4.33415337198545744856e-38f, "43341534", -37},
  {7.48447070897368524069e-29f, "7484471", -28},
  {5.56726435401788678088e-24f, "55672644", -23},
  {6.71705412381779438862e-40f, "671705", -39},
  {2.76525234696835871956e-15f, "27652523", -14},
  {2.73797308064302782927e+30f, "2737973", 31},
  {1.19754316971483385037e+21f, "11975432", 22},
  {5.16050621831264100248e-14f, "51605062", -13},
  {1.98473252969907373005e+37f, "19847325", 38},
  {1.55943040785099038011e+31f, "15594304", 32},
  {4.66779557137224085275e+30f, "46677956", 31},
  {3.18936875008000000000e+11f, "31893688", 12},
  {7.71863480573489256700e+24f, "7718635", 25},
  {1.26837374976000000000e+11f, "126837375", 12},
  {3.15169826492119736408e-27f, "31516983", -26},
  {1.18390722473227713930e+36f, "11839072", 37},
  {6.82735999354457112620e-15f, "682736", -14},
  {9.45222456298193289216e+20f, "94522246", 21},
  {2.29313113636608889578e-11f, "22931311", -10},
  {6.74795880856552248824e-37f, "6747959", -36},
  {8.86884331703186035156e-02f, "8868843", -1},
  {5.49418250000000000000e+06f, "54941825", 7},
  {2.41893542210214247600e-40f, "241894", -39},
  {2.76885988834350559396e+22f, "276886", 23},
  {1.89441830289408000000e+14f, "18944183", 15},
  {6.46772225605689424235e-24f, "64677223", -23},
  {1.78410264339845525683e-08f, "17841026", -7},
  {3.60497288525879228550e-17f, "3604973", -16},
  {8.42591781480878599488e+26f, "8425918", 27},
  {1.10923118591308593750e+01f, "11092312", 2},
  {3.24797351193282829614e-16f, "32479735", -15},
  {5.96600641849984915037e+27f, "59660064", 28},
  {1.28436101120000000000e+11f, "1284361", 12},
  {2.86339938640594482422e-01f, "28633994", 0},
  {6.24896176371624291099e+27f, "6248962", 28},
  {5.92208429943825072328e+34f, "59220843", 35},
  {1.14114928617681243850e-09f, "11411493", -8},
  {1.09635604480000000000e+10f, "1096356", 11},
  {4.30690817874975716815e-18f, "4306908", -17},
  {3.17736184585193370822e-11f, "3177362", -10},
  {2.32197570800781250000e+02f, "23219757", 3},
  {2.79820333772284549620e-26f, "27982033", -25},
  {1.47174117760703989515e-38f, "14717412", -37},
  {2.56517506888598312287e-12f, "2565175", -11},
  {5.82771556389265216635e+23f, "58277156", 24},
  {7.77307867782214981445e-27f, "7773079", -26},
  {4.23329109939217518299e-15f, "4233291", -14},
  {5.83744551318910218972e-30f, "58374455", -29},
  {1.17092454211492849040e+33f, "117092454", 34},
  {1.55461552701440000000e+13f, "15546155", 14},
  {6.63956018680490085546e-28f, "663956", -27},
  {1.45806055229513731319e-07f, "14580606", -6},
  {1.16802012546156130548e-19f, "11680201", -18},
  {6.72267465651990421232e-28f, "67226747", -27},
  {5.58820782219059942330e-24f, "5588208", -23},
  {3.69528939340807796736e+33f, "36952894", 34},
  {7.36328153397997064999e-13f, "73632815", -12},
  {1.58227870000000000000e+07f, "15822787", 8},
  {1.82345236107160329429e-22f, "18234524", -21},
  {8.19108642644160247886e-25f, "81910864", -24},
  {2.51008104748034406510e-31f, "2510081", -30},
  {9.47967529296875000000e+00f, "9479675", 1},
  {7.13381721479344402930e-36f, "7133817", -35},
  {5.26540890305881702400e+18f, "5265409", 19},
  {7.33856355900852673523e+30f, "73385636", 31},
  {4.41196119851008000000e+14f, "44119612", 15},
  {7.24391491235820694783e-10f, "7243915", -9},
  {1.10310585021972656250e+02f, "110310585", 3},
  {3.00542645960603824337e+35f, "30054265", 36},
  {3.79853559703588044800e+18f, "37985356", 19},
  {3.70174937496883578883e-35f, "37017494", -34},
  {1.19359568488709704094e-29f, "11935957", -28},
  {8.75930336314261504000e+18f, "87593034", 19},
  {1.45127359019170398824e-08f, "14512736", -7},
  {1.18096013515715279161e+33f, "11809601", 34},
  {1.11776036087974410425e+31f, "11177604", 32},
  {1.02630906417643520000e+16f, "10263091", 17},
  {1.00480430588823714260e-35f, "10048043", -34},
  {1.84365222716497073107e+25f, "18436522", 26},
  {2.21983681436555002620e-10f, "22198368", -9},
  {1.08641322360597514820e-24f, "10864132", -23},
  {3.82656174747731441344e-21f, "38265617", -20},
  {4.26089472000000000000e+09f, "42608947", 10},
  {1.12427564003328428477e-13f, "112427564", -12},
  {3.46819660990149714053e-06f, "34681966", -5},
  {2.30606015625000000000e+04f, "23060602", 5},
  {1.40477957406720000000e+13f, "14047796", 14},
  {8.01478878435760725903e-38f, "8014789", -37},
  {6.66862844629770829824e+20f, "66686284", 21},
  {1.95289082952682264423e+27f, "19528908", 28},
  {3.11965988013315160581e-30f, "31196599", -29},
  {9.12234880012363958421e-18f, "9122349", -17},
  {2.23466688767623988629e+30f, "22346669", 31},
  {2.77069033454658819602e+27f, "27706903", 28},
  {5.70719922434892496150e-18f, "57071992", -17},
  {2.28584815276807579238e+22f, "22858482", 23},
  {1.72699291992187500000e+03f, "17269929", 4},
  {6.60040712192000000000e+11f, "6600407", 12},
  {3.43497821671452131798e-15f, "34349782", -14},
  {7.47670888900756835938e-01f, "7476709", 0},
  {3.44209238889447988186e-09f, "34420924", -8},
  {2.14112130803023603676e-11f, "21411213", -10},
  {1.48892518400000000000e+09f, "14889252", 10},
  {4.41088211999163364785e-29f, "4410882", -28},
  {5.23604853411115171840e+19f, "52360485", 20},
  {2.47035253906250000000e+03f, "24703525", 4},
  {6.95714867905950843606e-37f, "69571487", -36},
  {7.61067320127040147781e-04f, "7610673", -3},
  {3.93372100000000000000e+06f, "3933721", 7},
  {2.17359874367112794549e+27f, "21735987", 28},
  {2.83467219306009108540e+25f, "28346722", 26},
  {7.01942859870987354112e+20f, "70194286", 21},
  {1.16185700004801659223e-32f, "1161857", -31},
  {1.76956164068542420864e-04f, "17695616", -3},
  {1.15073514840978783065e-31f, "11507351", -30},
  {6.81421852111816406250e+00f, "68142185", 1},
  {2.60325404357454462976e+20f, "2603254", 21},
  {9.01191558837890625000e+01f, "90119156", 2},
  {5.86412264920656642048e+20f, "58641226", 21},
  {7.20247936000000000000e+08f, "72024794", 9},
  {4.76030525440000000000e+10f, "47603053", 11},
  {7.83318469606611622649e-36f, "7833185", -35},
  {2.20881533622741699219e+00f, "22088153", 1},
  {1.88063025474548339844e-01f, "18806303", 0},
  {6.91535443478655774407e-15f, "69153544", -14},
  {7.29708296147739063353e-17f, "7297083", -16},
  {4.48012203675521065744e-37f, "4480122", -36},
  {7.62382897313822871536e+35f, "7623829", 36},
  {4.18842040000000000000e+07f, "41884204", 8},
  {5.39636001586914062500e+01f, "539636", 2},
  {3.62900334782700895175e-12f, "36290033", -11},
  {1.42859934421425368991e+35f, "14285993", 36},
  {1.08348569588286084754e-28f, "10834857", -27},
  {2.72249393165111541748e-02f, "2722494", -1},
  {1.02578293068267520000e+16f, "10257829", 17},
  {4.50099276677120000000e+13f, "45009928", 14},
  {3.18384695053100585938e+00f, "3183847", 1},
  {1.09699251702786560776e-26f, "10969925", -25},
  {2.50451471122121198571e-19f, "25045147", -18},
  {9.80611859074942415759e-12f, "9806119", -11},
  {4.94687564584872168607e+37f, "49468756", 38},
  {2.52804825570199580613e-37f, "25280483", -36},
  {1.88135290954960510135e-05f, "1881353", -4},
  {1.23033887575729750097e-05f, "12303389", -4},
  {4.76827001846083536348e-30f, "476827", -29},
  {2.01099546526589026686e+34f, "20109955", 35},
  {1.12133957372861914337e-05f, "11213396", -4},
  {2.02056971402101604038e+29f, "20205697", 30},
  {2.62623047456145286560e-03f, "26262305", -2},
  {9.63899831530872717093e-24f, "9638998", -23},
  {2.02090635895729064941e-01f, "20209064", 0},
  {1.70597202920854482571e-31f, "1705972", -30},
  {1.19134526164236421610e-20f, "11913453", -19},
  {7.32088909689598204068e+37f, "7320889", 38},
  {5.17814250000000000000e+06f, "51781425", 7},
  {1.39642021484375000000e+04f, "13964202", 5},
  {7.18632430463715278089e-18f, "7186324", -17},
  {3.82677856000000000000e+08f, "38267786", 9},
  {1.48137674331665039062e+01f, "14813767", 2},
  {5.08607181570070640091e+28f, "5086072", 29},
  {2.80695321783136072516e-29f, "28069532", -28},
  {9.14484439490694683645e+27f, "91448444", 28},
  {9.70543964681152291353e+24f, "970544", 25},
  {5.13903584835373479416e-19f, "5139036", -18},
  {3.61338319291790166510e-13f, "36133832", -12},
  {1.46222946166992187500e+02f, "14622295", 3},
  {3.80138456859495291306e+33f, "38013846", 34},
  {1.82767351909774296464e+26f, "18276735", 27},
  {2.58940155723776000000e+14f, "25894016", 15},
  {1.33940693097475594441e-24f, "13394069", -23},
  {2.52926851407063315460e-24f, "25292685", -23},
  {1.76429455114240000000e+13f, "17642946", 14},
  {5.19703583843519943195e-23f, "51970358", -22},
  {7.56692684800000000000e+09f, "7566927", 10},
  {3.18604202095459556283e-31f, "3186042", -30},
  {4.19080900895558300379e-14f, "4190809", -13},
  {2.22603593750000000000e+05f, "2226036", 6},
  {5.55662048339843750000e+02f, "55566205", 3},
  {1.15783355424258730354e-23f, "115783355", -22},
  {7.84636380722960169965e-37f, "7846364", -36},
  {8.88834342216794112000e+17f, "88883434", 18},
  {3.84605630758912000000e+14f, "38460563", 15},
  {2.23786830358132928659e-29f, "22378683", -28},
  {1.72799252818605993868e+36f, "17279925", 37},
  {3.82639349432320000000e+13f, "38263935", 14},
  {1.81510794012262400000e+16f, "1815108", 17},
  {3.21475753784179687500e+01f, "32147575", 2},
  {4.66552762266608118565e+34f, "46655276", 35},
  {1.01833104597967398497e-14f, "101833105", -13},
  {6.98274737519803990234e-37f, "69827474", -36},
  {3.40213473889650951481e+24f, "34021347", 25},
  {4.71533894597087055445e-05f, "4715339", -4},
  {1.07948008747939275582e+30f, "10794801", 31},
  {4.84681564160000000000e+10f, "48468156", 11},
  {3.89584618573004800000e+15f, "38958462", 16},
  {5.47311191171358649147e-22f, "5473112", -21},
  {1.00358707176662238259e-26f, "10035871", -25},
  {2.05186621440000000000e+10f, "20518662", 11},
  {1.41884062251358360781e-34f, "14188406", -33},
  {4.31068164093951376970e+26f, "43106816", 27},
  {4.38498446890315821770e+24f, "43849845", 25},
  {5.43324796561447852320e-20f, "5433248", -19},
  {1.11659336090087890625e+01f, "11165934", 2},
  {3.34211230774973486013e-37f, "33421123", -36},
  {6.98820089488549510100e+28f, "6988201", 29},
  {5.42914432000000000000e+08f, "5429144", 9},
  {2.27643164735225056461e-12f, "22764316", -11},
  {2.23144616029458120465e-05f, "22314462", -4},
  {4.42886753714791537407e-28f, "44288675", -27},
  {4.10071093750000000000e+03f, "4100711", 4},
  {2.94015882536768913269e-03f, "29401588", -2},
  {6.49043560562878556457e+28f, "64904356", 29},
  {2.31670933889137812434e-21f, "23167093", -20},
  {1.07238560000000000000e+07f, "10723856", 8},
  {1.49977471108760398956e+26f, "14997747", 27},
  {1.47561666881034579259e+31f, "14756167", 32},
  {2.85542826862643958456e-16f, "28554283", -15},
  {7.06868417965633710764e-12f, "7068684", -11},
  {9.76892711413710631322e+26f, "9768927", 27},
  {4.61479232000000000000e+08f, "46147923", 9},
  {8.37891256377787385645e-10f, "83789126", -9},
  {4.36582062489600000000e+12f, "43658206", 13},
  {3.04361057873851726491e-35f, "30436106", -34},
  {1.30319110522613524107e-18f, "13031911", -17},
  {3.09964136690745123773e-16f, "30996414", -15},
  {1.83948130400180633600e+19f, "18394813", 20},
  {1.12173698842525482178e-01f, "1121737", 0},
  {4.75813023513182997704e-04f, "47581302", -3},
  {5.53537660152869648300e-10f, "55353766", -9},
  {2.59724804687500000000e+03f, "2597248", 4},
  {2.97936454128191270836e-16f, "29793645", -15},
  {3.31633298579523041088e-24f, "3316333", -23},
  {2.39980273413943145267e+22f, "23998027", 23},
  {5.25135713337276253602e+23f, "5251357", 24},
  {1.88387733936310510352e-22f, "18838773", -21},
  {2.27492233216000000000e+12f, "22749223", 13},
  {4.16942896208638558164e-07f, "4169429", -6},
  {6.75514609375000000000e+04f, "6755146", 5},
  {7.38036302828322233110e-32f, "7380363", -31},
  {3.02337187500000000000e+04f, "30233719", 5},
  {4.07014213675606556262e-31f, "4070142", -30},
  {3.28426054687500000000e+04f, "32842605", 5},
  {2.83000190393067896366e-06f, "2830002", -5},
  {1.59098767688915787577e-13f, "15909877", -12},
  {5.17254468142614433594e-28f, "51725447", -27},
  {6.16759047910549998263e-19f, "61675905", -18},
  {3.14167558732901421023e-21f, "31416756", -20},
  {2.39048877119785174727e-05f, "23904888", -4},
  {7.32922560000000000000e+08f, "73292256", 9},
  {4.41507339505800042391e-33f, "44150734", -32},
  {1.54769515066582382361e-35f, "15476952", -34},
  {9.90674724565098317996e+37f, "9906747", 38},
  {3.26995885100000870400e+18f, "32699589", 19},
  {7.64229373249954936735e-32f, "7642294", -31},
  {1.80737542126158721443e-19f, "18073754", -18},
  {1.36475681548100653076e-36f, "13647568", -35},
  {2.38986018083693000160e+26f, "23898602", 27},
  {3.37065542440661811200e+18f, "33706554", 19},
  {1.10187701880931854248e-01f, "1101877", 0},
  {1.83501643085341915055e-22f, "18350164", -21},
  {1.20041228043471176023e-17f, "12004123", -16},
  {5.21722200992511531418e+21f, "5217222", 22},
  {1.03439340648492361652e-07f, "10343934", -6},
  {3.85348308116906420078e-34f, "3853483", -33},
  {3.86362100000000000000e+06f, "3863621", 7},
  {3.25278515200000000000e+09f, "32527852", 10},
  {1.49150040798003200000e+17f, "14915004", 18},
  {2.70712221364512167337e+38f, "27071222", 39},
  {3.19591489703124682449e-25f, "3195915", -24},
  {1.85189515475430784421e+24f, "18518952", 25},
  {1.17671787109375000000e+04f, "11767179", 5},
  {2.18901735496358529646e-17f, "21890174", -16},
  {8.92980411837385190665e-11f, "8929804", -10},
  {5.10465910193864921709e+36f, "5104659", 37},
  {5.30643424000000000000e+08f, "53064342", 9},
  {7.25915479660034179688e+00f, "7259155", 1},
  {4.54791938327645731489e-21f, "45479194", -20},
  {2.83382848510301979479e+26f, "28338285", 27},
  {2.86909588641725874125e+34f, "2869096", 35},
  {5.28440557065624257424e+26f, "52844056", 27},
  {2.05110668003142370778e+32f, "20511067", 33},
  {7.09146056418235544035e+37f, "70914606", 38},
  {7.24201140641504945357e+25f, "72420114", 26},
  {9.24805103616000000000e+11f, "9248051", 12},
  {7.50179409264866012803e-33f, "7501794", -32},
  {1.89699573868892065719e-32f, "18969957", -31},
  {2.10583219601408000000e+14f, "21058322", 15},
  {2.85843507949531860427e+32f, "2858435", 33},
  {9.67928446955801198304e+24f, "9679284", 25},
  {3.25518059935606237243e-26f, "32551806", -25},
  {7.54666380170281005447e-29f, "7546664", -28},
  {1.70669166685011823012e-31f, "17066917", -30},
  {2.83307653544620345970e+34f, "28330765", 35},
  {1.25971960449218750000e+03f, "12597196", 4},
  {1.11876977728102983844e-26f, "11187698", -25},
  {1.54418548583984375000e+02f, "15441855", 3},
  {5.63804705269889186780e-27f, "5638047", -26},
  {2.79857430302332927533e+29f, "27985743", 30},
  {5.75199470520019531250e+01f, "57519947", 2},
  {2.93389498893376066135e-13f, "2933895", -12},
  {7.30709362737152000000e+14f, "73070936", 15},
  {9.50578567813812703878e-34f, "9505786", -33},
  {1.00271059200000000000e+09f, "10027106", 10},
  {8.82138141343195713965e-35f, "88213814", -34},
  {6.94587156711723260901e-36f, "69458716", -35},
  {7.81173941637950661511e-22f, "78117394", -21},
  {1.07932414062500000000e+05f, "107932414", 6},
  {5.19164484550483706167e-18f, "5191645", -17},
  {3.22749973775506001590e-34f, "32274997", -33},
  {4.11334991455078125000e+00f, "411335", 1},
  {3.79875462750714725626e-30f, "37987546", -29},
  {1.03143081957147009638e+37f, "10314308", 38},
  {4.23882961273193359375e-01f, "42388296", 0},
  {4.46907000466360133509e+34f, "446907", 35},
  {1.39338741760000000000e+10f, "13933874", 11},
  {5.01420531250000000000e+05f, "50142053", 6},
  {1.21492720349924386910e-36f, "12149272", -35},
  {3.97335574612114363069e-15f, "39733557", -14},
  {2.09301769733428955078e-01f, "20930177", 0},
  {2.00017677056351193981e+27f, "20001768", 28},
  {2.15263627469539642334e-02f, "21526363", -1},
  {2.51080550400000000000e+09f, "25108055", 10},
  {5.59322899423419945231e+34f, "5593229", 35},
  {8.30537828733213245869e-07f, "83053783", -6},
  {4.52164054553402071873e-27f, "45216405", -26},
  {8.50181743526007255552e-31f, "8501817", -30},
  {2.02308394974951200525e+34f, "2023084", 35},
  {4.06526729122770776048e-15f, "40652673", -14},
  {3.92150349893851240070e+37f, "39215035", 38},
  {1.70474348124116659164e-03f, "17047435", -2},
  {1.97171544064000000000e+11f, "19717154", 12},
  {4.01764243210240000000e+13f, "40176424", 14},
  {2.53386093139648437500e+02f, "2533861", 3},
  {2.82392559337367658876e-19f, "28239256", -18},
  {5.68970191900246016000e+17f, "5689702", 18},
  {2.97182125000000000000e+05f, "29718212", 6},
  {3.58375199139118194580e-02f, "3583752", -1},
  {8.99796879470036851424e-17f, "8997969", -16},
  {2.52237956112061131236e+26f, "25223796", 27},
  {1.86635705566406250000e+03f, "1866357", 4},
  {6.23075620534491996488e+22f, "6230756", 23},
  {1.52356360629669492458e+35f, "15235636", 36},
  {2.82003211975097656250e+01f, "28200321", 2},
  {3.73256781085081195282e-17f, "37325678", -16},
  {9.68390020079984078286e+30f, "96839", 31},
  {5.59250285396701695307e-28f, "5592503", -27},
  {3.11358461149471010787e+27f, "31135846", 28},
  {1.97920986922919098585e+33f, "19792099", 34},
  {3.66952357580885291100e-04f, "36695236", -3},
  {8.78563226943546160541e-13f, "8785632", -12},
  {5.38565945073853897114e+21f, "53856595", 22},
  {1.22065978901950056231e+33f, "12206598", 34},
  {3.65925172092444126218e+35f, "36592517", 36},
  {4.28592450005630976000e+17f, "42859245", 18},
  {1.47564447640358142877e-12f, "14756445", -11},
  {2.36744411792331798852e-30f, "23674441", -29},
  {6.05318700381754157726e+25f, "6053187", 26},
  {4.35942182265574738539e-17f, "43594218", -16},
  {1.56861972300248453394e-06f, "15686197", -5},
  {3.40577191801316796531e+24f, "3405772", 25},
  {1.21407667119723642880e+19f, "12140767", 20},
  {4.15780846669237705756e-34f, "41578085", -33},
  {1.93809628486633300781e-01f, "19380963", 0},
  {4.49599877164723535903e-18f, "44959988", -17},
  {1.96356297920471239982e-14f, "1963563", -13},
  {1.61411543498785185786e-22f, "16141154", -21},
  {2.21211104429147950414e+26f, "2212111", 27},
  {1.15492866888877345866e+23f, "11549287", 24},
  {2.29083776473999023438e+00f, "22908378", 1},
  {7.45622260940800000000e+13f, "7456223", 14},
  {3.07215868413160397843e-13f, "30721587", -12},
  {1.99250207160589238448e-16f, "19925021", -15},
  {1.62651781120000000000e+10f, "16265178", 11},
  {1.37865652544611960427e+27f, "13786565", 28},
  {1.19483725000000000000e+06f, "11948372", 7},
  {2.30826049804687500000e+02f, "23082605", 3},
  {1.27461821639937185984e+38f, "12746182", 39},
  {5.32933199792751111090e-06f, "5329332", -5},
  {6.48465065751224756241e-04f, "64846507", -3},
  {6.11171490163542330265e-05f, "6111715", -4},
  {7.84522903332033921024e+20f, "7845229", 21},
  {4.97551965728130458541e-21f, "49755197", -20},
  {1.09550750415632336399e-10f, "10955075", -9},
  {4.12226940980690944000e+17f, "41222694", 18},
  {3.24912000713472563484e+35f, "324912", 36},
  {2.71036681467985920000e+16f, "27103668", 17},
  {1.49384196149233789212e+26f, "1493842", 27},
  {2.87158632030388250214e+22f, "28715863", 23},
  {1.82936321276523284367e+38f, "18293632", 39},
  {3.41645652114254840643e-19f, "34164565", -18},
  {1.29439544000000000000e+08f, "129439544", 9},
  {3.20859813071080652800e+18f, "3208598", 19},
  {2.35188421743390968510e-14f, "23518842", -13},
  {3.64669821486316851720e-32f, "36466982", -31},
  {1.98351877846281731390e-38f, "19835188", -37},
  {7.12432680960000000000e+10f, "7124327", 11},
  {8.91522823413240430440e-16f, "8915228", -15},
  {6.91348919068893946420e+26f, "6913489", 27},
  {1.19419964903499931097e-05f, "119419965", -4},
  {3.47319692933039751430e+23f, "3473197", 24},
  {7.52977523803710937500e+01f, "7529775", 2},
  {5.65624739756249186304e+20f, "56562474", 21},
  {9.58402290870901217566e-32f, "9584023", -31},
  {1.72874842185600967833e-27f, "17287484", -26},
  {1.10604108800000000000e+09f, "11060411", 10},
  {1.90586090946560000000e+13f, "1905861", 14},
  {6.59134160568320000000e+13f, "65913416", 14},
  {2.05136704000000000000e+08f, "2051367", 9},
  {1.45979588802911349778e-31f, "14597959", -30},
  {6.06566339677412867021e-29f, "60656634", -28},
  {1.84134661126506355936e-35f, "18413466", -34},
  {1.79198495751582331035e+28f, "1791985", 29},
  {4.86017302792074445961e-11f, "4860173", -10},
  {3.36599015327010420151e-07f, "33659902", -6},
  {1.03988700000000000000e+07f, "1039887", 8},
  {2.30988307230476849763e-14f, "2309883", -13},
  {1.20938966460056452221e-29f, "12093897", -28},
  {2.23233678298129234463e-06f, "22323368", -5},
  {9.03751372081680541866e-31f, "9037514", -30},
  {3.14212385929600971744e-30f, "31421239", -29},
  {1.22860307742720000000e+14f, "12286031", 15},
  {1.93553989684428800000e+16f, "193554", 17},
  {1.71215181735380502538e+27f, "17121518", 28},
  {1.17395538652249578275e+23f, "11739554", 24},
  {5.30064328023363725963e+27f, "5300643", 28},
  {4.93978746880000000000e+10f, "49397875", 11},
  {1.53579629978717767432e-31f, "15357963", -30},
  {5.34753332061798400000e+15f, "53475333", 16},
  {7.72628284060000027299e-34f, "7726283", -33},
  {8.65382951603100772872e+30f, "86538295", 31},
  {5.77641870613373386634e-22f, "57764187", -21},
  {7.42508704031178358407e+25f, "7425087", 26},
  {1.40412231442711993982e+38f, "14041223", 39},
  {1.66935118506295054885e-10f, "16693512", -9},
  {1.18983218271750956774e-04f, "11898322", -3},
  {3.81287399424000000000e+12f, "3812874", 13},
  {1.57364585297859368394e-35f, "15736459", -34},
  {3.55769478076578330577e-35f, "35576948", -34},
  {8.95997654974196613120e+19f, "89599765", 20},
  {1.56002359277387377019e-25f, "15600236", -24},
  {9.93510663097475396338e-32f, "9935107", -31},
  {2.19847731200000000000e+09f, "21984773", 10},
  {1.20699389648437500000e+03f, "12069939", 4},
  {5.67735242843627929688e+00f, "56773524", 1},
  {3.34415934425208690340e-23f, "33441593", -22},
  {4.46683628100251691765e+27f, "44668363", 28},
  {1.14735124480000000000e+10f, "11473512", 11},
  {1.23160350720000000000e+10f, "12316035", 11},
  {6.47926130407997181892e+35f, "64792613", 36},
  {6.12086138506156441600e+18f, "61208614", 19},
  {2.09561287458281605978e-15f, "20956129", -14},
  {1.80183084564480000000e+13f, "18018308", 14},
  {1.43471660000000000000e+07f, "14347166", 8},
  {1.40391391139369284269e-15f, "14039139", -14},
  {3.08191264048218727112e-03f, "30819126", -2},
  {1.08689695480279624462e-04f, "108689695", -3},
  {1.05749839433515896018e+34f, "10574984", 35},
  {7.44110000000000000000e+04f, "74411", 5},
  {7.94934662338377221441e-28f, "79493466", -27},
  {1.20048861088121710765e-38f, "12004886", -37},
  {8.99457430932670831680e-04f, "89945743", -3},
  {7.75373307226878694109e-11f, "7753733", -10},
  {1.50146867559589273768e+26f, "15014687", 27},
  {1.82205403689295053482e-04f, "1822054", -3},
  {2.03610902998129049600e+18f, "2036109", 19},
  {2.62293496304909974659e-17f, "2622935", -16},
  {9.67554478297420400091e-31f, "9675545", -30},
  {5.06887906769906538906e+21f, "5068879", 22},
  {1.55504542619436247897e-13f, "15550454", -12},
  {1.42692324297171988929e+28f, "14269232", 29},
  {1.31438976917547250500e+35f, "13143898", 36},
  {2.62331400335824582726e-06f, "2623314", -5},
  {4.57678139209747314453e-02f, "45767814", -1},
  {2.20105528831481933594e-01f, "22010553", 0},
  {2.32966698053076428553e+33f, "2329667", 34},
  {2.43188447051776000000e+14f, "24318845", 15},
  {1.42334559936896365429e-12f, "14233456", -11},
  {3.70410390625000000000e+04f, "3704104", 5},
  {4.12730483131755997162e-15f, "4127305", -14},
  {1.34538319358459184175e-15f, "13453832", -14},
  {3.23663994640076974063e-16f, "323664", -15},
  {1.44037977600000000000e+09f, "14403798", 10},
  {4.09133470633300902395e+36f, "40913347", 37},
  {7.40288067934793678475e+29f, "7402881", 30},
  {3.11882570849617915138e+32f, "31188257", 33},
  {1.70429739227984100580e-05f, "17042974", -4},
  {1.10773078264379126745e-13f, "11077308", -12},
  {4.80434292808949492302e+27f, "4804343", 28},
  {2.13076326748512928695e+38f, "21307633", 39},
  {1.49758085608482360840e-02f, "14975809", -1},
  {9.71397455868943073831e+27f, "97139746", 28},
  {2.67196999629959464073e-04f, "267197", -3},
  {1.93271020219064883702e+26f, "19327102", 27},
  {2.14182677341798400000e+15f, "21418268", 16},
  {8.04737852771333688368e+30f, "80473785", 31},
  {5.32166875000000000000e+05f, "5321669", 6},
  {9.52975797158284955896e+36f, "9529758", 37},
  {9.56366443593340670985e-39f, "9563664", -38},
  {3.95959307009086103335e-12f, "3959593", -11},
  {2.06089489989899361105e-15f, "2060895", -14},
  {2.48461692880071768041e+28f, "2484617", 29},
  {7.41870524600008341559e-16f, "7418705", -15},
  {8.85185887757926400000e+17f, "8851859", 18},
  {1.56340413705324809968e-12f, "15634041", -11},
  {2.70381575000528173138e+22f, "27038158", 23},
  {2.92527931392000000000e+12f, "29252793", 13},
  {5.44277910533669043773e-37f, "5442779", -36},
  {5.03955440394134473220e-29f, "50395544", -28},
  {1.54654009523368196226e-22f, "15465401", -21},
  {3.65769643306118608095e-13f, "36576964", -12},
  {1.15290831672609783709e-05f, "11529083", -4},
  {7.67327594757080078125e+00f, "7673276", 1},
  {8.10052353441788152612e+34f, "81005235", 35},
  {6.25925693498174950946e-08f, "6259257", -7},
  {8.09347344699062887230e-09f, "80934734", -8},
  {3.70838278508776471520e+28f, "37083828", 29},
  {1.80593384673943552096e+26f, "18059338", 27},
  {1.49163286477144064000e+17f, "14916329", 18},
  {2.61239564713066496000e+17f, "26123956", 18},
  {5.49106675035701989469e+25f, "54910668", 26},
  {3.22920014336994877292e-24f, "32292001", -23},
  {3.72126025000000000000e+06f, "37212602", 7},
  {2.10088407311014287800e-17f, "2100884", -16},
  {9.03469091307654444440e-37f, "9034691", -36},
  {1.16348561440136451998e-17f, "11634856", -16},
  {2.27663285094520954512e-25f, "22766329", -24},
  {8.16006400000000000000e+07f, "8160064", 8},
  {1.59280981099718958058e-19f, "15928098", -18},
  {3.95909073769729536709e-25f, "39590907", -24},
  {5.41805354621109814529e+34f, "54180535", 35},
  {5.33885273437500000000e+04f, "53388527", 5},
  {1.40702397703137958238e-35f, "1407024", -34},
  {5.35295780870398960335e-20f, "53529578", -19},
  {6.46616812476705357052e-17f, "6466168", -16},
  {3.51647067020621761912e-09f, "35164707", -8},
  {2.11593646669301024426e-36f, "21159365", -35},
  {3.10521017081422217769e+34f, "31052102", 35},
  {3.18248225994466338307e-07f, "31824823", -6},
  {1.81288802556181147309e-26f, "1812888", -25},
  {6.31943451886128499601e-27f, "63194345", -26},
  {1.79256393338181386240e+19f, "17925639", 20},
  {3.21081380000000000000e+07f, "32108138", 8},
  {8.24233164800000000000e+12f, "82423316", 13},
  {2.13204001934540800000e+15f, "213204", 16},
  {3.34144220172946943836e+38f, "33414422", 39},
  {9.43887123618941930983e-35f, "9438871", -34},
  {1.15729156250000000000e+05f, "11572916", 6},
  {8.75053863639702678264e+25f, "8750539", 26},
  {2.35575851494616648909e+21f, "23557585", 22},
  {4.38149629535458250314e-17f, "43814963", -16},
  {6.81867948851200000000e+12f, "68186795", 13},
  {1.29422729120282680222e+36f, "12942273", 37},
  {2.67996304908607585476e+28f, "2679963", 29},
  {2.21032906556763791288e+34f, "2210329", 35},
  {1.95365158775135387834e+38f, "19536516", 39},
  {4.15930956730661687599e-28f, "41593096", -27},
  {7.35311024970432333529e-30f, "735311", -29},
  {2.28874360000000000000e+07f, "22887436", 8},
  {1.11676969893892419350e-08f, "11167697", -7},
  {4.79458976386797249003e-16f, "479459", -15},
  {1.70859167480468750000e+03f, "17085917", 4},
  {9.37264804994808829193e+34f, "9372648", 35},
  {1.13555454102354236312e-12f, "11355545", -11},
  {1.55218463928166708675e+22f, "15521846", 23},
  {8.76193164110068625029e-21f, "8761932", -20},
  {6.55116721778065408000e+17f, "6551167", 18},
  {5.07613698779374238774e+24f, "5076137", 25},
  {3.69778105588090096968e-25f, "3697781", -24},
  {2.97121855131244312772e-28f, "29712186", -27},
  {1.54442968581218105467e+37f, "15444297", 38},
  {3.96518646909871375072e-13f, "39651865", -12},
  {8.96722011182834530882e+29f, "896722", 30},
  {7.16266000000000000000e+05f, "716266", 6},
  {2.74393425000000000000e+06f, "27439342", 7},
  {3.48675687500000000000e+05f, "3486757", 6},
  {7.59959221502457527449e-35f, "7599592", -34},
  {4.33904986826147224283e-28f, "433905", -27},
  {4.35433662460127379745e-08f, "43543366", -7},
  {3.04413059091534553798e+25f, "30441306", 26},
  {3.15265106110018678010e-06f, "3152651", -5},
  {3.89600658931006045138e-34f, "38960066", -33},
  {5.74661158928322511503e+22f, "57466116", 23},
  {1.11680976458124279344e-16f, "11168098", -15},
  {1.26447442109952403978e-38f, "12644744", -37},
  {1.57667420074539168563e+22f, "15766742", 23},
  {7.90197736932896077633e-06f, "7901977", -5},
  {1.56616367289999280641e-29f, "15661637", -28},
  {4.81291784204529449198e-10f, "4812918", -9},
  {1.48420392970713621772e+25f, "14842039", 26},
  {1.25931592265260405838e-06f, "12593159", -5},
  {1.38091795511802222233e+32f, "1380918", 33},
  {1.96311429249619512525e+21f, "19631143", 22},
  {2.31550006382091567104e+20f, "23155", 21},
  {3.02991447529881600000e+15f, "30299145", 16},
  {2.29909693795246985002e-38f, "2299097", -37},
  {2.13186278939247131348e-01f, "21318628", 0},
  {2.23243656158447265625e+01f, "22324366", 2},
  {1.44259683991058497241e-24f, "14425968", -23},
  {1.01083463680000000000e+10f, "10108346", 11},
  {4.61911886930465698242e-01f, "4619119", 0},
  {9.52256088256835937500e+01f, "9522561", 2},
  {1.27323551177978515625e+01f, "12732355", 2},
  {4.67545117940139506037e-34f, "4675451", -33},
  {7.07773971557617187500e+01f, "707774", 2},
  {4.68374871851736111392e-32f, "46837487", -31},
  {2.65241518080000000000e+10f, "26524152", 11},
  {8.83042812500000000000e+05f, "8830428", 6},
  {3.34451113835049202406e-21f, "33445111", -20},
  {1.51212848269401717569e-36f, "15121285", -35},
  {3.74927857649254292483e-08f, "37492786", -7},
  {1.78906831257600000000e+12f, "17890683", 13},
  {1.00229007775546181505e-31f, "10022901", -30},
  {2.94338104626640330185e-24f, "2943381", -23},
  {3.39177645392425343016e+34f, "33917765", 35},
  {2.15386394138456134783e-31f, "2153864", -30},
  {7.70172467641532815532e+36f, "77017247", 37},
  {3.88549858953979310172e-10f, "38854986", -9},
  {5.64539610418797942109e-22f, "5645396", -21},
  {5.39184712503026908337e-12f, "5391847", -11},
  {7.96369677747358006282e-24f, "7963697", -23},
  {1.13625587712000000000e+11f, "11362559", 12},
  {1.02714066889218235678e-18f, "10271407", -17},
  {2.48068811884110119539e+36f, "24806881", 37},
  {3.64337537916981091257e-08f, "36433754", -7},
  {5.08351579912111755037e+35f, "50835158", 36},
  {9.68803936082854673849e+36f, "96880394", 37},
  {1.22201780622028207544e+30f, "12220178", 31},
  {1.50393573567271232605e-02f, "15039357", -1},
  {2.02415021450944716786e-26f, "20241502", -25},
  {1.76763305664062500000e+01f, "1767633", 2},
  {1.17815145718194086371e+36f, "117815146", 37},
  {2.96677583880192000000e+14f, "2966776", 15},
  {3.19041401381905033922e-37f, "3190414", -36},
  {7.47238975722568035918e-37f, "74723898", -36},
  {3.07024916747507465390e-23f, "30702492", -22},
  {2.51846881093052351405e-30f, "25184688", -29},
  {3.36540886630400000000e+12f, "33654089", 13},
  {4.35444181508686872576e+21f, "43544418", 22},
  {1.42837987531646559702e-12f, "14283799", -11},
  {8.64349149200384000000e+14f, "86434915", 15},
  {2.27935220239692610176e-25f, "22793522", -24},
  {1.46566711274015933071e+22f, "14656671", 23},
  {1.09511413826091086321e-10f, "109511414", -9},
  {1.90115886389828311636e+34f, "19011589", 35},
  {5.20996215590549496916e+29f, "5209962", 30},
  {1.20955990449284067623e-12f, "12095599", -11},
  {1.06550027793319256053e-14f, "10655003", -13},
  {3.89885756351356774743e-31f, "38988576", -30},
  {1.02007929464422400000e+15f, "10200793", 16},
  {1.36239852905273437500e+01f, "13623985", 2},
  {7.51901136605780377600e+18f, "75190114", 19},
  {1.65840914661434768452e+35f, "16584091", 36},
  {4.90393936634063720703e-02f, "49039394", -1},
  {3.74198173358729112622e-28f, "37419817", -27},
  {1.23804013834324436619e+32f, "12380401", 33},
  {6.79383927490562200546e-04f, "6793839", -3},
  {6.69916582024548664980e-37f, "6699166", -36},
  {2.70277267233609563846e-09f, "27027727", -8},
  {2.10183744000000000000e+09f, "21018374", 10},
  {1.93097155761718750000e+03f, "19309716", 4},
  {4.45188720957223615926e-12f, "4451887", -11},
  {8.98391731219880772252e-16f, "8983917", -15},
  {1.03679882812500000000e+05f, "10367988", 6},
  {5.63556035171330904632e-10f, "56355604", -9},
  {4.68562650680541992188e+00f, "46856265", 1},
  {4.14577045012480000000e+13f, "41457705", 14},
  {2.61902117978767494789e-36f, "26190212", -35},
  {2.81881315189900431666e-17f, "2818813", -16},
  {8.22290795072097190062e-38f, "8222908", -37},
  {3.67790797019414528000e+17f, "3677908", 18},
  {1.09161285217851400375e-03f, "10916129", -2},
  {4.57617022846053228006e-38f, "45761702", -37},
  {7.31146430969238281250e+00f, "73114643", 1},
  {1.93351081394187792370e+25f, "19335108", 26},
  {1.47647068360382563081e+35f, "14764707", 36},
  {5.48303225045287945250e-09f, "54830323", -8},
  {3.43571665604533965738e-26f, "34357167", -25},
  {2.21488672551766056692e-18f, "22148867", -17},
  {3.62198978662490844727e-01f, "36219898", 0},
  {5.65071821056686764638e+27f, "5650718", 28},
  {4.67465506694230546842e+21f, "4674655", 22},
  {3.65654503154533979308e-21f, "3656545", -20},
  {1.37502116794543843259e+24f, "13750212", 25},
  {3.35897548188229709048e-19f, "33589755", -18},
  {2.24933169312713232557e-10f, "22493317", -9},
  {2.39720232371879936000e+17f, "23972023", 18},
  {3.49557230623784960000e+16f, "34955723", 17},
  {2.55272549765095391194e-08f, "25527255", -7},
  {8.79132852833087275912e-31f, "87913285", -30},
  {1.07884323219745170697e-13f, "10788432", -12},
  {8.30154543734520657376e+33f, "83015454", 34},
  {6.53397815767675638199e-04f, "6533978", -3},
  {1.64017960960000000000e+10f, "16401796", 11},
  {1.18084907531738281250e+00f, "11808491", 1},
  {5.99002858028937297170e+25f, "59900286", 26},
  {1.09135636971246385946e-28f, "10913564", -27},
  {7.02662998553885151308e-26f, "702663", -25},
  {2.55317553704404675917e+28f, "25531755", 29},
  {5.22809727954154368490e-07f, "5228097", -6},
  {9.16488837532069405506e-25f, "9164888", -24},
  {1.31286320000000000000e+07f, "13128632", 8},
  {9.62006687746186776274e+28f, "9620067", 29},
  {6.97779498420736914966e-24f, "6977795", -23},
  {1.37352612252339565312e-31f, "13735261", -30},
  {2.73239350077030400000e+15f, "27323935", 16},
  {1.47962861317754296584e-27f, "14796286", -26},
  {1.16547577083110809326e-01f, "11654758", 0},
  {1.52767257070050233511e+28f, "15276726", 29},
  {5.28567682067659916356e-07f, "5285677", -6},
  {6.98406837445752041603e+36f, "69840684", 37},
  {1.21323987069304832000e+17f, "12132399", 18},
  {3.60081713303191562472e-24f, "3600817", -23},
  {3.68665498139518644970e-23f, "3686655", -22},
  {2.33100723266601562500e+02f, "23310072", 3},
  {1.99869915377348661423e-04f, "19986992", -3},
  {1.38930050000000000000e+06f, "13893005", 7},
  {8.04745083271631403233e-20f, "8047451", -19},
  {1.01960788149040871629e-26f, "10196079", -25},
  {5.51919542619518285601e+36f, "55191954", 37},
  {1.16337182942682915154e-11f, "11633718", -10},
  {1.84460982680320739746e-01f, "18446098", 0},
  {6.63991239234696265863e+31f, "66399124", 32},
  {1.17089591115163791000e+24f, "11708959", 25},
  {4.37063093647032494479e-30f, "4370631", -29},
  {1.08344188731734902831e-07f, "10834419", -6},
  {1.02080790528000000000e+11f, "10208079", 12},
  {7.94685080682823405485e-20f, "7946851", -19},
  {1.23402900000000000000e+06f, "1234029", 7},
  {3.54899048805236816406e+00f, "35489905", 1},
  {6.87127396352000000000e+12f, "6871274", 13},
  {1.89607261772762316800e+20f, "18960726", 21},
  {6.60449267570235674006e-32f, "66044927", -31},
  {9.09603820800781250000e+02f, "9096038", 3},
  {2.22526614911685845410e+35f, "22252661", 36},
  {1.43306661131460992879e-24f, "14330666", -23},
  {3.37118508777623459105e-21f, "3371185", -20},
  {4.61868140339214241015e-31f, "46186814", -30},
  {2.80988127068160000000e+13f, "28098813", 14},
  {7.55606240565910341149e-32f, "75560624", -31},
  {4.09427719116210937500e+01f, "40942772", 2},
  {2.62616956928000000000e+11f, "26261696", 12},
  {1.47036820872198890507e+24f, "14703682", 25},
  {2.46390484086292480000e+16f, "24639048", 17},
  {1.61373991346009046427e+27f, "16137399", 28},
  {4.71736527878768852062e-13f, "47173653", -12},
  {6.49515328549926537567e-27f, "6495153", -26},
  {3.10613427245698403567e-06f, "31061343", -5},
  {6.38311100000000000000e+06f, "6383111", 7},
  {1.12467764187005117571e-14f, "11246776", -13},
  {2.48335929597942595137e-08f, "24833593", -7},
  {1.16388275231521097071e+34f, "11638828", 35},
  {3.19921342038389469217e+23f, "31992134", 24},
  {2.31533745626531783923e-15f, "23153375", -14},
  {1.95141323697684480000e+19f, "19514132", 20},
  {2.34243865317356664315e+32f, "23424387", 33},
  {4.03930722022195200000e+16f, "40393072", 17},
  {2.87468404636115337780e-09f, "2874684", -8},
  {2.46806720592938976934e-26f, "24680672", -25},
  {7.20531885304320795539e-17f, "7205319", -16},
  {1.67054734362673999278e+30f, "16705473", 31},
  {2.84710991025178975058e+25f, "284711", 26},
  {1.90525464605548414976e-35f, "19052546", -34},
  {1.76242844688884982460e+37f, "17624284", 38},
  {3.63358787502932045754e-11f, "3633588", -10},
  {3.59268087095927268527e-26f, "3592681", -25},
  {2.07783780000000000000e+07f, "20778378", 8},
  {4.31144808729060507117e-31f, "4311448", -30},
  {1.53743152550479319404e+26f, "15374315", 27},
  {2.49251632250880000000e+14f, "24925163", 15},
  {2.94751513600000000000e+09f, "29475151", 10},
  {5.93085475265979766846e-02f, "59308548", -1},
  {4.96824890375137329102e-01f, "4968249", 0},
  {9.89237852874400025449e-14f, "98923785", -13},
  {1.36588169160484218523e-13f, "13658817", -12},
  {3.96395811506959493429e+25f, "3963958", 26},
  {1.09085120260715484619e-01f, "10908512", 0},
  {6.75132860920506613760e+19f, "67513286", 20},
  {3.68717053333966759965e-07f, "36871705", -6},
  {2.00712663183359783993e+23f, "20071266", 24},
  {2.41773502979997152305e-27f, "2417735", -26},
  {6.06556515084233360824e-12f, "6065565", -11},
  {9.30622720000000000000e+07f, "9306227", 8},
  {8.78869439475238323212e-04f, "87886944", -3},
  {1.70113228386733930358e-31f, "17011323", -30},
  {2.92860031127929687500e+01f, "29286003", 2},
  {4.96581776860804892352e-26f, "49658178", -25},
  {7.92804583907127380371e-02f, "7928046", -1},
  {1.22438083936256000000e+14f, "12243808", 15},
  {5.95240504480898380280e-04f, "5952405", -3},
  {1.84671583580708897898e-10f, "18467158", -9},
  {4.84748458862304687500e+00f, "48474846", 1},
  {1.80187618732452392578e+00f, "18018762", 1},
  {4.52454219923570377659e-12f, "4524542", -11},
  {2.89254604315223237763e+28f, "2892546", 29},
  {1.72398328781127929688e+00f, "17239833", 1},
  {2.61367645263671875000e+01f, "26136765", 2},
  {8.29516793601214885712e-04f, "8295168", -3},
  {1.21941192000000000000e+08f, "12194119", 9},
  {5.89582289239887202825e-12f, "5895823", -11},
  {2.96841873065579018360e-28f, "29684187", -27},
  {5.03819030168891715337e-22f, "50381903", -21},
  {5.87443159738287022376e+25f, "58744316", 26},
  {2.50343219200000000000e+10f, "25034322", 11},
  {7.90484863281250000000e+03f, "79048486", 4},
  {1.11148983912844386241e-26f, "111148984", -25},
  {1.44711765460669994354e-03f, "14471177", -2},
  {1.26032299592624776702e-36f, "1260323", -35},
  {1.25742705307097797466e+32f, "12574271", 33},
  {8.14750739315466805255e+28f, "8147507", 29},
  {3.88195403662712280806e+25f, "3881954", 26},
  {4.03060207001165474091e-34f, "4030602", -33},
  {7.18135650183181651447e-22f, "71813565", -21},
  {5.30318266100948676467e-06f, "53031827", -5},
  {5.90825195312500000000e+01f, "5908252", 2},
  {2.01908243135885331898e-14f, "20190824", -13},
  {2.53503058676387101887e+34f, "25350306", 35},
  {4.97475056041984000000e+14f, "49747506", 15},
  {2.55278330311776241975e+23f, "25527833", 24},
  {4.21019033600000000000e+09f, "42101903", 10},
  {4.01158159240488004669e-28f, "40115816", -27},
  {6.59473418660858738485e-26f, "6594734", -25},
  {2.95953802694097759067e-29f, "2959538", -28},
  {1.22892091392000000000e+11f, "12289209", 12},
  {4.86177215576171875000e+01f, "4861772", 2},
  {1.38899549052062048750e+38f, "13889955", 39},
  {3.05406266861150312634e-28f, "30540627", -27},
  {1.73461826748950111051e-36f, "17346183", -35},
  {1.62549651577137410641e-04f, "16254965", -3},
  {6.13060910539761254400e+18f, "6130609", 19},
  {1.65168478893917836103e-09f, "16516848", -8},
  {7.55602450000000000000e+06f, "75560245", 7},
  {5.04765356749984836928e+35f, "50476536", 36},
  {1.36794552038850027965e-22f, "13679455", -21},
  {2.66537116725356650621e-22f, "26653712", -21},
  {5.79547071456909179688e+00f, "57954707", 1},
  {2.35609559640082011356e-10f, "23560956", -9},
  {6.12396150292480000000e+13f, "61239615", 14},
  {1.15110327148437500000e+03f, "11511033", 4},
  {4.33495977583683920857e-17f, "43349598", -16},
  {7.24539208984375000000e+03f, "7245392", 4},
  {6.56341370142143887279e-11f, "6563414", -10},
  {2.92536784726737941753e-12f, "29253678", -11},
  {8.64514432538505117696e+20f, "8645144", 21},
  {5.73402402832472457871e+22f, "5734024", 23},
  {2.88106644246902455708e+28f, "28810664", 29},
  {2.32387004697110484313e-32f, "232387", -31},
  {2.00418842072055808000e+18f, "20041884", 19},
  {2.00204824218750000000e+04f, "20020482", 5},
  {9.98045181997149364501e+29f, "9980452", 30},
  {1.23609716212724762840e-11f, "12360972", -10},
  {1.36052886994944000000e+15f, "13605289", 16},
  {8.90860447179541324261e-35f, "89086045", -34},
  {5.84772750735282897949e-02f, "58477275", -1},
  {2.26999381748235751211e-13f, "22699938", -12},
  {7.18037937500000000000e+05f, "71803794", 6},
  {1.17502287030220031738e-02f, "11750229", -1},
  {1.17891114205121994019e-02f, "11789111", -1},
  {2.04333104000000000000e+08f, "2043331", 9},
  {2.97848973079269022997e+32f, "29784897", 33},
  {9.73225145618107550688e-23f, "97322515", -22},
  {5.51207845543032150769e+37f, "55120785", 38},
  {3.27426528930664062500e+00f, "32742653", 1},
  {7.01730047273944864065e-26f, "70173005", -25},
  {1.05076517122319390995e-23f, "10507652", -22},
  {1.36608134998261760000e+17f, "136608135", 18},
  {6.35504039034880000000e+13f, "63550404", 14},
  {4.19379750000000000000e+05f, "41937975", 6},
  {1.21917818063366212300e-08f, "12191782", -7},
  {1.02191105322457927440e-22f, "102191105", -21},
  {2.87608322426755739984e+27f, "28760832", 28},
  {1.45929275527189305133e+34f, "14592928", 35},
  {1.10931100000000000000e+06f, "1109311", 7},
  {1.17120750759925172718e-23f, "11712075", -22},
  {1.68415911173160960000e+16f, "16841591", 17},
  {9.17180983939225313861e-11f, "917181", -10},
  {4.71639282112106991235e-34f, "4716393", -33},
  {6.63072989545094845563e+22f, "663073", 23},
  {2.59152893515898888641e-31f, "2591529", -30},
  {1.55305907200000000000e+09f, "15530591", 10},
  {9.35747544678400000000e+13f, "93574754", 14},
  {4.94599749799817800522e-04f, "49459975", -3},
  {2.93949994147101392739e-15f, "29395", -14},
  {1.36047274116933222400e+18f, "13604727", 19},
  {4.89169685386044355538e+33f, "4891697", 34},
  {1.13490149376000000000e+11f, "11349015", 12},
  {1.37629523747816390547e-15f, "13762952", -14},
  {8.27456929641812166665e-08f, "8274569", -7},
  {1.83095451473910218000e-30f, "18309545", -29},
  {4.34843121975300503441e+31f, "4348431", 32},
  {3.47847191860001930808e-14f, "3478472", -13},
  {2.84057310008870023132e-14f, "28405731", -13},
  {3.46792309498925073228e+30f, "3467923", 31},
  {1.79985954144183379485e+25f, "17998595", 26},
  {3.39054763317108154297e-01f, "33905476", 0},
  {4.82123659490464979985e-32f, "48212366", -31},
  {3.59798754882812500000e+03f, "35979875", 4},
  {3.00481155547846832328e-26f, "30048116", -25},
  {3.42065283072000000000e+12f, "34206528", 13},
  {7.23382029655150715858e+33f, "723382", 34},
  {5.08858621905972086097e-10f, "5088586", -9},
  {1.37373886108398437500e+01f, "13737389", 2},
  {1.42486377172487560832e+29f, "14248638", 30},
  {9.55953342039079786805e+34f, "9559533", 35},
  {2.67883531227627520000e+16f, "26788353", 17},
  {3.49851750000000000000e+06f, "34985175", 7},
  {1.22667523179604588679e-14f, "12266752", -13},
  {2.02058022374144265421e+21f, "20205802", 22},
  {3.31402461029028927442e-10f, "33140246", -9},
  {4.96126745019864756614e-07f, "49612675", -6},
  {4.31350244411987659987e-09f, "43135024", -8},
  {4.22053096262458308016e-35f, "4220531", -34},
  {4.17292150377100342791e+28f, "41729215", 29},
  {2.04090564516249600000e+15f, "20409056", 16},
  {9.12909987470488947917e+21f, "91291", 22},
  {2.92802844824583989625e+23f, "29280284", 24},
  {3.32917666958504332442e-13f, "33291767", -12},
  {1.82760924589575808131e-32f, "18276092", -31},
  {3.50949323038937579525e-23f, "35094932", -22},
  {9.91633714875206351280e-05f, "9916337", -4},
  {1.32259574925656979493e+38f, "13225957", 39},
  {1.98365127563476562500e+02f, "19836513", 3},
  {4.79192816792033558528e+20f, "4791928", 21},
  {6.09283048165845565701e+29f, "60928305", 30},
  {5.13223795059469800606e-12f, "5132238", -11},
  {2.14648987485203564811e-19f, "21464899", -18},
  {4.99333624461515651045e+36f, "49933362", 37},
  {2.96013828520797294368e+30f, "29601383", 31},
  {1.08930362330283969641e-06f, "10893036", -5},
  {2.46327910400000000000e+10f, "24632791", 11},
  {3.01893326084786197595e+25f, "30189333", 26},
  {9.33126927672731815117e+22f, "9331269", 23},
  {4.64881451458677087020e-28f, "46488145", -27},
  {6.12121530754662400000e+15f, "61212153", 16},
  {1.27805527369659187200e+19f, "12780553", 20},
  {2.02779907271343721208e+27f, "2027799", 28},
  {2.85162475982102275483e-17f, "28516248", -16},
  {2.14175392144057336921e-34f, "2141754", -33},
  {5.79623475200000000000e+09f, "5796235", 10},
  {1.59513719603200000000e+12f, "15951372", 13},
  {1.80080551654100418091e-02f, "18008055", -1},
  {3.54396985600317191613e-38f, "35439699", -37},
  {1.08438475295948800000e+16f, "10843848", 17},
  {1.09676785882417693330e-12f, "10967679", -11},
  {1.18906416550379520000e+16f, "11890642", 17},
  {1.42133876681327819824e-01f, "14213388", 0},
  {4.61862315529607046415e-28f, "4618623", -27},
  {5.36947402133852373996e-36f, "5369474", -35},
  {4.24621843750000000000e+05f, "42462184", 6},
  {2.67275914941911274525e-12f, "26727591", -11},
  {8.80629122257232666016e-02f, "8806291", -1},
  {7.69725390625000000000e+04f, "7697254", 5},
  {8.07408215013241766091e+28f, "8074082", 29},
  {5.59760035227566888051e-20f, "55976004", -19},
  {6.69595974613912403584e-05f, "669596", -4},
  {6.05557095828924836581e-22f, "6055571", -21},
  {2.02472496032714843750e+00f, "2024725", 1},
  {4.70960230813943780959e-07f, "47096023", -6},
  {2.52025292923642754914e-30f, "2520253", -29},
  {3.74682669415358727628e+32f, "37468267", 33},
  {1.69622371195436069415e-35f, "16962237", -34},
  {1.20269378186885871333e+34f, "12026938", 35},
  {5.00642948757585920000e+16f, "50064295", 17},
  {1.29053265916133554750e-24f, "12905327", -23},
  {1.04270454784000000000e+11f, "104270455", 12},
  {8.66813294123858213425e-04f, "8668133", -3},
  {3.60570623466421836431e-36f, "36057062", -35},
  {5.01297087609651128065e+32f, "5012971", 33},
  {3.01967353820800781250e+01f, "30196735", 2},
  {3.40352172032000000000e+12f, "34035217", 13},
  {1.04622187500000000000e+06f, "10462219", 7},
  {8.84573789094667772707e+37f, "8845738", 38},
  {1.85629346365440000000e+13f, "18562935", 14},
  {1.66452793657882210229e-17f, "1664528", -16},
  {1.41622024979644323128e-13f, "14162202", -12},
  {3.20213633386856599827e-10f, "32021363", -9},
  {3.94462163771429224448e+20f, "39446216", 21},
  {1.08534088358283042908e-02f, "10853409", -1},
  {2.76475191185454605147e-07f, "2764752", -6},
  {2.22404831096839616933e-13f, "22240483", -12},
  {4.49382198832030148251e+24f, "4493822", 25},
  {3.97694342695817467189e+30f, "39769434", 31},
  {2.86692194426640263556e+30f, "2866922", 31},
  {5.28523777277952000000e+14f, "52852378", 15},
  {3.23360291359338526906e-28f, "3233603", -27},
  {2.79184742815394293380e-13f, "27918474", -12},
  {5.30395168046657255855e+31f, "53039517", 32},
  {1.10883348480000000000e+11f, "11088335", 12},
  {2.21954520027978792960e+19f, "22195452", 20},
  {1.79138296251338796830e-37f, "1791383", -36},
  {5.79385820312500000000e+04f, "57938582", 5},
  {6.09142023719362966323e+22f, "60914202", 23},
  {3.53267958147734055569e+35f, "35326796", 36},
  {4.01660831559365955263e-18f, "40166083", -17},
  {1.24686239803508666754e+37f, "12468624", 38},
  {5.30298240000000000000e+07f, "53029824", 8},
  {5.57132677916917760000e+17f, "55713268", 18},
  {6.44521287160710874547e-38f, "6445213", -37},
  {3.60048942565917968750e+01f, "36004894", 2},
  {2.46688280779970822655e-20f, "24668828", -19},
  {3.37503940771840000000e+13f, "33750394", 14},
  {5.52529423435225561360e-32f, "5525294", -31},
  {3.15104680049915842318e-21f, "31510468", -20},
  {8.97520501929455205570e-13f, "8975205", -12},
  {1.53677723324641135605e-10f, "15367772", -9},
  {7.24677578125000000000e+04f, "7246776", 5},
  {4.86019658856529920000e+16f, "48601966", 17},
  {8.36354819132087138357e-29f, "8363548", -28},
  {1.12471793102468317965e-36f, "11247179", -35},
  {1.90411653081789682823e-29f, "19041165", -28},
  {3.15012689679861068726e-03f, "3150127", -2},
  {8.37842630325613928005e+26f, "8378426", 27},
  {1.01301670858463076421e-37f, "10130167", -36},
  {1.26868428956816714503e-11f, "12686843", -10},
  {6.30426391601562500000e+02f, "6304264", 3},
  {5.42328930090219333996e-27f, "54232893", -26},
  {5.54937457049600000000e+14f, "55493746", 15},
  {4.69612605229485780001e-05f, "4696126", -4},
  {9.76201426164731829289e+22f, "9762014", 23},
  {1.79252892849035561085e-05f, "1792529", -4},
  {1.40991376247256994247e-03f, "14099138", -2},
  {7.71351212069948388717e-12f, "7713512", -11},
  {1.51376414893387382476e-21f, "15137641", -20},
  {7.18511955710710026324e-07f, "71851196", -6},
  {5.23060736000000000000e+09f, "52306074", 10},
  {2.59361641086909948123e-23f, "25936164", -22},
  {5.11218118430911092283e-38f, "5112181", -37},
  {4.18654217196334776929e-12f, "4186542", -11},
  {2.81728734980838741709e-22f, "28172873", -21},
  {3.10372772216796875000e+02f, "31037277", 3},
  {1.65341660000000000000e+07f, "16534166", 8},
  {1.58318673712392804473e+30f, "15831867", 31},
  {2.86271692800000000000e+09f, "2862717", 10},
  {8.85453976539449478506e+24f, "885454", 25},
  {2.07113544972668809204e-21f, "20711354", -20},
  {7.03167157009247095498e+37f, "70316716", 38},
  {9.01914265494241362831e-10f, "90191427", -9},
  {1.63199937947464752447e+34f, "16319994", 35},
  {8.26542853057524864273e-30f, "82654285", -29},
  {1.70690157119679497555e-07f, "17069016", -6},
  {4.16060485755038788995e-34f, "4160605", -33},
  {4.03193100000000000000e+06f, "4031931", 7},
  {1.93580025199230250597e-19f, "19358003", -18},
  {7.13289898610567133442e-33f, "7132899", -32},
  {8.65161754929456212017e+33f, "86516175", 34},
  {1.92060937550806772613e+22f, "19206094", 23},
  {6.21995190045303027539e-21f, "6219952", -20},
  {7.03418931200000000000e+09f, "70341893", 10},
  {1.31763490010518432710e-21f, "13176349", -20},
  {8.48460705306238310175e-37f, "8484607", -36},
  {1.74539961124548653188e-34f, "17453996", -33},
  {2.81382148374528000000e+14f, "28138215", 15},
  {1.10635045569296153189e-09f, "11063505", -8},
  {4.43995943581636037193e-17f, "44399594", -16},
  {2.97039499620867511046e-31f, "2970395", -30},
  {4.76992608556456754668e-39f, "4769926", -38},
  {1.94918140769004821777e-01f, "19491814", 0},
  {2.51395773380980790351e-30f, "25139577", -29},
  {5.66276279340138799512e-12f, "5662763", -11},
  {8.51077404976742400000e+15f, "8510774", 16},
  {1.24093882368000000000e+11f, "12409388", 12},
  {1.58634489358982627116e+34f, "15863449", 35},
  {1.91039760000000000000e+07f, "19103976", 8},
  {4.93901892334746709160e-19f, "4939019", -18},
  {2.00504371982068875264e+20f, "20050437", 21},
  {6.58268949382262910930e+24f, "65826895", 25},
  {4.85722103590014421169e-20f, "4857221", -19},
  {2.61627519961046567330e-28f, "26162752", -27},
  {1.42617424540406382592e+20f, "142617425", 21},
  {6.41278349866603036844e-11f, "64127835", -10},
  {7.07530566406250000000e+03f, "70753057", 4},
  {9.79695509708270060595e+24f, "9796955", 25},
  {4.25470236534875631686e+34f, "42547024", 35},
  {2.28612426846122987749e+23f, "22861243", 24},
  {1.18688649746014467754e+31f, "11868865", 32},
  {5.35748208462260735335e+29f, "5357482", 30},
  {6.41557550000000000000e+06f, "64155755", 7},
  {1.01596824945185599604e-28f, "10159682", -27},
  {5.31319236755371093750e+00f, "53131924", 1},
  {1.31190347136942006390e+24f, "13119035", 25},
  {1.46561404467682481573e-26f, "1465614", -25},
  {1.49530171875000000000e+05f, "14953017", 6},
  {5.42260825634002685547e-01f, "5422608", 0},
  {2.70724877929687500000e+03f, "27072488", 4},
  {1.07731029289707148456e+27f, "10773103", 28},
  {2.66873640000000000000e+07f, "26687364", 8},
  {3.53828710937500000000e+03f, "3538287", 4},
  {2.95547982788468832638e-13f, "29554798", -12},
  {1.06654324406353920000e+16f, "10665432", 17},
  {3.25595487748130011130e+30f, "3255955", 31},
  {3.57983839953743481636e-36f, "35798384", -35},
  {1.80980772902794573298e-12f, "18098077", -11},
  {7.00922548658848282339e+25f, "70092255", 26},
  {1.14099333120000000000e+10f, "11409933", 11},
  {1.51500256000000000000e+08f, "15150026", 9},
  {1.96379480000000000000e+07f, "19637948", 8},
  {1.03122518339660018682e-04f, "10312252", -3},
  {1.18889479537289315196e+27f, "11888948", 28},
  {8.45108551486537728000e+17f, "84510855", 18},
  {2.14720996425193468529e-23f, "214721", -22},
  {1.08258322896934113989e-22f, "10825832", -21},
  {8.28087037068263282598e-18f, "828087", -17},
  {3.07578421211321163128e-37f, "30757842", -36},
  {6.76448457338610949609e-27f, "67644846", -26},
  {2.62886252553850934807e-33f, "26288625", -32},
  {5.85992186765530843293e+32f, "5859922", 33},
  {5.22792646443410304354e-36f, "52279265", -35},
  {2.71760071065600000000e+12f, "27176007", 13},
  {8.72395256158609327586e-35f, "87239526", -34},
  {4.36459375000000000000e+03f, "43645938", 4},
  {5.16016781330108642578e-03f, "5160168", -2},
  {2.06025742387515036180e-22f, "20602574", -21},
  {9.51681354900300755847e-31f, "9516814", -30},
  {4.67065665583684837321e+35f, "46706567", 36},
  {9.35439512007637729280e+19f, "9354395", 20},
  {1.61741134549890388907e+35f, "16174113", 36},
  {1.63529970703125000000e+04f, "16352997", 5},
  {4.43075840807791252601e-16f, "44307584", -15},
  {6.92069725392004185364e-17f, "6920697", -16},
  {2.55940331474293382837e-19f, "25594033", -18},
  {2.11705950323916130884e-24f, "21170595", -23},
  {4.08228782537971984778e-14f, "40822878", -13},
  {7.85322080000000000000e+07f, "7853221", 8},
  {2.05293296669819500889e-37f, "2052933", -36},
  {7.32993804640375372488e+34f, "7329938", 35},
  {1.71919360082946316077e-23f, "17191936", -22},
  {6.77552192000000000000e+08f, "6775522", 9},
  {1.08344684335293095501e-08f, "10834468", -7},
  {2.93643912869399250847e-35f, "2936439", -34},
  {7.85834776157595671364e-13f, "7858348", -12},
  {3.61234840000000000000e+07f, "36123484", 8},
  {5.38727119921724986246e-19f, "5387271", -18},
  {1.03158035200000000000e+09f, "103158035", 10},
  {1.83817203200000000000e+09f, "1838172", 10},
  {6.14630437212326796725e-07f, "61463044", -6},
  {4.58156106842112000000e+14f, "4581561", 15},
  {1.55408276367187500000e+03f, "15540828", 4},
  {5.01098693348467350006e-04f, "5010987", -3},
  {1.69486093996168429854e-12f, "16948609", -11},
  {2.23062000000000000000e+07f, "223062", 8},
  {1.43199955750942534114e+24f, "14319996", 25},
  {7.70938794292238142669e+23f, "7709388", 24},
  {5.12059163031754108572e-31f, "51205916", -30},
  {9.38598013090052177920e+20f, "938598", 21},
  {1.01133070312500000000e+05f, "10113307", 6},
  {1.19899964606392535857e-34f, "11989996", -33},
  {2.25421437294532137074e-14f, "22542144", -13},
  {7.61879986005141381153e+27f, "76188", 28},
  {1.35681548461830114860e-12f, "13568155", -11},
  {9.26196062500000000000e+05f, "92619606", 6},
  {2.18868510291826495738e-35f, "21886851", -34},
  {8.48014501478400000000e+12f, "8480145", 13},
  {1.00130207144340359048e-25f, "10013021", -24},
  {7.35633915636187953573e-34f, "7356339", -33},
  {9.08804416000000000000e+08f, "9088044", 9},
  {2.87728812997656291373e-10f, "2877288", -9},
  {8.24619040768000000000e+13f, "824619", 14},
  {1.34824250186855084698e-38f, "13482425", -37},
  {1.38810639782604994252e-06f, "13881064", -5},
  {8.93339541914171211177e-38f, "89333954", -37},
  {8.21091520000000000000e+07f, "8210915", 8},
  {1.19468902580224000000e+14f, "1194689", 15},
  {1.56456314880000000000e+10f, "15645631", 11},
  {2.04924038179945096396e-22f, "20492404", -21},
  {9.79532859771847575580e-32f, "97953286", -31},
  {1.02963944404528724708e-14f, "102963944", -13},
  {5.36103661791021629440e+19f, "53610366", 20},
  {8.29832226562500000000e+03f, "8298322", 4},
  {2.88645552537600000000e+12f, "28864555", 13},
  {1.62132438551176871755e-12f, "16213244", -11},
  {4.52527587890625000000e+03f, "4525276", 4},
  {5.84816513583064079285e-03f, "5848165", -2},
  {1.70941439633029509505e-27f, "17094144", -26},
  {3.85661370368000000000e+11f, "38566137", 12},
  {7.36699897457440893666e-21f, "7366999", -20},
  {2.88454556264693760000e+16f, "28845456", 17},
  {7.42256409155993600000e+15f, "7422564", 16},
  {2.74176347656250000000e+04f, "27417635", 5},
  {2.98804531250000000000e+05f, "29880453", 6},
  {1.37219464764864768109e-35f, "13721946", -34},
  {3.63511753839245504624e-29f, "36351175", -28},
  {1.05126694400000000000e+09f, "105126694", 10},
  {1.92418357381693440000e+16f, "19241836", 17},
  {6.11430203579924665819e-16f, "6114302", -15},
  {1.31445444050944000000e+14f, "13144544", 15},
  {2.50241298358931316126e-14f, "2502413", -13},
  {2.83692341657600000000e+13f, "28369234", 14},
  {1.51311723567415512548e-11f, "15131172", -10},
  {5.42250570617283655928e-14f, "54225057", -13},
  {5.26633341661328108674e-32f, "52663334", -31},
  {2.25814214549480141159e-10f, "22581421", -9},
  {7.34318177653203658014e+32f, "7343182", 33},
  {1.04240014389517536461e+21f, "104240014", 22},
  {2.15448462497128705142e-28f, "21544846", -27},
  {1.73571406492008312017e+28f, "17357141", 29},
  {8.59905476360313392181e-15f, "8599055", -14},
  {1.92677947332551555001e+30f, "19267795", 31},
  {2.10476173378992825747e-07f, "21047617", -6},
  {4.04834297005156873792e+36f, "4048343", 37},
  {4.41346860640677857245e-21f, "44134686", -20},
  {1.55387233986652674693e+35f, "15538723", 36},
  {3.11263356707058846951e-05f, "31126336", -4},
  {1.26725274718353375647e-09f, "12672527", -8},
  {8.54586960000000000000e+07f, "85458696", 8},
  {3.89534952980480000000e+13f, "38953495", 14},
  {4.83657209420547736268e-32f, "4836572", -31},
  {8.53350330733159724572e-16f, "85335033", -15},
  {1.50819683567047981428e-21f, "15081968", -20},
  {2.42287430860800000000e+12f, "24228743", 13},
  {1.93094628828105463469e-12f, "19309463", -11},
  {8.88091076373109800102e-12f, "8880911", -11},
  {3.67738113279535662665e-18f, "3677381", -17},
  {5.43923735822031137784e-35f, "54392374", -34},
  {8.78180761600000000000e+11f, "87818076", 12},
  {8.00812170918155788579e+34f, "80081217", 35},
  {2.20095053293789533200e-10f, "22009505", -9},
  {3.43904321253168943073e-14f, "34390432", -13},
  {1.74766105721316927779e-15f, "17476611", -14},
  {2.02490474450124800000e+15f, "20249047", 16},
  {3.04733561051762080751e-07f, "30473356", -6},
  {6.71114057482240000000e+13f, "67111406", 14},
  {2.07218534400000000000e+09f, "20721853", 10},
  {4.31804710147614389517e-25f, "4318047", -24},
  {5.87065825689600000000e+13f, "58706583", 14},
  {7.36660432099223797760e+19f, "73666043", 20},
  {1.08132723751262254766e-35f, "108132724", -34},
  {7.99132211810372764138e+37f, "7991322", 38},
  {2.08451354624000000000e+11f, "20845135", 12},
  {3.81412421120330691338e-04f, "38141242", -3},
  {4.65750953454923134903e+35f, "46575095", 36},
  {1.44140527704107140158e+29f, "14414053", 30},
  {8.53938502132223220542e-08f, "8539385", -7},
  {2.11822399620587020763e-08f, "2118224", -7},
  {2.55874234573471567469e-19f, "25587423", -18},
  {8.30022291193193649273e-39f, "8300223", -38},
  {1.17762217926826816434e-33f, "11776222", -32},
  {2.07721014867934261616e-12f, "20772101", -11},
  {1.44566945931977764578e-15f, "14456695", -14},
  {2.90702051604810698428e-16f, "29070205", -15},
  {2.86531484401741997949e-39f, "2865315", -38},
  {4.64331472896000000000e+11f, "46433147", 12},
  {4.20505124864000000000e+11f, "42050512", 12},
  {4.52307322027670850786e-18f, "45230732", -17},
  {4.09582898983731200000e+15f, "4095829", 16},
  {5.00573019602564396949e-16f, "500573", -15},
  {5.21591144973983813171e-22f, "52159114", -21},
  {1.31696289189184201776e-33f, "13169629", -32},
  {2.87160652800000000000e+09f, "28716065", 10},
  {1.53505752563476562500e+02f, "15350575", 3},
  {4.45080758811352891392e+20f, "44508076", 21},
  {1.21524764122167795367e-36f, "12152476", -35},
  {1.46468482692763751981e-23f, "14646848", -22},
  {1.33911637334449551417e-09f, "13391164", -8},
  {8.78469003840259725369e-23f, "878469", -22},
  {1.40647903232308613515e+29f, "1406479", 30},
  {1.44856317058158241281e-28f, "14485632", -27},
  {1.57864615246480894140e-19f, "15786462", -18},
  {1.63801939995074490437e+28f, "16380194", 29},
  {4.60730767516465364992e+21f, "46073077", 22},
  {9.17211526148915200000e+15f, "9172115", 16},
  {1.02086068732240799256e+25f, "10208607", 26},
  {9.73386612736000000000e+11f, "9733866", 12},
  {1.14462182546912740934e-30f, "11446218", -29},
  {3.12779890553922691930e-22f, "3127799", -21},
  {3.95626970740952685983e+31f, "39562697", 32},
  {1.82555890162927981455e-30f, "18255589", -29},
  {5.58276967080696196518e-17f, "558277", -16},
  {1.18454512614883941586e-19f, "11845451", -18},
  {4.25521022862085374072e-07f, "42552102", -6},
  {2.75756200000000000000e+06f, "2757562", 7},
  {1.44882377423979116732e-19f, "14488238", -18},
  {2.83880645944384300293e-34f, "28388065", -33},
  {1.56251893356370220545e-21f, "15625189", -20},
  {1.04959434509277343750e+02f, "104959435", 3},
  {1.90799273114759856128e+20f, "19079927", 21},
  {1.26200767517089843750e+02f, "12620077", 3},
  {8.63106292394858905600e+18f, "8631063", 19},
  {3.87793126291324859759e+25f, "38779313", 26},
  {5.28734406910372040024e-28f, "5287344", -27},
  {1.85758916185267733661e-18f, "18575892", -17},
  {2.53405440000000000000e+07f, "25340544", 8},
  {9.94904039723511862391e-26f, "99490404", -25},
  {4.59965551272034645081e-03f, "45996555", -2},
  {5.17941499313530836135e+36f, "5179415", 37},
  {1.47503365077739090339e-09f, "14750337", -8},
  {8.88002399477422210694e-13f, "8880024", -12},
  {1.09088960253484838422e-30f, "10908896", -29},
  {3.57289533440000000000e+10f, "35728953", 11},
  {2.12646954887622593131e-23f, "21264695", -22},
  {8.45610138686802527662e+29f, "84561014", 30},
  {4.81194945001206519919e-13f, "48119495", -12},
  {3.12636391202720018448e-37f, "3126364", -36},
  {1.13123083496093750000e+03f, "11312308", 4},
  {9.21105602174066007137e-05f, "9211056", -4},
  {1.54406864576689991478e-20f, "15440686", -19},
  {6.44109604763798415661e-05f, "6441096", -4},
  {2.72994277343750000000e+04f, "27299428", 5},
  {1.46563064575195312500e+02f, "14656306", 3},
  {1.29237458406604800000e+15f, "12923746", 16},
  {1.92869584476839481513e+36f, "19286958", 37},
  {5.75841627566693527429e-31f, "57584163", -30},
  {3.08248679104110759444e+34f, "30824868", 35},
  {7.24097775937280002429e-37f, "72409778", -36},
  {1.48319114694032971880e-13f, "14831911", -12},
  {4.39122878015041351318e-03f, "4391229", -2},
  {2.30052583431363897590e+22f, "23005258", 23},
  {3.16049984676249413630e+27f, "31604998", 28},
  {5.28262188239752370996e-23f, "5282622", -22},
  {1.31029798400000000000e+09f, "1310298", 10},
  {2.69775640536244344152e+38f, "26977564", 39},
  {1.66647713631391525269e-02f, "16664771", -1},
  {4.58118885358034620092e-23f, "4581189", -22},
  {3.90331796354937873049e-26f, "3903318", -25},
  {1.29190283594986142939e+34f, "12919028", 35},
  {3.47209805817751763636e-25f, "3472098", -24},
  {8.96064160156250000000e+03f, "8960642", 4},
  {1.66088701839460869568e-17f, "1660887", -16},
  {5.89456580741372013210e-17f, "5894566", -16},
  {4.68878165160800789264e-25f, "46887817", -24},
  {5.63596934080123901367e-02f, "56359693", -1},
  {7.21719289574179540081e-26f, "7217193", -25},
  {3.81387748718261718750e+01f, "38138775", 2},
  {2.93154072761535644531e+00f, "29315407", 1},
  {1.35173358223360000000e+16f, "13517336", 17},
  {5.65246274151555147035e+35f, "56524627", 36},
  {7.40218000926939545600e+18f, "740218", 19},
  {1.25695509671641845992e-27f, "12569551", -26},
  {2.18752155303955078125e+01f, "21875216", 2},
  {1.51798354392413140047e-18f, "15179835", -17},
  {2.63664865515496807823e+26f, "26366487", 27},
  {5.68184517323970794678e-02f, "5681845", -1},
  {1.40868108844394157586e-10f, "14086811", -9},
  {1.12208873565796171776e+22f, "11220887", 23},
  {6.97269058227539062500e+00f, "69726906", 1},
  {3.41074842012876800000e+15f, "34107484", 16},
  {7.11351739223448967960e-20f, "71135174", -19},
  {2.17721494346033168487e-16f, "2177215", -15},
  {1.46734472656250000000e+04f, "14673447", 5},
  {6.38637924566864967346e-04f, "6386379", -3},
  {4.79220999603140510793e+31f, "479221", 32},
  {5.63933642578125000000e+03f, "56393364", 4},
  {1.78417164232725477017e+33f, "17841716", 34},
  {3.01675428347572658387e-30f, "30167543", -29},
  {3.39898214247301120000e+16f, "33989821", 17},
  {3.20583491917552894558e+28f, "3205835", 29},
  {1.76647463835353255111e-16f, "17664746", -15},
  {4.29483392674589719231e-19f, "4294834", -18},
  {7.33205237243363634687e-28f, "73320524", -27},
  {1.73326412500000000000e+06f, "17332641", 7},
  {3.40063597832340747118e-05f, "3400636", -4},
  {6.95285811200000000000e+09f, "6952858", 10},
  {1.93502215743461130240e+19f, "19350222", 20},
  {2.17022575040698016180e+35f, "21702258", 36},
  {2.73793781920079793887e-29f, "27379378", -28},
  {3.78345575882121920586e-04f, "37834558", -3},
  {1.63416712080318966280e+32f, "16341671", 33},
  {3.34679732257086371172e+28f, "33467973", 29},
  {7.42048560000000000000e+07f, "74204856", 8},
  {5.24266897627967409790e-06f, "5242669", -5},
  {7.26921734317992296254e-29f, "72692173", -28},
  {2.76128048426471650600e-05f, "27612805", -4},
  {4.83745525375630221942e+31f, "48374553", 32},
  {1.64986467361450195312e+00f, "16498647", 1},
  {4.23027430353011076360e-22f, "42302743", -21},
  {4.61506232340980204754e-07f, "46150623", -6},
  {7.70628830865634302666e-24f, "7706288", -23},
  {5.11680822819471359253e-03f, "5116808", -2},
  {1.70844801078394880000e+16f, "1708448", 17},
  {1.80384591224326062080e+19f, "18038459", 20},
  {5.25016947217388478167e+32f, "52501695", 33},
  {1.15763264000000000000e+09f, "11576326", 10},
  {1.47939968770798317352e-16f, "14793997", -15},
  {1.23317967250971878801e+27f, "12331797", 28},
  {5.73643185037770752000e+17f, "5736432", 18},
  {2.57831770813598284483e-39f, "2578318", -38},
  {5.80367076598743040000e+16f, "58036708", 17},
  {1.48706947704084191216e-37f, "14870695", -36},
  {5.20409050160373334694e-19f, "52040905", -18},
  {7.06205469266606591294e+27f, "70620547", 28},
  {4.14160000000000000000e+07f, "41416", 8},
  {2.95954492581478400000e+15f, "2959545", 16},
  {6.53130635619163513184e-02f, "6531306", -1},
  {1.16712791774914448339e-12f, "11671279", -11},
  {8.90856800256000000000e+11f, "8908568", 12},
  {3.03229504000000000000e+08f, "3032295", 9},
  {6.92478072376107382866e+22f, "69247807", 23},
  {2.13331781250000000000e+05f, "21333178", 6},
  {1.42134288325905799866e-02f, "14213429", -1},
  {7.22226767280176318309e-09f, "72222677", -8},
  {1.70468967482073846377e+38f, "17046897", 39},
  {1.68998336000000000000e+08f, "16899834", 9},
  {3.38179201540847400334e+25f, "3381792", 26},
  {1.21131755845615475707e+31f, "12113176", 32},
  {3.76483945257631874864e-31f, "37648395", -30},
  {2.10171444867628058339e-35f, "21017144", -34},
  {8.03018997732598757699e-15f, "803019", -14},
  {4.76748312136905877737e-16f, "4767483", -15},
  {1.68950233459472656250e+01f, "16895023", 2},
  {1.93139779036791789441e-37f, "19313978", -36},
  {1.23894536052635934523e-35f, "12389454", -34},
  {1.27698694996070116758e-05f, "127698695", -4},
  {3.79687690240000000000e+10f, "3796877", 11},
  {3.09637542385624020547e-13f, "30963754", -12},
  {2.31215261900108657038e-17f, "23121526", -16},
  {3.18762967410624042941e-11f, "31876297", -10},
  {3.59509459962187305493e-13f, "35950946", -12},
  {2.17257342664209684037e+38f, "21725734", 39},
  {7.80720654791622337143e-10f, "78072065", -9},
  {2.98822500000000000000e+07f, "2988225", 8},
  {2.10832885047605032353e+27f, "21083289", 28},
  {5.07998459991785678884e+36f, "50799846", 37},
  {1.21616368526951802807e-16f, "12161637", -15},
  {1.98736358858302153418e-13f, "19873636", -12},
  {8.48493570868545654573e-15f, "8484936", -14},
  {1.78187368518083030090e+34f, "17818737", 35},
  {9.74968769530124441933e+33f, "9749688", 34},
  {8.10256971276034885283e-31f, "810257", -30},
  {5.37389707565307617188e+00f, "5373897", 1},
  {2.02302985030655690935e-07f, "20230299", -6},
  {9.82917726039886474609e-01f, "9829177", 0},
  {1.34540092945098876953e+00f, "13454009", 1},
  {4.59894805473843931659e-38f, "4598948", -37},
  {4.87199561564292255023e-14f, "48719956", -13},
  {2.29455867639671851066e-08f, "22945587", -7},
  {2.94272973666207257396e-30f, "29427297", -29},
  {1.69991645759814957728e-10f, "16999165", -9},
  {3.00840662125772800000e+16f, "30084066", 17},
  {2.31113247650682751555e-07f, "23111325", -6},
  {4.80489078163108883773e+29f, "48048908", 30},
  {9.78201066774462464000e+17f, "9782011", 18},
  {4.80467278975993394852e-04f, "48046728", -3},
  {8.45495074235265431373e-15f, "8454951", -14},
  {5.24435009308099608916e-11f, "524435", -10},
  {2.51191038930360247255e+22f, "25119104", 23},
  {3.11386840000000000000e+07f, "31138684", 8},
  {2.73416226493956096000e+17f, "27341623", 18},
  {1.20596873153684669453e-29f, "12059687", -28},
  {9.50374000000000000000e+06f, "950374", 7},
  {3.10375553560607412161e-31f, "31037555", -30},
  {6.09626927849799680000e+16f, "60962693", 17},
  {2.80155727523379027843e-05f, "28015573", -4},
  {2.28749474162689378816e-33f, "22874947", -32},
  {9.25675484887391392461e-39f, "9256755", -38},
  {9.35106527110189023232e+20f, "9351065", 21},
  {3.12704129257213025994e-09f, "31270413", -8},
  {3.12235564035832469450e+34f, "31223556", 35},
  {1.31672068671406080000e+16f, "13167207", 17},
  {4.26485091447830200195e-01f, "4264851", 0},
  {2.25443596718832850456e-04f, "2254436", -3},
  {3.65682487535157586785e-30f, "3656825", -29},
  {7.11094790332954396529e+37f, "7110948", 38},
  {4.95234991177623665476e+34f, "495235", 35},
  {2.81483297964288881435e-29f, "2814833", -28},
  {4.92390797799118103140e-15f, "4923908", -14},
  {1.57532407257798823252e-12f, "15753241", -11},
  {1.34186749542322339029e-20f, "13418675", -19},
  {1.29912954421248000000e+14f, "129912954", 15},
  {6.75080952944655335098e-35f, "67508095", -34},
  {5.27481176064000000000e+11f, "52748118", 12},
  {8.92816796875000000000e+04f, "8928168", 5},
  {1.03797297879773064724e+22f, "1037973", 23},
  {3.72137108207613154334e-31f, "3721371", -30},
  {1.22982616364184330789e+29f, "12298262", 30},
  {7.67784201985118431768e-28f, "7677842", -27},
  {1.54241843394051880873e+30f, "15424184", 31},
  {5.50105096772313117981e-03f, "5501051", -2},
  {3.56159888441067239391e+28f, "3561599", 29},
  {2.65118018360640176318e-38f, "26511802", -37},
  {7.42062320011188200140e-35f, "7420623", -34},
  {1.82361965269017676592e+36f, "18236197", 37},
  {2.62252472620285952000e+17f, "26225247", 18},
  {3.44307929277420043945e-01f, "34430793", 0},
  {5.58702621328588817855e-36f, "55870262", -35},
  {4.63249537549467648000e+17f, "46324954", 18},
  {4.25303002804505713337e-19f, "425303", -18},
  {2.92859181172389071435e-06f, "29285918", -5},
  {1.95375168225280000000e+13f, "19537517", 14},
  {9.45890295819574273363e+35f, "9458903", 36},
  {2.01423134768307930450e+32f, "20142313", 33},
  {6.17650698453124411417e-30f, "6176507", -29},
  {4.87525812756981732932e-33f, "4875258", -32},
  {1.94015620729640593147e+31f, "19401562", 32},
  {4.42828328833185435375e-34f, "44282833", -33},
  {2.24620159489322274952e-23f, "22462016", -22},
  {1.37547428265018478096e-22f, "13754743", -21},
  {1.12160165599561878480e-07f, "112160166", -6},
  {5.11910657223779708147e-05f, "51191066", -4},
  {2.90361163396588701639e+30f, "29036116", 31},
  {1.25373399350792169571e-03f, "1253734", -2},
  {3.93541549659885843004e-32f, "39354155", -31},
  {3.68067179806530475616e-04f, "36806718", -3},
  {1.87407105867522319156e-20f, "1874071", -19},
  {2.45400250624259119723e-24f, "24540025", -23},
  {6.02461806028901925014e-14f, "6024618", -13},
  {2.39119302136714395601e-09f, "2391193", -8},
  {5.23885983611425950949e-33f, "523886", -32},
  {5.54644279880526510162e+22f, "5546443", 23},
  {1.17300905853102175365e-19f, "1173009", -18},
  {2.25293072614050602545e-32f, "22529307", -31},
  {6.24747687460528558692e+26f, "6247477", 27},
  {3.07864491942603325602e-22f, "3078645", -21},
  {9.95874788647350518678e+23f, "9958748", 24},
  {3.15268644524024921338e-13f, "31526864", -12},
  {2.84160037511240340761e-19f, "28416004", -18},
  {6.42435241699218750000e+02f, "64243524", 3},
  {2.26145140000000000000e+07f, "22614514", 8},
  {1.29892427497472000000e+14f, "12989243", 15},
  {1.80700675689940739930e-23f, "18070068", -22},
  {2.90184824218750000000e+04f, "29018482", 5},
  {3.64820000000000000000e+07f, "36482", 8},
  {1.87973924349171123138e-14f, "18797392", -13},
  {2.32488181760000000000e+10f, "23248818", 11},
  {1.00039017200469970703e+00f, "10003902", 1},
  {1.37127664778802227374e-09f, "13712766", -8},
  {8.12739655354067390332e+25f, "8127397", 26},
  {2.34095109409341440000e+16f, "2340951", 17},
  {2.55788380983974460129e+22f, "25578838", 23},
  {5.99475408864226535469e-18f, "5994754", -17},
  {9.69563200000000000000e+07f, "9695632", 8},
  {4.43968869701693235174e-20f, "44396887", -19},
  {3.85411702552573842695e-11f, "3854117", -10},
  {4.70014758102820205698e-35f, "47001476", -34},
  {1.27597048878669738770e-01f, "12759705", 0},
  {1.48080068359375000000e+04f, "14808007", 5},
  {4.71354899556075679357e-10f, "4713549", -9},
  {5.16780936820610394205e+28f, "51678094", 29},
  {1.29512611840000000000e+10f, "12951261", 11},
  {3.82663606133002985363e-26f, "3826636", -25},
  {8.74971941373549414952e-30f, "87497194", -29},
  {4.81171757470842880000e+16f, "48117176", 17},
  {3.50225039812329346230e-38f, "35022504", -37},
  {4.18435170410416668041e-13f, "41843517", -12},
  {6.34578094482421875000e+01f, "6345781", 2},
  {1.70644737489816789022e-12f, "17064474", -11},
  {1.93064540000000000000e+07f, "19306454", 8},
  {5.95985278593996355617e-35f, "5959853", -34},
  {6.35635168451549926710e+33f, "63563517", 34},
  {3.46361264029812454638e-18f, "34636126", -17},
  {1.73813730206360172419e-19f, "17381373", -18},
  {2.49417051672935485840e-01f, "24941705", 0},
  {2.14685580518989403704e+28f, "21468558", 29},
  {5.04862500000000000000e+05f, "5048625", 6},
  {8.51083639215686953998e-30f, "85108364", -29},
  {3.15565663877581670249e-11f, "31556566", -10},
  {1.16165777792380257104e+35f, "11616578", 36},
  {1.16227466820417926174e+35f, "11622747", 36},
  {1.06601321509051523305e-33f, "10660132", -32},
  {4.04082178030934425600e+18f, "40408218", 19},
  {9.54527753769176381919e-22f, "9545278", -21},
  {1.60838849658880000000e+13f, "16083885", 14},
  {2.95701813153798524737e+37f, "29570181", 38},
  {6.08665650000000000000e+06f, "60866565", 7},
  {1.28326716497068032000e+17f, "12832672", 18},
  {5.51234232261776924133e-03f, "55123423", -2},
  {1.27105321687294898929e-28f, "12710532", -27},
  {8.84075371645385190636e-32f, "8840754", -31},
  {3.90104588172610067254e-13f, "3901046", -12},
  {2.60691656078713159680e+20f, "26069166", 21},
  {5.52282232017208019883e-19f, "55228223", -18},
  {5.38157531991600990295e-04f, "53815753", -3},
  {1.72193013131618499756e-02f, "17219301", -1},
  {3.05861012314113624226e-18f, "30586101", -17},
  {3.66917291359127186964e+22f, "3669173", 23},
  {1.84618828282784605035e+38f, "18461883", 39},
  {8.80160896000000000000e+08f, "8801609", 9},
  {1.01812025476988310402e-09f, "10181203", -8},
  {1.59238890377258870277e-35f, "15923889", -34},
  {7.63337207031250000000e+03f, "7633372", 4},
  {5.99143219200000000000e+11f, "5991432", 12},
  {4.27669820274672826156e-16f, "42766982", -15},
  {2.79704106049827910712e-36f, "2797041", -35},
  {1.87795257568359375000e+01f, "18779526", 2},
  {3.66816734823797096004e+28f, "36681673", 29},
  {3.90179963741842160923e-27f, "39017996", -26},
  {9.96686897170414534188e+28f, "9966869", 29},
  {6.04581891306590013961e+24f, "6045819", 25},
  {6.33686340997211341843e-31f, "63368634", -30},
  {1.70490104941814392617e+34f, "1704901", 35},
  {3.28555937500000000000e+04f, "32855594", 5},
  {9.85376873412907583472e-14f, "9853769", -13},
  {3.94676896000000000000e+08f, "3946769", 9},
  {1.42648974609375000000e+03f, "14264897", 4},
  {9.61114692408285043766e+31f, "9611147", 32},
  {7.11211756263159522451e-14f, "71121176", -13},
  {9.45351537014515446399e-39f, "9453515", -38},
  {1.73749630584331490696e-35f, "17374963", -34},
  {9.95917162072146311402e-07f, "9959172", -6},
  {6.91176987605707227047e-13f, "691177", -12},
  {7.31382561872335488418e+23f, "73138256", 24},
  {9.27298874245120000000e+13f, "9272989", 14},
  {6.12797280284925681992e+22f, "6127973", 23},
  {1.82077441335620852101e-17f, "18207744", -16},
  {4.49004764139331567508e+34f, "44900476", 35},
  {3.28100475000000000000e+06f, "32810048", 7},
  {4.84715803478161570922e-18f, "4847158", -17},
  {5.63729882812500000000e+04f, "5637299", 5},
  {5.50866402269297426894e+35f, "5508664", 36},
  {1.22213572812182591498e-14f, "12221357", -13},
  {6.24771250781253014708e-31f, "62477125", -30},
  {4.69101280000000000000e+08f, "46910128", 9},
  {8.83720000000000000000e+08f, "88372", 9},
  {2.91398617263757373668e-28f, "29139862", -27},
  {1.21248476943814402496e-29f, "12124848", -28},
  {4.68127541244029998779e-02f, "46812754", -1},
  {1.83240596243213317920e-16f, "1832406", -15},
  {2.00639761651841833941e+38f, "20063976", 39},
  {3.88190408696537938259e-16f, "3881904", -15},
  {1.87318089928112385678e-08f, "18731809", -7},
  {4.72762399487367710989e+33f, "4727624", 34},
  {2.16754304652661057389e+27f, "2167543", 28},
  {2.86870469246713856000e+17f, "28687047", 18},
  {2.64458349609375000000e+03f, "26445835", 4},
  {4.26167190425985609181e-09f, "4261672", -8},
  {4.03805634560000000000e+10f, "40380563", 11},
  {3.05519142837198726326e+28f, "30551914", 29},
  {7.25761051256768041640e-09f, "72576105", -8},
  {1.13904806002688000000e+14f, "11390481", 15},
  {4.40417824949527656440e-17f, "44041782", -16},
  {8.46310248976220160000e+17f, "84631025", 18},
  {1.14290975034236907959e-01f, "114290975", 0},
  {6.32893101553971866552e+35f, "6328931", 36},
  {6.97712173461914062500e+01f, "6977122", 2},
  {3.36663951316174766080e+20f, "33666395", 21},
  {4.02703829060845586831e+31f, "40270383", 32},
  {3.26328140375842643040e-31f, "32632814", -30},
  {2.31376429534739456651e-36f, "23137643", -35},
  {3.33173875696957111359e-03f, "33317388", -2},
  {2.52755874380888116360e-34f, "25275587", -33},
  {4.57571610809615059168e-12f, "4575716", -11},
  {3.38122156250000000000e+05f, "33812216", 6},
  {1.86463467601920000000e+13f, "18646347", 14},
  {6.32652762922984845684e+35f, "63265276", 36},
  {1.56074022000394240000e+16f, "15607402", 17},
  {3.74234492335699263488e+22f, "3742345", 23},
  {4.27804043283686041832e-05f, "42780404", -4},
  {1.09600039632652059279e+22f, "10960004", 23},
  {2.65190962113177190400e+18f, "26519096", 19},
  {1.22213714703889309021e-08f, "122213715", -7},
  {7.13892627669319680000e+16f, "71389263", 17},
  {7.97341300000000000000e+06f, "7973413", 7},
  {5.14617659400160640357e-30f, "51461766", -29},
  {2.75983822445248223273e-19f, "27598382", -18},
  {5.55613920146293425958e+36f, "5556139", 37},
  {3.33169901275195637760e+19f, "3331699", 20},
  {1.14557006384809392565e-29f, "11455701", -28},
  {5.80095693702986636708e-11f, "5800957", -10},
  {5.43518945050891488791e-06f, "54351895", -5},
  {8.35657516518040210940e-08f, "8356575", -7},
  {7.20480471022943992522e-32f, "7204805", -31},
  {1.01692586508254844508e+32f, "10169259", 33},
  {7.60508808705928629479e-11f, "7605088", -10},
  {8.32946240000000000000e+08f, "83294624", 9},
  {4.90512276520960000000e+13f, "49051228", 14},
  {4.48262036601010896593e-18f, "44826204", -17},
  {4.34566208348487680000e+16f, "4345662", 17},
  {1.74008269977681920000e+16f, "17400827", 17},
  {2.30339604608607846400e+18f, "2303396", 19},
  {1.79278393246439230669e+21f, "1792784", 22},
  {1.14558479246170194274e-34f, "11455848", -33},
  {1.14371735433755174552e-15f, "11437174", -14},
  {4.81710558233316987753e-05f, "48171056", -4},
  {1.02828805924884262065e-37f, "10282881", -36},
  {2.39913927869662578524e-38f, "23991393", -37},
  {2.64215018191683390148e-21f, "26421502", -20},
  {7.30122905224561691284e-04f, "7301229", -3},
  {1.65008303186319503895e-38f, "1650083", -37},
  {4.04390214081016522370e-38f, "40439021", -37},
  {2.72204324234039703050e-24f, "27220432", -23},
  {3.11154160215210140450e-08f, "31115416", -7},
  {4.90434309711200256000e+17f, "4904343", 18},
  {3.65129593116542002790e+21f, "3651296", 22},
  {2.67991790771484375000e+01f, "2679918", 2},
  {2.09942156980894248846e+37f, "20994216", 38},
  {2.93557378046891130880e+19f, "29355738", 20},
  {1.28462028008886035499e-18f, "12846203", -17},
  {3.52919585832969019902e-31f, "35291959", -30},
  {2.50001279730622907392e-30f, "25000128", -29},
  {1.07290866745344000000e+15f, "10729087", 16},
  {4.76606225967407226562e+00f, "47660623", 1},
  {2.76841962554048035458e-23f, "27684196", -22},
  {1.55602176000000000000e+08f, "15560218", 9},
  {5.93442606488230668497e+28f, "5934426", 29},
  {3.86218587157090811878e+24f, "3862186", 25},
  {1.07791990116928669942e-17f, "10779199", -16},
  {3.61505211689623510531e-28f, "3615052", -27},
  {2.30851348876953125000e+02f, "23085135", 3},
  {3.15893966034713945227e+37f, "31589397", 38},
  {1.41657167397027514090e+29f, "14165717", 30},
  {5.87118505109154127306e-16f, "5871185", -15},
  {5.04042815606925496325e-36f, "5040428", -35},
  {2.22444600427934639070e-25f, "2224446", -24},
  {4.38235263188493926400e+18f, "43823526", 19},
  {8.51469505209679252631e-35f, "8514695", -34},
  {9.06719978512265005814e-25f, "90672", -24},
  {1.94092898997324728591e+36f, "1940929", 37},
  {1.01097974777221679688e+01f, "101097975", 2},
  {2.48136414674018199171e-24f, "24813641", -23},
  {1.25508729542454748837e+37f, "12550873", 38},
  {4.29890846536499200000e+15f, "42989085", 16},
  {1.29516140000000000000e+07f, "12951614", 8},
  {8.47493845326233600000e+15f, "84749385", 16},
  {2.27419193834066390991e-02f, "2274192", -1},
  {4.80771829232075841128e-31f, "48077183", -30},
  {2.61222981173248000000e+14f, "26122298", 15},
  {8.86725398779145604431e-22f, "8867254", -21},
  {9.89511458882041949892e-11f, "98951146", -10},
  {1.55424019474158966538e+22f, "15542402", 23},
  {3.70944702905717793584e-13f, "3709447", -12},
  {1.54636419603916158660e-34f, "15463642", -33},
  {1.01981284541760065798e-16f, "101981285", -15},
  {1.71756689453125000000e+03f, "17175669", 4},
  {3.88163436544000000000e+12f, "38816344", 13},
  {8.62847121815800755985e-27f, "8628471", -26},
  {9.27447528498159812216e-12f, "9274475", -11},
  {6.84661122136362948930e+33f, "6846611", 34},
  {4.99724027891619571040e-16f, "49972403", -15},
  {3.41695327127702344798e+29f, "34169533", 30},
  {2.92705293530412040286e+32f, "2927053", 33},
  {9.89123599810746677995e-26f, "9891236", -25},
  {2.89569810233128636171e-25f, "2895698", -24},
  {2.45725274528203186139e+35f, "24572527", 36},
  {3.61782327186477292713e-12f, "36178233", -11},
  {2.11069511725055662565e+32f, "21106951", 33},
  {2.93247795837373700185e-38f, "2932478", -37},
  {5.55559204101562500000e+02f, "5555592", 3},
  {5.58086021957394457039e+29f, "55808602", 30},
  {4.83540115356445312500e+01f, "4835401", 2},
  {2.28418129011671040000e+17f, "22841813", 18},
  {9.61279018294841392643e+27f, "961279", 28},
  {3.00730942683547309440e-22f, "30073094", -21},
  {4.01073658063289678610e-15f, "40107366", -14},
  {1.19478804687500000000e+05f, "119478805", 6},
  {1.05589402029260800000e+15f, "1055894", 16},
  {3.21346135478961514309e-07f, "32134614", -6},
  {4.55148829603458283401e-20f, "45514883", -19},
  {1.55972156554538636740e+32f, "15597216", 33},
  {4.94805424509615603712e+21f, "4948054", 22},
  {9.96682837372829258480e-37f, "9966828", -36},
  {8.42391106924685384001e-20f, "8423911", -19},
  {1.27943241141083961161e+26f, "12794324", 27},
  {1.65123059133300345569e-14f, "16512306", -13},
  {2.32576310590549776138e+22f, "2325763", 23},
  {7.09395349025726318359e-01f, "70939535", 0},
  {2.33928356319665908813e-02f, "23392836", -1},
  {3.04118710470954530945e-28f, "3041187", -27},
  {6.62765523884445428848e-06f, "66276552", -5},
  {1.91541540220531900416e+21f, "19154154", 22},
  {1.48970246080336967044e-37f, "14897025", -36},
  {2.80367330914021994914e-12f, "28036733", -11},
  {3.18944778149145873511e+34f, "31894478", 35},
  {6.56581908177339011288e-24f, "6565819", -23},
  {9.06155952851768909523e-16f, "906156", -15},
  {1.69262686494055442695e-16f, "16926269", -15},
  {2.02770913533792892621e-30f, "20277091", -29},
  {4.50334553176758023429e-15f, "45033455", -14},
  {1.55676696453268379544e+25f, "1556767", 26},
  {1.78005525525008337725e+38f, "17800553", 39},
  {3.44039386256613542828e+25f, "34403939", 26},
  {4.89319873046875000000e+03f, "48931987", 4},
  {2.46041816526212979331e+27f, "24604182", 28},
  {1.44300742031348448885e-35f, "14430074", -34},
  {3.27695251878634404921e+27f, "32769525", 28},
  {4.31683503165913862176e-07f, "4316835", -6},
  {2.47750893502464000000e+18f, "2477509", 19},
  {1.44968582568504213357e-18f, "14496858", -17},
  {3.27613703782400000000e+12f, "3276137", 13},
  {5.48918394880000000000e+11f, "5489184", 12},
  {1.03468492171823666591e-35f, "10346849", -34},
  {5.10773885403136000000e+14f, "5107739", 15},
  {7.86395063095484842827e+30f, "78639506", 31},
  {2.17527727341971533936e+29f, "21752773", 30},
  {1.14796850495770869376e-38f, "11479685", -37},
  {2.50813859495936000000e+14f, "25081386", 15},
  {2.08567788040348034428e-10f, "20856779", -9},
  {4.60539124906063079834e-02f, "46053912", -1},
  {1.24573768091952211317e+25f, "12457377", 26},
  {2.31053485930548853473e+23f, "23105349", 24},
  {1.18844295629155413595e-19f, "1188443", -18},
  {2.89706742866907014254e+26f, "28970674", 27},
  {8.64597137319067661715e-28f, "8645971", -27},
  {5.39920148246507632079e-24f, "53992015", -23},
  {2.79347579847262990534e-36f, "27934758", -35},
  {1.33125038701109588146e-04f, "13312504", -3},
  {1.44548907876014709473e-01f, "14454891", 0},
  {9.22335842976316457057e-28f, "9223358", -27},
  {1.00212999396620500992e+20f, "100213", 21},
  {3.13713602147149168975e-15f, "3137136", -14},
  {2.39918509850286559316e-28f, "2399185", -27},
  {4.76800650000000000000e+06f, "47680065", 7},
  {2.42720325303091355402e+27f, "24272033", 28},
  {1.00002937752249454143e+38f, "10000294", 39},
  {1.14725877760000000000e+10f, "11472588", 11},
  {1.15673132957696000000e+16f, "11567313", 17},
  {5.91916062830932787620e-08f, "59191606", -7},
  {4.10373679482489706061e-11f, "41037368", -10},
  {2.59944337009005703954e+36f, "25994434", 37},
  {2.84258686764318671115e-34f, "28425869", -33},
  {3.30781014684928195503e-38f, "33078101", -37},
  {3.93736310012570657158e-38f, "3937363", -37},
  {2.38071623262803066880e+19f, "23807162", 20},
  {3.97104761662849608686e+31f, "39710476", 32},
  {1.32794260205123254318e+30f, "13279426", 31},
  {4.67504163763844546560e+19f, "46750416", 20},
  {1.45963230000000000000e+07f, "14596323", 8},
  {3.98801144104678255637e-19f, "39880114", -18},
  {2.94919554593900469550e-21f, "29491955", -20},
  {2.45113369601313024759e-07f, "24511337", -6},
  {1.31746066323989236963e-34f, "13174607", -33},
  {5.74075914919376373291e-02f, "5740759", -1},
  {1.03013622593236071966e-19f, "10301362", -18},
  {1.90377111766089445880e-23f, "19037711", -22},
  {5.16806158581760000000e+13f, "51680616", 14},
  {4.87623566670050852517e-17f, "48762357", -16},
  {4.20290822144000000000e+11f, "42029082", 12},
  {1.05028848476488181185e-26f, "10502885", -25},
  {7.24275832908460870385e-06f, "72427583", -5},
  {5.62414079752215911867e-08f, "56241408", -7},
  {5.43473986908793449402e-03f, "543474", -2},
  {2.84862593750000000000e+05f, "2848626", 6},
  {4.35531584498717651873e+37f, "4355316", 38},
  {1.92126859126923177357e-14f, "19212686", -13},
  {4.13595585937500000000e+04f, "4135956", 5},
  {7.29883968000000000000e+08f, "72988397", 9},
  {3.07735478743202688626e-37f, "30773548", -36},
  {4.14830221125380302488e+35f, "41483022", 36},
  {4.70426595542886193359e+36f, "4704266", 37},
  {1.35415903225767648793e+38f, "1354159", 39},
  {1.62151431165549640939e-37f, "16215143", -36},
  {2.50221323801942160480e+37f, "25022132", 38},
  {3.13357802072929863473e-39f, "3133578", -38},
  {5.99078674057008250880e+20f, "5990787", 21},
  {1.43803887198062701481e+30f, "14380389", 31},
  {1.66586713843182940776e+30f, "16658671", 31},
  {4.10256423950195312500e+01f, "41025642", 2},
  {2.92879696935415267944e-02f, "2928797", -1},
  {9.31614684558882501312e-28f, "9316147", -27},
  {1.88700802396591226880e+19f, "1887008", 20},
  {1.20585900148385803823e+30f, "1205859", 31},
  {2.01357282483078813619e-23f, "20135728", -22},
  {1.57547452873877895946e-21f, "15754745", -20},
  {1.82033854814439668757e-28f, "18203385", -27},
  {5.84084212107427447336e-08f, "5840842", -7},
  {1.34760750322655743756e+31f, "13476075", 32},
  {1.48737444760627113283e-06f, "14873744", -5},
  {3.58432563972197328851e-35f, "35843256", -34},
  {1.88171666311693256416e-34f, "18817167", -33},
  {1.80525179682405418400e+27f, "18052518", 28},
  {3.35942168021574616432e-04f, "33594217", -3},
  {1.72208602905273437500e+02f, "1722086", 3},
  {7.36682579827174777165e-07f, "7366826", -6},
  {2.13615276152268052101e-05f, "21361528", -4},
  {5.25305127081927697517e+26f, "52530513", 27},
  {4.80417266835934926330e+36f, "48041727", 37},
  {2.11787763949304978349e-35f, "21178776", -34},
  {2.64137753702784455765e+28f, "26413775", 29},
  {2.74013942493689282094e+33f, "27401394", 34},
  {1.43787605367164061399e-37f, "1437876", -36},
  {4.76696333134224542568e+27f, "47669633", 28},
  {7.39280509818280676261e+34f, "7392805", 35},
  {5.90218363548386589530e+27f, "59021836", 28},
  {6.46584262438420480000e+16f, "64658426", 17},
  {1.16621311036609725951e+30f, "11662131", 31},
  {1.38910803717406064640e+19f, "1389108", 20},
  {3.64794445343806236569e-21f, "36479445", -20},
  {4.98953135752433496464e-11f, "49895314", -10},
  {2.10348513806403685991e+30f, "21034851", 31},
  {1.16932959143356756395e+37f, "11693296", 38},
  {8.76523228561522889783e-20f, "8765232", -19},
  {5.82164458865501005037e-32f, "58216446", -31},
  {2.59354131131092244090e-23f, "25935413", -22},
  {2.64435251473571497627e-09f, "26443525", -8},
  {5.70315599441528320312e-01f, "5703156", 0},
  {5.08211017705128235295e-31f, "508211", -30},
  {5.98207049636926778769e+23f, "59820705", 24},
  {3.33721972656250000000e+03f, "33372197", 4},
  {1.60596380122091358835e-26f, "16059638", -25},
  {1.58062700134400000000e+12f, "1580627", 13},
  {1.71080542978852755196e+38f, "17108054", 39},
  {4.46963724058624000000e+14f, "44696372", 15},
  {1.52726810663906121005e-33f, "15272681", -32},
  {5.36144307261565700173e-06f, "5361443", -5},
  {3.29033355712890625000e+02f, "32903336", 3},
  {1.07709814116806567894e-35f, "107709814", -34},
  {1.82020943611860275269e-02f, "18202094", -1},
  {1.20613083964826728334e-08f, "12061308", -7},
  {4.90511600256817322760e+36f, "4905116", 37},
  {4.23486560583114624023e-01f, "42348656", 0},
  {8.37113888487053134551e-20f, "8371139", -19},
  {5.27294872946552260878e+32f, "52729487", 33},
  {3.49873334169387817383e-01f, "34987333", 0},
  {6.84786114862484903427e-31f, "6847861", -30},
  {4.87731200000000000000e+10f, "4877312", 11},
  {5.77165371051790998536e-10f, "57716537", -9},
  {1.53778537094961509066e+27f, "15377854", 28},
  {2.96346583463699627901e+28f, "29634658", 29},
  {4.50525549188192665600e+18f, "45052555", 19},
  {4.38472262919861043200e+18f, "43847226", 19},
  {4.93876228611928017018e+26f, "49387623", 27},
  {6.68120218040641200718e+37f, "6681202", 38},
  {4.18710053826302805363e+25f, "41871005", 26},
  {1.87227422349774555591e-35f, "18722742", -34},
  {2.31715285847755581017e-10f, "23171529", -9},
  {3.47589355030857721784e-14f, "34758936", -13},
  {1.48948455966794464532e-27f, "14894846", -26},
  {2.03664299790902807724e-25f, "2036643", -24},
  {1.83460065518969763443e+28f, "18346007", 29},
  {3.85983511998070141780e-15f, "3859835", -14},
  {5.44419818535174235142e+25f, "5444198", 26},
  {4.60017111805472063285e+27f, "4600171", 28},
  {2.84881188195069565869e+38f, "28488119", 39},
  {1.40942423251640403992e+31f, "14094242", 32},
  {3.50681831028426993675e-17f, "35068183", -16},
  {1.25418731689453125000e+02f, "12541873", 3},
  {2.44959242183653549966e+34f, "24495924", 35},
  {1.05397205517677363200e+20f, "105397206", 21},
  {2.56127743789955112466e+32f, "25612774", 33},
  {1.66240395281489577185e+32f, "1662404", 33},
  {6.08424298510283264564e-20f, "6084243", -19},
  {2.90214161681274473876e-26f, "29021416", -25},
  {1.27615239584709331623e+26f, "12761524", 27},
  {3.50911994734942617600e+18f, "350912", 19},
  {3.22459197806087363724e-18f, "3224592", -17},
  {8.35056975483894348145e-03f, "835057", -2},
  {2.77882783218002711902e-30f, "27788278", -29},
  {6.94868978782369317286e-30f, "694869", -29},
  {3.55849085007658993973e-13f, "35584909", -12},
  {2.12323381968760764123e+27f, "21232338", 28},
  {4.96480392366301741838e+27f, "4964804", 28},
  {2.40056314567446338132e-25f, "24005631", -24},
  {1.98979937021740589446e+26f, "19897994", 27},
  {3.05393112711168000000e+14f, "3053931", 15},
  {7.26866787925716777181e-22f, "7268668", -21},
  {6.75665928644528050153e-23f, "6756659", -22},
  {1.53748281480114582307e-38f, "15374828", -37},
  {1.81626338968676748209e-10f, "18162634", -9},
  {2.32088792628815099306e-09f, "2320888", -8},
  {4.59689320541979874037e+28f, "4596893", 29},
  {1.15869552214016000000e+14f, "11586955", 15},
  {1.75050948550056479901e-22f, "17505095", -21},
  {2.93537650059509760000e+17f, "29353765", 18},
  {4.64780808683520000000e+13f, "4647808", 14},
  {3.29147182716120233207e-30f, "3291472", -29},
  {1.50684006076236931825e-38f, "150684", -37},
  {8.47465855186423905043e-24f, "84746586", -23},
  {1.17726792384183871324e-34f, "11772679", -33},
  {2.52392225652911112192e+20f, "25239223", 21},
  {2.93324246281590799016e-30f, "29332425", -29},
  {3.31530848174974229069e+36f, "33153085", 37},
  {2.15423574738504183057e-38f, "21542357", -37},
  {1.37520199587594442155e-17f, "1375202", -16},
  {5.73172512085893703533e+23f, "5731725", 24},
  {1.24926819011164897280e+19f, "12492682", 20},
  {7.53961230468750000000e+03f, "75396123", 4},
  {6.81864913980223240363e-18f, "6818649", -17},
  {5.52492971515428962424e+27f, "552493", 28},
  {8.54008109465600000000e+12f, "8540081", 13},
  {4.10808960000000000000e+08f, "41080896", 9},
  {1.64911486295080960000e+16f, "16491149", 17},
  {6.22215614318847656250e+01f, "6222156", 2},
  {1.59731566150750956421e+22f, "15973157", 23},
  {4.57426171875000000000e+03f, "45742617", 4},
  {2.72479435530431004812e-23f, "27247944", -22},
  {1.65449600098704675287e-38f, "1654496", -37},
  {5.13948414530405007360e+19f, "5139484", 20},
  {7.07983982209622461797e-23f, "707984", -22},
  {4.58128729396989342604e-10f, "45812873", -9},
  {1.65504500881425454947e-28f, "1655045", -27},
  {4.61533832684576259503e-33f, "46153383", -32},
  {7.77234683670662747978e-35f, "7772347", -34},
  {4.70167524704856454321e-12f, "47016752", -11},
  {2.29118072997885637558e+23f, "22911807", 24},
  {5.57794893154484224000e+17f, "5577949", 18},
  {2.60839005932211875916e-03f, "260839", -2},
  {5.43428470332526753219e+23f, "54342847", 24},
  {7.89160314076090200245e+32f, "7891603", 33},
  {4.98573036193847656250e+01f, "49857304", 2},
  {1.97699859375000000000e+05f, "19769986", 6},
  {3.23513278851119420231e-36f, "32351328", -35},
  {2.25640147924423217773e-01f, "22564015", 0},
  {7.03044687500000000000e+05f, "7030447", 6},
  {7.50995504661660512324e-15f, "7509955", -14},
  {1.88914446440396248741e-16f, "18891445", -15},
  {1.20466169252985387528e-14f, "12046617", -13},
  {9.39674663872361052755e+27f, "93967466", 28},
  {2.18488093750000000000e+05f, "2184881", 6},
  {9.36348497102669886256e-26f, "9363485", -25},
  {1.17724639892578125000e+02f, "11772464", 3},
  {1.23799417774697012707e-25f, "12379942", -24},
  {2.60192684020628671284e+29f, "26019268", 30},
  {1.07362855307532794691e-35f, "107362855", -34},
  {3.13787257502194650785e+35f, "31378726", 36},
  {1.67733173839224036783e-06f, "16773317", -5},
  {4.91487714018222413326e-20f, "4914877", -19},
  {8.61358283193955023953e+35f, "8613583", 36},
  {1.19100555466796411809e-25f, "11910056", -24},
  {5.61823020689189434052e-04f, "561823", -3},
  {5.74653226479565626406e-13f, "5746532", -12},
  {3.18136109395529640548e-15f, "3181361", -14},
  {4.21984375000000000000e+02f, "42198438", 3},
  {6.99583102559131475573e-09f, "6995831", -8},
  {2.38227632947200000000e+12f, "23822763", 13},
  {1.32394312526984414546e-13f, "13239431", -12},
  {5.72135218646912402290e-30f, "5721352", -29},
  {8.95407337021351682002e-30f, "8954073", -29},
  {9.90863150773660755680e-29f, "99086315", -28},
  {6.19344684540409472365e-36f, "6193447", -35},
  {6.79247462400000000000e+10f, "67924746", 11},
  {3.31225542479052800000e+15f, "33122554", 16},
  {3.40233284926278199679e-33f, "3402333", -32},
  {2.24918961192551122310e-29f, "22491896", -28},
  {3.14312523427721046237e-18f, "31431252", -17},
  {4.32525704141539790726e-09f, "4325257", -8},
  {7.07426863755244994536e-07f, "70742686", -6},
  {6.32207000000000000000e+06f, "632207", 7},
  {5.73927958909981003784e-20f, "57392796", -19},
  {2.44687166929537783947e+37f, "24468717", 38},
  {9.72852022419925237760e+19f, "972852", 20},
  {1.12047461740401446093e+21f, "11204746", 22},
  {4.35506724982995756725e-27f, "43550672", -26},
  {3.36812564480000000000e+10f, "33681256", 11},
  {2.03344858638850955464e+24f, "20334486", 25},
  {1.95064222106525070466e-30f, "19506422", -29},
  {8.27821003991220034486e-35f, "827821", -34},
  {1.43992042750731871302e-34f, "14399204", -33},
  {2.36102723972960503527e-33f, "23610272", -32},
  {1.58495691449857415916e-21f, "15849569", -20},
  {1.31672992706298828125e+01f, "13167299", 2},
  {2.14108240470523014665e-07f, "21410824", -6},
  {8.51012634277343750000e+02f, "85101263", 3},
  {7.78971780779083701117e-36f, "7789718", -35},
  {2.52967605400566478406e+23f, "2529676", 24},
  {2.88763441546192375535e-24f, "28876344", -23},
  {1.69831509966300586711e-10f, "16983151", -9},
  {2.41306816154620718469e+32f, "24130682", 33},
  {4.13641551769822722606e-15f, "41364155", -14},
  {2.84289646148681640625e+00f, "28428965", 1},
  {2.51927076826454141391e+35f, "25192708", 36},
  {4.74022591498859245974e+34f, "4740226", 35},
  {1.25227542961301318217e-23f, "12522754", -22},
  {1.21901666325442769846e-36f, "12190167", -35},
  {1.48154817221878991734e-33f, "14815482", -32},
  {6.65731821209192276001e-03f, "6657318", -2},
  {8.49439345529390266165e-07f, "84943935", -6},
  {1.75842642784118652344e-01f, "17584264", 0},
  {5.83350952812875615942e-35f, "58335095", -34},
  {8.09290589798400000000e+12f, "8092906", 13},
  {6.08302606269717216492e-03f, "6083026", -2},
  {9.24848122607323217658e+23f, "9248481", 24},
  {1.32619597934535704553e-05f, "1326196", -4},
  {4.09113395200000000000e+09f, "4091134", 10},
  {4.54876717412844300270e-05f, "4548767", -4},
  {3.84973314438645610118e-20f, "3849733", -19},
  {1.31600134411649024000e+18f, "13160013", 19},
  {6.04928553104400634766e-01f, "60492855", 0},
  {8.50697158844563238941e-16f, "85069716", -15},
  {5.05888157192226189869e+23f, "50588816", 24},
  {1.55794853421121536000e+17f, "15579485", 18},
  {1.88775231058427346787e+24f, "18877523", 25},
  {1.55633168922477483152e-22f, "15563317", -21},
  {1.88995738545673086658e-19f, "18899574", -18},
  {2.29737034587366286010e+27f, "22973703", 28},
  {5.37865266080450386696e-38f, "53786527", -37},
  {9.08597357920370995998e-05f, "90859736", -4},
  {5.56772776246804981205e-22f, "5567728", -21},
  {2.11726432344027695141e+33f, "21172643", 34},
  {6.09828511280843980800e+19f, "6098285", 20},
  {2.50197049176227840000e+17f, "25019705", 18},
  {7.27195401308367244513e+29f, "7271954", 30},
  {4.03997965103923200000e+15f, "40399797", 16},
  {5.28470645184489778462e+32f, "52847065", 33},
  {1.43409879535100089806e+32f, "14340988", 33},
  {1.01369778867626888397e+21f, "10136978", 22},
  {4.96487873036244309333e-09f, "49648787", -8},
  {1.76108490312389120991e-13f, "17610849", -12},
  {2.43731249030587263484e-19f, "24373125", -18},
  {4.71289677079766988754e-05f, "47128968", -4},
  {2.36356801010137974435e+38f, "2363568", 39},
  {2.42296061698244608000e+17f, "24229606", 18},
  {5.82408951257607698547e-20f, "58240895", -19},
  {4.30088812208850868046e-06f, "4300888", -5},
  {1.44277634544359711910e-12f, "14427763", -11},
  {4.40478793203712000000e+14f, "4404788", 15},
  {2.72283562147840000000e+13f, "27228356", 14},
  {2.66209522020419394378e-33f, "26620952", -32},
  {3.67010140583089295482e-25f, "36701014", -24},
  {3.89025838356155699100e+36f, "38902584", 37},
  {2.22099072544719007896e+29f, "22209907", 30},
  {9.41000415371922097509e+30f, "9410004", 31},
  {9.67957316830852494131e+21f, "9679573", 22},
  {4.61374156470696437024e-32f, "46137416", -31},
  {2.58328219002966515527e-27f, "25832822", -26},
  {3.23095900160000000000e+10f, "3230959", 11},
  {4.00531832528561969570e-31f, "40053183", -30},
  {3.64944760000000000000e+07f, "36494476", 8},
  {2.95943978109202576298e+27f, "29594398", 28},
  {1.23872649788492969508e-36f, "12387265", -35},
  {3.16606680109132732071e-12f, "31660668", -11},
  {1.01260931250000000000e+06f, "10126093", 7},
  {1.45535383896926860070e+32f, "14553538", 33},
  {1.84729783840202688359e-35f, "18472978", -34},
  {7.79937505722045898438e-01f, "7799375", 0},
  {3.02042929179223982059e+25f, "30204293", 26},
  {3.02701933346649732756e+24f, "30270193", 25},
  {5.99796645038261433525e+29f, "59979665", 30},
  {7.17703263416945500391e-27f, "7177033", -26},
  {1.05999936762460917857e-33f, "10599994", -32},
  {4.08404762103093538217e-14f, "40840476", -13},
  {2.42301323340555918162e-27f, "24230132", -26},
  {3.99408128064823303864e+22f, "39940813", 23},
  {3.96178593750000000000e+05f, "3961786", 6},
  {1.70626862500000000000e+06f, "17062686", 7},
  {8.29792814699695253199e-29f, "8297928", -28},
  {2.33362901943753053529e-19f, "2333629", -18},
  {6.36956601270592840103e-20f, "6369566", -19},
  {3.62999299583933370214e-23f, "3629993", -22},
  {1.41216169140534475446e-05f, "14121617", -4},
  {3.46929893711106513101e-22f, "3469299", -21},
  {1.09270472450425535714e-32f, "10927047", -31},
  {1.94034417981721329927e-13f, "19403442", -12},
  {8.50223128660968633003e-26f, "8502231", -25},
  {8.16074386239051818848e-02f, "8160744", -1},
  {2.65233223680000000000e+10f, "26523322", 11},
  {5.75941955000970387513e-18f, "57594196", -17},
  {4.29355776856770034867e-33f, "42935578", -32},
  {1.08698055148124694824e-01f, "108698055", 0},
  {1.16048468916580584109e-15f, "11604847", -14},
  {2.16274816011718939990e-06f, "21627482", -5},
  {1.60869834261698950387e-34f, "16086983", -33},
  {2.33029713350678623898e-22f, "23302971", -21},
  {6.51788245886564254761e-03f, "65178825", -2},
  {2.01595761718750000000e+04f, "20159576", 5},
  {1.00026605395544216128e-35f, "100026605", -34},
  {2.66526229130180570452e-17f, "26652623", -16},
  {1.71366482391022145748e-05f, "17136648", -4},
  {1.17298788777624502872e-23f, "11729879", -22},
  {4.71657305226025336253e-12f, "4716573", -11},
  {1.15108707940706549760e+20f, "11510871", 21},
  {4.62875224260805850918e-12f, "46287522", -11},
  {2.73378822257968335292e-28f, "27337882", -27},
  {6.08972304549405818452e-14f, "6089723", -13},
  {1.23288901181133855737e+33f, "1232889", 34},
  {3.46472912732991799548e-18f, "34647291", -17},
  {2.40650675000000000000e+06f, "24065068", 7},
  {1.11105228325251863752e-25f, "11110523", -24},
  {2.13852021843194961548e-02f, "21385202", -1},
  {4.69835812961549189434e-38f, "4698358", -37},
  {6.38095309923869535851e-09f, "6380953", -8},
  {3.74101718750000000000e+04f, "3741017", 5},
  {1.55087520516822285899e-12f, "15508752", -11},
  {5.12625630832985734742e-09f, "51262563", -8},
  {5.14848209491722240000e+17f, "5148482", 18},
  {1.95541205671984097091e+25f, "1955412", 26},
  {1.80549302911424456233e-37f, "1805493", -36},
  {1.42409237127095225863e+31f, "14240924", 32},
  {3.31819677352905273438e+00f, "33181968", 1},
  {7.78429737152924825644e-16f, "77842974", -15},
  {4.37173185835731253901e-14f, "4371732", -13},
  {8.71410156250000000000e+04f, "87141016", 5},
  {2.96531143188476562500e+01f, "29653114", 2},
  {4.55895156895065581814e+22f, "45589516", 23},
  {2.46141840254274333576e-30f, "24614184", -29},
  {4.96532460937500000000e+04f, "49653246", 5},
  {1.73683184159030078130e-33f, "17368318", -32},
  {6.89429199218750000000e+03f, "6894292", 4},
  {9.50277377444009738240e+19f, "9502774", 20},
  {1.35779384891066001728e-06f, "13577938", -5},
  {1.10417510350264242922e-15f, "11041751", -14},
  {6.15393438969037002318e-31f, "61539344", -30},
  {5.82436914062500000000e+04f, "5824369", 5},
  {1.12915210240000000000e+10f, "11291521", 11},
  {1.09821191094608296622e-36f, "10982119", -35},
  {3.43284015145225228827e+25f, "34328402", 26},
  {3.86992945778337368043e-23f, "38699295", -22},
  {2.03065292560627139540e-23f, "2030653", -22},
  {1.01553416436366396661e-15f, "10155342", -14},
  {3.09268361431309121747e-22f, "30926836", -21},
  {2.09244100000000000000e+07f, "2092441", 8},
  {6.36329733981624132608e+27f, "63632973", 28},
  {7.63942578125000000000e+04f, "7639426", 5},
  {1.72614714582477769372e+37f, "17261471", 38},
  {4.49334200000000000000e+06f, "4493342", 7},
  {2.19160356529357613908e-09f, "21916036", -8},
  {3.18258450000000000000e+06f, "31825845", 7},
  {4.38780040423897163765e-17f, "43878004", -16},
  {2.40457797050476074219e+00f, "2404578", 1},
  {4.02619294922909033886e+29f, "4026193", 30},
  {3.00389536000000000000e+08f, "30038954", 9},
  {2.95043870391987198499e-34f, "29504387", -33},
  {1.67453606536582810804e-08f, "1674536", -7},
  {1.97557010750415429357e-08f, "19755701", -7},
  {1.12916835068140273285e-25f, "11291684", -24},
  {1.36167689990170488924e+35f, "13616769", 36},
  {5.67598035559058189392e-03f, "56759804", -2},
  {1.27919622316883968000e+17f, "12791962", 18},
  {1.73561969188536320000e+16f, "17356197", 17},
  {1.18956396591913617750e+30f, "1189564", 31},
  {1.91545796428428452723e-37f, "1915458", -36},
  {1.79783308013622395509e+24f, "17978331", 25},
  {1.00967867183499038219e-04f, "10096787", -3},
  {3.66395260928000000000e+11f, "36639526", 12},
  {3.01269235839284456045e+26f, "30126924", 27},
  {4.95781991149018485762e-18f, "495782", -17},
  {2.22204815775003424992e+27f, "22220482", 28},
  {8.91479734108164228121e-36f, "8914797", -35},
  {8.24382125000000000000e+05f, "8243821", 6},
  {9.67151752463460745863e-34f, "96715175", -33},
  {2.96939745280000000000e+10f, "29693975", 11},
  {7.08557809048215858638e-06f, "7085578", -5},
  {1.22073159680000000000e+10f, "12207316", 11},
  {7.25676480000000000000e+08f, "7256765", 9},
  {4.53444152201078928244e-38f, "45344415", -37},
  {3.75623770660001661115e-38f, "37562377", -37},
  {5.08649824000000000000e+08f, "50864982", 9},
  {2.42651000000000000000e+07f, "242651", 8},
  {2.61701469905615971903e-16f, "26170147", -15},
  {1.73100890689659574379e-30f, "1731009", -29},
  {1.34121496230363845825e-02f, "1341215", -1},
  {1.31596012222810371356e+31f, "13159601", 32},
  {8.42231474653014020282e-26f, "8422315", -25},
  {3.64552005917774885901e+28f, "364552", 29},
  {3.60471546665216578328e-16f, "36047155", -15},
  {1.56540167113583539304e-12f, "15654017", -11},
  {7.15479220283863871573e+24f, "7154792", 25},
  {3.17718011371268866048e+20f, "317718", 21},
  {2.88199761164190784964e-34f, "28819976", -33},
  {1.80032165527343750000e+02f, "18003217", 3},
  {5.36911183872000000000e+11f, "5369112", 12},
  {9.33598919258169392790e-33f, "9335989", -32},
  {4.30562540915807590025e-13f, "43056254", -12},
  {7.92573010586417015356e-32f, "792573", -31},
  {5.32588967044841472000e+17f, "53258897", 18},
  {1.90307467181072008852e-25f, "19030747", -24},
  {6.03336061666404077641e-11f, "60333606", -10},
  {1.72254337500000000000e+06f, "17225434", 7},
  {2.79894765904831966392e-22f, "27989477", -21},
  {8.35392577525746922664e+33f, "8353926", 34},
  {2.60883906560000000000e+11f, "2608839", 12},
  {1.30006291794148304736e+27f, "13000629", 28},
  {8.53527734601122745062e-11f, "8535277", -10},
  {4.57723742037698703652e-18f, "45772374", -17},
  {1.36900413781404495239e-03f, "13690041", -2},
  {6.49638287608667042150e-10f, "6496383", -9},
  {2.66040773372285449571e-17f, "26604077", -16},
  {9.98963292826100427574e-34f, "9989633", -33},
  {2.44764078460580131195e+36f, "24476408", 37},
  {1.14884550000000000000e+06f, "11488455", 7},
  {2.88248837995432763746e-25f, "28824884", -24},
  {4.75511296826880425215e-05f, "4755113", -4},
  {2.17697080224752426147e-02f, "21769708", -1},
  {3.72164668874241932883e-12f, "37216467", -11},
  {2.48454181660002094284e-15f, "24845418", -14},
  {1.20028487672548399514e+21f, "12002849", 22},
  {9.81883680718848000000e+14f, "9818837", 15},
  {2.37068359227508808133e-29f, "23706836", -28},
  {5.59693481445312500000e+02f, "5596935", 3},
  {4.57698631106407956480e+19f, "45769863", 20},
  {7.06299035648000000000e+11f, "70629904", 12},
  {4.32790342544881467454e-25f, "43279034", -24},
  {6.79105077157409968630e+25f, "6791051", 26},
  {5.01229351566385960127e+37f, "50122935", 38},
  {5.73829873383908114300e-18f, "57382987", -17},
  {5.25347929687500000000e+04f, "52534793", 5},
  {1.31693025000298804515e-26f, "13169303", -25},
  {5.80842946560000000000e+10f, "58084295", 11},
  {1.25811843062520126490e-28f, "12581184", -27},
  {6.24307938679180551844e-10f, "62430794", -9},
  {6.81250937500000000000e+05f, "68125094", 6},
  {5.40314467629180492186e+21f, "54031447", 22},
  {1.17811572347389679265e-21f, "11781157", -20},
  {9.16820745180827273813e+33f, "91682075", 34},
  {3.52314999792817843037e-35f, "352315", -34},
  {2.52304850681856000000e+14f, "25230485", 15},
  {8.24812308432504651123e-15f, "8248123", -14},
  {1.56942980746727078767e-13f, "15694298", -12},
  {4.01940637243282554880e+19f, "40194064", 20},
  {2.78172038799865642845e-17f, "27817204", -16},
  {2.99390575941628484286e+31f, "29939058", 32},
  {1.92549596040960815706e+33f, "1925496", 34},
  {2.24873853279535104000e+17f, "22487385", 18},
  {8.70493621629719882549e-10f, "8704936", -9},
  {1.04523799516731657599e-17f, "1045238", -16},
  {7.36912190767634156003e-37f, "7369122", -36},
  {1.52354039368855525946e-27f, "15235404", -26},
  {1.66222950880374488231e+36f, "16622295", 37},
  {2.96831448969755022446e-27f, "29683145", -26},
  {1.39274028580864000000e+14f, "13927403", 15},
  {1.07446312080769024000e+17f, "10744631", 18},
  {3.39118241694830869610e+23f, "33911824", 24},
  {1.01573073726221812374e+28f, "10157307", 29},
  {1.02118417968750000000e+04f, "10211842", 5},
  {2.45644788435259070874e+22f, "24564479", 23},
  {8.47970162811997319888e-29f, "84797016", -28},
  {7.29616413117534811034e-31f, "7296164", -30},
  {5.48039917764560418084e+34f, "5480399", 35},
  {8.08736788203568103424e+20f, "8087368", 21},
  {1.48505544829235018218e-20f, "14850554", -19},
  {4.71814360042226155212e-14f, "47181436", -13},
  {7.59171805281289024947e-13f, "7591718", -12},
  {1.16603199886402632121e-37f, "1166032", -36},
  {8.60915917968750000000e+03f, "8609159", 4},
  {9.95848612434939144274e-18f, "9958486", -17},
  {6.56124763443514638411e-34f, "65612476", -33},
  {3.12327566546111102236e-21f, "31232757", -20},
  {1.33881280000000000000e+07f, "13388128", 8},
  {1.61511053420326788910e-08f, "16151105", -7},
  {2.05564465074572083713e+37f, "20556447", 38},
  {6.33116104560450303169e+28f, "6331161", 29},
  {6.92775595004642636213e-16f, "6927756", -15},
  {5.74587306311571671581e+31f, "5745873", 32},
  {1.94378400000000000000e+07f, "1943784", 8},
  {1.00582463373312000000e+14f, "10058246", 15},
  {7.95257137351963498070e-25f, "79525714", -24},
  {2.40010112000000000000e+09f, "2400101", 10},
  {2.54438177676394782723e+25f, "25443818", 26},
  {1.89562717004925264542e-27f, "18956272", -26},
  {1.15398815403109200691e+21f, "115398815", 22},
  {5.17847013473510742188e+00f, "517847", 1},
  {3.29678982270051560373e+28f, "32967898", 29},
  {5.64647750000000000000e+05f, "56464775", 6},
  {7.68482846802420738186e-11f, "76848285", -10},
  {4.55621773198799928650e-07f, "45562177", -6},
  {2.00439959768816677865e-11f, "20043996", -10},
  {9.99910712242126464844e-01f, "9999107", 0},
  {5.63460388183593750000e+01f, "5634604", 2},
  {1.50703540816157560353e-15f, "15070354", -14},
  {1.18817701772461833755e-18f, "1188177", -17},
  {1.36992252683960188928e+20f, "13699225", 21},
  {1.16549980160000000000e+10f, "11654998", 11},
  {1.39494016000000000000e+08f, "13949402", 9},
  {2.58910647792636946022e+21f, "25891065", 22},
  {1.45557224594678976799e-25f, "14555722", -24},
  {2.33640762902443598541e+29f, "23364076", 30},
  {2.78525138266163527285e+26f, "27852514", 27},
  {7.45892378972712322138e-08f, "7458924", -7},
  {4.18152241036295890808e-03f, "41815224", -2},
  {6.38259265332521808354e-21f, "63825927", -20},
  {2.20633800118719136663e-09f, "2206338", -8},
  {3.79413785545762438645e-13f, "37941379", -12},
  {7.39226013183593750000e+02f, "739226", 3},
  {1.77745125890766222411e-16f, "17774513", -15},
  {1.18596288296966237931e+33f, "11859629", 34},
  {9.91644605992911252578e-23f, "9916446", -22},
  {2.38093696534633636475e-02f, "2380937", -1},
  {3.98315380859375000000e+03f, "39831538", 4},
  {3.57674756111986742465e-36f, "35767476", -35},
  {7.28914380800000000000e+09f, "7289144", 10},
  {6.74955662920747462286e-15f, "67495566", -14},
  {3.03758496093750000000e+03f, "3037585", 4},
  {3.40397387742996215820e-01f, "3403974", 0},
  {6.26476580067064136610e+29f, "62647658", 30},
  {3.65780961749273936333e+31f, "36578096", 32},
  {2.58115140466149107492e+31f, "25811514", 32},
  {1.83531635450740673089e-20f, "18353164", -19},
  {5.37413598067359998822e-08f, "5374136", -7},
  {1.97109147848095744848e-06f, "19710915", -5},
  {4.30487744140625000000e+03f, "43048774", 4},
  {1.03190112501760000000e+13f, "10319011", 14},
  {3.90845079796276404050e-25f, "39084508", -24},
  {7.27823717125909322841e-26f, "7278237", -25},
  {2.10326056301000772651e-18f, "21032606", -17},
  {1.65035292994428785818e+35f, "16503529", 36},
  {1.65124131815824748415e-12f, "16512413", -11},
  {6.81344662369379121892e-28f, "68134466", -27},
  {6.74907999005861772001e+22f, "674908", 23},
  {1.96819156451438100480e+19f, "19681916", 20},
  {4.71747776000000000000e+08f, "47174778", 9},
  {6.28287838602056742503e-37f, "62828784", -36},
  {6.31834660918394925616e-29f, "63183466", -28},
  {2.96184606798063728759e+34f, "2961846", 35},
  {7.30121093750000000000e+04f, "7301211", 5},
  {1.76664661921677179635e-06f, "17666466", -5},
  {4.96499978381289443692e+28f, "4965", 29},
  {1.17305949107812250419e+21f, "11730595", 22},
  {6.97848198132176039897e+30f, "6978482", 31},
  {2.85683029233041452244e-07f, "28568303", -6},
  {7.10738565583627400249e+23f, "7107386", 24},
  {6.86975326538085937500e+01f, "6869753", 2},
  {3.16497961108373504000e+17f, "31649796", 18},
  {3.01772929561794356346e-12f, "30177293", -11},
  {3.37364202766449040116e-38f, "3373642", -37},
  {2.88537088000000000000e+08f, "2885371", 9},
  {1.58559537433904935374e-19f, "15855954", -18},
  {1.38536525470915495096e+32f, "13853653", 33},
  {8.84575537974973411231e+26f, "88457554", 27},
  {1.39166770790400000000e+12f, "13916677", 13},
  {3.95860780136661483120e-13f, "39586078", -12},
  {5.51381829083652519330e-09f, "55138183", -8},
  {2.04472906434240847551e-14f, "2044729", -13},
  {2.60963993072509765625e+01f, "260964", 2},
  {6.18633710937500000000e+04f, "6186337", 5},
  {6.92604300000000000000e+06f, "6926043", 7},
  {6.31861388683319091797e-03f, "6318614", -2},
  {1.72753323556455202733e+31f, "17275332", 32},
  {7.71434194319441920000e+17f, "7714342", 18},
  {6.08901710970697072943e-19f, "6089017", -18},
  {4.86654312448000000000e+11f, "4866543", 12},
  {4.98231447418340245292e-13f, "49823145", -12},
  {5.96360362482637590669e-17f, "59636036", -16},
  {4.82585976525657263309e+21f, "482586", 22},
  {2.11178234311665152822e-17f, "21117823", -16},
  {7.35573954967944468684e+26f, "73557395", 27},
  {1.24035984341183084306e-23f, "124035984", -22},
  {1.43386726584443839027e-27f, "14338673", -26},
  {1.26231654400000000000e+09f, "12623165", 10},
  {1.23322805056631366555e-31f, "1233228", -30},
  {6.46605429687500000000e+04f, "64660543", 5},
  {1.28883584693539887667e-06f, "12888358", -5},
  {1.42167795200000000000e+09f, "1421678", 10},
  {2.97361040824319783089e-17f, "29736104", -16},
  {5.96468275122993627136e+20f, "5964683", 21},
  {7.55497369600000000000e+09f, "75549737", 10},
  {1.45303242334267000132e+30f, "14530324", 31},
  {1.38511806332082841915e-37f, "13851181", -36},
  {1.50182287597656250000e+03f, "15018229", 4},
  {1.81625412086503833600e+18f, "18162541", 19},
  {3.05862069452800000000e+13f, "30586207", 14},
  {9.56789417255912392242e+28f, "9567894", 29},
  {1.33216995550440438664e-29f, "133217", -28},
  {1.00168482779434459077e+38f, "10016848", 39},
  {3.42477690651321609039e-09f, "3424777", -8},
  {1.36752790503424000000e+14f, "13675279", 15},
  {9.58803312500000000000e+05f, "9588033", 6},
  {3.60544652944076533669e+27f, "36054465", 28},
  {3.45370175000000000000e+06f, "34537018", 7},
  {1.03650182969823373078e-15f, "10365018", -14},
  {2.93497279050031839737e-30f, "29349728", -29},
  {2.40098502809214512582e-21f, "2400985", -20},
  {8.67665756160000000000e+10f, "86766576", 11},
  {2.88273014348305878229e-08f, "28827301", -7},
  {1.69177964857810499827e-38f, "16917796", -37},
  {2.89522375604091303093e+32f, "28952238", 33},
  {3.04376551401886546533e-20f, "30437655", -19},
  {3.47703255077261742467e-23f, "34770326", -22},
  {6.00644047396343170784e-34f, "60064405", -33},
  {6.43023275264024603604e+27f, "6430233", 28},
  {6.94656590482698420297e-16f, "6946566", -15},
  {6.58265702400000000000e+09f, "6582657", 10},
  {1.14492963715608496076e-17f, "11449296", -16},
  {1.53194538262798621665e+32f, "15319454", 33},
  {3.25329941147222559759e+31f, "32532994", 32},
  {9.99361474318285947844e-36f, "9993615", -35},
  {1.68683300781250000000e+03f, "1686833", 4},
  {6.61222325350219487642e+22f, "66122233", 23},
  {2.18281862272509992942e-34f, "21828186", -33},
  {3.43253680926517604234e-33f, "34325368", -32},
  {1.69675567626953125000e+02f, "16967557", 3},
  {1.07913967017813606400e+18f, "10791397", 19},
  {5.48954507865584457031e+34f, "5489545", 35},
  {3.79618525184000000000e+11f, "37961853", 12},
  {1.51246551774134272000e+17f, "15124655", 18},
  {2.63804169481351991067e-13f, "26380417", -12},
  {7.52844577585516649965e-14f, "7528446", -13},
  {2.08528301662347424848e-16f, "2085283", -15},
  {1.33709714624426882184e-24f, "13370971", -23},
  {3.99821363050622034198e+31f, "39982136", 32},
  {3.50728800000000000000e+07f, "3507288", 8},
  {6.55791595428678120508e-16f, "6557916", -15},
  {1.40209024028227536327e-28f, "14020902", -27},
  {4.43124652722813309693e-21f, "44312465", -20},
  {3.17791743770624000000e+15f, "31779174", 16},
  {3.69115186827129405238e-28f, "36911519", -27},
  {1.76453220022272452048e-27f, "17645322", -26},
  {1.59323563923050048339e+34f, "15932356", 35},
  {2.07611380344252527408e-12f, "20761138", -11},
  {1.74865042433688475375e-22f, "17486504", -21},
  {1.38482851273877508588e+23f, "13848285", 24},
  {2.34413588480000000000e+11f, "23441359", 12},
  {1.83245768217325953685e+26f, "18324577", 27},
  {2.28465041263988848435e-33f, "22846504", -32},
  {5.22273359375000000000e+04f, "52227336", 5},
  {8.24660988720368844800e+18f, "824661", 19},
  {3.60760908979225220290e-30f, "3607609", -29},
  {1.22386805924845611904e-31f, "12238681", -30},
  {7.87680969238281250000e+02f, "78768097", 3},
  {1.32005752882436537344e-25f, "13200575", -24},
  {7.00555568971538862348e-26f, "70055557", -25},
  {1.79499537094560968569e-34f, "17949954", -33},
  {2.32982056246688812802e+31f, "23298206", 32},
  {5.29051639169500767872e-30f, "52905164", -29},
  {1.12146288350330880000e+16f, "11214629", 17},
  {5.14611814400000000000e+09f, "5146118", 10},
  {2.24225412239320576191e-04f, "22422541", -3},
  {1.18075462347038400848e-36f, "11807546", -35},
  {1.74660747371830050811e+32f, "17466075", 33},
  {4.99352125440000000000e+10f, "49935213", 11},
  {8.00010208601905933530e+33f, "8000102", 34},
  {8.97346687316894531250e+00f, "8973467", 1},
  {5.01061151712413825652e+33f, "50106115", 34},
  {1.48629909794153127669e-33f, "14862991", -32},
  {6.59266567283094323200e+18f, "65926657", 19},
  {2.30432931840000000000e+10f, "23043293", 11},
  {9.30199094125543124797e-23f, "9301991", -22},
  {1.92904620923729297972e+30f, "19290462", 31},
  {4.91657968750000000000e+05f, "49165797", 6},
  {3.11042402343750000000e+04f, "3110424", 5},
  {4.62786342486528546233e-31f, "46278634", -30},
  {9.94379856233962300394e-11f, "99437986", -10},
  {1.06146165178144769742e-23f, "106146165", -22},
  {1.40970941908439178664e+34f, "14097094", 35},
  {3.63511499017477035522e-05f, "3635115", -4},
  {8.83884819156104642560e+19f, "8838848", 20},
  {1.61242836631552000000e+14f, "16124284", 15},
  {2.18636542968750000000e+04f, "21863654", 5},
  {1.78144147744347284316e+27f, "17814415", 28},
  {1.78315128758116191390e-22f, "17831513", -21},
  {4.64377430321135616000e+17f, "46437743", 18},
  {1.68717164673398855631e-37f, "16871716", -36},
  {5.37128862221665339999e-18f, "53712886", -17},
  {1.51167651840000000000e+10f, "15116765", 11},
  {1.48506808934184875058e-28f, "14850681", -27},
  {9.53451292898430564745e+36f, "9534513", 37},
  {1.06143234591436309892e-19f, "106143235", -18},
  {5.48445000000000000000e+06f, "548445", 7},
  {1.60188691261105371310e-38f, "16018869", -37},
  {2.67393124435450136848e-26f, "26739312", -25},
  {3.72885235028403430711e-22f, "37288524", -21},
  {1.97670576411772451863e+34f, "19767058", 35},
  {4.06770186977280000000e+13f, "4067702", 14},
  {2.73182550737335832086e-27f, "27318255", -26},
  {4.30895073884488274858e-38f, "43089507", -37},
  {3.78052476435186690651e-07f, "37805248", -6},
  {9.74898827526509323878e+21f, "9748988", 22},
  {6.73357936206017589726e-22f, "67335794", -21},
  {9.83583128681166096730e-16f, "9835831", -15},
  {6.94031984660448131308e-12f, "694032", -11},
  {3.51432288914862034125e+21f, "3514323", 22},
  {7.63367964395911258180e-08f, "76336796", -7},
  {1.16450281520103424000e+17f, "11645028", 18},
  {5.80824321458332338180e+36f, "5808243", 37},
  {1.48995225879300363658e-12f, "14899523", -11},
  {5.83946465814279776778e-27f, "58394647", -26},
  {7.43805253819826176000e+17f, "74380525", 18},
  {3.35517891146211662239e-37f, "3355179", -36},
  {2.05666484653916160000e+16f, "20566648", 17},
  {1.81333750000000000000e+06f, "18133375", 7},
  {9.94794708078833867284e-21f, "9947947", -20},
  {1.33728881337447091937e-05f, "13372888", -4},
  {5.11182320000000000000e+07f, "5111823", 8},
  {8.12981224060058593750e+00f, "8129812", 1},
  {2.91322764964287513100e-34f, "29132276", -33},
  {1.14956778798369996800e+18f, "11495678", 19},
  {1.13091818988323211670e-01f, "11309182", 0},
  {5.22473215272501942397e-15f, "5224732", -14},
  {9.24968279324579062406e-15f, "9249683", -14},
  {2.93050944805145263672e-01f, "29305094", 0},
  {2.35165394842624664307e-02f, "2351654", -1},
  {5.44091064453125000000e+02f, "54409106", 3},
  {8.20695640868507325649e-06f, "8206956", -5},
  {1.34188157761959854763e-27f, "13418816", -26},
  {2.46796706119680000000e+14f, "2467967", 15},
  {5.82436296099331229925e-05f, "5824363", -4},
  {8.17126406250000000000e+04f, "8171264", 5},
  {3.48791084252297878265e-03f, "34879108", -2},
  {6.59024720691200000000e+12f, "6590247", 13},
  {1.34118631829198004562e+28f, "13411863", 29},
  {4.09475521509283435276e+24f, "40947552", 25},
  {3.03165033983532339334e-05f, "30316503", -4},
  {1.41811141112570394506e-18f, "14181114", -17},
  {6.70527160644531250000e+02f, "67052716", 3},
  {2.57308840900805080310e-07f, "25730884", -6},
  {3.41769600000000000000e+08f, "3417696", 9},
  {6.28730733002752000000e+14f, "6287307", 15},
  {2.76573964109831064413e-28f, "27657396", -27},
  {1.81610127360000000000e+10f, "18161013", 11},
  {1.87535373896707824315e-08f, "18753537", -7},
  {7.91813041044848640000e+16f, "791813", 17},
  {3.02090657546970535204e+28f, "30209066", 29},
  {3.91243128601710388650e+25f, "39124313", 26},
  {5.76357978541736787337e-15f, "57635798", -14},
  {3.58883894824302274174e-10f, "3588839", -9},
  {1.93186678429018136141e+30f, "19318668", 31},
  {9.72886950945008670456e-36f, "97288695", -35},
  {6.68915302334626437864e+27f, "6689153", 28},
  {1.31991922671653815717e-23f, "13199192", -22},
  {1.39571991117359850421e-11f, "13957199", -10},
  {2.77044359675571172374e-12f, "27704436", -11},
  {5.27647385845760000000e+13f, "5276474", 14},
  {1.25557040897573021947e+30f, "12555704", 31},
  {3.77498842083105754317e+21f, "37749884", 22},
  {1.12268890516014347049e+25f, "11226889", 26},
  {4.54698437500000000000e+05f, "45469844", 6},
  {3.19182563339735061539e-22f, "31918256", -21},
  {1.31099398004153044894e-09f, "1310994", -8},
  {2.28756427401185203472e-36f, "22875643", -35},
  {3.18733556793920022611e+29f, "31873356", 30},
  {2.38784860832710743896e-20f, "23878486", -19},
  {1.50273331058260996970e+27f, "15027333", 28},
  {1.41580481401713288714e-14f, "14158048", -13},
  {5.58756971359252929688e+00f, "55875697", 1},
  {1.41889011651130658720e-09f, "14188901", -8},
  {6.17850424422039552000e+17f, "6178504", 18},
  {2.63492701109699691891e-30f, "2634927", -29},
  {1.26369655924578011323e-33f, "12636966", -32},
  {2.85484337750797356069e+28f, "28548434", 29},
  {7.96527399871394611200e+18f, "7965274", 19},
  {3.70879005640745162964e-03f, "370879", -2},
  {3.23001025000000000000e+06f, "32300102", 7},
  {3.36178240000000000000e+08f, "33617824", 9},
  {2.12079275535474265444e-16f, "21207928", -15},
  {2.94726836316381050514e+30f, "29472684", 31},
  {1.90744868967543945072e+37f, "19074487", 38},
  {5.93177203059438872166e-25f, "5931772", -24},
  {4.61849153380041548369e+33f, "46184915", 34},
  {1.77121338504389940291e+26f, "17712134", 27},
  {1.33069244512284967641e-09f, "13306924", -8},
  {9.42158055953408479256e-17f, "94215806", -16},
  {6.89739349188633840544e-25f, "68973935", -24},
  {9.28531367703549319243e-35f, "92853137", -34},
  {1.73519940124193250031e-25f, "17351994", -24},
  {4.20852591442577077581e+35f, "4208526", 36},
  {1.72609219598757138935e+29f, "17260922", 30},
  {1.30300308257966653440e+19f, "13030031", 20},
  {1.83401889750332068213e-25f, "18340189", -24},
};


Vector<const PrecomputedShortestSingle>
PrecomputedShortestSingleRepresentations() {
  int number_elements =
      sizeof(kShortestSingleTestNumbers) / sizeof(PrecomputedShortestSingle);
  return Vector<const PrecomputedShortestSingle>(kShortestSingleTestNumbers,
                                                 number_elements);
}

}  // namespace double_conversion
