/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2015 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
    case 2:	/* sbc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
    case 4:	/* sbcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
    case 7:	/* adds */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
    case 10:	/* subs */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
    case 12:	/* add */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
    case 14:	/* adds */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
    case 17:	/* subs */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
    case 20:	/* adds */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
    case 22:	/* sub */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
    case 24:	/* subs */
      value = 24;	/* --> subs.  */
      break;
    case 150:	/* mov */
    case 149:	/* umov */
      value = 149;	/* --> umov.  */
      break;
    case 152:	/* mov */
    case 151:	/* ins */
      value = 151;	/* --> ins.  */
      break;
    case 154:	/* mov */
    case 153:	/* ins */
      value = 153;	/* --> ins.  */
      break;
    case 236:	/* mvn */
    case 235:	/* not */
      value = 235;	/* --> not.  */
      break;
    case 311:	/* mov */
    case 310:	/* orr */
      value = 310;	/* --> orr.  */
      break;
    case 380:	/* sxtl */
    case 379:	/* sshll */
      value = 379;	/* --> sshll.  */
      break;
    case 382:	/* sxtl2 */
    case 381:	/* sshll2 */
      value = 381;	/* --> sshll2.  */
      break;
    case 404:	/* uxtl */
    case 403:	/* ushll */
      value = 403;	/* --> ushll.  */
      break;
    case 406:	/* uxtl2 */
    case 405:	/* ushll2 */
      value = 405;	/* --> ushll2.  */
      break;
    case 527:	/* mov */
    case 526:	/* dup */
      value = 526;	/* --> dup.  */
      break;
    case 614:	/* sxtw */
    case 613:	/* sxth */
    case 612:	/* sxtb */
    case 615:	/* asr */
    case 611:	/* sbfx */
    case 610:	/* sbfiz */
    case 609:	/* sbfm */
      value = 609;	/* --> sbfm.  */
      break;
    case 618:	/* bfc */
    case 619:	/* bfxil */
    case 617:	/* bfi */
    case 616:	/* bfm */
      value = 616;	/* --> bfm.  */
      break;
    case 624:	/* uxth */
    case 623:	/* uxtb */
    case 626:	/* lsr */
    case 625:	/* lsl */
    case 622:	/* ubfx */
    case 621:	/* ubfiz */
    case 620:	/* ubfm */
      value = 620;	/* --> ubfm.  */
      break;
    case 644:	/* cset */
    case 643:	/* cinc */
    case 642:	/* csinc */
      value = 642;	/* --> csinc.  */
      break;
    case 647:	/* csetm */
    case 646:	/* cinv */
    case 645:	/* csinv */
      value = 645;	/* --> csinv.  */
      break;
    case 649:	/* cneg */
    case 648:	/* csneg */
      value = 648;	/* --> csneg.  */
      break;
    case 667:	/* rev */
    case 668:	/* rev64 */
      value = 667;	/* --> rev.  */
      break;
    case 675:	/* lsl */
    case 674:	/* lslv */
      value = 674;	/* --> lslv.  */
      break;
    case 677:	/* lsr */
    case 676:	/* lsrv */
      value = 676;	/* --> lsrv.  */
      break;
    case 679:	/* asr */
    case 678:	/* asrv */
      value = 678;	/* --> asrv.  */
      break;
    case 681:	/* ror */
    case 680:	/* rorv */
      value = 680;	/* --> rorv.  */
      break;
    case 691:	/* mul */
    case 690:	/* madd */
      value = 690;	/* --> madd.  */
      break;
    case 693:	/* mneg */
    case 692:	/* msub */
      value = 692;	/* --> msub.  */
      break;
    case 695:	/* smull */
    case 694:	/* smaddl */
      value = 694;	/* --> smaddl.  */
      break;
    case 697:	/* smnegl */
    case 696:	/* smsubl */
      value = 696;	/* --> smsubl.  */
      break;
    case 700:	/* umull */
    case 699:	/* umaddl */
      value = 699;	/* --> umaddl.  */
      break;
    case 702:	/* umnegl */
    case 701:	/* umsubl */
      value = 701;	/* --> umsubl.  */
      break;
    case 713:	/* ror */
    case 712:	/* extr */
      value = 712;	/* --> extr.  */
      break;
    case 920:	/* bic */
    case 919:	/* and */
      value = 919;	/* --> and.  */
      break;
    case 922:	/* mov */
    case 921:	/* orr */
      value = 921;	/* --> orr.  */
      break;
    case 925:	/* tst */
    case 924:	/* ands */
      value = 924;	/* --> ands.  */
      break;
    case 930:	/* uxtw */
    case 929:	/* mov */
    case 928:	/* orr */
      value = 928;	/* --> orr.  */
      break;
    case 932:	/* mvn */
    case 931:	/* orn */
      value = 931;	/* --> orn.  */
      break;
    case 936:	/* tst */
    case 935:	/* ands */
      value = 935;	/* --> ands.  */
      break;
    case 1062:	/* staddb */
    case 966:	/* ldaddb */
      value = 966;	/* --> ldaddb.  */
      break;
    case 1063:	/* staddh */
    case 967:	/* ldaddh */
      value = 967;	/* --> ldaddh.  */
      break;
    case 1064:	/* stadd */
    case 968:	/* ldadd */
      value = 968;	/* --> ldadd.  */
      break;
    case 1065:	/* staddlb */
    case 970:	/* ldaddlb */
      value = 970;	/* --> ldaddlb.  */
      break;
    case 1066:	/* staddlh */
    case 973:	/* ldaddlh */
      value = 973;	/* --> ldaddlh.  */
      break;
    case 1067:	/* staddl */
    case 976:	/* ldaddl */
      value = 976;	/* --> ldaddl.  */
      break;
    case 1068:	/* stclrb */
    case 978:	/* ldclrb */
      value = 978;	/* --> ldclrb.  */
      break;
    case 1069:	/* stclrh */
    case 979:	/* ldclrh */
      value = 979;	/* --> ldclrh.  */
      break;
    case 1070:	/* stclr */
    case 980:	/* ldclr */
      value = 980;	/* --> ldclr.  */
      break;
    case 1071:	/* stclrlb */
    case 982:	/* ldclrlb */
      value = 982;	/* --> ldclrlb.  */
      break;
    case 1072:	/* stclrlh */
    case 985:	/* ldclrlh */
      value = 985;	/* --> ldclrlh.  */
      break;
    case 1073:	/* stclrl */
    case 988:	/* ldclrl */
      value = 988;	/* --> ldclrl.  */
      break;
    case 1074:	/* steorb */
    case 990:	/* ldeorb */
      value = 990;	/* --> ldeorb.  */
      break;
    case 1075:	/* steorh */
    case 991:	/* ldeorh */
      value = 991;	/* --> ldeorh.  */
      break;
    case 1076:	/* steor */
    case 992:	/* ldeor */
      value = 992;	/* --> ldeor.  */
      break;
    case 1077:	/* steorlb */
    case 994:	/* ldeorlb */
      value = 994;	/* --> ldeorlb.  */
      break;
    case 1078:	/* steorlh */
    case 997:	/* ldeorlh */
      value = 997;	/* --> ldeorlh.  */
      break;
    case 1079:	/* steorl */
    case 1000:	/* ldeorl */
      value = 1000;	/* --> ldeorl.  */
      break;
    case 1080:	/* stsetb */
    case 1002:	/* ldsetb */
      value = 1002;	/* --> ldsetb.  */
      break;
    case 1081:	/* stseth */
    case 1003:	/* ldseth */
      value = 1003;	/* --> ldseth.  */
      break;
    case 1082:	/* stset */
    case 1004:	/* ldset */
      value = 1004;	/* --> ldset.  */
      break;
    case 1083:	/* stsetlb */
    case 1006:	/* ldsetlb */
      value = 1006;	/* --> ldsetlb.  */
      break;
    case 1084:	/* stsetlh */
    case 1009:	/* ldsetlh */
      value = 1009;	/* --> ldsetlh.  */
      break;
    case 1085:	/* stsetl */
    case 1012:	/* ldsetl */
      value = 1012;	/* --> ldsetl.  */
      break;
    case 1086:	/* stsmaxb */
    case 1014:	/* ldsmaxb */
      value = 1014;	/* --> ldsmaxb.  */
      break;
    case 1087:	/* stsmaxh */
    case 1015:	/* ldsmaxh */
      value = 1015;	/* --> ldsmaxh.  */
      break;
    case 1088:	/* stsmax */
    case 1016:	/* ldsmax */
      value = 1016;	/* --> ldsmax.  */
      break;
    case 1089:	/* stsmaxlb */
    case 1018:	/* ldsmaxlb */
      value = 1018;	/* --> ldsmaxlb.  */
      break;
    case 1090:	/* stsmaxlh */
    case 1021:	/* ldsmaxlh */
      value = 1021;	/* --> ldsmaxlh.  */
      break;
    case 1091:	/* stsmaxl */
    case 1024:	/* ldsmaxl */
      value = 1024;	/* --> ldsmaxl.  */
      break;
    case 1092:	/* stsminb */
    case 1026:	/* ldsminb */
      value = 1026;	/* --> ldsminb.  */
      break;
    case 1093:	/* stsminh */
    case 1027:	/* ldsminh */
      value = 1027;	/* --> ldsminh.  */
      break;
    case 1094:	/* stsmin */
    case 1028:	/* ldsmin */
      value = 1028;	/* --> ldsmin.  */
      break;
    case 1095:	/* stsminlb */
    case 1030:	/* ldsminlb */
      value = 1030;	/* --> ldsminlb.  */
      break;
    case 1096:	/* stsminlh */
    case 1033:	/* ldsminlh */
      value = 1033;	/* --> ldsminlh.  */
      break;
    case 1097:	/* stsminl */
    case 1036:	/* ldsminl */
      value = 1036;	/* --> ldsminl.  */
      break;
    case 1098:	/* stumaxb */
    case 1038:	/* ldumaxb */
      value = 1038;	/* --> ldumaxb.  */
      break;
    case 1099:	/* stumaxh */
    case 1039:	/* ldumaxh */
      value = 1039;	/* --> ldumaxh.  */
      break;
    case 1100:	/* stumax */
    case 1040:	/* ldumax */
      value = 1040;	/* --> ldumax.  */
      break;
    case 1101:	/* stumaxlb */
    case 1042:	/* ldumaxlb */
      value = 1042;	/* --> ldumaxlb.  */
      break;
    case 1102:	/* stumaxlh */
    case 1045:	/* ldumaxlh */
      value = 1045;	/* --> ldumaxlh.  */
      break;
    case 1103:	/* stumaxl */
    case 1048:	/* ldumaxl */
      value = 1048;	/* --> ldumaxl.  */
      break;
    case 1104:	/* stuminb */
    case 1050:	/* lduminb */
      value = 1050;	/* --> lduminb.  */
      break;
    case 1105:	/* stuminh */
    case 1051:	/* lduminh */
      value = 1051;	/* --> lduminh.  */
      break;
    case 1106:	/* stumin */
    case 1052:	/* ldumin */
      value = 1052;	/* --> ldumin.  */
      break;
    case 1107:	/* stuminlb */
    case 1054:	/* lduminlb */
      value = 1054;	/* --> lduminlb.  */
      break;
    case 1108:	/* stuminlh */
    case 1057:	/* lduminlh */
      value = 1057;	/* --> lduminlh.  */
      break;
    case 1109:	/* stuminl */
    case 1060:	/* lduminl */
      value = 1060;	/* --> lduminl.  */
      break;
    case 1111:	/* mov */
    case 1110:	/* movn */
      value = 1110;	/* --> movn.  */
      break;
    case 1113:	/* mov */
    case 1112:	/* movz */
      value = 1112;	/* --> movz.  */
      break;
    case 1126:	/* psb */
    case 1125:	/* esb */
    case 1124:	/* sevl */
    case 1123:	/* sev */
    case 1122:	/* wfi */
    case 1121:	/* wfe */
    case 1120:	/* yield */
    case 1119:	/* nop */
    case 1118:	/* hint */
      value = 1118;	/* --> hint.  */
      break;
    case 1135:	/* tlbi */
    case 1134:	/* ic */
    case 1133:	/* dc */
    case 1132:	/* at */
    case 1131:	/* sys */
      value = 1131;	/* --> sys.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ins_regno (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ins_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ins_reglane (self, info, code, inst);
    case 31:
      return aarch64_ins_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ins_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 59:
      return aarch64_ins_limm (self, info, code, inst);
    case 60:
      return aarch64_ins_aimm (self, info, code, inst);
    case 61:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ins_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ins_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ins_barrier (self, info, code, inst);
    case 87:
      return aarch64_ins_prfop (self, info, code, inst);
    case 88:
      return aarch64_ins_hint (self, info, code, inst);
    default: assert (0); abort ();
    }
}
